/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TerminalBlock {
    private static final Logger LOG = Logger.getInstance(TerminalBlock.class);
    @NotNull
    private final PsiVariable myVariable;
    private final StreamApiMigrationInspection.Operation @NotNull [] myOperations;
    private final PsiStatement @NotNull [] myStatements;

    private TerminalBlock(StreamApiMigrationInspection.Operation @NotNull [] operations, @NotNull PsiVariable variable, PsiStatement ... statements) {
        if (variable == null) {
            TerminalBlock.$$$reportNull$$$0(0);
        }
        if (operations == null) {
            TerminalBlock.$$$reportNull$$$0(1);
        }
        if (statements == null) {
            TerminalBlock.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(operations.length > 0);
        for (StreamApiMigrationInspection.Operation operation : operations) {
            Objects.requireNonNull(operation);
        }
        for (StreamApiMigrationInspection.Operation operation : statements) {
            Objects.requireNonNull(operation);
        }
        this.myVariable = variable;
        while (true) {
            PsiStatement[] psiStatementArray;
            if (statements.length == 1 && statements[0] instanceof PsiBlockStatement) {
                statements = ((PsiBlockStatement)statements[0]).getCodeBlock().getStatements();
                continue;
            }
            if (statements.length != 1 || !(statements[0] instanceof PsiLabeledStatement)) break;
            PsiStatement statement = ((PsiLabeledStatement)statements[0]).getStatement();
            if (statement == null) {
                psiStatementArray = PsiStatement.EMPTY_ARRAY;
            } else {
                PsiStatement[] psiStatementArray2 = new PsiStatement[1];
                psiStatementArray = psiStatementArray2;
                psiStatementArray2[0] = statement;
            }
            statements = psiStatementArray;
        }
        this.myStatements = statements;
        this.myOperations = operations;
    }

    private TerminalBlock(@Nullable TerminalBlock previousBlock, @NotNull StreamApiMigrationInspection.Operation operation, @NotNull PsiVariable variable, PsiStatement ... statements) {
        StreamApiMigrationInspection.Operation[] operationArray;
        if (operation == null) {
            TerminalBlock.$$$reportNull$$$0(3);
        }
        if (variable == null) {
            TerminalBlock.$$$reportNull$$$0(4);
        }
        if (statements == null) {
            TerminalBlock.$$$reportNull$$$0(5);
        }
        if (previousBlock == null) {
            StreamApiMigrationInspection.Operation[] operationArray2 = new StreamApiMigrationInspection.Operation[1];
            operationArray = operationArray2;
            operationArray2[0] = operation;
        } else {
            operationArray = (StreamApiMigrationInspection.Operation[])ArrayUtil.append((Object[])previousBlock.myOperations, (Object)operation);
        }
        this(operationArray, variable, statements);
    }

    Collection<PsiStatement> findExitPoints(ControlFlow controlFlow) {
        int startOffset = controlFlow.getStartOffset((PsiElement)this.myStatements[0]);
        int endOffset = controlFlow.getEndOffset((PsiElement)this.myStatements[this.myStatements.length - 1]);
        if (startOffset < 0 || endOffset < 0) {
            return null;
        }
        return ControlFlowUtil.findExitPointsAndStatements((ControlFlow)controlFlow, (int)startOffset, (int)endOffset, (IntList)new IntArrayList(), (Class[])ControlFlowUtil.DEFAULT_EXIT_STATEMENTS_CLASSES);
    }

    PsiStatement getSingleStatement() {
        return this.myStatements.length == 1 ? this.myStatements[0] : null;
    }

    PsiStatement @NotNull [] getStatements() {
        if (this.myStatements == null) {
            TerminalBlock.$$$reportNull$$$0(6);
        }
        return this.myStatements;
    }

    @Nullable
    <T extends PsiExpression> T getSingleExpression(Class<T> wantedType) {
        PsiStatement statement = this.getSingleStatement();
        if (statement instanceof PsiExpressionStatement) {
            PsiExpression expression = ((PsiExpressionStatement)statement).getExpression();
            return (T)((PsiExpression)ObjectUtils.tryCast((Object)expression, wantedType));
        }
        return null;
    }

    int getOperationCount() {
        return this.myOperations.length;
    }

    @Nullable
    PsiMethodCallExpression getSingleMethodCall() {
        return this.getSingleExpression(PsiMethodCallExpression.class);
    }

    @Nullable
    private TerminalBlock extractFilter() {
        PsiStatement first;
        PsiStatement single = this.getSingleStatement();
        if (single instanceof PsiIfStatement) {
            PsiStatement thenBranch;
            PsiIfStatement ifStatement = (PsiIfStatement)single;
            PsiExpression condition = ifStatement.getCondition();
            if (ifStatement.getElseBranch() == null && condition != null && (thenBranch = ifStatement.getThenBranch()) != null) {
                return this.fromCondition(condition, false, thenBranch);
            }
        }
        if (this.myStatements.length >= 1 && (first = this.myStatements[0]) instanceof PsiIfStatement) {
            PsiStatement[] statements;
            PsiIfStatement ifStatement = (PsiIfStatement)first;
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return null;
            }
            PsiStatement branch = ifStatement.getThenBranch();
            if (branch instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)branch).getCodeBlock().getStatements()).length == 1) {
                branch = statements[0];
            }
            if (!(branch instanceof PsiContinueStatement) || ((PsiContinueStatement)branch).getLabelIdentifier() != null) {
                return null;
            }
            if (ifStatement.getElseBranch() != null) {
                statements = (PsiStatement[])this.myStatements.clone();
                statements[0] = ifStatement.getElseBranch();
            } else {
                statements = Arrays.copyOfRange(this.myStatements, 1, this.myStatements.length);
            }
            return this.fromCondition(condition, true, statements);
        }
        return null;
    }

    @Nullable
    private TerminalBlock fromCondition(PsiExpression condition, boolean negated, PsiStatement ... statements) {
        TerminalBlock result = new TerminalBlock(this, new StreamApiMigrationInspection.FilterOp(condition, this.myVariable, negated), this.myVariable, statements);
        List vars = JavaPsiPatternUtil.getExposedPatternVariables((PsiExpression)condition);
        if (!vars.isEmpty()) {
            List used = ContainerUtil.filter((Collection)vars, var -> ContainerUtil.or((Object[])statements, st -> VariableAccessUtils.variableIsUsed((PsiVariable)var, (PsiElement)st)));
            if (used.size() > 1) {
                return null;
            }
            if (!used.isEmpty()) {
                PsiPatternVariable var2 = (PsiPatternVariable)used.getFirst();
                String text = JavaPsiPatternUtil.getEffectiveInitializerText((PsiPatternVariable)var2);
                if (text == null) {
                    return null;
                }
                if (ContainerUtil.or((Object[])statements, st -> VariableAccessUtils.variableIsUsed((PsiVariable)this.myVariable, (PsiElement)st))) {
                    return null;
                }
                PsiExpression mappingExpression = JavaPsiFacade.getElementFactory((Project)condition.getProject()).createExpressionFromText(text, (PsiElement)var2);
                result = new TerminalBlock(result, new StreamApiMigrationInspection.MapOp(mappingExpression, this.myVariable, var2.getType()), (PsiVariable)var2, statements);
            }
        }
        return result;
    }

    @Nullable
    private TerminalBlock extractOperation() {
        TerminalBlock withLimit;
        StreamApiMigrationInspection.Operation op2;
        TerminalBlock withFilter = this.extractFilter();
        if (withFilter != null) {
            return withFilter;
        }
        PsiStatement psiStatement = this.getSingleStatement();
        if (psiStatement instanceof PsiLoopStatement) {
            PsiLoopStatement loopStatement = (PsiLoopStatement)psiStatement;
            StreamApiMigrationInspection.StreamSource source = StreamApiMigrationInspection.StreamSource.tryCreate(loopStatement);
            PsiStatement body = loopStatement.getBody();
            if (source == null || body == null) {
                return null;
            }
            op2 = new StreamApiMigrationInspection.FlatMapOp(source, this.myVariable);
            TerminalBlock withFlatMap = new TerminalBlock(this, op2, source.getVariable(), body);
            if (!VariableAccessUtils.variableIsUsed((PsiVariable)this.myVariable, (PsiElement)body)) {
                return withFlatMap;
            }
            TerminalBlock withFlatMapFilter = withFlatMap.extractFilter();
            if (withFlatMapFilter != null && !withFlatMapFilter.isEmpty()) {
                boolean flowBreaks;
                PsiStatement[] statements = withFlatMapFilter.getStatements();
                PsiStatement lastStatement = statements[statements.length - 1];
                boolean bl = flowBreaks = lastStatement instanceof PsiBreakStatement && ((StreamApiMigrationInspection.FlatMapOp)op2).breaksMe((PsiBreakStatement)lastStatement) || lastStatement instanceof PsiReturnStatement || lastStatement instanceof PsiThrowStatement;
                if (flowBreaks && ReferencesSearch.search((PsiElement)withFlatMapFilter.getVariable(), (SearchScope)new LocalSearchScope((PsiElement[])statements)).findFirst() == null) {
                    StreamApiMigrationInspection.FilterOp filterOp = (StreamApiMigrationInspection.FilterOp)withFlatMapFilter.getLastOperation();
                    return new TerminalBlock(this, new StreamApiMigrationInspection.CompoundFilterOp(((StreamApiMigrationInspection.FlatMapOp)op2).getSource(), op2.getVariable(), filterOp), this.myVariable, lastStatement instanceof PsiReturnStatement || lastStatement instanceof PsiThrowStatement ? statements : Arrays.copyOf(statements, statements.length - 1));
                }
            }
        }
        if (this.myStatements.length >= 1) {
            PsiExpression rValue;
            PsiLocalVariable declaredVar;
            PsiDeclarationStatement decl;
            PsiElement[] elements;
            StreamApiMigrationInspection.Operation op3;
            PsiStatement first = this.myStatements[0];
            if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)this.myVariable.getContainingFile()) && first instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)first;
                PsiExpression condition = ifStatement.getCondition();
                if (ifStatement.getElseBranch() == null && condition != null) {
                    PsiLoopStatement loop;
                    PsiStatement thenStatement = ControlFlowUtils.stripBraces((PsiStatement)ifStatement.getThenBranch());
                    PsiStatement sourceStatement = this.getStreamSourceStatement();
                    if (sourceStatement instanceof PsiLoopStatement && ControlFlowUtils.statementBreaksLoop((PsiStatement)thenStatement, (PsiLoopStatement)(loop = (PsiLoopStatement)sourceStatement))) {
                        op3 = new StreamApiMigrationInspection.TakeWhileOp(condition, this.myVariable, true);
                        PsiStatement[] leftOver = Arrays.copyOfRange(this.myStatements, 1, this.myStatements.length);
                        return new TerminalBlock(this, op3, this.myVariable, leftOver);
                    }
                }
            }
            if (first instanceof PsiDeclarationStatement && (elements = (decl = (PsiDeclarationStatement)first).getDeclaredElements()).length == 1 && (declaredVar = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class)) != null && StreamApiUtil.isSupportedStreamElement((PsiType)declaredVar.getType())) {
                PsiExpression initializer = declaredVar.getInitializer();
                PsiStatement[] leftOver = Arrays.copyOfRange(this.myStatements, 1, this.myStatements.length);
                if (initializer != null && ReferencesSearch.search((PsiElement)this.myVariable, (SearchScope)new LocalSearchScope((PsiElement[])leftOver)).findFirst() == null) {
                    op3 = new StreamApiMigrationInspection.MapOp(initializer, this.myVariable, declaredVar.getType());
                    return new TerminalBlock(this, op3, (PsiVariable)declaredVar, leftOver);
                }
            }
            if ((rValue = ExpressionUtils.getAssignmentTo((PsiElement)first, (PsiVariable)this.myVariable)) != null && this.operations().allMatch(op -> op.canReassignVariable(this.myVariable))) {
                PsiStatement[] leftOver = Arrays.copyOfRange(this.myStatements, 1, this.myStatements.length);
                op2 = new StreamApiMigrationInspection.MapOp(rValue, this.myVariable, this.myVariable.getType());
                return new TerminalBlock(this, op2, this.myVariable, leftOver);
            }
        }
        return (withLimit = this.tryPeelLimit(true)) == this ? null : withLimit;
    }

    private TerminalBlock tryPeelLimit(boolean dedicatedCounter) {
        PsiExpression limit;
        StreamApiMigrationInspection.FilterOp filter;
        PsiStatement[] statements;
        TerminalBlock tb;
        block31: {
            block30: {
                if (this.myStatements.length == 0) {
                    return this;
                }
                tb = this;
                statements = new PsiStatement[]{};
                if (this.myStatements.length > 1) {
                    int count = this.myStatements.length - 1;
                    if (this.myStatements[count] instanceof PsiBreakStatement || this.myStatements[count] instanceof PsiReturnStatement) {
                        --count;
                    }
                    statements = Arrays.copyOf(this.myStatements, count);
                    tb = new TerminalBlock(this.myOperations, this.myVariable, Arrays.copyOfRange(this.myStatements, count, this.myStatements.length)).extractFilter();
                }
                PsiStatement sourceStatement = this.getStreamSourceStatement();
                if (tb == null) break block30;
                if (!(sourceStatement instanceof PsiLoopStatement)) break block31;
                PsiLoopStatement loop = (PsiLoopStatement)sourceStatement;
                if (ControlFlowUtils.statementBreaksLoop((PsiStatement)tb.getSingleStatement(), (PsiLoopStatement)loop)) break block31;
            }
            return this;
        }
        if ((filter = tb.getLastOperation(StreamApiMigrationInspection.FilterOp.class)) == null) {
            return this;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)filter.getExpression()), PsiBinaryExpression.class);
        if (!ComparisonUtils.isComparison((PsiExpression)binOp)) {
            return this;
        }
        String comparison = filter.isNegated() ? ComparisonUtils.getNegatedComparison((IElementType)binOp.getOperationTokenType()) : binOp.getOperationSign().getText();
        boolean flipped = false;
        int delta = 0;
        switch (comparison) {
            case "==": 
            case ">=": {
                break;
            }
            case ">": {
                delta = 1;
                break;
            }
            case "<": {
                delta = 1;
                flipped = true;
                break;
            }
            case "<=": {
                flipped = true;
                break;
            }
            default: {
                return this;
            }
        }
        PsiExpression countExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)(flipped ? binOp.getROperand() : binOp.getLOperand()));
        if (countExpression == null || VariableAccessUtils.variableIsUsed((PsiVariable)this.myVariable, (PsiElement)countExpression)) {
            return this;
        }
        PsiExpression incrementedValue = StreamApiMigrationInspection.extractIncrementedLValue(countExpression);
        PsiLocalVariable var = null;
        if (dedicatedCounter) {
            if (!(incrementedValue instanceof PsiReferenceExpression)) {
                return this;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)incrementedValue;
            var = (PsiLocalVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiLocalVariable.class);
            if (var == null || !ExpressionUtils.isZero((PsiExpression)var.getInitializer()) || VariableAccessUtils.getVariableReferences((PsiVariable)var).size() != 1) {
                return this;
            }
        }
        PsiExpression psiExpression = limit = flipped ? binOp.getLOperand() : binOp.getROperand();
        if (!ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)limit) || VariableAccessUtils.variableIsUsed((PsiVariable)this.myVariable, (PsiElement)limit)) {
            return this;
        }
        PsiType type = limit.getType();
        if (!PsiTypes.intType().equals((Object)type) && !PsiTypes.longType().equals((Object)type)) {
            return this;
        }
        if (countExpression instanceof PsiPostfixExpression) {
            ++delta;
        }
        TerminalBlock block = new TerminalBlock(Arrays.copyOf(tb.myOperations, tb.myOperations.length - 1), this.myVariable, statements);
        if (incrementedValue == null) {
            TerminalBlock newBlock;
            while ((newBlock = block.extractOperation()) != null && !(newBlock.getLastOperation() instanceof StreamApiMigrationInspection.FlatMapOp)) {
                block = newBlock;
            }
        }
        return block.add(new StreamApiMigrationInspection.LimitOp(block.getVariable(), countExpression, limit, var, delta));
    }

    @Nullable
    private PsiLocalVariable extractCollectionAdditionVariable() {
        PsiMethodCallExpression call = this.getSingleMethodCall();
        if (!StreamApiMigrationInspection.isCallOf(call, "java.util.Collection", "add")) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 1 || !ExpressionUtils.isReferenceTo((PsiExpression)args[0], (PsiVariable)this.myVariable)) {
            return null;
        }
        PsiReferenceExpression qualifier = (PsiReferenceExpression)ObjectUtils.tryCast((Object)call.getMethodExpression().getQualifierExpression(), PsiReferenceExpression.class);
        if (qualifier == null) {
            return null;
        }
        PsiLocalVariable var = (PsiLocalVariable)ObjectUtils.tryCast((Object)qualifier.resolve(), PsiLocalVariable.class);
        if (var == null) {
            return null;
        }
        PsiNewExpression initializer = (PsiNewExpression)ObjectUtils.tryCast((Object)var.getInitializer(), PsiNewExpression.class);
        if (initializer == null) {
            return null;
        }
        PsiExpressionList argumentList = initializer.getArgumentList();
        if (argumentList == null || !argumentList.isEmpty() || ControlFlowUtils.getInitializerUsageStatus((PsiVariable)var, (PsiStatement)this.getStreamSourceStatement()) == ControlFlowUtils.InitializerUsageStatus.UNKNOWN) {
            return null;
        }
        return var;
    }

    @NotNull
    private TerminalBlock replace(StreamApiMigrationInspection.Operation orig, StreamApiMigrationInspection.Operation replacement) {
        int idx = ArrayUtil.indexOf((Object[])this.myOperations, (Object)orig);
        if (idx == -1) {
            throw new NoSuchElementException(orig.toString());
        }
        StreamApiMigrationInspection.Operation[] ops = (StreamApiMigrationInspection.Operation[])this.myOperations.clone();
        ops[idx] = replacement;
        return new TerminalBlock(ops, this.myVariable, this.myStatements);
    }

    TerminalBlock add(StreamApiMigrationInspection.Operation op) {
        return new TerminalBlock(this, op, this.myVariable, this.myStatements);
    }

    private TerminalBlock tryExtractDistinct() {
        PsiLocalVariable collectionVariable = this.extractCollectionAdditionVariable();
        if (collectionVariable == null) {
            return this;
        }
        for (int idx = this.myOperations.length - 1; idx > 0; --idx) {
            StreamApiMigrationInspection.Operation op = this.myOperations[idx];
            if (op instanceof StreamApiMigrationInspection.FilterOp) {
                PsiExpression[] conditionArgs;
                PsiMethodCallExpression conditionCall;
                StreamApiMigrationInspection.FilterOp filter = (StreamApiMigrationInspection.FilterOp)op;
                PsiExpression condition = filter.getExpression();
                if (BoolUtils.isNegation((PsiExpression)condition)) {
                    if (filter.isNegated()) continue;
                    condition = BoolUtils.getNegated((PsiExpression)condition);
                } else if (!filter.isNegated()) continue;
                if (!(condition instanceof PsiMethodCallExpression) || !ExpressionUtils.isReferenceTo((PsiExpression)(conditionCall = (PsiMethodCallExpression)condition).getMethodExpression().getQualifierExpression(), (PsiVariable)collectionVariable) || !StreamApiMigrationInspection.isCallOf(conditionCall, "java.util.Collection", "contains") || (conditionArgs = conditionCall.getArgumentList().getExpressions()).length != 1 || !ExpressionUtils.isReferenceTo((PsiExpression)conditionArgs[0], (PsiVariable)this.myVariable)) continue;
                return this.replace(op, new StreamApiMigrationInspection.DistinctOp(this.myVariable));
            }
            if (!(op instanceof StreamApiMigrationInspection.LimitOp)) break;
        }
        return this;
    }

    @NotNull
    StreamApiMigrationInspection.Operation getLastOperation() {
        StreamApiMigrationInspection.Operation operation = this.myOperations[this.myOperations.length - 1];
        if (operation == null) {
            TerminalBlock.$$$reportNull$$$0(7);
        }
        return operation;
    }

    @Nullable
    TerminalBlock withoutLastOperation() {
        if (this.myOperations.length == 1) {
            return null;
        }
        StreamApiMigrationInspection.Operation[] operations = new StreamApiMigrationInspection.Operation[this.myOperations.length - 1];
        System.arraycopy(this.myOperations, 0, operations, 0, operations.length);
        return new TerminalBlock(operations, operations[operations.length - 1].getVariable(), this.myStatements);
    }

    @Nullable
    <T extends StreamApiMigrationInspection.Operation> T getLastOperation(Class<T> clazz) {
        return (T)((StreamApiMigrationInspection.Operation)ObjectUtils.tryCast((Object)this.getLastOperation(), clazz));
    }

    @Nullable
    PsiExpression getCountExpression() {
        StreamApiMigrationInspection.LimitOp limitOp = this.getLastOperation(StreamApiMigrationInspection.LimitOp.class);
        if (limitOp != null && limitOp.getCounterVariable() == null) {
            return limitOp.getCountExpression();
        }
        return null;
    }

    @NotNull
    private TerminalBlock extractOperations() {
        TerminalBlock terminalBlock = StreamEx.iterate((Object)this, Objects::nonNull, TerminalBlock::extractOperation).reduce((a, b) -> b).orElse(this);
        if (terminalBlock == null) {
            TerminalBlock.$$$reportNull$$$0(8);
        }
        return terminalBlock;
    }

    @NotNull
    PsiVariable getVariable() {
        PsiVariable psiVariable = this.myVariable;
        if (psiVariable == null) {
            TerminalBlock.$$$reportNull$$$0(9);
        }
        return psiVariable;
    }

    boolean hasOperations() {
        return this.myOperations.length > 1;
    }

    boolean isEmpty() {
        return this.myStatements.length == 0;
    }

    @NotNull
    StreamEx<StreamApiMigrationInspection.Operation> operations() {
        StreamEx streamEx = StreamEx.ofReversed((Object[])this.myOperations);
        if (streamEx == null) {
            TerminalBlock.$$$reportNull$$$0(10);
        }
        return streamEx;
    }

    PsiStatement getStreamSourceStatement() {
        return ((StreamApiMigrationInspection.StreamSource)this.myOperations[0]).getMainStatement();
    }

    private StreamEx<PsiExpression> intermediateExpressions() {
        return StreamEx.of((Object[])this.myOperations, (int)1, (int)this.myOperations.length).flatMap(StreamApiMigrationInspection.Operation::expressions);
    }

    StreamEx<PsiExpression> intermediateAndSourceExpressions() {
        return this.operations().flatMap(StreamApiMigrationInspection.Operation::expressions);
    }

    PsiElement convertToElement(CommentTracker ct, PsiElementFactory factory) {
        if (this.myStatements.length == 1) {
            return this.myStatements[0];
        }
        PsiCodeBlock block = factory.createCodeBlockFromText("{}", (PsiElement)this.myVariable);
        for (PsiStatement statement : this.myStatements) {
            block.add(ct.markUnchanged((PsiElement)statement));
        }
        return block;
    }

    void replaceContinueWithReturn(PsiElementFactory factory) {
        PsiLoopStatement currentLoop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myStatements[0], PsiLoopStatement.class);
        if (currentLoop == null) {
            return;
        }
        for (PsiStatement statement : this.myStatements) {
            if (statement instanceof PsiContinueStatement) {
                this.myStatements[i] = factory.createStatementFromText("return;", null);
                continue;
            }
            ((StreamEx)StreamEx.ofTree((Object)statement, s -> StreamEx.of((Object[])s.getChildren())).select(PsiContinueStatement.class).filter(stmt -> stmt.findContinuedStatement() == currentLoop)).forEach(stmt -> new CommentTracker().replaceAndRestoreComments((PsiElement)stmt, "return;"));
        }
    }

    String generate(CommentTracker ct) {
        return this.generate(ct, false);
    }

    String generate(CommentTracker ct, boolean noStreamForEmpty) {
        if (noStreamForEmpty && this.myOperations.length == 1 && this.myOperations[0] instanceof StreamApiMigrationInspection.CollectionStream) {
            return ParenthesesUtils.getText((PsiExpression)this.myOperations[0].getExpression(), (int)2);
        }
        return StreamEx.of((Object[])this.myOperations).map(operation -> operation.createReplacement(ct)).joining();
    }

    @NotNull
    static TerminalBlock from(StreamApiMigrationInspection.StreamSource source, @NotNull PsiStatement body) {
        if (body == null) {
            TerminalBlock.$$$reportNull$$$0(11);
        }
        return TerminalBlock.fromStatements(source, body);
    }

    @NotNull
    static TerminalBlock fromStatements(StreamApiMigrationInspection.StreamSource source, PsiStatement ... statements) {
        if (statements == null) {
            TerminalBlock.$$$reportNull$$$0(12);
        }
        TerminalBlock terminalBlock = new TerminalBlock(null, source, source.myVariable, statements).extractOperations().tryPeelLimit(false).tryExtractDistinct();
        if (terminalBlock == null) {
            TerminalBlock.$$$reportNull$$$0(13);
        }
        return terminalBlock;
    }

    @NotNull
    static TerminalBlock from(StreamApiMigrationInspection.StreamSource source, @NotNull PsiCodeBlock block) {
        if (block == null) {
            TerminalBlock.$$$reportNull$$$0(14);
        }
        return TerminalBlock.fromStatements(source, block.getStatements());
    }

    boolean dependsOn(PsiExpression qualifier) {
        return this.intermediateExpressions().anyMatch(expression -> StreamApiMigrationInspection.isExpressionDependsOnUpdatedCollections(expression, qualifier));
    }

    boolean isReferencedInOperations(PsiVariable variable) {
        return this.intermediateAndSourceExpressions().anyMatch(expr -> VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)expr));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operations";
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamMigration/TerminalBlock";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamMigration/TerminalBlock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastOperation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "extractOperations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "operations";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fromStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fromStatements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 13 -> new IllegalStateException(string);
        };
    }
}

