/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.streamToLoop.ChainContext;
import com.intellij.codeInspection.streamToLoop.ConditionalExpression;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.codeInspection.streamToLoop.Operation;
import com.intellij.codeInspection.streamToLoop.StreamToLoopInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StreamToLoopReplacementContext
extends ChainContext {
    private final boolean myHasNestedLoops;
    private final Set<String> myUsedLabels;
    private final CommentTracker myCommentTracker;
    private final String mySuffix;
    private String myFinisher;
    private String myLabel;
    private static final Logger LOG = Logger.getInstance(StreamToLoopReplacementContext.class);

    StreamToLoopReplacementContext(PsiStatement statement, List<StreamToLoopInspection.OperationRecord> records, @NotNull PsiExpression streamExpression, CommentTracker ct) {
        if (streamExpression == null) {
            StreamToLoopReplacementContext.$$$reportNull$$$0(0);
        }
        super((PsiElement)streamExpression);
        this.myHasNestedLoops = ContainerUtil.exists(records, or -> or.myOperation instanceof Operation.FlatMapOperation);
        this.mySuffix = this.myHasNestedLoops ? "Outer" : "";
        this.myUsedLabels = StreamEx.iterate((Object)statement, Objects::nonNull, PsiElement::getParent).select(PsiLabeledStatement.class).map(PsiLabeledStatement::getName).toSet();
        this.myCommentTracker = ct;
    }

    StreamToLoopReplacementContext(StreamToLoopReplacementContext parentContext, List<StreamToLoopInspection.OperationRecord> records) {
        super(parentContext);
        this.myUsedLabels = parentContext.myUsedLabels;
        this.mySuffix = "Inner";
        this.myHasNestedLoops = ContainerUtil.exists(records, or -> or.myOperation instanceof Operation.FlatMapOperation);
        this.myCommentTracker = parentContext.myCommentTracker;
    }

    public void registerReusedElement(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitVariable(@NotNull PsiVariable variable) {
                if (variable == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitVariable(variable);
                StreamToLoopReplacementContext.this.myUsedNames.add(variable.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/streamToLoop/StreamToLoopReplacementContext$1", "visitVariable"));
            }
        });
        this.myCommentTracker.markUnchanged(element);
    }

    @Nullable
    private String allocateLabel() {
        if (!this.myHasNestedLoops) {
            return null;
        }
        if (this.myLabel == null) {
            String base = StringUtil.toUpperCase((String)this.mySuffix);
            this.myLabel = (String)((StreamEx)IntStreamEx.ints().mapToObj(i -> i == 0 ? base : base + i).remove(this.myUsedLabels::contains)).findFirst().orElseThrow(IllegalArgumentException::new);
            this.myUsedLabels.add(this.myLabel);
        }
        return this.myLabel;
    }

    public String getLoopLabel() {
        return this.myLabel == null ? "" : this.myLabel + ":\n";
    }

    public String getBreakStatement() {
        String label = this.allocateLabel();
        return label == null ? "break;\n" : "break " + label + ";\n";
    }

    @Override
    public String declare(String desiredName, String type, String initializer) {
        String name = this.registerVarName(this.mySuffix.isEmpty() ? Collections.singleton(desiredName) : Arrays.asList(desiredName, desiredName + this.mySuffix));
        this.addBeforeStep(type + " " + name + " = " + initializer + ";");
        return name;
    }

    public String declareResult(String desiredName, PsiType type, String initializer, @NotNull StreamToLoopInspection.ResultKind kind) {
        if (kind == null) {
            StreamToLoopReplacementContext.$$$reportNull$$$0(1);
        }
        return this.declareResult(desiredName, type, null, initializer, kind);
    }

    public String declareResult(String desiredName, PsiType type, String mostAbstractAllowedType, String initializer, @NotNull StreamToLoopInspection.ResultKind kind) {
        PsiVariable var;
        PsiElement psiElement;
        if (kind == null) {
            StreamToLoopReplacementContext.$$$reportNull$$$0(2);
        }
        if (kind != StreamToLoopInspection.ResultKind.UNKNOWN && (psiElement = this.myChainExpression.getParent()) instanceof PsiVariable && StreamToLoopReplacementContext.isCompatibleType(var = (PsiVariable)psiElement, type, mostAbstractAllowedType) && (psiElement = var.getParent()) instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)psiElement;
            if ((kind == StreamToLoopInspection.ResultKind.FINAL || VariableAccessUtils.canUseAsNonFinal((PsiLocalVariable)((PsiLocalVariable)ObjectUtils.tryCast((Object)var, PsiLocalVariable.class)))) && declaration.getDeclaredElements().length == 1) {
                PsiExpression oldInitializer;
                PsiModifierList modifierList;
                this.myChainExpression = declaration;
                PsiVariable copy = (PsiVariable)var.copy();
                if (kind == StreamToLoopInspection.ResultKind.NON_FINAL && (modifierList = copy.getModifierList()) != null) {
                    modifierList.setModifierProperty("final", false);
                }
                LOG.assertTrue((oldInitializer = copy.getInitializer()) != null);
                oldInitializer.replace((PsiElement)this.createExpression(initializer));
                this.addBeforeStep(copy.getText());
                return var.getName();
            }
        }
        String name = this.registerVarName(Arrays.asList(desiredName, "result"));
        this.addBeforeStep(type.getCanonicalText() + " " + name + " = " + initializer + ";");
        if (this.myFinisher != null) {
            throw new IllegalStateException("Finisher is already defined");
        }
        this.setFinisher(name);
        return name;
    }

    public boolean tryUnwrapOrElse(@NotNull Number wantedValue) {
        if (wantedValue == null) {
            StreamToLoopReplacementContext.$$$reportNull$$$0(3);
        }
        if (!(this.myChainExpression instanceof PsiExpression)) {
            return false;
        }
        PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)((PsiExpression)this.myChainExpression));
        if (call == null || call.getParent() instanceof PsiExpressionStatement || !"orElse".equals(call.getMethodExpression().getReferenceName())) {
            return false;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length == 1 && wantedValue.equals(ExpressionUtils.computeConstantExpression((PsiExpression)args[0]))) {
            this.myChainExpression = call;
            return true;
        }
        return false;
    }

    private static boolean isCompatibleType(@NotNull PsiVariable var, @NotNull PsiType type, @Nullable String mostAbstractAllowedType) {
        if (var == null) {
            StreamToLoopReplacementContext.$$$reportNull$$$0(4);
        }
        if (type == null) {
            StreamToLoopReplacementContext.$$$reportNull$$$0(5);
        }
        if (EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(var.getType(), type)) {
            return true;
        }
        if (mostAbstractAllowedType == null) {
            return false;
        }
        Object[] superTypes = type.getSuperTypes();
        return ContainerUtil.exists((Object[])superTypes, superType -> InheritanceUtil.isInheritor((PsiType)superType, (String)mostAbstractAllowedType) && StreamToLoopReplacementContext.isCompatibleType(var, superType, mostAbstractAllowedType));
    }

    public PsiElement makeFinalReplacement() {
        LOG.assertTrue(this.myChainExpression != null);
        if (this.myFinisher == null || this.myChainExpression instanceof PsiStatement) {
            PsiElement toDelete = this.myChainExpression;
            if (toDelete instanceof PsiExpression && toDelete.getParent() instanceof PsiExpressionStatement) {
                toDelete = toDelete.getParent();
                while (toDelete instanceof PsiExpressionStatement && toDelete.getParent() instanceof PsiLabeledStatement) {
                    toDelete = toDelete.getParent();
                }
            }
            this.myCommentTracker.delete(toDelete);
            return null;
        }
        PsiExpression expression = this.createExpression(this.myFinisher);
        PsiElement parent = this.myChainExpression.getParent();
        if (parent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded((PsiExpression)expression, (PsiExpression)((PsiExpression)parent), (boolean)false)) {
            expression = this.createExpression("(" + this.myFinisher + ")");
        }
        return this.myCommentTracker.replace(this.myChainExpression, (PsiElement)expression);
    }

    public void setFinisher(String finisher) {
        this.myFinisher = finisher;
    }

    public void setFinisher(ConditionalExpression conditionalExpression) {
        if (conditionalExpression instanceof ConditionalExpression.Optional) {
            conditionalExpression = this.tryUnwrapOptional((ConditionalExpression.Optional)conditionalExpression, true);
        }
        this.setFinisher(conditionalExpression.asExpression());
    }

    public String assignAndBreak(ConditionalExpression conditionalExpression) {
        FunctionHelper fn;
        PsiExpression[] args;
        PsiMethodCallExpression call;
        ConditionalExpression.Boolean boolCondition;
        PsiIfStatement ifStatement;
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myChainExpression, PsiStatement.class);
        boolean inReturn = statement instanceof PsiReturnStatement;
        if (conditionalExpression instanceof ConditionalExpression.Optional) {
            conditionalExpression = this.tryUnwrapOptional((ConditionalExpression.Optional)conditionalExpression, inReturn);
        }
        if (conditionalExpression instanceof ConditionalExpression.Boolean) {
            conditionalExpression = this.tryUnwrapBoolean((ConditionalExpression.Boolean)conditionalExpression, inReturn);
        }
        if (inReturn) {
            this.setFinisher(conditionalExpression.getFalseBranch());
            Object mark = new Object();
            PsiTreeUtil.mark((PsiElement)this.myChainExpression, (Object)mark);
            PsiElement returnCopy = statement.copy();
            PsiElement placeHolderCopy = PsiTreeUtil.releaseMark((PsiElement)returnCopy, (Object)mark);
            LOG.assertTrue(placeHolderCopy != null);
            PsiElement replacement = placeHolderCopy.replace((PsiElement)this.createExpression(conditionalExpression.getTrueBranch()));
            if (returnCopy == placeHolderCopy) {
                returnCopy = replacement;
            }
            Object text = returnCopy.getText();
            if (returnCopy.getLastChild() instanceof PsiComment) {
                text = (String)text + "\n";
            }
            return text;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)this.myChainExpression.getParent());
        if (parent instanceof PsiIfStatement && (ifStatement = (PsiIfStatement)parent).getElseBranch() == null && conditionalExpression instanceof ConditionalExpression.Boolean && !(boolCondition = (ConditionalExpression.Boolean)conditionalExpression).isInverted()) {
            PsiStatement thenStatement = ControlFlowUtils.stripBraces((PsiStatement)ifStatement.getThenBranch());
            if (thenStatement instanceof PsiReturnStatement || thenStatement instanceof PsiThrowStatement) {
                this.myChainExpression = parent;
                return thenStatement.getText();
            }
            if (thenStatement instanceof PsiExpressionStatement) {
                this.myChainExpression = parent;
                return thenStatement.getText() + "\n" + this.getBreakStatement();
            }
        }
        if (conditionalExpression instanceof ConditionalExpression.Optional && this.myChainExpression instanceof PsiExpression && (call = ExpressionUtils.getCallForQualifier((PsiExpression)((PsiExpression)this.myChainExpression))) != null && call.getParent() instanceof PsiExpressionStatement && (args = call.getArgumentList().getExpressions()).length == 1 && "ifPresent".equals(call.getMethodExpression().getReferenceName()) && (fn = FunctionHelper.create(args[0], 1)) != null) {
            fn.transform(this, ((ConditionalExpression.Optional)conditionalExpression).unwrap("").getTrueBranch());
            this.myChainExpression = call.getParent();
            return fn.getStatementText() + this.getBreakStatement();
        }
        String found = this.declareResult(conditionalExpression.getCondition(), this.createType(conditionalExpression.getType()), conditionalExpression.getFalseBranch(), StreamToLoopInspection.ResultKind.NON_FINAL);
        return found + " = " + conditionalExpression.getTrueBranch() + ";\n" + this.getBreakStatement();
    }

    private ConditionalExpression tryUnwrapBoolean(ConditionalExpression.Boolean condition, boolean unwrapLazilyEvaluated) {
        if (this.myChainExpression instanceof PsiExpression) {
            PsiConditionalExpression ternary;
            PsiExpression negation = BoolUtils.findNegation((PsiExpression)((PsiExpression)this.myChainExpression));
            if (negation != null) {
                this.myChainExpression = negation;
                condition = condition.negate();
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)this.myChainExpression.getParent());
            ConditionalExpression candidate = null;
            if (parent instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression expression = (PsiPolyadicExpression)parent;
                Object[] operands = expression.getOperands();
                if (operands.length > 1 && PsiTreeUtil.isAncestor((PsiElement)operands[0], (PsiElement)this.myChainExpression, (boolean)false)) {
                    IElementType type = expression.getOperationTokenType();
                    if (type.equals(JavaTokenType.ANDAND)) {
                        candidate = condition.toPlain((PsiType)PsiTypes.booleanType(), StreamEx.of((Object[])operands, (int)1, (int)operands.length).map(PsiElement::getText).joining((CharSequence)" && "), "false");
                    } else if (type.equals(JavaTokenType.OROR)) {
                        candidate = condition.toPlain((PsiType)PsiTypes.booleanType(), "true", StreamEx.of((Object[])operands, (int)1, (int)operands.length).map(PsiElement::getText).joining((CharSequence)" || "));
                    }
                }
            } else if (parent instanceof PsiConditionalExpression && PsiTreeUtil.isAncestor((PsiElement)(ternary = (PsiConditionalExpression)parent).getCondition(), (PsiElement)this.myChainExpression, (boolean)false)) {
                PsiType type = ternary.getType();
                PsiExpression thenExpression = ternary.getThenExpression();
                PsiExpression elseExpression = ternary.getElseExpression();
                if (type != null && thenExpression != null && elseExpression != null) {
                    candidate = condition.toPlain(type, thenExpression.getText(), elseExpression.getText());
                }
            }
            if (candidate != null && (unwrapLazilyEvaluated || ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)this.createExpression(candidate.getFalseBranch())))) {
                this.myChainExpression = parent;
                return candidate;
            }
        }
        return condition;
    }

    @NotNull
    private ConditionalExpression tryUnwrapOptional(ConditionalExpression.Optional condition, boolean unwrapLazilyEvaluated) {
        PsiMethodCallExpression call;
        if (this.myChainExpression instanceof PsiExpression && (call = ExpressionUtils.getCallForQualifier((PsiExpression)((PsiExpression)this.myChainExpression))) != null && !(call.getParent() instanceof PsiExpressionStatement)) {
            String name = call.getMethodExpression().getReferenceName();
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length == 0 && "isPresent".equals(name)) {
                this.myChainExpression = call;
                return new ConditionalExpression.Boolean(condition.getCondition(), false);
            }
            if (args.length == 1) {
                FunctionHelper helper;
                String absentExpression = null;
                if ("orElse".equals(name)) {
                    absentExpression = args[0].getText();
                } else if (unwrapLazilyEvaluated && "orElseGet".equals(name) && (helper = FunctionHelper.create(args[0], 0)) != null) {
                    helper.transform(this, new String[0]);
                    absentExpression = helper.getText();
                }
                if (absentExpression != null) {
                    this.myChainExpression = call;
                    ConditionalExpression.Plain plain = condition.unwrap(absentExpression);
                    if (plain == null) {
                        StreamToLoopReplacementContext.$$$reportNull$$$0(6);
                    }
                    return plain;
                }
            }
        }
        ConditionalExpression.Optional optional = condition;
        if (optional == null) {
            StreamToLoopReplacementContext.$$$reportNull$$$0(7);
        }
        return optional;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamExpression";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wantedValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamToLoop/StreamToLoopReplacementContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamToLoop/StreamToLoopReplacementContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "tryUnwrapOptional";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "declareResult";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryUnwrapOrElse";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleType";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

