/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.streamToLoop.ChainContext;
import com.intellij.codeInspection.streamToLoop.ChainVariable;
import com.intellij.codeInspection.streamToLoop.ConditionalExpression;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.codeInspection.streamToLoop.Operation;
import com.intellij.codeInspection.streamToLoop.StreamToLoopInspection;
import com.intellij.codeInspection.streamToLoop.StreamToLoopReplacementContext;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TerminalOperation
extends Operation {
    TerminalOperation() {
    }

    @Override
    final String wrap(ChainVariable inVar, ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
        return this.generate(inVar, context);
    }

    @Override
    final void rename(String oldName, String newName, StreamToLoopReplacementContext context) {
        throw new IllegalStateException("Should not be called for terminal operation (tried to rename " + oldName + " -> " + newName + ")");
    }

    @Override
    final boolean changesVariable() {
        return true;
    }

    CollectorOperation asCollector() {
        return null;
    }

    abstract String generate(ChainVariable var1, StreamToLoopReplacementContext var2);

    @Nullable
    static TerminalOperation createTerminal(@NotNull String name, PsiExpression @NotNull [] args, @NotNull PsiType elementType, @NotNull PsiType resultType, boolean isVoid) {
        if (name == null) {
            TerminalOperation.$$$reportNull$$$0(0);
        }
        if (elementType == null) {
            TerminalOperation.$$$reportNull$$$0(1);
        }
        if (resultType == null) {
            TerminalOperation.$$$reportNull$$$0(2);
        }
        if (args == null) {
            TerminalOperation.$$$reportNull$$$0(3);
        }
        if (isVoid) {
            if ((name.equals("forEach") || name.equals("forEachOrdered")) && args.length == 1) {
                FunctionHelper fn = FunctionHelper.create(args[0], 1, true);
                return fn == null ? null : new ForEachTerminalOperation(fn);
            }
            return null;
        }
        if (name.equals("count") && args.length == 0) {
            return TemplateBasedOperation.counting();
        }
        if (name.equals("sum") && args.length == 0) {
            return TemplateBasedOperation.summing(resultType);
        }
        if (name.equals("average") && args.length == 0) {
            if (elementType.equals(PsiTypes.doubleType())) {
                return new AverageTerminalOperation(true, true);
            }
            if (elementType.equals(PsiTypes.intType()) || elementType.equals(PsiTypes.longType())) {
                return new AverageTerminalOperation(false, true);
            }
        }
        if (name.equals("summaryStatistics") && args.length == 0) {
            return TemplateBasedOperation.summarizing(resultType);
        }
        if ((name.equals("findFirst") || name.equals("findAny")) && args.length == 0) {
            PsiType optionalElementType = OptionalUtil.getOptionalElementType((PsiType)resultType);
            return optionalElementType == null ? null : new FindTerminalOperation(optionalElementType);
        }
        if (name.equals("toList") && args.length == 0) {
            return ToCollectionTerminalOperation.toList(resultType);
        }
        if (name.equals("toSet") && args.length == 0) {
            return ToCollectionTerminalOperation.toSet(resultType);
        }
        if (name.equals("toImmutableList") && args.length == 0) {
            return new WrappedCollectionTerminalOperation(ToCollectionTerminalOperation.toList(resultType), "unmodifiableList", resultType);
        }
        if (name.equals("toImmutableSet") && args.length == 0) {
            return new WrappedCollectionTerminalOperation(ToCollectionTerminalOperation.toSet(resultType), "unmodifiableSet", resultType);
        }
        if ((name.equals("anyMatch") || name.equals("allMatch") || name.equals("noneMatch")) && args.length == 1) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new MatchTerminalOperation(fn, name);
        }
        if (name.equals("reduce")) {
            FunctionHelper fn;
            if ((args.length == 2 || args.length == 3) && (fn = FunctionHelper.create(args[1], 2)) != null) {
                return new ReduceTerminalOperation(args[0], fn, resultType);
            }
            if (args.length == 1) {
                return ReduceToOptionalTerminalOperation.create(args[0], resultType);
            }
        }
        if (name.equals("toArray") && args.length < 2) {
            if (!(resultType instanceof PsiArrayType)) {
                return null;
            }
            PsiType componentType = ((PsiArrayType)resultType).getComponentType();
            if (componentType instanceof PsiPrimitiveType) {
                if (args.length == 0) {
                    return new ToPrimitiveArrayTerminalOperation(componentType);
                }
            } else {
                FunctionHelper fn = null;
                if (args.length == 1 && (fn = FunctionHelper.create(args[0], 1)) == null) {
                    return null;
                }
                return new ToArrayTerminalOperation(elementType, fn);
            }
        }
        if ((name.equals("max") || name.equals("min")) && args.length < 2) {
            return MinMaxTerminalOperation.create(args.length == 1 ? args[0] : null, elementType, name.equals("max"));
        }
        if (name.equals("collect")) {
            if (args.length == 3) {
                FunctionHelper supplier = FunctionHelper.create(args[0], 0);
                if (supplier == null) {
                    return null;
                }
                FunctionHelper accumulator = FunctionHelper.create(args[1], 2);
                if (accumulator == null) {
                    return null;
                }
                return new ExplicitCollectTerminalOperation(supplier, accumulator);
            }
            if (args.length == 1) {
                return TerminalOperation.fromCollector(elementType, resultType, PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]));
            }
        }
        return null;
    }

    @Contract(value="_, _, null -> null")
    @Nullable
    private static TerminalOperation fromCollector(@NotNull PsiType elementType, @NotNull PsiType resultType, PsiExpression expr) {
        if (elementType == null) {
            TerminalOperation.$$$reportNull$$$0(4);
        }
        if (resultType == null) {
            TerminalOperation.$$$reportNull$$$0(5);
        }
        if (!((expr = PsiUtil.skipParenthesizedExprDown((PsiExpression)expr)) instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression collectorCall = (PsiMethodCallExpression)expr;
        PsiExpression[] collectorArgs = collectorCall.getArgumentList().getExpressions();
        PsiMethod collector = collectorCall.resolveMethod();
        if (collector == null) {
            return null;
        }
        PsiClass collectorClass = collector.getContainingClass();
        if (collectorClass != null && "java.util.stream.Collectors".equals(collectorClass.getQualifiedName())) {
            return TerminalOperation.fromCollector(elementType, resultType, collector, collectorArgs);
        }
        return null;
    }

    @Nullable
    private static TerminalOperation fromCollector(@NotNull PsiType elementType, @NotNull PsiType resultType, PsiMethod collector, PsiExpression[] collectorArgs) {
        String collectorName;
        if (elementType == null) {
            TerminalOperation.$$$reportNull$$$0(6);
        }
        if (resultType == null) {
            TerminalOperation.$$$reportNull$$$0(7);
        }
        switch (collectorName = collector.getName()) {
            case "toList": {
                if (collectorArgs.length != 0) {
                    return null;
                }
                return ToCollectionTerminalOperation.toList(resultType);
            }
            case "toUnmodifiableList": {
                if (collectorArgs.length != 0) {
                    return null;
                }
                return new WrappedCollectionTerminalOperation(ToCollectionTerminalOperation.toList(resultType), "unmodifiableList", resultType);
            }
            case "toSet": {
                if (collectorArgs.length != 0) {
                    return null;
                }
                return ToCollectionTerminalOperation.toSet(resultType);
            }
            case "toUnmodifiableSet": {
                if (collectorArgs.length != 0) {
                    return null;
                }
                return new WrappedCollectionTerminalOperation(ToCollectionTerminalOperation.toSet(resultType), "unmodifiableSet", resultType);
            }
            case "toCollection": {
                if (collectorArgs.length != 1) {
                    return null;
                }
                FunctionHelper fn = FunctionHelper.create(collectorArgs[0], 0);
                return fn == null ? null : new ToCollectionTerminalOperation(resultType, fn, null);
            }
            case "collectingAndThen": {
                if (collectorArgs.length != 2) {
                    return null;
                }
                PsiExpression collectorCall = collectorArgs[0];
                PsiType downstreamResultType = PsiUtil.substituteTypeParameter((PsiType)collectorCall.getType(), (String)"java.util.stream.Collector", (int)2, (boolean)false);
                if (downstreamResultType == null) {
                    return null;
                }
                CollectorBasedTerminalOperation downstream = (CollectorBasedTerminalOperation)ObjectUtils.tryCast((Object)TerminalOperation.fromCollector(elementType, downstreamResultType, collectorCall), CollectorBasedTerminalOperation.class);
                if (downstream == null) {
                    return null;
                }
                FunctionHelper andThen = FunctionHelper.create(collectorArgs[1], 1);
                return andThen != null ? new WrappedCollectionTerminalOperation(downstream, andThen) : null;
            }
            case "toUnmodifiableMap": 
            case "toMap": {
                FunctionHelper supplier;
                if (collectorArgs.length < 2 || collectorArgs.length > 4) {
                    return null;
                }
                FunctionHelper key = FunctionHelper.create(collectorArgs[0], 1);
                FunctionHelper value = FunctionHelper.create(collectorArgs[1], 1);
                if (key == null || value == null) {
                    return null;
                }
                PsiExpression merger = collectorArgs.length > 2 ? collectorArgs[2] : null;
                FunctionHelper functionHelper = supplier = collectorArgs.length == 4 ? FunctionHelper.create(collectorArgs[3], 0) : FunctionHelper.newObjectSupplier(resultType, "java.util.HashMap");
                if (supplier == null) {
                    return null;
                }
                ToMapTerminalOperation operation = new ToMapTerminalOperation(key, value, merger, supplier, resultType);
                return collectorName.equals("toUnmodifiableMap") ? new WrappedCollectionTerminalOperation(operation, "unmodifiableMap", resultType) : operation;
            }
            case "reducing": {
                switch (collectorArgs.length) {
                    case 1: {
                        return ReduceToOptionalTerminalOperation.create(collectorArgs[0], resultType);
                    }
                    case 2: {
                        FunctionHelper fn = FunctionHelper.create(collectorArgs[1], 2);
                        return fn == null ? null : new ReduceTerminalOperation(collectorArgs[0], fn, resultType);
                    }
                    case 3: {
                        FunctionHelper mapper = FunctionHelper.create(collectorArgs[1], 1);
                        FunctionHelper fn = FunctionHelper.create(collectorArgs[2], 2);
                        return fn == null || mapper == null ? null : new MappingTerminalOperation(mapper, new ReduceTerminalOperation(collectorArgs[0], fn, resultType));
                    }
                }
                return null;
            }
            case "counting": {
                if (collectorArgs.length != 0) {
                    return null;
                }
                return TemplateBasedOperation.counting();
            }
            case "summingInt": 
            case "summingLong": 
            case "summingDouble": {
                if (collectorArgs.length != 1) {
                    return null;
                }
                FunctionHelper fn = FunctionHelper.create(collectorArgs[0], 1);
                PsiPrimitiveType type = PsiPrimitiveType.getUnboxedType((PsiType)resultType);
                return fn == null || type == null ? null : new InlineMappingTerminalOperation(fn, TemplateBasedOperation.summing((PsiType)type));
            }
            case "summarizingInt": 
            case "summarizingLong": 
            case "summarizingDouble": {
                if (collectorArgs.length != 1) {
                    return null;
                }
                FunctionHelper fn = FunctionHelper.create(collectorArgs[0], 1);
                return fn == null ? null : new InlineMappingTerminalOperation(fn, TemplateBasedOperation.summarizing(resultType));
            }
            case "averagingInt": 
            case "averagingLong": 
            case "averagingDouble": {
                if (collectorArgs.length != 1) {
                    return null;
                }
                FunctionHelper fn = FunctionHelper.create(collectorArgs[0], 1);
                return fn == null ? null : new InlineMappingTerminalOperation(fn, new AverageTerminalOperation(collectorName.equals("averagingDouble"), false));
            }
            case "mapping": {
                if (collectorArgs.length != 2) {
                    return null;
                }
                FunctionHelper fn = FunctionHelper.create(collectorArgs[0], 1);
                if (fn == null) {
                    return null;
                }
                TerminalOperation downstreamOp = TerminalOperation.fromCollector(fn.getResultType(), resultType, collectorArgs[1]);
                return downstreamOp == null ? null : new MappingTerminalOperation(fn, downstreamOp);
            }
            case "groupingBy": 
            case "partitioningBy": {
                CollectorOperation downstreamCollector;
                if (collectorArgs.length == 0 || collectorArgs.length > 3 || collectorArgs.length == 3 && collectorName.equals("partitioningBy")) {
                    return null;
                }
                FunctionHelper fn = FunctionHelper.create(collectorArgs[0], 1);
                if (fn == null) {
                    return null;
                }
                PsiType resultSubType = PsiUtil.substituteTypeParameter((PsiType)resultType, (String)"java.util.Map", (int)1, (boolean)false);
                if (resultSubType == null) {
                    return null;
                }
                if (collectorArgs.length == 1) {
                    downstreamCollector = ToCollectionTerminalOperation.toList(resultSubType).asCollector();
                } else {
                    PsiExpression downstream = collectorArgs[collectorArgs.length - 1];
                    TerminalOperation downstreamOp = TerminalOperation.fromCollector(elementType, resultSubType, downstream);
                    if (downstreamOp == null) {
                        return null;
                    }
                    downstreamCollector = downstreamOp.asCollector();
                }
                if (downstreamCollector == null) {
                    return null;
                }
                if (collectorName.equals("partitioningBy")) {
                    return new PartitionByTerminalOperation(fn, resultType, downstreamCollector);
                }
                FunctionHelper supplier = collectorArgs.length == 3 ? FunctionHelper.create(collectorArgs[1], 0) : FunctionHelper.newObjectSupplier(resultType, "java.util.HashMap");
                return new GroupByTerminalOperation(fn, supplier, resultType, downstreamCollector);
            }
            case "minBy": 
            case "maxBy": {
                if (collectorArgs.length != 1) {
                    return null;
                }
                return MinMaxTerminalOperation.create(collectorArgs[0], elementType, collectorName.equals("maxBy"));
            }
            case "joining": {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)collector.getProject());
                switch (collectorArgs.length) {
                    case 0: {
                        return new TemplateBasedOperation("sb", factory.createTypeFromText("java.lang.StringBuilder", (PsiElement)collector), "new java.lang.StringBuilder()", "{acc}.append({item});", "{acc}.toString()");
                    }
                    case 1: 
                    case 3: {
                        String initializer = "new java.util.StringJoiner(" + StreamEx.of((Object[])collectorArgs).map(PsiElement::getText).joining((CharSequence)",") + ")";
                        return new TemplateBasedOperation("joiner", factory.createTypeFromText("java.util.StringJoiner", (PsiElement)collector), initializer, "{acc}.add({item});", "{acc}.toString()");
                    }
                }
                return null;
            }
        }
        return null;
    }

    @NotNull
    static PsiType correctTypeParameters(PsiType resultType, String superClassName, Map<String, Function<? super PsiType, ? extends PsiType>> downstreamCorrectors) {
        PsiSubstitutor origSubstitutor;
        PsiClass resultClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)resultType);
        if (resultClass == null) {
            PsiType psiType = resultType;
            if (psiType == null) {
                TerminalOperation.$$$reportNull$$$0(8);
            }
            return psiType;
        }
        PsiSubstitutor substitutor = origSubstitutor = ((PsiClassType)resultType).resolveGenerics().getSubstitutor();
        Project project = resultClass.getProject();
        PsiClass superClass = JavaPsiFacade.getInstance((Project)project).findClass(superClassName, resultClass.getResolveScope());
        if (superClass == null) {
            PsiType psiType = resultType;
            if (psiType == null) {
                TerminalOperation.$$$reportNull$$$0(9);
            }
            return psiType;
        }
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)superClass, (PsiClass)resultClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (superClassSubstitutor == null) {
            PsiType psiType = resultType;
            if (psiType == null) {
                TerminalOperation.$$$reportNull$$$0(10);
            }
            return psiType;
        }
        for (PsiTypeParameter baseParameter : superClass.getTypeParameters()) {
            PsiClass substitution = PsiUtil.resolveClassInClassTypeOnly((PsiType)superClassSubstitutor.substitute(baseParameter));
            if (!(substitution instanceof PsiTypeParameter)) continue;
            PsiTypeParameter subClassParameter = (PsiTypeParameter)substitution;
            PsiType origType = origSubstitutor.substitute(subClassParameter);
            PsiType replacedType = GenericsUtil.eliminateWildcards((PsiType)origType, (boolean)false, (boolean)true);
            replacedType = (PsiType)downstreamCorrectors.getOrDefault(subClassParameter.getName(), Function.identity()).apply(replacedType);
            if (replacedType == origType) continue;
            substitutor = substitutor.put(subClassParameter, replacedType);
        }
        Object object = substitutor == origSubstitutor ? resultType : JavaPsiFacade.getElementFactory((Project)project).createType(resultClass, substitutor);
        if (object == null) {
            TerminalOperation.$$$reportNull$$$0(11);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamToLoop/TerminalOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamToLoop/TerminalOperation";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "correctTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTerminal";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromCollector";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    static class ForEachTerminalOperation
    extends TerminalOperation {
        private final FunctionHelper myFn;

        ForEachTerminalOperation(FunctionHelper fn) {
            this.myFn = fn;
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            this.myFn.preprocessVariable(context, inVar, 0);
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            this.myFn.registerReusedElements(consumer);
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            this.myFn.transform(context, inVar.getName());
            return this.myFn.getStatementText();
        }
    }

    static class TemplateBasedOperation
    extends AccumulatedOperation
    implements CollectorOperation {
        private final String myAccName;
        private final PsiType myAccType;
        private final String myAccInitializer;
        private final String myUpdateTemplate;
        private final String myFinisherTemplate;

        TemplateBasedOperation(String accName, PsiType accType, String accInitializer, String updateTemplate, String finisherTemplate) {
            this.myAccName = accName;
            this.myAccType = accType;
            this.myAccInitializer = accInitializer;
            this.myUpdateTemplate = updateTemplate;
            this.myFinisherTemplate = finisherTemplate;
        }

        TemplateBasedOperation(String accName, PsiType accType, String accInitializer, String updateTemplate) {
            this(accName, accType, accInitializer, updateTemplate, "{acc}");
        }

        @Override
        String initAccumulator(ChainVariable inVar, StreamToLoopReplacementContext context) {
            StreamToLoopInspection.ResultKind kind = this.myFinisherTemplate.equals("{acc}") ? (this.myAccType instanceof PsiPrimitiveType ? StreamToLoopInspection.ResultKind.NON_FINAL : StreamToLoopInspection.ResultKind.FINAL) : StreamToLoopInspection.ResultKind.UNKNOWN;
            String varName = context.declareResult(this.myAccName, this.myAccType, this.myAccInitializer, kind);
            context.setFinisher(this.myFinisherTemplate.replace("{acc}", varName));
            return varName;
        }

        @Override
        CollectorOperation asCollector() {
            return this.myFinisherTemplate.equals("{acc}") ? this : null;
        }

        @Override
        public String getSupplier() {
            return this.myAccInitializer;
        }

        @Override
        public String getAccumulatorUpdater(ChainVariable inVar, String acc) {
            return this.myUpdateTemplate.replace("{acc}", acc).replace("{item}", inVar.getName());
        }

        @Override
        public String getMerger(ChainVariable inVar, String map, String key) {
            if (!(this.myAccType instanceof PsiPrimitiveType)) {
                return null;
            }
            String boxedType = PsiTypesUtil.boxIfPossible((String)this.myAccType.getCanonicalText());
            String val = this.myUpdateTemplate.equals("{acc}++;") ? "1L" : "(" + this.myAccType.getCanonicalText() + ")" + String.valueOf(inVar);
            String merger = boxedType + "::sum";
            return map + ".merge(" + key + "," + val + "," + merger + ");\n";
        }

        @NotNull
        static TemplateBasedOperation summing(PsiType type) {
            String defValue = TypeUtils.getDefaultValue((PsiType)type);
            return new TemplateBasedOperation("sum", type, defValue, "{acc}+={item};");
        }

        @NotNull
        static TemplateBasedOperation summarizing(@NotNull PsiType resultType) {
            if (resultType == null) {
                TemplateBasedOperation.$$$reportNull$$$0(0);
            }
            return new TemplateBasedOperation("stat", resultType, "new " + resultType.getCanonicalText() + "()", "{acc}.accept({item});");
        }

        @NotNull
        static TemplateBasedOperation counting() {
            return new TemplateBasedOperation("count", (PsiType)PsiTypes.longType(), "0L", "{acc}++;");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/codeInspection/streamToLoop/TerminalOperation$TemplateBasedOperation", "summarizing"));
        }
    }

    static class AverageTerminalOperation
    extends TerminalOperation {
        private final boolean myDoubleAccumulator;
        private final boolean myUseOptional;

        AverageTerminalOperation(boolean doubleAccumulator, boolean useOptional) {
            this.myDoubleAccumulator = doubleAccumulator;
            this.myUseOptional = useOptional;
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            String sum = context.declareResult("sum", (PsiType)(this.myDoubleAccumulator ? PsiTypes.doubleType() : PsiTypes.longType()), "0", StreamToLoopInspection.ResultKind.UNKNOWN);
            String count = context.declare("count", "long", "0");
            String seenCheck = count + ">0";
            String result = (this.myDoubleAccumulator ? "" : "(double)") + sum + "/" + count;
            ConditionalExpression conditionalExpression = this.myUseOptional ? new ConditionalExpression.Optional((PsiType)PsiTypes.doubleType(), seenCheck, result) : new ConditionalExpression.Plain((PsiType)PsiTypes.doubleType(), seenCheck, result, "0.0");
            context.setFinisher(conditionalExpression);
            return sum + "+=" + String.valueOf(inVar) + ";\n" + count + "++;\n";
        }
    }

    static class FindTerminalOperation
    extends TerminalOperation {
        private final PsiType myType;

        FindTerminalOperation(PsiType type) {
            this.myType = type;
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            return context.assignAndBreak(new ConditionalExpression.Optional(this.myType, "found", inVar.getName()));
        }
    }

    static class ToCollectionTerminalOperation
    extends CollectorBasedTerminalOperation {
        private final boolean myList;

        ToCollectionTerminalOperation(PsiType resultType, FunctionHelper fn, String desiredName) {
            super(resultType, "java.util.Collection", context -> fn.suggestFinalOutputNames((ChainContext)context, desiredName, "collection").getFirst(), fn);
            this.myList = InheritanceUtil.isInheritor((PsiType)resultType, (String)"java.util.List");
        }

        @Override
        public String getAccumulatorUpdater(ChainVariable inVar, String acc) {
            return acc + ".add(" + String.valueOf(inVar) + ");\n";
        }

        @Override
        public PsiType correctReturnType(PsiType type) {
            return ToCollectionTerminalOperation.correctTypeParameters(type, "java.util.Collection", Collections.emptyMap());
        }

        public boolean isList() {
            return this.myList;
        }

        @NotNull
        private static ToCollectionTerminalOperation toList(@NotNull PsiType resultType) {
            if (resultType == null) {
                ToCollectionTerminalOperation.$$$reportNull$$$0(0);
            }
            return new ToCollectionTerminalOperation(resultType, FunctionHelper.newObjectSupplier(resultType, "java.util.ArrayList"), "list");
        }

        @NotNull
        private static ToCollectionTerminalOperation toSet(@NotNull PsiType resultType) {
            if (resultType == null) {
                ToCollectionTerminalOperation.$$$reportNull$$$0(1);
            }
            return new ToCollectionTerminalOperation(resultType, FunctionHelper.newObjectSupplier(resultType, "java.util.HashSet"), "set");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "resultType";
            objectArray2[1] = "com/intellij/codeInspection/streamToLoop/TerminalOperation$ToCollectionTerminalOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toSet";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class WrappedCollectionTerminalOperation
    extends TerminalOperation {
        private final CollectorBasedTerminalOperation myDelegate;
        private final FunctionHelper myWrapper;

        WrappedCollectionTerminalOperation(CollectorBasedTerminalOperation delegate, String wrapper, PsiType resultType) {
            this(delegate, new FunctionHelper.InlinedFunctionHelper(resultType, 1, "java.util.Collections." + wrapper + "({0})"));
        }

        WrappedCollectionTerminalOperation(CollectorBasedTerminalOperation delegate, FunctionHelper wrapper) {
            this.myDelegate = delegate;
            this.myWrapper = wrapper;
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            this.myDelegate.registerReusedElements(consumer);
            this.myWrapper.registerReusedElements(consumer);
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            this.myDelegate.preprocessVariables(context, inVar, outVar);
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            String acc = this.myDelegate.initAccumulator(inVar, context, false);
            this.myWrapper.transform(context, acc);
            context.setFinisher(this.myWrapper.getText());
            return this.myDelegate.getAccumulatorUpdater(inVar, acc);
        }
    }

    static abstract class CollectorBasedTerminalOperation
    extends AccumulatedOperation
    implements CollectorOperation {
        final PsiType myType;
        final Function<StreamToLoopReplacementContext, String> myAccNameSupplier;
        final FunctionHelper mySupplier;
        final String myMostAbstractAllowedType;

        CollectorBasedTerminalOperation(PsiType type, String mostAbstractAllowedType, Function<StreamToLoopReplacementContext, String> accNameSupplier, FunctionHelper accSupplier) {
            this.myType = type;
            this.myMostAbstractAllowedType = mostAbstractAllowedType;
            this.myAccNameSupplier = accNameSupplier;
            this.mySupplier = accSupplier;
        }

        @Override
        String initAccumulator(ChainVariable inVar, StreamToLoopReplacementContext context) {
            return this.initAccumulator(inVar, context, true);
        }

        String initAccumulator(ChainVariable inVar, StreamToLoopReplacementContext context, boolean canBeFinal) {
            this.transform(context, inVar.getName());
            PsiType resultType = this.correctReturnType(this.myType);
            return context.declareResult(this.myAccNameSupplier.apply(context), resultType, this.myMostAbstractAllowedType, this.getSupplier(), canBeFinal ? StreamToLoopInspection.ResultKind.FINAL : StreamToLoopInspection.ResultKind.UNKNOWN);
        }

        @Override
        CollectorOperation asCollector() {
            return this;
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            this.mySupplier.registerReusedElements(consumer);
        }

        @Override
        public void transform(StreamToLoopReplacementContext context, String item) {
            this.mySupplier.transform(context, new String[0]);
        }

        @Override
        public String getSupplier() {
            return this.mySupplier.getText();
        }
    }

    static class MatchTerminalOperation
    extends TerminalOperation {
        private final FunctionHelper myFn;
        private final boolean myDefaultValue;
        private final boolean myNegatePredicate;

        MatchTerminalOperation(FunctionHelper fn, String name) {
            this.myFn = fn;
            switch (name) {
                case "anyMatch": {
                    this.myDefaultValue = false;
                    this.myNegatePredicate = false;
                    break;
                }
                case "allMatch": {
                    this.myDefaultValue = true;
                    this.myNegatePredicate = true;
                    break;
                }
                case "noneMatch": {
                    this.myDefaultValue = true;
                    this.myNegatePredicate = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(name);
                }
            }
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            this.myFn.registerReusedElements(consumer);
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            this.myFn.preprocessVariable(context, inVar, 0);
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            this.myFn.transform(context, inVar.getName());
            String expression = this.myNegatePredicate ? BoolUtils.getNegatedExpressionText((PsiExpression)this.myFn.getExpression()) : this.myFn.getText();
            return "if(" + expression + ") {\n" + context.assignAndBreak(new ConditionalExpression.Boolean("b", this.myDefaultValue)) + "}\n";
        }
    }

    static class ReduceTerminalOperation
    extends TerminalOperation {
        private final PsiExpression myIdentity;
        private final PsiType myType;
        private final FunctionHelper myUpdater;

        ReduceTerminalOperation(PsiExpression identity, FunctionHelper updater, PsiType type) {
            this.myIdentity = identity;
            this.myType = type;
            this.myUpdater = updater;
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myIdentity);
            this.myUpdater.registerReusedElements(consumer);
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            String accumulator = context.declareResult("acc", this.myType, this.myIdentity.getText(), StreamToLoopInspection.ResultKind.NON_FINAL);
            this.myUpdater.transform(context, accumulator, inVar.getName());
            return accumulator + "=" + this.myUpdater.getText() + ";";
        }
    }

    static class ReduceToOptionalTerminalOperation
    extends TerminalOperation {
        private final PsiType myType;
        private final FunctionHelper myUpdater;

        ReduceToOptionalTerminalOperation(FunctionHelper updater, PsiType type) {
            this.myType = type;
            this.myUpdater = updater;
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            this.myUpdater.registerReusedElements(consumer);
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            String seen = context.declare("seen", "boolean", "false");
            String accumulator = context.declareResult("acc", this.myType, this.myType instanceof PsiPrimitiveType ? "0" : "null", StreamToLoopInspection.ResultKind.UNKNOWN);
            this.myUpdater.transform(context, accumulator, inVar.getName());
            context.setFinisher(new ConditionalExpression.Optional(this.myType, seen, accumulator));
            String ifClause = "if(!" + seen + ") {\n" + seen + "=true;\n" + accumulator + "=" + String.valueOf(inVar) + ";\n}";
            if (this.myUpdater.getText().equals(accumulator)) {
                return ifClause + "\n";
            }
            return ifClause + " else {\n" + accumulator + "=" + this.myUpdater.getText() + ";\n}\n";
        }

        @Nullable
        static ReduceToOptionalTerminalOperation create(PsiExpression arg, PsiType resultType) {
            PsiType optionalElementType = OptionalUtil.getOptionalElementType((PsiType)resultType);
            FunctionHelper fn = FunctionHelper.create(arg, 2);
            if (fn != null && optionalElementType != null) {
                return new ReduceToOptionalTerminalOperation(fn, optionalElementType);
            }
            return null;
        }
    }

    static class ToPrimitiveArrayTerminalOperation
    extends TerminalOperation {
        private final PsiType myType;

        ToPrimitiveArrayTerminalOperation(PsiType type) {
            this.myType = type;
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            String arr = context.declareResult("arr", (PsiType)this.myType.createArrayType(), "new " + this.myType.getCanonicalText() + "[10]", StreamToLoopInspection.ResultKind.NON_FINAL);
            String count = context.declare("count", "int", "0");
            context.addAfterStep(arr + "=java.util.Arrays.copyOfRange(" + arr + ",0," + count + ");\n");
            return "if(" + arr + ".length==" + count + ") " + arr + "=java.util.Arrays.copyOf(" + arr + "," + count + "*2);\n" + arr + "[" + count + "++]=" + String.valueOf(inVar) + ";\n";
        }
    }

    static class ToArrayTerminalOperation
    extends AccumulatedOperation {
        private final PsiType myType;
        private final FunctionHelper mySupplier;

        ToArrayTerminalOperation(PsiType type, FunctionHelper supplier) {
            this.myType = type;
            this.mySupplier = supplier;
        }

        @Override
        String initAccumulator(ChainVariable inVar, StreamToLoopReplacementContext context) {
            String list = context.declareResult("list", context.createType("java.util.List<" + this.myType.getCanonicalText() + ">"), "new java.util.ArrayList<>()", StreamToLoopInspection.ResultKind.UNKNOWN);
            String toArrayArg = "";
            if (this.mySupplier != null) {
                this.mySupplier.transform(context, "0");
                toArrayArg = this.mySupplier.getText();
            }
            context.setFinisher(list + ".toArray(" + toArrayArg + ")");
            return list;
        }

        @Override
        String getAccumulatorUpdater(ChainVariable inVar, String list) {
            return list + ".add(" + String.valueOf(inVar) + ");\n";
        }
    }

    static class MinMaxTerminalOperation
    extends TerminalOperation {
        private final PsiType myType;
        private final String myTemplate;
        @Nullable
        private final FunctionHelper myComparator;
        private final boolean myMax;

        MinMaxTerminalOperation(PsiType type, String template, @Nullable FunctionHelper comparator, boolean max) {
            this.myType = type;
            this.myTemplate = template;
            this.myComparator = comparator;
            this.myMax = max;
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            if (this.myComparator != null) {
                this.myComparator.registerReusedElements(consumer);
            }
        }

        Number getExtremeValue() {
            if (PsiTypes.intType().equals((Object)this.myType)) {
                return this.myMax ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            }
            if (PsiTypes.longType().equals((Object)this.myType)) {
                return this.myMax ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            return null;
        }

        String getExtremeValueExpression() {
            if (PsiTypes.intType().equals((Object)this.myType)) {
                return "java.lang.Integer" + (this.myMax ? ".MIN_VALUE" : ".MAX_VALUE");
            }
            if (PsiTypes.longType().equals((Object)this.myType)) {
                return "java.lang.Long" + (this.myMax ? ".MIN_VALUE" : ".MAX_VALUE");
            }
            return null;
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            String comparePredicate;
            if (this.getExtremeValue() != null && context.tryUnwrapOrElse(this.getExtremeValue())) {
                String best = context.declareResult("best", this.myType, this.getExtremeValueExpression(), StreamToLoopInspection.ResultKind.NON_FINAL);
                String comparePredicate2 = this.myTemplate.replace("{best}", best).replace("{item}", inVar.getName());
                return "if(" + comparePredicate2 + ")\n" + best + "=" + String.valueOf(inVar) + ";\n";
            }
            String seen = context.declare("seen", "boolean", "false");
            String best = context.declareResult("best", this.myType, this.myType instanceof PsiPrimitiveType ? "0" : "null", StreamToLoopInspection.ResultKind.UNKNOWN);
            context.setFinisher(new ConditionalExpression.Optional(this.myType, seen, best));
            if (this.myComparator != null) {
                this.myComparator.transform(context, inVar.getName(), best);
                PsiExpression expression = this.myComparator.getExpression();
                int expressionPrecedence = ParenthesesUtils.getPrecedence((PsiExpression)expression);
                Object text = expressionPrecedence >= 9 ? "(" + expression.getText() + ")" : expression.getText();
                comparePredicate = this.myTemplate.replace("{comparator}", (CharSequence)text);
            } else {
                comparePredicate = this.myTemplate.replace("{best}", best).replace("{item}", inVar.getName());
            }
            return "if(!" + seen + " || " + comparePredicate + ") {\n" + seen + "=true;\n" + best + "=" + String.valueOf(inVar) + ";\n}\n";
        }

        @Nullable
        static MinMaxTerminalOperation create(@Nullable PsiExpression comparator, PsiType elementType, boolean max) {
            String sign;
            String string = sign = max ? ">" : "<";
            if (comparator == null) {
                if (PsiTypes.intType().equals((Object)elementType) || PsiTypes.longType().equals((Object)elementType)) {
                    return new MinMaxTerminalOperation(elementType, "{item}" + sign + "{best}", null, max);
                }
                if (PsiTypes.doubleType().equals((Object)elementType)) {
                    return new MinMaxTerminalOperation(elementType, "java.lang.Double.compare({item},{best})" + sign + "0", null, max);
                }
            } else {
                FunctionHelper fn = FunctionHelper.create(comparator, 2);
                if (fn != null) {
                    return new MinMaxTerminalOperation(elementType, "{comparator}" + sign + "0", fn, max);
                }
            }
            return null;
        }
    }

    static class ExplicitCollectTerminalOperation
    extends TerminalOperation {
        private final FunctionHelper mySupplier;
        private final FunctionHelper myAccumulator;

        ExplicitCollectTerminalOperation(FunctionHelper supplier, FunctionHelper accumulator) {
            this.mySupplier = supplier;
            this.myAccumulator = accumulator;
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            this.mySupplier.registerReusedElements(consumer);
            this.myAccumulator.registerReusedElements(consumer);
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            this.myAccumulator.preprocessVariable(context, inVar, 1);
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            this.mySupplier.transform(context, new String[0]);
            String candidate = this.mySupplier.suggestFinalOutputNames(context, this.myAccumulator.getParameterName(0), "acc").getFirst();
            String acc = context.declareResult(candidate, this.mySupplier.getResultType(), this.mySupplier.getText(), StreamToLoopInspection.ResultKind.FINAL);
            this.myAccumulator.transform(context, acc, inVar.getName());
            return this.myAccumulator.getStatementText();
        }
    }

    static class ToMapTerminalOperation
    extends CollectorBasedTerminalOperation {
        private final FunctionHelper myKeyExtractor;
        private final FunctionHelper myValueExtractor;
        private final PsiExpression myMerger;

        ToMapTerminalOperation(FunctionHelper keyExtractor, FunctionHelper valueExtractor, PsiExpression merger, FunctionHelper supplier, PsiType resultType) {
            super(resultType, "java.util.Map", context -> "map", supplier);
            this.myKeyExtractor = keyExtractor;
            this.myValueExtractor = valueExtractor;
            this.myMerger = merger;
        }

        @Override
        public PsiType correctReturnType(PsiType type) {
            return ToMapTerminalOperation.correctTypeParameters(type, "java.util.Map", Collections.emptyMap());
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            super.registerReusedElements(consumer);
            this.myKeyExtractor.registerReusedElements(consumer);
            this.myValueExtractor.registerReusedElements(consumer);
            if (this.myMerger != null) {
                consumer.accept((PsiElement)this.myMerger);
            }
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            this.myKeyExtractor.preprocessVariable(context, inVar, 0);
            this.myValueExtractor.preprocessVariable(context, inVar, 0);
        }

        @Override
        public void transform(StreamToLoopReplacementContext context, String item) {
            super.transform(context, item);
            this.myKeyExtractor.transform(context, item);
            this.myValueExtractor.transform(context, item);
        }

        @Override
        public String getAccumulatorUpdater(ChainVariable inVar, String map) {
            PsiReferenceExpression ref;
            PsiExpression body;
            PsiLambdaExpression lambda;
            PsiParameter[] parameters;
            if (this.myMerger == null) {
                return "if(" + map + ".put(" + this.myKeyExtractor.getText() + "," + this.myValueExtractor.getText() + ")!=null) {\nthrow new java.lang.IllegalStateException(\"Duplicate key\");\n}\n";
            }
            PsiExpression psiExpression = this.myMerger;
            if (psiExpression instanceof PsiLambdaExpression && (parameters = (lambda = (PsiLambdaExpression)psiExpression).getParameterList().getParameters()).length == 2 && (body = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody())) instanceof PsiReferenceExpression && (ref = (PsiReferenceExpression)body).getQualifierExpression() == null) {
                if (Objects.equals(parameters[0].getName(), ref.getReferenceName())) {
                    return map + ".putIfAbsent(" + this.myKeyExtractor.getText() + "," + this.myValueExtractor.getText() + ");\n";
                }
                if (Objects.equals(parameters[1].getName(), ref.getReferenceName())) {
                    return map + ".put(" + this.myKeyExtractor.getText() + "," + this.myValueExtractor.getText() + ");\n";
                }
            }
            return map + ".merge(" + this.myKeyExtractor.getText() + "," + this.myValueExtractor.getText() + "," + this.myMerger.getText() + ");\n";
        }
    }

    static class MappingTerminalOperation
    extends AbstractMappingTerminalOperation {
        private ChainVariable myVariable;

        MappingTerminalOperation(FunctionHelper mapper, TerminalOperation downstream) {
            super(mapper, downstream);
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            this.createVariable(context, inVar.getName());
            return this.myVariable.getDeclaration(this.myMapper.getText()) + this.myDownstream.generate(this.myVariable, context);
        }

        private void createVariable(StreamToLoopReplacementContext context, String item) {
            this.myMapper.transform(context, item);
            this.myVariable = new ChainVariable(this.myMapper.getResultType());
            this.myDownstream.preprocessVariables(context, this.myVariable, ChainVariable.STUB);
            this.myMapper.suggestOutputNames(context, this.myVariable);
            this.myVariable.register(context);
        }

        @Override
        public void transform(StreamToLoopReplacementContext context, String item) {
            this.createVariable(context, item);
            this.myDownstreamCollector.transform(context, this.myVariable.getName());
        }

        @Override
        public String getAccumulatorUpdater(ChainVariable inVar, String acc) {
            return this.myVariable.getDeclaration(this.myMapper.getText()) + this.myDownstreamCollector.getAccumulatorUpdater(this.myVariable, acc);
        }

        @Override
        public String getMerger(ChainVariable inVar, String map, String key) {
            String merger = this.myDownstreamCollector.getMerger(this.myVariable, map, key);
            return merger == null ? null : this.myVariable.getDeclaration(this.myMapper.getText()) + merger;
        }
    }

    static class InlineMappingTerminalOperation
    extends AbstractMappingTerminalOperation {
        InlineMappingTerminalOperation(FunctionHelper mapper, TerminalOperation downstream) {
            super(mapper, downstream);
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            this.myMapper.transform(context, inVar.getName());
            ChainVariable updatedVar = new ChainVariable(this.myMapper.getResultType(), this.myMapper.getText());
            return this.myDownstream.generate(updatedVar, context);
        }

        @Override
        public void transform(StreamToLoopReplacementContext context, String item) {
            this.myMapper.transform(context, item);
            this.myDownstreamCollector.transform(context, this.myMapper.getText());
        }

        @Override
        public String getAccumulatorUpdater(ChainVariable inVar, String acc) {
            return this.myDownstreamCollector.getAccumulatorUpdater(new ChainVariable(this.myMapper.getResultType(), this.myMapper.getText()), acc);
        }

        @Override
        public String getMerger(ChainVariable inVar, String map, String key) {
            return this.myDownstreamCollector.getMerger(new ChainVariable(this.myMapper.getResultType(), this.myMapper.getText()), map, key);
        }
    }

    static interface CollectorOperation {
        default public void transform(StreamToLoopReplacementContext context, String item) {
        }

        default public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
        }

        default public void registerReusedElements(Consumer<? super PsiElement> consumer) {
        }

        public String getSupplier();

        public String getAccumulatorUpdater(ChainVariable var1, String var2);

        default public String getMerger(ChainVariable inVar, String map, String key) {
            return null;
        }

        default public PsiType correctReturnType(PsiType type) {
            return type;
        }
    }

    static class PartitionByTerminalOperation
    extends TerminalOperation {
        private final String myResultType;
        private final CollectorOperation myCollector;
        private final FunctionHelper myPredicate;

        PartitionByTerminalOperation(FunctionHelper predicate, PsiType resultType, CollectorOperation collector) {
            this.myPredicate = predicate;
            this.myResultType = resultType.getCanonicalText();
            this.myCollector = collector;
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            this.myPredicate.registerReusedElements(consumer);
            this.myCollector.registerReusedElements(consumer);
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            this.myPredicate.preprocessVariable(context, inVar, 0);
            this.myCollector.preprocessVariables(context, inVar, outVar);
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            PsiType resultType = context.createType(this.myResultType);
            resultType = PartitionByTerminalOperation.correctTypeParameters(resultType, "java.util.Map", Collections.singletonMap("V", this.myCollector::correctReturnType));
            String map = context.declareResult("map", resultType, "java.util.Map", "new java.util.HashMap<>()", StreamToLoopInspection.ResultKind.FINAL);
            this.myPredicate.transform(context, inVar.getName());
            this.myCollector.transform(context, inVar.getName());
            context.addBeforeStep(map + ".put(false, " + this.myCollector.getSupplier() + ");");
            context.addBeforeStep(map + ".put(true, " + this.myCollector.getSupplier() + ");");
            String key = this.myPredicate.getText();
            String merger = this.myCollector.getMerger(inVar, map, key);
            if (merger != null) {
                return merger;
            }
            return this.myCollector.getAccumulatorUpdater(inVar, map + ".get(" + key + ")");
        }
    }

    static class GroupByTerminalOperation
    extends CollectorBasedTerminalOperation {
        private final CollectorOperation myCollector;
        private final FunctionHelper myKeyExtractor;
        private String myKeyVar;

        GroupByTerminalOperation(FunctionHelper keyExtractor, FunctionHelper supplier, PsiType resultType, CollectorOperation collector) {
            super(resultType, "java.util.Map", (StreamToLoopReplacementContext context) -> "map", supplier);
            this.myKeyExtractor = keyExtractor;
            this.myCollector = collector;
        }

        @Override
        public PsiType correctReturnType(PsiType type) {
            return GroupByTerminalOperation.correctTypeParameters(type, "java.util.Map", Collections.singletonMap("V", this.myCollector::correctReturnType));
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            super.registerReusedElements(consumer);
            this.myKeyExtractor.registerReusedElements(consumer);
            this.myCollector.registerReusedElements(consumer);
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            this.myKeyExtractor.preprocessVariable(context, inVar, 0);
            this.myCollector.preprocessVariables(context, inVar, outVar);
        }

        @Override
        public void transform(StreamToLoopReplacementContext context, String item) {
            super.transform(context, item);
            this.myKeyExtractor.transform(context, item);
            this.myCollector.transform(context, item);
            this.myKeyVar = context.registerVarName(Arrays.asList("k", "key"));
        }

        @Override
        public String getAccumulatorUpdater(ChainVariable inVar, String map) {
            String key = this.myKeyExtractor.getText();
            String merger = this.myCollector.getMerger(inVar, map, key);
            if (merger != null) {
                return merger;
            }
            String acc = map + ".computeIfAbsent(" + key + "," + this.myKeyVar + "->" + this.myCollector.getSupplier() + ")";
            return this.myCollector.getAccumulatorUpdater(inVar, acc);
        }
    }

    static class SortedTerminalOperation
    extends TerminalOperation {
        private final AccumulatedOperation myOrigin;
        @Nullable
        private final PsiExpression myComparator;

        SortedTerminalOperation(AccumulatedOperation origin, @Nullable PsiExpression comparator) {
            this.myOrigin = origin;
            this.myComparator = comparator;
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            this.myOrigin.registerReusedElements(consumer);
            if (this.myComparator != null) {
                consumer.accept((PsiElement)this.myComparator);
            }
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            this.myOrigin.preprocessVariables(context, inVar, outVar);
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            String acc = this.myOrigin.initAccumulator(inVar, context);
            context.addAfterStep(acc + ".sort(" + (this.myComparator == null ? "null" : this.myComparator.getText()) + ");\n");
            return this.myOrigin.getAccumulatorUpdater(inVar, acc);
        }
    }

    static class MapForEachTerminalOperation
    extends TerminalOperation {
        private final FunctionHelper myFn;
        private final PsiType myKeyType;
        private final PsiType myValueType;

        MapForEachTerminalOperation(FunctionHelper fn, PsiType keyType, PsiType valueType) {
            this.myFn = fn;
            this.myKeyType = keyType;
            this.myValueType = valueType;
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            inVar.addBestNameCandidate("entry");
            inVar.addBestNameCandidate("e");
            inVar.addBestNameCandidate("mapEntry");
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            this.myFn.registerReusedElements(consumer);
        }

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            ChainVariable keyVar = new ChainVariable(this.myKeyType);
            this.myFn.preprocessVariable(context, keyVar, 0);
            keyVar.addBestNameCandidate("key");
            keyVar.addBestNameCandidate("k");
            ChainVariable valueVar = new ChainVariable(this.myValueType);
            this.myFn.preprocessVariable(context, valueVar, 1);
            valueVar.addBestNameCandidate("value");
            valueVar.addBestNameCandidate("v");
            keyVar.register(context);
            valueVar.register(context);
            this.myFn.transform(context, keyVar.getName(), valueVar.getName());
            return keyVar.getDeclaration(inVar.getName() + ".getKey()") + valueVar.getDeclaration(inVar.getName() + ".getValue()") + this.myFn.getStatementText();
        }
    }

    static abstract class AbstractMappingTerminalOperation
    extends TerminalOperation
    implements CollectorOperation {
        final FunctionHelper myMapper;
        final TerminalOperation myDownstream;
        final CollectorOperation myDownstreamCollector;

        AbstractMappingTerminalOperation(FunctionHelper mapper, TerminalOperation downstream) {
            this.myMapper = mapper;
            this.myDownstream = downstream;
            this.myDownstreamCollector = downstream.asCollector();
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            this.myMapper.registerReusedElements(consumer);
            this.myDownstream.registerReusedElements(consumer);
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            this.myMapper.preprocessVariable(context, inVar, 0);
        }

        @Override
        public PsiType correctReturnType(PsiType type) {
            return this.myDownstreamCollector.correctReturnType(type);
        }

        @Override
        CollectorOperation asCollector() {
            return this.myDownstreamCollector == null ? null : this;
        }

        @Override
        public String getSupplier() {
            return this.myDownstreamCollector.getSupplier();
        }
    }

    static abstract class AccumulatedOperation
    extends TerminalOperation {
        AccumulatedOperation() {
        }

        abstract String initAccumulator(ChainVariable var1, StreamToLoopReplacementContext var2);

        abstract String getAccumulatorUpdater(ChainVariable var1, String var2);

        @Override
        String generate(ChainVariable inVar, StreamToLoopReplacementContext context) {
            String acc = this.initAccumulator(inVar, context);
            return this.getAccumulatorUpdater(inVar, acc);
        }
    }
}

