/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.suspiciousNameCombination;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class SuspiciousNameCombinationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    private static final String ELEMENT_GROUPS = "group";
    @NonNls
    private static final String ATTRIBUTE_NAMES = "names";
    @NonNls
    private static final String ELEMENT_IGNORED_METHODS = "ignored";
    private final List<String> myNameGroups = new ArrayList<String>();
    final MethodMatcher myIgnoredMethods = new MethodMatcher().add("java.io.PrintStream", "println").add("java.io.PrintWriter", "println").add("java.lang.System", "identityHashCode").add("java.sql.PreparedStatement", "set.*").add("java.sql.ResultSet", "update.*").add("java.sql.SQLOutput", "write.*").add("java.lang.Integer", "compare.*|toUnsignedLong").add("java.lang.Long", "compare.*").add("java.lang.Short", "compare|toUnsigned.*").add("java.lang.Byte", "compare|toUnsigned.*").add("java.lang.Character", "compare").add("java.lang.Boolean", "compare").add("java.lang.Math", ".*").add("java.lang.StrictMath", ".*");
    private final Map<String, String> myWordToGroupMap = new HashMap<String, String>();
    private int myLongestWord = 0;

    public SuspiciousNameCombinationInspection() {
        this.addNameGroup("x,width,left,right");
        this.addNameGroup("y,height,top,bottom");
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"myNameGroups", (String)AnalysisBundle.message((String)"suspicious.name.combination.options.title", (Object[])new Object[0])), this.myIgnoredMethods.getTable(JavaBundle.message((String)"section.title.inspection.suspicious.names.ignore.methods", (Object[])new Object[0])).prefix("myIgnoredMethods")});
        if (optPane == null) {
            SuspiciousNameCombinationInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private void clearNameGroups() {
        this.myNameGroups.clear();
        this.myWordToGroupMap.clear();
        this.myLongestWord = 0;
    }

    public void addNameGroup(@NonNls String group) {
        this.myNameGroups.add(group);
        List words = StringUtil.split((String)group, (String)",");
        for (String word : words) {
            String canonicalized = SuspiciousNameCombinationInspection.canonicalize(word);
            this.myLongestWord = Math.max(this.myLongestWord, canonicalized.length());
            this.myWordToGroupMap.put(canonicalized, group);
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.probable.bugs", (Object[])new Object[0]);
        if (string == null) {
            SuspiciousNameCombinationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "SuspiciousNameCombination";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousNameCombinationInspection.$$$reportNull$$$0(2);
        }
        return new MyVisitor(holder);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            SuspiciousNameCombinationInspection.$$$reportNull$$$0(3);
        }
        this.clearNameGroups();
        for (Element e : node.getChildren(ELEMENT_GROUPS)) {
            this.addNameGroup(e.getAttributeValue(ATTRIBUTE_NAMES));
        }
        Element ignoredMethods = node.getChild(ELEMENT_IGNORED_METHODS);
        if (ignoredMethods != null) {
            this.myIgnoredMethods.readSettings(ignoredMethods);
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            SuspiciousNameCombinationInspection.$$$reportNull$$$0(4);
        }
        for (String group : this.myNameGroups) {
            Element e = new Element(ELEMENT_GROUPS);
            node.addContent(e);
            e.setAttribute(ATTRIBUTE_NAMES, group);
        }
        Element ignoredMethods = new Element(ELEMENT_IGNORED_METHODS);
        node.addContent(ignoredMethods);
        this.myIgnoredMethods.writeSettings(ignoredMethods);
    }

    @NotNull
    private static String canonicalize(String word) {
        String string = StringUtil.toLowerCase((String)word.trim());
        if (string == null) {
            SuspiciousNameCombinationInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalize";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private class MyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myProblemsHolder;

        MyVisitor(ProblemsHolder problemsHolder) {
            this.myProblemsHolder = problemsHolder;
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            PsiExpression expr;
            if (variable == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (variable.hasInitializer() && (expr = variable.getInitializer()) instanceof PsiReferenceExpression) {
                PsiReferenceExpression refExpr = (PsiReferenceExpression)expr;
                PsiIdentifier nameIdentifier = variable.getNameIdentifier();
                this.checkCombination((PsiElement)(nameIdentifier != null ? nameIdentifier : variable), variable.getName(), refExpr.getReferenceName(), "suspicious.name.assignment");
            }
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            PsiExpression lhs = expression.getLExpression();
            PsiExpression rhs = expression.getRExpression();
            if (lhs instanceof PsiReferenceExpression) {
                PsiReferenceExpression lhsExpr = (PsiReferenceExpression)lhs;
                if (rhs instanceof PsiReferenceExpression) {
                    PsiReferenceExpression rhsExpr = (PsiReferenceExpression)rhs;
                    this.checkCombination((PsiElement)lhsExpr, lhsExpr.getReferenceName(), rhsExpr.getReferenceName(), "suspicious.name.assignment");
                }
            }
        }

        public void visitCallExpression(@NotNull PsiCallExpression expression) {
            PsiMethod psiMethod;
            if (expression == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if (SuspiciousNameCombinationInspection.this.myIgnoredMethods.matches(psiMethod = expression.resolveMethod())) {
                return;
            }
            PsiExpressionList argList = expression.getArgumentList();
            if (psiMethod != null && argList != null) {
                PsiExpression[] args = argList.getExpressions();
                PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                for (int i = 0; i < parameters.length && i < args.length; ++i) {
                    String refName;
                    if (!(args[i] instanceof PsiReferenceExpression) || this.findNameGroup(refName = ((PsiReferenceExpression)args[i]).getReferenceName()) == null) continue;
                    this.checkCombination((PsiElement)args[i], parameters[i].getName(), refName, "suspicious.name.parameter");
                }
            }
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            PsiExpression returnValue = statement.getReturnValue();
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)returnValue, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
            if (returnValue instanceof PsiReferenceExpression && containingMethod != null) {
                String refName = ((PsiReferenceExpression)returnValue).getReferenceName();
                this.checkCombination((PsiElement)returnValue, containingMethod.getName(), refName, "suspicious.name.return");
            }
        }

        private void checkCombination(PsiElement location, @Nullable String name, @Nullable String referenceName, @PropertyKey(resourceBundle="messages.JavaErrorBundle") @PropertyKey(resourceBundle="messages.JavaErrorBundle") String key) {
            String nameGroup1 = this.findNameGroup(name);
            String nameGroup2 = this.findNameGroup(referenceName);
            if (nameGroup1 != null && nameGroup2 != null && !nameGroup1.equals(nameGroup2)) {
                this.myProblemsHolder.registerProblem(location, JavaErrorBundle.message((String)key, (Object[])new Object[]{referenceName, name}), new LocalQuickFix[0]);
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable
        private String findNameGroup(@Nullable String name) {
            if (name == null) {
                return null;
            }
            @NotNull List words = ContainerUtil.map((Collection)NameUtil.splitNameIntoWordList((String)name), SuspiciousNameCombinationInspection::canonicalize);
            String result = null;
            for (int i = 0; i < words.size(); ++i) {
                Object word = "";
                for (int j = i; j < words.size() && ((String)(word = (String)word + (String)words.get(j))).length() <= SuspiciousNameCombinationInspection.this.myLongestWord; ++j) {
                    String group = SuspiciousNameCombinationInspection.this.myWordToGroupMap.get(word);
                    if (group == null) continue;
                    if (result == null) {
                        result = group;
                        continue;
                    }
                    if (result.equals(group)) continue;
                    return null;
                }
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCallExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReturnStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

