/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.uncheckedWarnings;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableArrayTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.JavaBundle;
import com.intellij.java.codeserver.highlighting.JavaErrorCollector;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UncheckedWarningLocalInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "UNCHECKED_WARNING";
    @NonNls
    private static final String ID = "unchecked";
    private static final Logger LOG = Logger.getInstance(UncheckedWarningLocalInspection.class);
    public boolean IGNORE_UNCHECKED_ASSIGNMENT;
    public boolean IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION;
    public boolean IGNORE_UNCHECKED_CALL;
    public boolean IGNORE_UNCHECKED_CAST;
    public boolean IGNORE_UNCHECKED_OVERRIDING;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"IGNORE_UNCHECKED_ASSIGNMENT", (String)JavaBundle.message((String)"unchecked.warning.inspection.settings.ignore.unchecked.assignment", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION", (String)JavaBundle.message((String)"unchecked.warning.inspection.settings.ignore.unchecked.generics.array.creation.for.vararg.parameter", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"IGNORE_UNCHECKED_CALL", (String)JavaBundle.message((String)"unchecked.warning.inspection.settings.ignore.unchecked.call.as.member.of.raw.type", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"IGNORE_UNCHECKED_CAST", (String)JavaBundle.message((String)"unchecked.warning.inspection.settings.ignore.unchecked.cast", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"IGNORE_UNCHECKED_OVERRIDING", (String)JavaBundle.message((String)"unchecked.warning.inspection.settings.ignore.unchecked.overriding", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UncheckedWarningLocalInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    private static @NotNull LocalQuickFix @NotNull [] getChangeVariableTypeFixes(@NotNull PsiVariable parameter, @Nullable PsiType itemType) {
        if (parameter == null) {
            UncheckedWarningLocalInspection.$$$reportNull$$$0(1);
        }
        if (itemType instanceof PsiMethodReferenceType) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                UncheckedWarningLocalInspection.$$$reportNull$$$0(2);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LOG.assertTrue(parameter.isValid());
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        if (itemType != null) {
            for (ChangeVariableTypeQuickFixProvider fixProvider : ChangeVariableTypeQuickFixProvider.EP_NAME.getExtensionList()) {
                for (IntentionAction action : fixProvider.getFixes(parameter, itemType)) {
                    if (!(action instanceof LocalQuickFix)) continue;
                    result.add((LocalQuickFix)action);
                }
            }
        }
        LocalQuickFix[] localQuickFixArray = result.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            UncheckedWarningLocalInspection.$$$reportNull$$$0(3);
        }
        return localQuickFixArray;
    }

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return SHORT_NAME;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    @NonNls
    public String getID() {
        return ID;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            UncheckedWarningLocalInspection.$$$reportNull$$$0(4);
        }
        if (this.IGNORE_UNCHECKED_ASSIGNMENT || this.IGNORE_UNCHECKED_CALL || this.IGNORE_UNCHECKED_CAST || this.IGNORE_UNCHECKED_OVERRIDING || this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
            super.writeSettings(node);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        LanguageLevel languageLevel;
        if (holder == null) {
            UncheckedWarningLocalInspection.$$$reportNull$$$0(5);
        }
        if (session == null) {
            UncheckedWarningLocalInspection.$$$reportNull$$$0(6);
        }
        if (!JavaFeature.GENERICS.isSufficient(languageLevel = PsiUtil.getLanguageLevel((PsiElement)session.getFile()))) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
            if (psiElementVisitor == null) {
                UncheckedWarningLocalInspection.$$$reportNull$$$0(7);
            }
            return psiElementVisitor;
        }
        return new UncheckedWarningsVisitor(this, isOnTheFly, languageLevel){

            @Override
            protected void registerProblem(@NotNull @InspectionMessage String message, @Nullable PsiElement callExpression, @NotNull PsiElement psiElement, @NotNull @NotNull LocalQuickFix @NotNull [] quickFixes) {
                String rawExpression;
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (psiElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (quickFixes == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((rawExpression = UncheckedWarningLocalInspection.isMethodCalledOnRawType(callExpression)) != null) {
                    String referenceName = ((PsiMethodCallExpression)callExpression).getMethodExpression().getReferenceName();
                    message = (String)message + JavaBundle.message((String)"unchecked.warning.inspection.reason.expr.has.raw.type.so.result.erased", (Object[])new Object[]{rawExpression, referenceName});
                }
                PsiElement psiElement2 = psiElement;
                Objects.requireNonNull(psiElement2);
                PsiElement psiElement3 = psiElement2;
                int n = 0;
                PsiJavaCodeReferenceElement element2Highlight = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiNewExpression.class, PsiMethodCallExpression.class}, (Object)psiElement3, n)) {
                    case 0 -> {
                        PsiNewExpression expression = (PsiNewExpression)psiElement3;
                        yield expression.getClassOrAnonymousClassReference();
                    }
                    case 1 -> {
                        PsiMethodCallExpression call = (PsiMethodCallExpression)psiElement3;
                        yield call.getMethodExpression();
                    }
                    default -> null;
                };
                holder.registerProblem((PsiElement)ObjectUtils.notNull((Object)element2Highlight, (Object)psiElement), (String)message, quickFixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "psiElement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "quickFixes";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspection$1";
                objectArray[2] = "registerProblem";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static String isMethodCalledOnRawType(PsiElement expression) {
        PsiClass qualifierClass;
        PsiExpression qualifierExpression;
        if (expression instanceof PsiMethodCallExpression && (qualifierExpression = ((PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression()) != null && (qualifierClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierExpression.getType())) != null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)qualifierClass, (PsiSubstitutor)((PsiMethodCallExpression)expression).resolveMethodGenerics().getSubstitutor())) {
            return qualifierExpression.getText();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeVariableTypeFixes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChangeVariableTypeFixes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    private abstract class UncheckedWarningsVisitor
    extends JavaElementVisitor {
        private final boolean myOnTheFly;
        @NotNull
        private final LanguageLevel myLanguageLevel;

        UncheckedWarningsVisitor(@NotNull boolean onTheFly, LanguageLevel level) {
            if (level == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(0);
            }
            this.myOnTheFly = onTheFly;
            this.myLanguageLevel = level;
        }

        protected abstract void registerProblem(@NotNull @InspectionMessage String var1, PsiElement var2, @NotNull PsiElement var3, @NotNull @NotNull LocalQuickFix @NotNull [] var4);

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(1);
            }
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
                return;
            }
            JavaResolveResult result = expression.advancedResolve(false);
            if (JavaGenericsUtil.isUncheckedWarning((PsiJavaCodeReferenceElement)expression, (JavaResolveResult)result, (LanguageLevel)this.myLanguageLevel)) {
                this.registerProblem(JavaBundle.message((String)"unchecked.warning.inspection.message.unchecked.generics.array.creation.for.varargs.parameter", (Object[])new Object[0]), null, (PsiElement)expression, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(2);
            }
            super.visitNewExpression(expression);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
                return;
            }
            PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
            if (classReference != null && JavaGenericsUtil.isUncheckedWarning((PsiJavaCodeReferenceElement)classReference, (JavaResolveResult)expression.resolveMethodGenerics(), (LanguageLevel)this.myLanguageLevel)) {
                this.registerProblem(JavaBundle.message((String)"unchecked.warning.inspection.message.unchecked.generics.array.creation.for.varargs.parameter", (Object[])new Object[0]), (PsiElement)expression, (PsiElement)classReference, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(3);
            }
            super.visitTypeCastExpression(expression);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_CAST) {
                return;
            }
            PsiTypeElement typeElement = expression.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiType castType = typeElement.getType();
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType exprType = operand.getType();
            if (exprType == null) {
                return;
            }
            if (!TypeConversionUtil.areTypesConvertible((PsiType)exprType, (PsiType)castType)) {
                return;
            }
            if (JavaGenericsUtil.isUncheckedCast((PsiType)castType, (PsiType)exprType)) {
                String description = JavaErrorBundle.message((String)"generics.unchecked.cast", (Object[])new Object[]{JavaHighlightUtil.formatType((PsiType)exprType), JavaHighlightUtil.formatType((PsiType)castType)});
                this.registerProblem(description, (PsiElement)operand, (PsiElement)expression, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
            if (expression == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(4);
            }
            super.visitMethodReferenceExpression(expression);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_CALL) {
                return;
            }
            JavaResolveResult result = expression.advancedResolve(false);
            String description = UncheckedWarningsVisitor.getUncheckedCallDescription((PsiElement)expression, result);
            if (description != null) {
                PsiElement referenceNameElement = expression.getReferenceNameElement();
                this.registerProblem(description, (PsiElement)expression, (PsiElement)(referenceNameElement != null ? referenceNameElement : expression), LocalQuickFix.EMPTY_ARRAY);
            }
        }

        public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
            if (callExpression == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(5);
            }
            super.visitCallExpression(callExpression);
            JavaResolveResult result = callExpression.resolveMethodGenerics();
            String description = UncheckedWarningsVisitor.getUncheckedCallDescription((PsiElement)callExpression, result);
            if (description != null) {
                if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_CALL) {
                    return;
                }
                this.registerProblem(description, null, (PsiElement)callExpression, LocalQuickFix.EMPTY_ARRAY);
            } else {
                PsiMethod method;
                if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                    return;
                }
                PsiSubstitutor substitutor = result.getSubstitutor();
                PsiExpressionList argumentList = callExpression.getArgumentList();
                if (argumentList != null && (method = (PsiMethod)result.getElement()) != null) {
                    PsiExpression[] expressions = argumentList.getExpressions();
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    if (parameters.length != 0) {
                        for (int i = 0; i < expressions.length; ++i) {
                            PsiParameter parameter = parameters[Math.min(i, parameters.length - 1)];
                            PsiExpression expression = expressions[i];
                            PsiType parameterType = substitutor.substitute(parameter.getType());
                            PsiType expressionType = expression.getType();
                            if (expressionType == null) continue;
                            this.checkRawToGenericsAssignment((PsiElement)expression, expression, parameterType, expressionType, () -> LocalQuickFix.EMPTY_ARRAY);
                        }
                    }
                }
            }
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(6);
            }
            super.visitVariable(variable);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null || initializer instanceof PsiArrayInitializerExpression) {
                return;
            }
            PsiType initializerType = initializer.getType();
            this.checkRawToGenericsAssignment((PsiElement)initializer, initializer, variable.getType(), initializerType, () -> this.myOnTheFly ? UncheckedWarningLocalInspection.getChangeVariableTypeFixes(variable, initializerType) : LocalQuickFix.EMPTY_ARRAY);
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(7);
            }
            super.visitForeachStatement(statement);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiParameter parameter = statement.getIterationParameter();
            PsiType parameterType = parameter.getType();
            PsiExpression iteratedValue = statement.getIteratedValue();
            if (iteratedValue == null) {
                return;
            }
            PsiType itemType = JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue);
            this.checkRawToGenericsAssignment((PsiElement)parameter, iteratedValue, parameterType, itemType, () -> this.myOnTheFly ? UncheckedWarningLocalInspection.getChangeVariableTypeFixes((PsiVariable)parameter, itemType) : LocalQuickFix.EMPTY_ARRAY);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(8);
            }
            super.visitAssignmentExpression(expression);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            if (!"=".equals(expression.getOperationSign().getText())) {
                return;
            }
            PsiExpression lExpr = expression.getLExpression();
            PsiExpression rExpr = expression.getRExpression();
            if (rExpr == null) {
                return;
            }
            PsiType lType = lExpr.getType();
            PsiType rType = rExpr.getType();
            if (rType == null) {
                return;
            }
            this.checkRawToGenericsAssignment((PsiElement)rExpr, rExpr, lType, rType, () -> {
                PsiElement element;
                if (this.myOnTheFly && lExpr instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)lExpr).resolve()) instanceof PsiVariable) {
                    return UncheckedWarningLocalInspection.getChangeVariableTypeFixes((PsiVariable)element, rType);
                }
                return LocalQuickFix.EMPTY_ARRAY;
            });
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
            if (expression == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(9);
            }
            super.visitConditionalExpression(expression);
            if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)expression) && PsiPolyExpressionUtil.isPolyExpression((PsiExpression)expression)) {
                PsiType targetType = expression.getType();
                if (targetType == null) {
                    return;
                }
                this.processConditionalPart(targetType, expression.getThenExpression());
                this.processConditionalPart(targetType, expression.getElseExpression());
            }
        }

        private void processConditionalPart(PsiType targetType, PsiExpression thenExpression) {
            PsiType thenType;
            if (thenExpression != null && (thenType = thenExpression.getType()) != null) {
                this.checkRawToGenericsAssignment((PsiElement)thenExpression, thenExpression, targetType, thenType, () -> LocalQuickFix.EMPTY_ARRAY);
            }
        }

        public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression arrayInitializer) {
            PsiExpression[] initializers;
            if (arrayInitializer == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(10);
            }
            super.visitArrayInitializerExpression(arrayInitializer);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiType psiType = arrayInitializer.getType();
            if (!(psiType instanceof PsiArrayType)) {
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)psiType;
            PsiType componentType = arrayType.getComponentType();
            boolean arrayTypeFixChecked = false;
            VariableArrayTypeFix fix = null;
            for (PsiExpression expression : initializers = arrayInitializer.getInitializers()) {
                PsiType itemType = expression.getType();
                if (itemType == null || !TypeConversionUtil.isAssignable((PsiType)componentType, (PsiType)itemType) || !JavaGenericsUtil.isRawToGeneric((PsiType)componentType, (PsiType)itemType)) continue;
                String description = JavaErrorBundle.message((String)"generics.unchecked.assignment", (Object[])new Object[]{itemType.getCanonicalText(), componentType.getCanonicalText()});
                if (!arrayTypeFixChecked) {
                    PsiType checkResult = JavaHighlightUtil.sameType((PsiExpression[])initializers);
                    fix = checkResult != null ? VariableArrayTypeFix.createFix((PsiArrayInitializerExpression)arrayInitializer, (PsiType)checkResult) : null;
                    arrayTypeFixChecked = true;
                }
                if (fix == null) continue;
                this.registerProblem(description, null, (PsiElement)expression, new LocalQuickFix[]{LocalQuickFix.from((ModCommandAction)fix)});
            }
        }

        private void checkRawToGenericsAssignment(@NotNull PsiElement parameter, PsiExpression expression, PsiType parameterType, PsiType itemType, @NotNull @NotNull Supplier<? extends @NotNull LocalQuickFix @NotNull []> fixesSupplier) {
            if (parameter == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(11);
            }
            if (fixesSupplier == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(12);
            }
            if (JavaErrorCollector.findSingleError((PsiElement)expression) != null) {
                return;
            }
            if (parameterType == null || itemType == null) {
                return;
            }
            if (!TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)itemType)) {
                return;
            }
            if (JavaGenericsUtil.isRawToGeneric((PsiType)parameterType, (PsiType)itemType)) {
                String description = JavaErrorBundle.message((String)"generics.unchecked.assignment", (Object[])new Object[]{itemType.getCanonicalText(), parameterType.getCanonicalText()});
                this.registerProblem(description, (PsiElement)expression, parameter, fixesSupplier.get());
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            List superMethodSignatures;
            if (method == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(13);
            }
            super.visitMethod(method);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_OVERRIDING) {
                return;
            }
            if (!(method.isConstructor() || (superMethodSignatures = method.getHierarchicalMethodSignature().getSuperSignatures()).isEmpty() || method.hasModifierProperty("static"))) {
                MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
                for (MethodSignatureBackedByPsiMethod superSignature : superMethodSignatures) {
                    PsiMethod baseMethod = superSignature.getMethod();
                    PsiSubstitutor substitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)signature, (MethodSignature)superSignature);
                    if (substitutor == null) {
                        substitutor = superSignature.getSubstitutor();
                    }
                    if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)baseMethod, (PsiSubstitutor)superSignature.getSubstitutor())) continue;
                    PsiType baseReturnType = substitutor.substitute(baseMethod.getReturnType());
                    PsiType overriderReturnType = method.getReturnType();
                    if (baseReturnType == null || overriderReturnType == null) {
                        return;
                    }
                    if (!JavaGenericsUtil.isRawToGeneric((PsiType)baseReturnType, (PsiType)overriderReturnType)) continue;
                    String message = JavaErrorBundle.message((String)"unchecked.overriding.incompatible.return.type", (Object[])new Object[]{JavaHighlightUtil.formatType((PsiType)overriderReturnType), JavaHighlightUtil.formatType((PsiType)baseReturnType)});
                    PsiTypeElement returnTypeElement = method.getReturnTypeElement();
                    LOG.assertTrue(returnTypeElement != null);
                    this.registerProblem(message, null, (PsiElement)returnTypeElement, LocalQuickFix.EMPTY_ARRAY);
                }
            }
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            PsiType valueType;
            PsiExpression returnValue;
            if (statement == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(14);
            }
            super.visitReturnStatement(statement);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiType returnType = PsiTypesUtil.getMethodReturnType((PsiElement)statement);
            if (returnType != null && !PsiTypes.voidType().equals((Object)returnType) && (returnValue = statement.getReturnValue()) != null && (valueType = returnValue.getType()) != null) {
                this.checkRawToGenericsAssignment((PsiElement)returnValue, returnValue, returnType, valueType, () -> {
                    LocalQuickFix[] localQuickFixArray;
                    PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                    if (psiElement instanceof PsiMethod) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = QuickFixFactory.getInstance().createMethodReturnFix((PsiMethod)psiElement, valueType, true);
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    return localQuickFixArray;
                });
            }
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            PsiType type;
            PsiType interfaceReturnType;
            if (expression == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(15);
            }
            super.visitLambdaExpression(expression);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiElement body = expression.getBody();
            if (body instanceof PsiExpression && (interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression)) != null && !PsiTypes.voidType().equals((Object)interfaceReturnType) && (type = ((PsiExpression)body).getType()) != null) {
                this.checkRawToGenericsAssignment(body, (PsiExpression)body, interfaceReturnType, type, () -> LocalQuickFix.EMPTY_ARRAY);
            }
        }

        @Nullable
        @InspectionMessage
        private static String getUncheckedCallDescription(PsiElement place, JavaResolveResult resolveResult) {
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiMethod)) {
                return null;
            }
            PsiMethod method = (PsiMethod)element;
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            if (!PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)method, (PsiSubstitutor)substitutor)) {
                if (JavaVersionService.getInstance().isAtLeast(place, JavaSdkVersion.JDK_1_8)) {
                    for (PsiTypeParameter parameter : method.getTypeParameters()) {
                        PsiClassType[] extendsListTypes = parameter.getExtendsListTypes();
                        if (extendsListTypes.length <= 0) continue;
                        PsiType subst = substitutor.substitute(parameter);
                        for (PsiClassType classType : extendsListTypes) {
                            if (!JavaGenericsUtil.isRawToGeneric((PsiType)substitutor.substitute((PsiType)classType), (PsiType)subst)) continue;
                            return JavaErrorBundle.message((String)"generics.unchecked.call", (Object[])new Object[]{JavaHighlightUtil.formatMethod((PsiMethod)method)});
                        }
                    }
                }
                return null;
            }
            if (PsiTypesUtil.isUncheckedCall((JavaResolveResult)resolveResult)) {
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
                PsiClassType type = elementFactory.createType(method.getContainingClass(), substitutor);
                return JavaErrorBundle.message((String)"generics.unchecked.call.to.member.of.raw.type", (Object[])new Object[]{JavaHighlightUtil.formatMethod((PsiMethod)method), JavaHighlightUtil.formatType((PsiType)type)});
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 7: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayInitializer";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixesSupplier";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspection$UncheckedWarningsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeCastExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodReferenceExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCallExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForeachStatement";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitConditionalExpression";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArrayInitializerExpression";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkRawToGenericsAssignment";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReturnStatement";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLambdaExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

