/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.valuebased;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.java.JavaBundle;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SynchronizeOnValueBasedClassInspection
extends LocalInspectionTool {
    @NonNls
    private static final String JDK_INTERNAL_VALUE_BASED = "jdk.internal.ValueBased";

    @NotNull
    public String getID() {
        return "synchronization";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SynchronizeOnValueBasedClassInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.getLanguageLevel((PsiElement)holder.getFile()).isAtLeast(LanguageLevel.JDK_16)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SynchronizeOnValueBasedClassInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(this){

            public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
                TypeConstraint constraint;
                PsiType inferredType;
                PsiExpression monitor;
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((monitor = statement.getLockExpression()) == null) {
                    return;
                }
                PsiType monitorType = monitor.getType();
                if (monitorType == null) {
                    return;
                }
                if (!(SynchronizeOnValueBasedClassInspection.isValueBasedClass(PsiUtil.resolveClassInClassTypeOnly((PsiType)monitorType)) || !monitorType.equals(inferredType = (constraint = TypeConstraint.fromDfType((DfType)CommonDataflow.getDfType((PsiExpression)monitor))).getPsiType(statement.getProject())) && SynchronizeOnValueBasedClassInspection.isValueBasedClass(PsiUtil.resolveClassInClassTypeOnly((PsiType)inferredType)))) {
                    return;
                }
                ProblemHighlightType highlightType = JavaFeature.VALHALLA_VALUE_CLASSES.isSufficient(PsiUtil.getLanguageLevel((PsiElement)monitor)) ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                holder.registerProblem((PsiElement)monitor, JavaBundle.message((String)"inspection.value.based.warnings.synchronization", (Object[])new Object[0]), highlightType, new LocalQuickFix[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/valuebased/SynchronizeOnValueBasedClassInspection$1", "visitSynchronizedStatement"));
            }
        };
    }

    @Contract(value="null -> false", pure=true)
    private static boolean isValueBasedClass(PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        return aClass.isValueClass() || aClass.hasAnnotation(JDK_INTERNAL_VALUE_BASED) || ContainerUtil.or((Object[])aClass.getSupers(), c -> SynchronizeOnValueBasedClassInspection.isValueBasedClass(c));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/valuebased/SynchronizeOnValueBasedClassInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/valuebased/SynchronizeOnValueBasedClassInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

