/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.options.JavaClassValidator;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AddToInspectionOptionListFix;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.codeInspection.util.SpecialAnnotationsUtilBase;
import com.intellij.codeInspection.varScopeCanBeNarrowed.ConvertToLocalUtils;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.AllVariablesControlFlowPolicy;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowOptions;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FieldCanBeLocalInspection
extends AbstractBaseJavaLocalInspectionTool {
    public final JDOMExternalizableStringList EXCLUDE_ANNOS = new JDOMExternalizableStringList();
    public boolean IGNORE_FIELDS_USED_IN_MULTIPLE_METHODS = true;

    private void doCheckClass(PsiClass aClass, ProblemsHolder holder) {
        if (aClass.isInterface()) {
            return;
        }
        HashSet<PsiField> candidates = new HashSet<PsiField>();
        for (PsiField field : aClass.getFields()) {
            if (!field.isPhysical() || AnnotationUtil.isAnnotated((PsiModifierListOwner)field, (Collection)this.EXCLUDE_ANNOS, (int)0) || field.hasModifierProperty("volatile") || !field.hasModifierProperty("private") || field.hasModifierProperty("static") && field.hasModifierProperty("final")) continue;
            candidates.add(field);
        }
        if (candidates.isEmpty()) {
            return;
        }
        FieldCanBeLocalInspection.removeFieldsReferencedFromInitializers((PsiElement)aClass, (PsiElement)aClass, candidates);
        if (candidates.isEmpty()) {
            return;
        }
        HashSet usedFields = new HashSet();
        FieldCanBeLocalInspection.removeReadFields(aClass, candidates, usedFields, this.IGNORE_FIELDS_USED_IN_MULTIPLE_METHODS);
        if (candidates.isEmpty()) {
            return;
        }
        List implicitUsageProviders = ImplicitUsageProvider.EP_NAME.getExtensionList();
        PsiClass scope = FieldCanBeLocalInspection.findVariableScope(aClass);
        block1: for (PsiField field : candidates) {
            if (!usedFields.contains(field) || FieldCanBeLocalInspection.hasImplicitReadOrWriteUsage(field, implicitUsageProviders)) continue;
            List references = VariableAccessUtils.getVariableReferences((PsiVariable)field, (PsiElement)scope);
            HashMap<PsiCodeBlock, List<PsiReferenceExpression>> refs = new HashMap<PsiCodeBlock, List<PsiReferenceExpression>>();
            for (PsiReferenceExpression reference : references) {
                PsiThisExpression thisExpression;
                PsiElement qualifier = reference.getQualifier();
                if ((qualifier == null || qualifier instanceof PsiThisExpression && (thisExpression = (PsiThisExpression)qualifier).getQualifier() == null) && FieldCanBeLocalInspection.groupReferenceByCodeBlocks(refs, reference)) continue;
                continue block1;
            }
            String message = JavaBundle.message((String)"inspection.field.can.be.local.problem.descriptor", (Object[])new Object[0]);
            ArrayList<ConvertFieldToLocalQuickFix> fixes = new ArrayList<ConvertFieldToLocalQuickFix>();
            SpecialAnnotationsUtilBase.processUnknownAnnotations((PsiModifierListOwner)field, qualifiedName -> {
                fixes.add((ConvertFieldToLocalQuickFix)new AddToInspectionOptionListFix((InspectionProfileEntry)this, QuickFixBundle.message((String)"fix.add.special.annotation.text", (Object[])new Object[]{qualifiedName}), qualifiedName, insp -> insp.EXCLUDE_ANNOS));
                return true;
            });
            fixes.add(new ConvertFieldToLocalQuickFix(refs));
            holder.registerProblem((PsiElement)field.getNameIdentifier(), message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"EXCLUDE_ANNOS", (String)JavaBundle.message((String)"special.annotations.annotations.list", (Object[])new Object[0]), (StringValidator)new JavaClassValidator().annotationsOnly()), OptPane.checkbox((String)"IGNORE_FIELDS_USED_IN_MULTIPLE_METHODS", (String)JavaBundle.message((String)"checkbox.ignore.fields.used.in.multiple.methods", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            FieldCanBeLocalInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    private static PsiClass findVariableScope(@NotNull PsiClass containingClass) {
        PsiClass scope;
        if (containingClass == null) {
            FieldCanBeLocalInspection.$$$reportNull$$$0(1);
        }
        PsiClass psiClass = (scope = (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)containingClass, PsiClass.class)) == null ? containingClass : scope;
        if (psiClass == null) {
            FieldCanBeLocalInspection.$$$reportNull$$$0(2);
        }
        return psiClass;
    }

    private static void removeFieldsReferencedFromInitializers(final PsiElement aClass, PsiElement root, final Set<PsiField> candidates) {
        root.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethod(@NotNull PsiMethod method) {
                PsiDocComment docComment;
                PsiMethodCallExpression call;
                PsiMethod resolveMethod;
                PsiExpressionStatement statement;
                PsiExpression expression;
                PsiStatement psiStatement;
                PsiStatement[] statements;
                PsiCodeBlock body;
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (method.isConstructor() && !PsiUtil.isAvailable((JavaFeature)JavaFeature.STATEMENTS_BEFORE_SUPER, (PsiElement)method) && (body = method.getBody()) != null && (statements = body.getStatements()).length > 0 && (psiStatement = statements[0]) instanceof PsiExpressionStatement && (expression = (statement = (PsiExpressionStatement)psiStatement).getExpression()) instanceof PsiMethodCallExpression && (resolveMethod = (call = (PsiMethodCallExpression)expression).resolveMethod()) != null && resolveMethod.isConstructor()) {
                    FieldCanBeLocalInspection.removeFieldsReferencedFromInitializers(aClass, (PsiElement)expression, candidates);
                }
                if ((docComment = method.getDocComment()) != null) {
                    FieldCanBeLocalInspection.removeFieldsReferencedFromInitializers(aClass, (PsiElement)docComment, candidates);
                }
            }

            public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
                if (initializer == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.excludeFieldCandidate((PsiReference)expression);
                super.visitReferenceExpression(expression);
            }

            public void visitDocTagValue(@NotNull PsiDocTagValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.excludeFieldCandidate(value.getReference());
                super.visitDocTagValue(value);
            }

            private void excludeFieldCandidate(PsiReference ref) {
                PsiField field;
                PsiElement psiElement;
                if (ref != null && (psiElement = ref.resolve()) instanceof PsiField && aClass.equals((Object)(field = (PsiField)psiElement).getContainingClass())) {
                    candidates.remove(field);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "initializer";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassInitializer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDocTagValue";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void removeReadFields(PsiClass aClass, final Set<? super PsiField> candidates, final Set<? super PsiField> usedFields, final boolean ignoreFieldsUsedInMultipleMethods) {
        final HashSet ignored = new HashSet();
        aClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!candidates.isEmpty()) {
                    super.visitElement(element);
                }
            }

            public void visitMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.visitMethod(method);
                PsiCodeBlock body = method.getBody();
                if (body != null) {
                    FieldCanBeLocalInspection.checkCodeBlock((PsiElement)body, candidates, usedFields, ignoreFieldsUsedInMultipleMethods, ignored);
                }
            }

            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(2);
                }
                super.visitLambdaExpression(expression);
                PsiElement body = expression.getBody();
                if (body != null) {
                    FieldCanBeLocalInspection.checkCodeBlock(body, candidates, usedFields, ignoreFieldsUsedInMultipleMethods, ignored);
                }
            }

            public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
                if (initializer == null) {
                    2.$$$reportNull$$$0(3);
                }
                super.visitClassInitializer(initializer);
                FieldCanBeLocalInspection.checkCodeBlock((PsiElement)initializer.getBody(), candidates, usedFields, ignoreFieldsUsedInMultipleMethods, ignored);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "initializer";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassInitializer";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void checkCodeBlock(PsiElement body, Set<? super PsiField> candidates, Set<? super PsiField> usedFields, boolean ignoreFieldsUsedInMultipleMethods, Set<? super PsiField> ignored) {
        try {
            ControlFlow controlFlow = ControlFlowFactory.getControlFlow((PsiElement)body, (ControlFlowPolicy)AllVariablesControlFlowPolicy.getInstance(), (ControlFlowOptions)ControlFlowOptions.NO_CONST_EVALUATE);
            List usedVars = ContainerUtil.filterIsInstance((Collection)ControlFlowUtil.getUsedVariables((ControlFlow)controlFlow, (int)0, (int)controlFlow.getSize()), PsiField.class);
            if (usedVars.isEmpty()) {
                return;
            }
            Collection writtenVariables = ControlFlowUtil.getWrittenVariables((ControlFlow)controlFlow, (int)0, (int)controlFlow.getSize(), (boolean)false);
            for (PsiField usedVariable : usedVars) {
                if (!writtenVariables.contains(usedVariable)) {
                    ignored.add((PsiField)usedVariable);
                }
                if (usedFields.add((PsiField)usedVariable) || !ignoreFieldsUsedInMultipleMethods && !ignored.contains(usedVariable)) continue;
                candidates.remove(usedVariable);
            }
            if (candidates.isEmpty()) {
                return;
            }
            for (PsiReferenceExpression readBeforeWrite : ControlFlowUtil.getReadBeforeWrite((ControlFlow)controlFlow)) {
                PsiMethod method;
                PsiElement parent;
                PsiField field;
                PsiElement resolved = readBeforeWrite.resolve();
                if (!(resolved instanceof PsiField) || FieldCanBeLocalInspection.isImmutableState((field = (PsiField)resolved).getType()) && PsiUtil.isConstantExpression((PsiExpression)field.getInitializer()) && !writtenVariables.contains(field) || (parent = body.getParent()) instanceof PsiMethod && (method = (PsiMethod)parent).isConstructor() && field.getInitializer() != null && !field.hasModifierProperty("static") && PsiTreeUtil.isAncestor((PsiElement)method.getContainingClass(), (PsiElement)field, (boolean)true)) continue;
                candidates.remove(field);
            }
        }
        catch (AnalysisCanceledException e) {
            candidates.clear();
        }
    }

    private static boolean isImmutableState(PsiType type) {
        return type instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)type) != null || Comparing.strEqual((String)"java.lang.String", (String)type.getCanonicalText());
    }

    private static boolean hasImplicitReadOrWriteUsage(PsiField field, List<? extends ImplicitUsageProvider> implicitUsageProviders) {
        for (ImplicitUsageProvider implicitUsageProvider : implicitUsageProviders) {
            if (!implicitUsageProvider.isImplicitRead((PsiElement)field) && !implicitUsageProvider.isImplicitWrite((PsiElement)field)) continue;
            return true;
        }
        return false;
    }

    private static boolean groupByCodeBlocks(Collection<? extends PsiReferenceExpression> allReferences, Map<PsiCodeBlock, List<PsiReferenceExpression>> refs) {
        for (PsiReferenceExpression psiReferenceExpression : allReferences) {
            if (FieldCanBeLocalInspection.groupReferenceByCodeBlocks(refs, psiReferenceExpression)) continue;
            return false;
        }
        return true;
    }

    private static boolean groupReferenceByCodeBlocks(Map<PsiCodeBlock, List<PsiReferenceExpression>> refs, PsiReferenceExpression ref) {
        PsiCodeBlock block = FieldCanBeLocalInspection.getTopmostBlock((PsiElement)ref);
        if (block == null) {
            return false;
        }
        List<PsiReferenceExpression> references = refs.get(block);
        if (references == null) {
            references = new ArrayList<PsiReferenceExpression>();
            if (FieldCanBeLocalInspection.findExistentBlock(refs, ref, block, references)) {
                return true;
            }
            refs.put(block, references);
        }
        references.add(ref);
        return true;
    }

    @Nullable
    private static PsiCodeBlock getTopmostBlock(@NotNull PsiElement element) {
        if (element == null) {
            FieldCanBeLocalInspection.$$$reportNull$$$0(3);
        }
        PsiCodeBlock result = null;
        for (PsiElement parent = element.getParent(); !(parent == null || parent instanceof PsiClass && result != null); parent = parent.getParent()) {
            PsiCodeBlock block;
            if (!(parent instanceof PsiCodeBlock)) continue;
            result = block = (PsiCodeBlock)parent;
        }
        return result;
    }

    private static boolean findExistentBlock(Map<PsiCodeBlock, List<PsiReferenceExpression>> refs, PsiReferenceExpression psiReference, PsiCodeBlock block, Collection<? super PsiReferenceExpression> references) {
        Iterator<PsiCodeBlock> iterator = refs.keySet().iterator();
        while (iterator.hasNext()) {
            PsiCodeBlock codeBlock = iterator.next();
            if (PsiTreeUtil.isAncestor((PsiElement)codeBlock, (PsiElement)block, (boolean)false)) {
                refs.get(codeBlock).add(psiReference);
                return true;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)codeBlock, (boolean)false)) continue;
            references.addAll((Collection<? super PsiReferenceExpression>)refs.get(codeBlock));
            iterator.remove();
            break;
        }
        return false;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            FieldCanBeLocalInspection.$$$reportNull$$$0(4);
        }
        if (!this.EXCLUDE_ANNOS.isEmpty() || !this.IGNORE_FIELDS_USED_IN_MULTIPLE_METHODS) {
            super.writeSettings(node);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FieldCanBeLocalInspection.$$$reportNull$$$0(5);
        }
        return new JavaElementVisitor(){

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.visitClass(aClass);
                FieldCanBeLocalInspection.this.doCheckClass(aClass, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$3", "visitClass"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findVariableScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findVariableScope";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostBlock";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private static final class ConvertFieldToLocalQuickFix
    extends PsiUpdateModCommandQuickFix {
        @IntentionName
        private final String myName;

        private ConvertFieldToLocalQuickFix(@NotNull Map<PsiCodeBlock, List<PsiReferenceExpression>> refs) {
            if (refs == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(0);
            }
            Set<PsiCodeBlock> blocks = refs.keySet();
            PsiElement block = blocks.size() == 1 ? PsiTreeUtil.getParentOfType((PsiElement)blocks.toArray(PsiCodeBlock.EMPTY_ARRAY)[0], (Class[])new Class[]{PsiClassInitializer.class, PsiMethod.class}) : null;
            this.myName = this.determineName(block);
        }

        @NotNull
        @IntentionName
        private String determineName(@Nullable PsiElement block) {
            if (block instanceof PsiClassInitializer) {
                String string = JavaBundle.message((String)"inspection.field.can.be.local.quickfix.initializer", (Object[])new Object[0]);
                if (string == null) {
                    ConvertFieldToLocalQuickFix.$$$reportNull$$$0(1);
                }
                return string;
            }
            if (block instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)block;
                if (method.isConstructor()) {
                    String string = JavaBundle.message((String)"inspection.field.can.be.local.quickfix.constructor", (Object[])new Object[0]);
                    if (string == null) {
                        ConvertFieldToLocalQuickFix.$$$reportNull$$$0(2);
                    }
                    return string;
                }
                String string = JavaBundle.message((String)"inspection.field.can.be.local.quickfix.one.method", (Object[])new Object[]{method.getName()});
                if (string == null) {
                    ConvertFieldToLocalQuickFix.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = this.getFamilyName();
            if (string == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        private static String suggestLocalName(@NotNull PsiField field, @NotNull PsiCodeBlock scope) {
            if (field == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(6);
            }
            if (scope == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(7);
            }
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)field.getProject());
            String propertyName = styleManager.variableNameToPropertyName(field.getName(), VariableKind.FIELD);
            String localName = styleManager.propertyNameToVariableName(propertyName, VariableKind.LOCAL_VARIABLE);
            String string = CommonJavaRefactoringUtil.suggestUniqueVariableName((String)localName, (PsiElement)scope, (PsiField)field);
            if (string == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        private static List<PsiElement> moveDeclaration(@NotNull PsiField variable) {
            if (variable == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(9);
            }
            HashMap<PsiCodeBlock, List<PsiReferenceExpression>> refs = new HashMap<PsiCodeBlock, List<PsiReferenceExpression>>();
            ArrayList<PsiElement> newDeclarations = new ArrayList<PsiElement>();
            PsiClass containingClass = variable.getContainingClass();
            if (containingClass == null) {
                ArrayList<PsiElement> arrayList = newDeclarations;
                if (arrayList == null) {
                    ConvertFieldToLocalQuickFix.$$$reportNull$$$0(10);
                }
                return arrayList;
            }
            PsiClass scope = FieldCanBeLocalInspection.findVariableScope(containingClass);
            if (!FieldCanBeLocalInspection.groupByCodeBlocks(VariableAccessUtils.getVariableReferences((PsiVariable)variable, (PsiElement)scope), refs)) {
                ArrayList<PsiElement> arrayList = newDeclarations;
                if (arrayList == null) {
                    ConvertFieldToLocalQuickFix.$$$reportNull$$$0(11);
                }
                return arrayList;
            }
            for (List ref : refs.values()) {
                PsiElement declaration = ConvertToLocalUtils.copyVariableToMethodBody((PsiVariable)variable, ref, block -> ConvertFieldToLocalQuickFix.suggestLocalName(variable, block));
                if (declaration == null) continue;
                newDeclarations.add(declaration);
            }
            if (!newDeclarations.isEmpty()) {
                PsiElement lastDeclaration = (PsiElement)newDeclarations.getLast();
                ConvertFieldToLocalQuickFix.deleteField(variable, lastDeclaration);
            }
            ArrayList<PsiElement> arrayList = newDeclarations;
            if (arrayList == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(12);
            }
            return arrayList;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.convert.to.local.quickfix", (Object[])new Object[0]);
            if (string == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(13);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiField variable;
            if (project == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(14);
            }
            if (element == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(15);
            }
            if (updater == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(16);
            }
            if ((variable = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class)) == null) {
                return;
            }
            List<PsiElement> newDeclarations = ConvertFieldToLocalQuickFix.moveDeclaration(variable);
            if (newDeclarations.isEmpty()) {
                return;
            }
            updater.moveCaretTo(newDeclarations.getLast());
            newDeclarations.forEach(declaration -> ConvertToLocalUtils.inlineRedundant(declaration));
        }

        private static void deleteField(@NotNull PsiField variable, PsiElement newDeclaration) {
            if (variable == null) {
                ConvertFieldToLocalQuickFix.$$$reportNull$$$0(17);
            }
            CommentTracker tracker = new CommentTracker();
            variable.normalizeDeclaration();
            tracker.delete((PsiElement)variable);
            tracker.insertCommentsBefore(newDeclaration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 8, 10, 11, 12, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refs";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 9: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "determineName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestLocalName";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "moveDeclaration";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "suggestLocalName";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "moveDeclaration";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteField";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 8, 10, 11, 12, 13 -> new IllegalStateException(string);
            };
        }
    }
}

