/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.varScopeCanBeNarrowed.ConvertToLocalUtils;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.refactoring.ChangeSignatureRefactoring;
import com.intellij.refactoring.JavaRefactoringFactory;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParameterCanBeLocalInspection
extends AbstractBaseJavaLocalInspectionTool {
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(1);
        }
        List<PsiParameter> parameters = ParameterCanBeLocalInspection.filterFinal(method.getParameterList().getParameters());
        PsiCodeBlock body = method.getBody();
        if (body == null || parameters.isEmpty() || ParameterCanBeLocalInspection.isOverrides(method)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Collection<PsiParameter> writtenBeforeReadParameters = ParameterCanBeLocalInspection.getWriteBeforeRead(parameters, body);
        if (writtenBeforeReadParameters.isEmpty() || MethodUtils.isOverridden((PsiMethod)method)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (PsiParameter parameter : writtenBeforeReadParameters) {
            PsiIdentifier identifier = parameter.getNameIdentifier();
            if (identifier == null || !identifier.isPhysical()) continue;
            result.add(ParameterCanBeLocalInspection.createProblem(manager, identifier, isOnTheFly));
        }
        return result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    private static ProblemDescriptor createProblem(@NotNull InspectionManager manager, @NotNull PsiIdentifier identifier, boolean isOnTheFly) {
        if (manager == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(2);
        }
        if (identifier == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(3);
        }
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)identifier, JavaBundle.message((String)"inspection.parameter.can.be.local.problem.descriptor", (Object[])new Object[0]), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{new ConvertParameterToLocalQuickFix()});
        if (problemDescriptor == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(4);
        }
        return problemDescriptor;
    }

    @NotNull
    private static List<PsiParameter> filterFinal(PsiParameter[] parameters) {
        List list = ContainerUtil.filter((Object[])parameters, parameter -> !parameter.hasModifierProperty("final"));
        if (list == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static Collection<PsiParameter> getWriteBeforeRead(@NotNull Collection<? extends PsiParameter> parameters, @NotNull PsiCodeBlock body) {
        ControlFlow controlFlow;
        if (parameters == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(6);
        }
        if (body == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(7);
        }
        if ((controlFlow = ParameterCanBeLocalInspection.getControlFlow((PsiElement)body)) == null) {
            return Collections.emptyList();
        }
        Set<PsiParameter> result = ParameterCanBeLocalInspection.filterParameters(controlFlow, parameters);
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        result.retainAll(ControlFlowUtil.getWrittenVariables((ControlFlow)controlFlow, (int)0, (int)controlFlow.getSize(), (boolean)false));
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        for (PsiReferenceExpression readBeforeWrite : ControlFlowUtil.getReadBeforeWrite((ControlFlow)controlFlow)) {
            PsiElement psiElement = readBeforeWrite.resolve();
            if (!(psiElement instanceof PsiParameter)) continue;
            PsiParameter param = (PsiParameter)psiElement;
            result.remove(param);
        }
        return result;
    }

    private static Set<PsiParameter> filterParameters(@NotNull ControlFlow controlFlow, @NotNull Collection<? extends PsiParameter> parameters) {
        if (controlFlow == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(8);
        }
        if (parameters == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(9);
        }
        HashSet usedVars = new HashSet(ControlFlowUtil.getUsedVariables((ControlFlow)controlFlow, (int)0, (int)controlFlow.getSize()));
        return parameters.stream().filter(usedVars::contains).collect(Collectors.toSet());
    }

    private static boolean isOverrides(PsiMethod method) {
        return SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
    }

    @Nullable
    private static ControlFlow getControlFlow(PsiElement context) {
        try {
            return ControlFlowFactory.getInstance((Project)context.getProject()).getControlFlow(context, (ControlFlowPolicy)LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFinal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProblem";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWriteBeforeRead";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class ConvertParameterToLocalQuickFix
    implements LocalQuickFix {
        private static final Logger LOG = Logger.getInstance(ConvertParameterToLocalQuickFix.class);

        private ConvertParameterToLocalQuickFix() {
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(0);
            }
            if (previewDescriptor == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(1);
            }
            this.applyFix(project, previewDescriptor);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(2);
            }
            return intentionPreviewInfo;
        }

        @NotNull
        private static List<PsiElement> moveDeclaration(@NotNull Project project, @NotNull PsiParameter variable) {
            List references;
            if (project == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(3);
            }
            if (variable == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(4);
            }
            if ((references = VariableAccessUtils.getVariableReferences((PsiVariable)variable)).isEmpty()) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    ConvertParameterToLocalQuickFix.$$$reportNull$$$0(5);
                }
                return list;
            }
            PsiElement scope = variable.getDeclarationScope();
            if (!(scope instanceof PsiMethod)) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    ConvertParameterToLocalQuickFix.$$$reportNull$$$0(6);
                }
                return list;
            }
            PsiMethod method = (PsiMethod)scope;
            if (!IntentionPreviewUtils.prepareElementForWrite((PsiElement)method)) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    ConvertParameterToLocalQuickFix.$$$reportNull$$$0(7);
                }
                return list;
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            ArrayList<ParameterInfoImpl> info = new ArrayList<ParameterInfoImpl>();
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter psiParameter = parameters[i];
                if (psiParameter == variable) continue;
                info.add(ParameterInfoImpl.create((int)i).withName(psiParameter.getName()).withType(psiParameter.getType()));
            }
            ParameterInfoImpl[] newParams = info.toArray(new ParameterInfoImpl[0]);
            String visibilityModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
            PsiElement moved = (PsiElement)IntentionPreviewUtils.writeAndCompute(() -> ConvertToLocalUtils.copyVariableToMethodBody((PsiVariable)variable, references, block -> variable.getName()));
            if (moved == null) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    ConvertParameterToLocalQuickFix.$$$reportNull$$$0(8);
                }
                return list;
            }
            SmartPsiElementPointer newDeclaration = SmartPointerManager.createPointer((PsiElement)moved);
            if (IntentionPreviewUtils.isPreviewElement((PsiElement)variable)) {
                variable.delete();
            } else {
                ChangeSignatureRefactoring processor = JavaRefactoringFactory.getInstance((Project)project).createChangeSignatureProcessor(method, false, visibilityModifier, method.getName(), method.getReturnType(), (ParameterInfo[])newParams, null, null, null, null);
                processor.run();
            }
            List<PsiElement> list = Collections.singletonList(Objects.requireNonNull(newDeclaration.getElement()));
            if (list == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(9);
            }
            return list;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.convert.to.local.quickfix", (Object[])new Object[0]);
            if (string == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(10);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiParameter variable;
            if (project == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(11);
            }
            if (descriptor == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(12);
            }
            if ((variable = (PsiParameter)descriptor.getPsiElement().getParent()) == null || !variable.isValid()) {
                return;
            }
            if (!IntentionPreviewUtils.prepareElementForWrite((PsiElement)descriptor.getPsiElement())) {
                return;
            }
            PsiFile myFile = variable.getContainingFile();
            try {
                List<PsiElement> newDeclarations = ConvertParameterToLocalQuickFix.moveDeclaration(project, variable);
                if (newDeclarations.isEmpty()) {
                    return;
                }
                ConvertParameterToLocalQuickFix.positionCaretToDeclaration(project, myFile, newDeclarations.getLast());
                newDeclarations.forEach(declaration -> IntentionPreviewUtils.write(() -> ConvertToLocalUtils.inlineRedundant(declaration)));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static void positionCaretToDeclaration(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement declaration) {
            PsiFile openedFile;
            if (project == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(13);
            }
            if (psiFile == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(14);
            }
            if (declaration == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(15);
            }
            if (!psiFile.isPhysical()) {
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor != null && (IJSwingUtilities.hasFocus((Component)editor.getComponent()) || ApplicationManager.getApplication().isUnitTestMode()) && (openedFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) == psiFile) {
                editor.getCaretModel().moveToOffset(declaration.getTextOffset());
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 6, 7, 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "moveDeclaration";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "moveDeclaration";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "positionCaretToDeclaration";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
            };
        }
    }
}

