/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.transformer;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.transformer.IrConstEvaluationContext;
import org.jetbrains.kotlin.ir.interpreter.transformer.IrConstExpressionTransformer;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstOnlyNecessaryTransformer;", "Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstExpressionTransformer;", "context", "Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstEvaluationContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstEvaluationContext;)V", "jsCodeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "visitCall", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstExpressionTransformer$Data;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitField", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "ir.interpreter"})
public final class IrConstOnlyNecessaryTransformer
extends IrConstExpressionTransformer {
    @NotNull
    private final FqName jsCodeFqName;

    public IrConstOnlyNecessaryTransformer(@NotNull IrConstEvaluationContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        this.jsCodeFqName = JsStandardClassIds.Callables.JsCode.asSingleFqName();
    }

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression, @NotNull IrConstExpressionTransformer.Data data) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean isJsCodeCall = Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(expression.getSymbol().getOwner()), (Object)this.jsCodeFqName);
        if (isJsCodeCall) {
            expression.transformChildren(this, IrConstExpressionTransformer.Data.copy$default(data, true, false, 2, null));
            return expression;
        }
        boolean isConstGetter = UtilsKt.isConst(UtilsKt.getProperty(expression.getSymbol().getOwner()));
        if (data.mustEvaluate() || isConstGetter) {
            return super.visitCall(expression, IrConstExpressionTransformer.Data.copy$default(data, true, false, 2, null));
        }
        expression.transformChildren(this, data);
        return expression;
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression, @NotNull IrConstExpressionTransformer.Data data) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean isConst = UtilsKt.isConst(UtilsKt.getProperty((IrField)expression.getSymbol().getOwner()));
        if (data.mustEvaluate() || isConst) {
            return super.visitGetField(expression, IrConstExpressionTransformer.Data.copy$default(data, true, false, 2, null));
        }
        expression.transformChildren(this, data);
        return expression;
    }

    @Override
    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression, @NotNull IrConstExpressionTransformer.Data data) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.mustEvaluate()) {
            return super.visitStringConcatenation(expression, IrConstExpressionTransformer.Data.copy$default(data, true, false, 2, null));
        }
        expression.transformChildren(this, data);
        return expression;
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration, @NotNull IrConstExpressionTransformer.Data data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean isConst = UtilsKt.isConst(UtilsKt.getProperty(declaration));
        if (isConst) {
            return super.visitField(declaration, IrConstExpressionTransformer.Data.copy$default(data, true, false, 2, null));
        }
        declaration.transformChildren(this, data);
        return declaration;
    }
}

