/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.ContextKey;
import com.intellij.kubernetes.api.ContextsConfiguration;
import com.intellij.kubernetes.api.KubeConfigEntity;
import com.intellij.kubernetes.api.KubeConfigEx;
import com.intellij.kubernetes.api.KubeConfigFileHandlerKt;
import com.intellij.kubernetes.api.KubeConfigUtilsKt;
import com.intellij.kubernetes.api.KubernetesApiProviderKt;
import com.intellij.kubernetes.api.KubernetesConflictingContextEntitiesFoundException;
import com.intellij.kubernetes.api.KubernetesContextNotFoundException;
import com.intellij.kubernetes.api.KubernetesContextsConfigurationKt;
import com.intellij.kubernetes.api.KubernetesContextsConfigurationModelKt;
import com.intellij.kubernetes.api.KubernetesContextsNameResolvingException;
import com.intellij.kubernetes.api.KubernetesIllegalKindException;
import com.intellij.kubernetes.api.KubernetesKubeConfigParsingException;
import com.intellij.kubernetes.api.settings.KubeConfigPathProvider;
import com.intellij.kubernetes.splitApi.KubernetesApiProviderProxy;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import fleet.util.logging.BaseLogger;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import io.kubernetes.client.util.KubeConfig;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a,\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u00050\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007\u001a%\u0010\u000b\u001a\u00020\u00042\u000e\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0003\u001a2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0087@\u00a2\u0006\u0002\u0010\u0019\u001a\u001e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0087@\u00a2\u0006\u0002\u0010\u001c\u001a\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\nH\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"LOG", "Lfleet/util/logging/KLogger;", "readConfiguration", "Lkotlin/Pair;", "Lcom/intellij/kubernetes/api/ContextsConfiguration;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "kubeConfigFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "parseKubeConfiguration", "configuration", "", "kubeConfigUrl", "", "Lorg/jetbrains/annotations/NonNls;", "mergeKubeConfigFile", "", "Lcom/intellij/kubernetes/api/Context;", "project", "Lcom/intellij/openapi/project/Project;", "contexts", "kubeConfig", "Lio/kubernetes/client/util/KubeConfig;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lio/kubernetes/client/util/KubeConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkConfiguration", "file", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseAndValidateKubeConfiguration", "kubeConfigFile", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesContextsConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesContextsConfiguration.kt\ncom/intellij/kubernetes/api/KubernetesContextsConfigurationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 7 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,300:1\n1642#2,10:301\n1915#2:311\n1916#2:313\n1652#2:314\n1586#2:315\n1661#2,3:316\n1849#2,3:319\n1586#2:322\n1661#2,3:323\n1512#2:326\n1538#2,3:327\n1541#2,3:337\n1586#2:349\n1661#2,3:350\n1849#2,3:353\n1586#2:361\n1661#2,3:362\n1786#2,3:365\n1915#2,2:369\n1#3:312\n1#3:359\n383#4,7:330\n540#4:340\n525#4,6:341\n540#4:371\n525#4,6:372\n540#4:378\n525#4,6:379\n221#5,2:347\n129#5:356\n158#5,2:357\n160#5:360\n18#6:368\n18#6:385\n18#7:386\n*S KotlinDebug\n*F\n+ 1 KubernetesContextsConfiguration.kt\ncom/intellij/kubernetes/api/KubernetesContextsConfigurationKt\n*L\n32#1:301,10\n32#1:311\n32#1:313\n32#1:314\n42#1:315\n42#1:316,3\n42#1:319,3\n44#1:322\n44#1:323,3\n44#1:326\n44#1:327,3\n44#1:337,3\n50#1:349\n50#1:350,3\n50#1:353,3\n102#1:361\n102#1:362,3\n103#1:365,3\n182#1:369,2\n32#1:312\n44#1:330,7\n44#1:340\n44#1:341,6\n188#1:371\n188#1:372,6\n195#1:378\n195#1:379,6\n44#1:347,2\n82#1:356\n82#1:357,2\n82#1:360\n200#1:368\n198#1:385\n24#1:386\n*E\n"})
public final class KubernetesContextsConfigurationKt {
    @NotNull
    private static final KLogger LOG;

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final Pair<ContextsConfiguration, List<Exception>> readConfiguration(@NotNull Set<? extends VirtualFile> kubeConfigFiles) {
        void $this$fold$iv;
        void initial$iv;
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Map $this$filter$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$mapTo$iv$iv2;
        ContextsConfiguration acc;
        void var7_18;
        Object element$iv222;
        void $this$fold$iv2;
        Object it;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Object it2;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(kubeConfigFiles, (String)"kubeConfigFiles");
        List exceptions = new ArrayList();
        Iterable $this$mapNotNull$iv = kubeConfigFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<ContextsConfiguration> destination$iv$iv = new ArrayList();
        boolean bl = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ContextsConfiguration it$iv$iv;
            ContextsConfiguration contextsConfiguration;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            it2 = (VirtualFile)element$iv$iv;
            boolean bl22 = false;
            try {
                contextsConfiguration = KubernetesContextsConfigurationKt.parseAndValidateKubeConfiguration(it2);
            }
            catch (Exception e) {
                if (e instanceof CancellationException) {
                    throw e;
                }
                exceptions.add(e);
                contextsConfiguration = null;
            }
            if (contextsConfiguration == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List kubeConfigs = (List)destination$iv$iv;
        Iterable $this$map$iv = kubeConfigs;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            element$iv$iv$iv = (ContextsConfiguration)item$iv$iv;
            collection = collection2;
            boolean bl3 = false;
            collection.add(((ContextsConfiguration)it).getKubeConfig());
        }
        $this$map$iv = (List)collection2;
        KubeConfigEx initial$iv2 = new KubeConfigEx(null, null, null, 7, null);
        boolean $i$f$fold232 = false;
        KubeConfigEx kubeConfigEx = initial$iv2;
        for (Object element$iv222 : $this$fold$iv2) {
            void kubeConfig;
            Object item$iv$iv;
            item$iv$iv = (KubeConfigEx)((Object)element$iv222);
            acc = var7_18;
            boolean bl4 = false;
            KubeConfigEx kubeConfigEx2 = KubernetesContextsConfigurationModelKt.plus((KubeConfig)acc, (KubeConfig)kubeConfig);
        }
        void globalConfig = var7_18;
        $this$map$iv = kubeConfigs;
        $i$f$map = false;
        Iterable $i$f$fold232 = $this$map$iv;
        Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            acc = (ContextsConfiguration)item$iv$iv;
            collection = collection3;
            boolean bl5 = false;
            collection.add(CollectionsKt.toList((Iterable)((ContextsConfiguration)it).getContexts().keySet()));
        }
        Object $this$groupBy$iv = CollectionsKt.flatten((Iterable)((List)collection3));
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv2 = $this$groupBy$iv;
        Map map2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            it = (ContextKey)((Object)element$iv$iv);
            boolean bl6 = false;
            ContextKey key$iv$iv = it;
            it2 = map2;
            ContextKey key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = map2;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        Map map3 = new LinkedHashMap();
        boolean $i$f$filterTo22 = false;
        element$iv222 = $this$filterTo$iv$iv.entrySet().iterator();
        while (element$iv222.hasNext()) {
            Object element$iv$iv;
            it = element$iv$iv = (Map.Entry)element$iv222.next();
            boolean bl7 = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            map3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = map3;
        boolean $i$f$forEach2 = false;
        $this$filterTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Map.Entry entry;
            Map.Entry $i$f$filterTo22 = entry = $this$filterTo$iv$iv.next();
            boolean bl8 = false;
            ContextKey key = (ContextKey)((Object)$i$f$filterTo22.getKey());
            List values = (List)$i$f$filterTo22.getValue();
            BaseLogger baseLogger = (BaseLogger)LOG;
            String string = key.getName();
            String string2 = ((ContextKey)((Object)CollectionsKt.first((List)values))).getConfigFileUrl();
            Intrinsics.checkNotNull((Object)string2);
            String string3 = ((ContextKey)((Object)CollectionsKt.last((List)values))).getConfigFileUrl();
            Intrinsics.checkNotNull((Object)string3);
            BaseLogger.error$default((BaseLogger)baseLogger, (Throwable)new KubernetesConflictingContextEntitiesFoundException(string, string2, string3, KubeConfigEntity.Contexts.getSingularKey()), null, (int)2, null);
        }
        Iterable $this$map$iv2 = kubeConfigs;
        boolean $i$f$map232 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : iterable2) {
            void it3;
            ContextsConfiguration bl7 = (ContextsConfiguration)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl5 = false;
            collection.add(it3.getContexts());
        }
        $this$map$iv2 = (List)destination$iv$iv3;
        Map $i$f$map232 = MapsKt.emptyMap();
        boolean bl9 = false;
        Map accumulator$iv2 = initial$iv;
        for (Object element$iv4 : $this$fold$iv) {
            void contexts;
            Object item$iv$iv;
            item$iv$iv = (Map)element$iv4;
            void acc2 = accumulator$iv2;
            boolean bl10 = false;
            accumulator$iv2 = MapsKt.plus((Map)acc2, (Map)contexts);
        }
        void allContexts = accumulator$iv2;
        return TuplesKt.to((Object)new ContextsConfiguration((Map<ContextKey, Context>)allContexts, (KubeConfigEx)globalConfig), (Object)exceptions);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    private static final ContextsConfiguration parseKubeConfiguration(Map<?, ?> configuration, String kubeConfigUrl) {
        KubeConfigEx kubeConfigEx;
        Iterator $this$mapTo$iv$iv;
        Object contextName;
        Collection collection;
        Object object;
        void $this$mapTo$iv$iv2;
        Map<String, Map<Object, Object>> map2;
        List<Object> clustersList = KubeConfigUtilsKt.getAsListSafely(configuration, KubeConfigEntity.Clusters);
        List<Object> contextsList = KubeConfigUtilsKt.getAsListSafely(configuration, KubeConfigEntity.Contexts);
        List<Object> usersList = KubeConfigUtilsKt.getAsListSafely(configuration, KubeConfigEntity.Users);
        Map clusterServers = new LinkedHashMap();
        for (Object clusterNode : clustersList) {
            String clusterName;
            String clusterServer;
            Map<Object, Object> clusterDefinition;
            Map<Object, Object> clusterMap = KubeConfigUtilsKt.asMapSafely(clusterNode);
            if (KubeConfigUtilsKt.getAsNonBlankStringSafely(clusterMap, "name") == null || KubeConfigUtilsKt.getAsNonBlankStringSafely(clusterDefinition = KubeConfigUtilsKt.getAsMapSafely(clusterMap, KubeConfigEntity.Clusters), "server") == null) continue;
            Map map3 = clusterServers;
            if (KubernetesApiProviderKt.toPath(clusterServer) == null) continue;
            map3.put(clusterName, map2);
        }
        String kind = KubeConfigUtilsKt.getAsNonBlankStringSafely(configuration, "kind");
        if (!Intrinsics.areEqual((Object)kind, (Object)"Config")) {
            throw new KubernetesIllegalKindException(kind, kubeConfigUrl);
        }
        Map<String, Map<Object, Object>> clusterDefinitions = KubeConfigUtilsKt.associateByName(configuration, KubeConfigEntity.Clusters);
        Map<String, Map<Object, Object>> contextDefinitions = KubeConfigUtilsKt.associateByName(configuration, KubeConfigEntity.Contexts);
        Map<String, Map<Object, Object>> userDefinitions = KubeConfigUtilsKt.associateByName(configuration, KubeConfigEntity.Users);
        Map<String, Map<Object, Object>> $this$map$iv = contextDefinitions;
        boolean $i$f$map = false;
        map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo22 = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv2.entrySet()) {
            Map<Object, Object> map4;
            Map<Object, Object> clusterDefinition;
            object = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            contextName = (String)object.getKey();
            Map contextDefinition = (Map)object.getValue();
            String string = KubeConfigUtilsKt.getAsNonBlankStringSafely(contextDefinition, KubeConfigEntity.Clusters.getSingularKey());
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                v0 = clusterDefinitions.get(it);
            } else {
                v0 = clusterDefinition = null;
            }
            if (KubeConfigUtilsKt.getAsNonBlankStringSafely(contextDefinition, KubeConfigEntity.Users.getSingularKey()) != null) {
                String it;
                boolean bl3 = false;
                map4 = userDefinitions.get(it);
            } else {
                map4 = null;
            }
            Map<Object, Object> userDefinition = map4;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)KubeConfigEntity.Clusters), clusterDefinition), TuplesKt.to((Object)((Object)KubeConfigEntity.Contexts), (Object)contextDefinition), TuplesKt.to((Object)((Object)KubeConfigEntity.Users), userDefinition)};
            Map definitions = MapsKt.mapOf((Pair[])pairArray);
            collection.add(TuplesKt.to((Object)((Object)new ContextKey((String)contextName, kubeConfigUrl)), (Object)new Context((String)contextName, kubeConfigUrl, new EnumMap<KubeConfigEntity, Map<Object, Object>>(definitions))));
        }
        Map existingContexts = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        String currentContextName = KubeConfigUtilsKt.getAsNonBlankStringSafely(configuration, "current-context");
        Iterable $this$map$iv2 = existingContexts.keySet();
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void it;
            Object item$iv$iv = object.next();
            contextName = (ContextKey)((Object)item$iv$iv);
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getName());
        }
        Set contextNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        if (currentContextName != null) {
            boolean bl;
            block13: {
                Iterable $this$all$iv = contextNames;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it = (String)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)currentContextName)) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            }
            if (bl) {
                throw new KubernetesContextNotFoundException(currentContextName, contextNames, kubeConfigUrl);
            }
        }
        KubeConfigEx $this$parseKubeConfiguration_u24lambda_u243 = kubeConfigEx = new KubeConfigEx(contextsList, clustersList, usersList);
        boolean bl = false;
        $this$parseKubeConfiguration_u24lambda_u243.setContext(currentContextName);
        $this$parseKubeConfiguration_u24lambda_u243.setPreferences(configuration.get("preferences"));
        $this$parseKubeConfiguration_u24lambda_u243.setFile(new File(kubeConfigUrl));
        KubeConfigEx kubeConfig = kubeConfigEx;
        return new ContextsConfiguration(existingContexts, kubeConfig);
    }

    /*
     * Unable to fully structure code
     */
    @ApiStatus.Internal
    @Nullable
    public static final Object mergeKubeConfigFile(@NotNull Project project, @NotNull Collection<Context> contexts, @NotNull KubeConfig kubeConfig, @NotNull Continuation<? super Collection<Context>> $completion) {
        block12: {
            block13: {
                if (!($completion instanceof mergeKubeConfigFile.1)) ** GOTO lbl-1000
                var9_4 = $completion;
                if ((var9_4.label & -2147483648) != 0) {
                    var9_4.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl($completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        int I$0;
                        /* synthetic */ Object result;
                        int label;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return KubernetesContextsConfigurationKt.mergeKubeConfigFile(null, null, null, (Continuation<? super Collection<Context>>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = VirtualFileManager.getInstance().findFileByNioPath(KubeConfigPathProvider.Companion.getDefaultKubeConfigFilePath());
                        if (v0 == null) break block12;
                        it = v0;
                        $i$a$-let-KubernetesContextsConfigurationKt$mergeKubeConfigFile$kubeConfigFile$1 = 0;
                        if (!(((CharSequence)VirtualFileUtil.readText((VirtualFile)it)).length() == 0)) break;
                        $continuation.L$0 = project;
                        $continuation.L$1 = contexts;
                        $continuation.L$2 = kubeConfig;
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)it);
                        $continuation.I$0 = $i$a$-let-KubernetesContextsConfigurationKt$mergeKubeConfigFile$kubeConfigFile$1;
                        $continuation.label = 1;
                        v1 = KubeConfigFileHandlerKt.fillEmptyConfigFileByDefaultConfig(it, KubernetesApiProviderProxy.Companion, (Continuation<? super VirtualFile>)$continuation);
                        if (v1 == var10_6) {
                            return var10_6;
                        }
                        ** GOTO lbl35
                    }
                    case 1: {
                        $i$a$-let-KubernetesContextsConfigurationKt$mergeKubeConfigFile$kubeConfigFile$1 = $continuation.I$0;
                        it = (VirtualFile)$continuation.L$3;
                        kubeConfig = (KubeConfig)$continuation.L$2;
                        contexts = (Collection)$continuation.L$1;
                        project = (Project)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl35:
                        // 2 sources

                        v2 = (VirtualFile)v1;
                        break block13;
                    }
                }
                v2 = it;
            }
            v0 = v2;
            if (v2 != null) ** GOTO lbl60
        }
        $continuation.L$0 = project;
        $continuation.L$1 = contexts;
        $continuation.L$2 = kubeConfig;
        $continuation.L$3 = null;
        $continuation.label = 2;
        v3 = KubeConfigFileHandlerKt.createEmptyConfig(KubeConfigPathProvider.Companion.getDefaultKubeConfigFilePath(), (Continuation<? super VirtualFile>)$continuation);
        if (v3 == var10_6) {
            return var10_6;
        }
        ** GOTO lbl58
        {
            case 2: {
                kubeConfig = (KubeConfig)$continuation.L$2;
                contexts = (Collection)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl58:
                // 2 sources

                if ((v0 = (VirtualFile)v3) == null) {
                    throw new IllegalStateException("Cannot create default kubeconfig file");
                }
lbl60:
                // 3 sources

                kubeConfigFile = v0;
                var5_13 = new ReadConstraint[]{ReadConstraint.Companion.withDocumentsCommitted(project)};
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)contexts);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)kubeConfig);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)kubeConfigFile);
                $continuation.label = 3;
                v4 = CoroutinesKt.constrainedReadAndWriteAction((ReadConstraint[])var5_13, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, mergeKubeConfigFile$lambda$1(com.intellij.openapi.vfs.VirtualFile io.kubernetes.client.util.KubeConfig java.util.Collection com.intellij.openapi.application.ReadAndWriteScope ), (Lcom/intellij/openapi/application/ReadAndWriteScope;)Lcom/intellij/openapi/application/ReadResult;)((VirtualFile)kubeConfigFile, (KubeConfig)kubeConfig, (Collection)contexts), (Continuation)$continuation);
                if (v4 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl78
            }
            case 3: {
                kubeConfigFile = (VirtualFile)$continuation.L$3;
                kubeConfig = (KubeConfig)$continuation.L$2;
                contexts = (Collection)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl78:
                // 2 sources

                return v4;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @ApiStatus.Internal
    @Nullable
    public static final Object checkConfiguration(@NotNull VirtualFile file, @NotNull Project project, @NotNull Continuation<? super ContextsConfiguration> $completion) {
        ReadConstraint[] readConstraintArray = new ReadConstraint[]{ReadConstraint.Companion.withDocumentsCommitted(project)};
        return CoroutinesKt.constrainedReadAction((ReadConstraint[])readConstraintArray, () -> KubernetesContextsConfigurationKt.checkConfiguration$lambda$0(file), $completion);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    private static final ContextsConfiguration parseAndValidateKubeConfiguration(VirtualFile kubeConfigFile) {
        ContextsConfiguration contextsConfiguration;
        try {
            Map map2 = KubeConfigFileHandlerKt.loadConfiguration$default(kubeConfigFile, null, 2, null);
            String string = kubeConfigFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            contextsConfiguration = KubernetesContextsConfigurationKt.parseKubeConfiguration(map2, string);
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof CancellationException) {
                throw e;
            }
            if (exception instanceof KubernetesContextNotFoundException) {
                throw e;
            }
            if (exception instanceof KubernetesIllegalKindException) {
                throw e;
            }
            if (exception instanceof KubernetesContextsNameResolvingException) {
                throw e;
            }
            String string = kubeConfigFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            throw new KubernetesKubeConfigParsingException(string, e);
        }
        return contextsConfiguration;
    }

    private static final void mergeKubeConfigFile$lambda$1$updateConfiguration(Map<Object, Object> configuration, Collection<Context> $contexts, VirtualFile kubeConfigFile, KubeConfigEntity entity) {
        Map<String, Map<Object, Object>> entityDefinitions = KubeConfigUtilsKt.associateByName(configuration, entity);
        List<Object> entityNodes = KubeConfigUtilsKt.getAsListSafely(configuration, entity);
        for (Context context : $contexts) {
            String string = switch (WhenMappings.$EnumSwitchMapping$0[entity.ordinal()]) {
                case 1 -> {
                    Map<Object, Object> v0 = context.getDefinitions().get((Object)KubeConfigEntity.Contexts);
                    if (v0 != null) {
                        yield KubeConfigUtilsKt.getAsNonBlankStringSafely(v0, "cluster");
                    }
                    yield null;
                }
                case 2 -> context.getName();
                case 3 -> {
                    Map<Object, Object> v2 = context.getDefinitions().get((Object)KubeConfigEntity.Contexts);
                    if (v2 != null) {
                        yield KubeConfigUtilsKt.getAsNonBlankStringSafely(v2, "user");
                    }
                    yield null;
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            if (string == null) {
                String string2 = context.getName();
                String string3 = kubeConfigFile.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getUrl(...)");
                throw new KubernetesContextsNameResolvingException(string2, string3, context.getKubeConfigUrl(), entity);
            }
            String entityNodeName = string;
            Map map2 = context.getDefinitions().getOrDefault((Object)entity, MapsKt.emptyMap());
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map newEntityDefinitions = MapsKt.toMutableMap(map2);
            Map<Object, Object> entityNodeMap = entityDefinitions.get(entityNodeName);
            if (entityNodeMap != null) {
                if (Intrinsics.areEqual(entityNodeMap, (Object)newEntityDefinitions) && entity != KubeConfigEntity.Contexts) continue;
                String string4 = kubeConfigFile.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getUrl(...)");
                throw new KubernetesConflictingContextEntitiesFoundException(entityNodeName, string4, context.getKubeConfigUrl(), entity.getSingularKey());
            }
            Map map3 = new LinkedHashMap();
            if (entity == KubeConfigEntity.Users) {
                map3.put("name", entityNodeName);
            }
            map3.put(entity.getSingularKey(), newEntityDefinitions);
            if (entity == KubeConfigEntity.Contexts || entity == KubeConfigEntity.Clusters) {
                map3.put("name", entityNodeName);
            }
            ((Collection)entityNodes).add(map3);
        }
    }

    private static final Object mergeKubeConfigFile$lambda$1$2(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object $this$asSafely$iv = it;
        boolean $i$f$asSafely = false;
        Object object = $this$asSafely$iv;
        if (!(object instanceof Map)) {
            object = null;
        }
        Map map2 = (Map)object;
        return map2 != null ? map2.get("name") : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Collection mergeKubeConfigFile$lambda$1$4(VirtualFile $kubeConfigFile, ReadAndWriteScope $this_constrainedReadAndWriteAction, ContextsConfiguration $contextsConfiguration, Yaml $yaml, Map $configuration) {
        Closeable closeable = $kubeConfigFile.getOutputStream((Object)$this_constrainedReadAndWriteAction);
        Throwable throwable = null;
        try {
            OutputStream stream = (OutputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)stream);
            Closeable closeable2 = stream;
            Object object = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter((OutputStream)closeable2, (Charset)object);
            int n = 8192;
            closeable2 = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
            object = null;
            try {
                BufferedWriter writer2 = (BufferedWriter)closeable2;
                boolean bl2 = false;
                $yaml.dump((Object)$configuration, (Writer)writer2);
                writer = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return $contextsConfiguration.getContexts().values();
    }

    /*
     * WARNING - void declaration
     */
    private static final ReadResult mergeKubeConfigFile$lambda$1(VirtualFile $kubeConfigFile, KubeConfig $kubeConfig, Collection $contexts, ReadAndWriteScope $this$constrainedReadAndWriteAction) {
        Map<Object, Object> newPref;
        Intrinsics.checkNotNullParameter((Object)$this$constrainedReadAndWriteAction, (String)"$this$constrainedReadAndWriteAction");
        Yaml yaml = KubeConfigFileHandlerKt.createYaml();
        Map configuration = MapsKt.toMutableMap(KubeConfigFileHandlerKt.loadConfiguration($kubeConfigFile, yaml));
        Iterable $this$forEach$iv = (Iterable)KubeConfigEntity.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KubeConfigEntity it = (KubeConfigEntity)((Object)element$iv);
            boolean bl = false;
            KubernetesContextsConfigurationKt.mergeKubeConfigFile$lambda$1$updateConfiguration(configuration, $contexts, $kubeConfigFile, it);
        }
        Map<Object, Object> preferences = KubeConfigUtilsKt.asMapSafely(configuration.get("preferences"));
        Object object = $kubeConfig.getPreferences();
        Map<Object, Object> map2 = newPref = object instanceof Map ? (Map<Object, Object>)object : null;
        if (map2 != null) {
            void $this$filterTo$iv$iv;
            Object object2;
            void $this$filterTo$iv$iv2;
            Map<Object, Object> it = map2;
            boolean bl = false;
            Map<Object, Object> $this$filter$iv = it;
            boolean $i$f$filter = false;
            Map<Object, Object> map3 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo22 = false;
            for (Map.Entry element$iv$iv : $this$filterTo$iv$iv2.entrySet()) {
                Object value2;
                object2 = element$iv$iv;
                boolean bl2 = false;
                Object key = object2.getKey();
                if (!(!Intrinsics.areEqual((Object)preferences.getOrDefault(key, value2 = object2.getValue()), value2))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map conflicts = destination$iv$iv;
            if (!conflicts.isEmpty()) {
                String string = CollectionsKt.joinToString$default((Iterable)conflicts.keySet(), null, null, null, (int)0, null, null, (int)63, null);
                String string2 = $kubeConfigFile.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
                ArrayList arrayList = $kubeConfig.getContexts();
                Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"getContexts(...)");
                throw new KubernetesConflictingContextEntitiesFoundException(string, string2, CollectionsKt.first((List)arrayList).toString(), "preferences");
            }
            $this$filter$iv = preferences;
            Map<Object, Object> $this$filter$iv2 = it;
            boolean $i$f$filter2 = false;
            Map<Object, Object> $i$f$filterTo22 = $this$filter$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            object2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (object2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = (Map.Entry)object2.next();
                boolean bl3 = false;
                Object key = entry.getKey();
                Object value3 = entry.getValue();
                if (!(key != null && value3 != null)) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv.putAll(destination$iv$iv2);
        }
        Object $this$asSafely$iv = configuration.get("current-context");
        boolean $i$f$asSafely = false;
        Object object3 = $this$asSafely$iv;
        if (!(object3 instanceof CharSequence)) {
            object3 = null;
        }
        if ((($this$asSafely$iv = (CharSequence)object3) == null || $this$asSafely$iv.length() == 0) && ($this$asSafely$iv = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)KubeConfigUtilsKt.getAsListSafely(configuration, KubeConfigEntity.Contexts)), KubernetesContextsConfigurationKt::mergeKubeConfigFile$lambda$1$2))) != null) {
            Object it = $this$asSafely$iv;
            boolean bl = false;
            configuration.put("current-context", it);
        }
        String string = $kubeConfigFile.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        ContextsConfiguration contextsConfiguration = KubernetesContextsConfigurationKt.parseKubeConfiguration(configuration, string);
        return $this$constrainedReadAndWriteAction.writeAction(() -> KubernetesContextsConfigurationKt.mergeKubeConfigFile$lambda$1$4($kubeConfigFile, $this$constrainedReadAndWriteAction, contextsConfiguration, yaml, configuration));
    }

    private static final ContextsConfiguration checkConfiguration$lambda$0(VirtualFile $file) {
        return KubernetesContextsConfigurationKt.parseAndValidateKubeConfiguration($file);
    }

    static {
        boolean $i$f$logger = false;
        LOG = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ContextsConfiguration.class));
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KubeConfigEntity.values().length];
            try {
                nArray[KubeConfigEntity.Clusters.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KubeConfigEntity.Contexts.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KubeConfigEntity.Users.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

