/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.mappers;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.mappers.KubernetesNamespacedResourceMapper;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapperKt;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressList;
import io.kubernetes.client.openapi.models.V1IngressLoadBalancerIngress;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1IngressServiceBackend;
import io.kubernetes.client.openapi.models.V1IngressSpec;
import io.kubernetes.client.openapi.models.V1IngressTLS;
import io.kubernetes.client.openapi.models.V1ServiceBackendPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/view/mappers/KubernetesIngressMapper;", "Lcom/intellij/kubernetes/view/mappers/KubernetesNamespacedResourceMapper;", "Lio/kubernetes/client/openapi/models/V1Ingress;", "Lio/kubernetes/client/openapi/models/V1IngressList;", "<init>", "()V", "getColumnDescriptors", "", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "getColumnDescriptorsForMultilineTable", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesIngressMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesIngressMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesIngressMapper\n+ 2 KubernetesResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n174#2,5:97\n174#2,5:102\n1642#3,10:107\n1915#3:117\n1916#3:119\n1652#3:120\n1642#3,10:121\n1915#3:131\n1916#3:133\n1652#3:134\n1586#3:135\n1661#3,3:136\n1586#3:139\n1661#3,3:140\n1915#3:143\n1915#3,2:144\n1916#3:146\n1#4:118\n1#4:132\n*S KotlinDebug\n*F\n+ 1 KubernetesIngressMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesIngressMapper\n*L\n14#1:97,5\n61#1:102,5\n19#1:107,10\n19#1:117\n19#1:119\n19#1:120\n32#1:121,10\n32#1:131\n32#1:133\n32#1:134\n37#1:135\n37#1:136,3\n53#1:139\n53#1:140,3\n75#1:143\n76#1:144,2\n75#1:146\n19#1:118\n32#1:132\n*E\n"})
public final class KubernetesIngressMapper
extends KubernetesNamespacedResourceMapper<V1Ingress, V1IngressList> {
    @NotNull
    public static final KubernetesIngressMapper INSTANCE = new KubernetesIngressMapper();

    private KubernetesIngressMapper() {
        super(KubernetesEntity.Ingress);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<KubernetesResourceMapper.ColumnDescriptor<V1Ingress, ?>> getColumnDescriptors(@NotNull KubernetesApiModelInterface apiModel2) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        KubernetesResourceMapper.ColumnDescriptor[] columnDescriptorArray = new KubernetesResourceMapper.ColumnDescriptor[6];
        columnDescriptorArray[0] = this.addNameField();
        columnDescriptorArray[1] = this.addNamespaceField(apiModel2);
        KubernetesResourceMapper.ColumnDescriptor.Companion companion = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string = KubernetesBundle.message("KubernetesIngressMapper.ingressClassField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Function1 getValue$iv = KubernetesIngressMapper::getColumnDescriptors$lambda$0;
        boolean $i$f$simple = false;
        columnDescriptorArray[2] = new KubernetesResourceMapper.ColumnDescriptor((String)name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
        columnDescriptorArray[3] = this.addLabelsField();
        String string3 = KubernetesBundle.message("KubernetesIngressMapper.endpointsField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        columnDescriptorArray[4] = this.addMultilineField(string3, KubernetesIngressMapper::getColumnDescriptors$lambda$1);
        columnDescriptorArray[5] = this.addAgeField();
        return CollectionsKt.listOfNotNull((Object[])columnDescriptorArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<KubernetesResourceMapper.ColumnDescriptor<V1Ingress, ?>> getColumnDescriptorsForMultilineTable(@NotNull KubernetesApiModelInterface apiModel2) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Collection collection = this.getColumnDescriptors(apiModel2);
        KubernetesResourceMapper.ColumnDescriptor[] columnDescriptorArray = new KubernetesResourceMapper.ColumnDescriptor[6];
        String string = KubernetesBundle.message("KubernetesPodMapper.annotationsField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        columnDescriptorArray[0] = this.addMultilineField(string, KubernetesIngressMapper::getColumnDescriptorsForMultilineTable$lambda$0);
        String string2 = KubernetesBundle.message("KubernetesIngressMapper.hostsField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        columnDescriptorArray[1] = this.addMultilineField(string2, KubernetesIngressMapper::getColumnDescriptorsForMultilineTable$lambda$1);
        String string3 = KubernetesBundle.message("KubernetesIngressMapper.rulesField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        columnDescriptorArray[2] = this.addMultilineField(string3, KubernetesIngressMapper::getColumnDescriptorsForMultilineTable$lambda$2);
        String string4 = KubernetesBundle.message("KubernetesIngressMapper.tlsField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        columnDescriptorArray[3] = this.addMultilineField(string4, KubernetesIngressMapper::getColumnDescriptorsForMultilineTable$lambda$3);
        KubernetesResourceMapper.ColumnDescriptor.Companion companion = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string5 = KubernetesBundle.message("KubernetesIngressMapper.defaultBackendField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        String string6 = string5;
        Function1 getValue$iv = KubernetesIngressMapper::getColumnDescriptorsForMultilineTable$lambda$4;
        boolean $i$f$simple = false;
        columnDescriptorArray[4] = new KubernetesResourceMapper.ColumnDescriptor((String)name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
        String string7 = KubernetesBundle.message("KubernetesIngressMapper.backendServicesField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        columnDescriptorArray[5] = this.addMultilineField(string7, KubernetesIngressMapper::getColumnDescriptorsForMultilineTable$lambda$5);
        return CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOfNotNull((Object[])columnDescriptorArray));
    }

    private static final String getColumnDescriptors$lambda$0(V1Ingress $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        V1IngressSpec v1IngressSpec = $this$simple.getSpec();
        return v1IngressSpec != null ? v1IngressSpec.getIngressClassName() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable getColumnDescriptors$lambda$1(V1Ingress $this$addMultilineField) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
        Object object = $this$addMultilineField.getStatus();
        if (object != null && (object = object.getLoadBalancer()) != null && (object = object.getIngress()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                V1IngressLoadBalancerIngress it = (V1IngressLoadBalancerIngress)element$iv$iv;
                boolean bl2 = false;
                String string = it.getIp();
                if (string == null) {
                    string = it.getHostname();
                }
                if (string == null) continue;
                String it$iv$iv = string;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    private static final CharSequence getColumnDescriptorsForMultilineTable$lambda$2$0$0(V1HTTPIngressPath path) {
        String string;
        String string2;
        Object servicePort;
        V1IngressServiceBackend v1IngressServiceBackend;
        Object object;
        Object serviceName;
        V1IngressBackend v1IngressBackend = path.getBackend();
        Object service = v1IngressBackend != null ? v1IngressBackend.getService() : null;
        Object object2 = service;
        if (object2 == null || (object2 = object2.getName()) == null) {
            object2 = serviceName = "unknown";
        }
        if (((object = service) == null || (object = object.getPort()) == null || (object = object.getNumber()) == null || (object = String.valueOf((Integer)object)) == null) && ((v1IngressServiceBackend = service) != null && (v1IngressServiceBackend = v1IngressServiceBackend.getPort()) != null ? v1IngressServiceBackend.getName() : (object = null)) == null) {
            object = servicePort = "unknown";
        }
        if ((string2 = path.getPath()) == null) {
            string2 = "/";
        }
        if ((string = path.getPathType()) == null) {
            string = "Prefix";
        }
        return string2 + " (" + string + ") -> " + (String)serviceName + ":" + (String)servicePort;
    }

    private static final Iterable getColumnDescriptorsForMultilineTable$lambda$0(V1Ingress $this$addMultilineField) {
        Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
        Object object = $this$addMultilineField.getMetadata();
        return object != null && (object = object.getAnnotations()) != null ? KubernetesResourceMapperKt.getIterable((Map<String, String>)object) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable getColumnDescriptorsForMultilineTable$lambda$1(V1Ingress $this$addMultilineField) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
        Object object = $this$addMultilineField.getSpec();
        if (object != null && (object = object.getRules()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                V1IngressRule it = (V1IngressRule)element$iv$iv;
                boolean bl2 = false;
                if (it.getHost() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable getColumnDescriptorsForMultilineTable$lambda$2(V1Ingress $this$addMultilineField) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
        Object object = $this$addMultilineField.getSpec();
        if (object != null && (object = object.getRules()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object2;
                String host;
                void rule;
                V1IngressRule v1IngressRule = (V1IngressRule)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = rule.getHost();
                if (string == null) {
                    string = host = "*";
                }
                if ((object2 = rule.getHttp()) == null || (object2 = object2.getPaths()) == null || (object2 = CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)"\n", null, null, (int)0, null, KubernetesIngressMapper::getColumnDescriptorsForMultilineTable$lambda$2$0$0, (int)30, null)) == null) {
                    object2 = "no paths";
                }
                Object paths = object2;
                collection.add(host + ":\n " + (String)paths);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable getColumnDescriptorsForMultilineTable$lambda$3(V1Ingress $this$addMultilineField) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
        Object object = $this$addMultilineField.getSpec();
        if (object != null && (object = object.getTls()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                Object hosts;
                void tls;
                V1IngressTLS v1IngressTLS = (V1IngressTLS)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object2 = tls.getHosts();
                if (object2 == null || (object2 = CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)) == null) {
                    object2 = hosts = "all hosts";
                }
                if ((string = tls.getSecretName()) == null) {
                    string = "no secret";
                }
                String secretName = string;
                collection.add((String)hosts + " (secret: " + secretName + ")");
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    private static final String getColumnDescriptorsForMultilineTable$lambda$4(V1Ingress $this$simple) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        V1IngressSpec v1IngressSpec = $this$simple.getSpec();
        if (v1IngressSpec != null && (v1IngressSpec = v1IngressSpec.getDefaultBackend()) != null) {
            V1IngressServiceBackend v1IngressServiceBackend;
            Object object;
            Object serviceName;
            V1IngressSpec backend = v1IngressSpec;
            boolean bl = false;
            V1IngressServiceBackend service = backend.getService();
            Object object2 = service;
            if (object2 == null || (object2 = object2.getName()) == null) {
                object2 = serviceName = "unknown";
            }
            if (((object = service) == null || (object = object.getPort()) == null || (object = object.getNumber()) == null || (object = String.valueOf((Integer)object)) == null) && ((v1IngressServiceBackend = service) != null && (v1IngressServiceBackend = v1IngressServiceBackend.getPort()) != null ? v1IngressServiceBackend.getName() : (object = null)) == null) {
                object = "unknown";
            }
            Object servicePort = object;
            string = (String)serviceName + ":" + (String)servicePort;
        } else {
            string = null;
        }
        return string;
    }

    private static final Iterable getColumnDescriptorsForMultilineTable$lambda$5(V1Ingress $this$addMultilineField) {
        Set services2;
        block6: {
            Object servicePort;
            V1IngressSpec v1IngressSpec;
            Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
            services2 = new LinkedHashSet();
            Object object = $this$addMultilineField.getSpec();
            if (object != null && (object = object.getRules()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    V1IngressRule rule = (V1IngressRule)element$iv;
                    boolean bl = false;
                    Object object2 = rule.getHttp();
                    if (object2 == null || (object2 = object2.getPaths()) == null) continue;
                    Iterable $this$forEach$iv2 = (Iterable)object2;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Object servicePort2;
                        V1IngressServiceBackend service;
                        V1HTTPIngressPath path = (V1HTTPIngressPath)element$iv2;
                        boolean bl2 = false;
                        V1IngressBackend v1IngressBackend = path.getBackend();
                        V1IngressServiceBackend v1IngressServiceBackend = service = v1IngressBackend != null ? v1IngressBackend.getService() : null;
                        String serviceName = v1IngressServiceBackend != null ? v1IngressServiceBackend.getName() : null;
                        Object object3 = service;
                        if (object3 == null || (object3 = object3.getPort()) == null || (object3 = object3.getNumber()) == null || (object3 = String.valueOf((Integer)object3)) == null) {
                            V1IngressServiceBackend v1IngressServiceBackend2 = service;
                            object3 = v1IngressServiceBackend2 != null && (v1IngressServiceBackend2 = v1IngressServiceBackend2.getPort()) != null ? v1IngressServiceBackend2.getName() : (servicePort2 = null);
                        }
                        if (serviceName == null || servicePort2 == null) continue;
                        services2.add(serviceName + ":" + (String)servicePort2);
                    }
                }
            }
            if ((v1IngressSpec = $this$addMultilineField.getSpec()) == null || (v1IngressSpec = v1IngressSpec.getDefaultBackend()) == null || (v1IngressSpec = v1IngressSpec.getService()) == null) break block6;
            V1IngressSpec service = v1IngressSpec;
            boolean bl = false;
            String serviceName = service.getName();
            Object object4 = service.getPort();
            if (object4 == null || (object4 = object4.getNumber()) == null || (object4 = String.valueOf((Integer)object4)) == null) {
                V1ServiceBackendPort v1ServiceBackendPort = service.getPort();
                object4 = servicePort = v1ServiceBackendPort != null ? v1ServiceBackendPort.getName() : null;
            }
            if (serviceName != null && servicePort != null) {
                services2.add(serviceName + ":" + (String)servicePort + " (default)");
            }
        }
        return CollectionsKt.toList((Iterable)services2);
    }
}

