/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.ui.actions.ActionUtilsKt;
import com.intellij.kubernetes.view.ui.actions.Navigator;
import com.intellij.kubernetes.view.ui.actions.OpenKubeConfigAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "openKubeConfigActionPerformed", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/kubernetes/api/Context;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nOpenKubeConfigAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenKubeConfigAction.kt\ncom/intellij/kubernetes/view/ui/actions/OpenKubeConfigActionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,101:1\n1#2:102\n30#3,2:103\n1068#4:105\n13#5:106\n*S KotlinDebug\n*F\n+ 1 OpenKubeConfigAction.kt\ncom/intellij/kubernetes/view/ui/actions/OpenKubeConfigActionKt\n*L\n56#1:103,2\n65#1:105\n28#1:106\n*E\n"})
public final class OpenKubeConfigActionKt {
    @NotNull
    private static final Logger LOG;

    public static final void openKubeConfigActionPerformed(@NotNull Project project, @NotNull Context context) {
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT().log(project, "open-kube-config");
                KubernetesApiModel apiModel2 = ActionUtilsKt.getBackendApiModel(project, context);
                object = apiModel2;
                if (object == null || (object = ((KubernetesApiModel)object).getCurrentContextObject()) == null || (object = ((Context)object).getKubeConfigFile()) == null) break block5;
                Object it = object;
                boolean bl = false;
                Set set = SetsKt.setOf((Object)it);
                object = set;
                if (set != null) break block6;
            }
            return;
        }
        Object configPaths = object;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<Navigator> serviceClass$iv = Navigator.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Navigator navigator = (Navigator)object2;
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.singleOrNull((Iterable)((Iterable)configPaths));
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            navigator.scheduleNavigateTo(it);
            return;
        }
        String string = KubernetesBundle.message("action.Kubernetes.OpenKubeConfig.text", new Object[0]);
        Iterable $this$sortedBy$iv = (Iterable)configPaths;
        boolean $i$f$sortedBy = false;
        List list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                VirtualFile it = (VirtualFile)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getPresentableUrl());
                it = (VirtualFile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPresentableUrl())));
            }
        });
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<VirtualFile>(navigator, string, (List<? extends VirtualFile>)list2){
            final /* synthetic */ Navigator $navigator;
            {
                this.$navigator = $navigator;
                super($super_call_param$1, $super_call_param$2);
            }

            public PopupStep<?> onChosen(VirtualFile file, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.$navigator.scheduleNavigateTo(file);
                return BaseListPopupStep.FINAL_CHOICE;
            }

            public String getTextFor(VirtualFile value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                String string = value2.getPresentableUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableUrl(...)");
                return string;
            }
        }, 3).showInFocusCenter();
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(OpenKubeConfigAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

