/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.jspJava;

import com.intellij.jsp.jspJava.JspxImportStatementImpl;
import com.intellij.jsp.jspJava.JspxStaticImportStatement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JspxImportListAttribute {
    private static final Logger LOG = Logger.getInstance(JspxImportListAttribute.class);
    private final XmlAttribute myAttribute;
    private final PsiElement myContext;
    private final AtomicReference<List<JspxImportStatementImpl>> myImports;
    private volatile boolean[] myIsStaticImport;
    private volatile TextRange[] myImportStatementRanges;

    JspxImportListAttribute(@NotNull XmlAttribute attribute, @NotNull PsiElement context) {
        if (attribute == null) {
            JspxImportListAttribute.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JspxImportListAttribute.$$$reportNull$$$0(1);
        }
        this.myImports = new AtomicReference();
        this.myAttribute = attribute;
        this.myContext = context;
    }

    JspxImportStatementImpl @NotNull [] getAllImportStatements() {
        this.ensureRangesAreBuilt();
        List<JspxImportStatementImpl> imports = this.myImports.get();
        JspxImportStatementImpl[] jspxImportStatementImplArray = imports.toArray(new JspxImportStatementImpl[0]);
        if (jspxImportStatementImplArray == null) {
            JspxImportListAttribute.$$$reportNull$$$0(2);
        }
        return jspxImportStatementImplArray;
    }

    JspxImportStatementImpl @NotNull [] getImportStatements() {
        JspxImportStatementImpl[] statements = this.getAllImportStatements();
        JspxImportStatementImpl[] jspxImportStatementImplArray = ContainerUtil.filter((Object[])statements, s -> !(s instanceof JspxStaticImportStatement)).toArray(new JspxImportStatementImpl[0]);
        if (jspxImportStatementImplArray == null) {
            JspxImportListAttribute.$$$reportNull$$$0(3);
        }
        return jspxImportStatementImplArray;
    }

    JspxStaticImportStatement @NotNull [] getStaticImportStatements() {
        JspxImportStatementImpl[] statements = this.getAllImportStatements();
        JspxStaticImportStatement[] jspxStaticImportStatementArray = ContainerUtil.filter((Object[])statements, s -> s instanceof JspxStaticImportStatement).toArray(new JspxStaticImportStatement[0]);
        if (jspxStaticImportStatementArray == null) {
            JspxImportListAttribute.$$$reportNull$$$0(4);
        }
        return jspxStaticImportStatementArray;
    }

    private void ensureRangesAreBuilt() {
        TextRange[] importStatementRanges = this.myImportStatementRanges;
        boolean[] staticImport = this.myIsStaticImport;
        if (importStatementRanges != null && staticImport != null) {
            return;
        }
        String importList = this.getAttribute().getValue();
        if (importList == null) {
            this.myImportStatementRanges = TextRange.EMPTY_ARRAY;
            this.myIsStaticImport = ArrayUtilRt.EMPTY_BOOLEAN_ARRAY;
            this.myImports.compareAndSet(null, List.of());
            return;
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        BooleanArrayList isStatic = new BooleanArrayList();
        int start = 0;
        while (true) {
            int delim;
            if ((delim = importList.indexOf(44, start)) == -1) {
                delim = importList.length();
            }
            if (delim <= start) break;
            String importString = importList.substring(start, delim);
            String importClass = importString.trim();
            int trimOffset = importList.indexOf(importClass, start);
            @NonNls String staticPrefix = "static ";
            boolean isStaticImport = importClass.startsWith(staticPrefix);
            TextRange textRange = new TextRange(trimOffset, trimOffset + importClass.length());
            if (!textRange.isEmpty()) {
                ranges.add(textRange);
                isStatic.add(isStaticImport);
            }
            start = delim + 1;
        }
        List<JspxImportStatementImpl> imports = this.myImports.get();
        if (imports == null) {
            imports = new ArrayList<JspxImportStatementImpl>(ranges.size());
            int size = ranges.size();
            for (int i = 0; i < size; ++i) {
                TextRange range = (TextRange)ranges.get(i);
                imports.add(isStatic.getBoolean(i) ? new JspxStaticImportStatement(this.myContext, this, range) : new JspxImportStatementImpl(this.myContext, this, range));
            }
            this.myImports.compareAndSet(null, imports);
        }
        this.myImportStatementRanges = ranges.toArray(TextRange.EMPTY_ARRAY);
        this.myIsStaticImport = isStatic.toBooleanArray();
    }

    void add(PsiElement element) {
        String importText = JspxImportListAttribute.computeImportText(element);
        if (importText == null) {
            throw new IncorrectOperationException("Can't add to import statement: " + String.valueOf(element));
        }
        this.ensureRangesAreBuilt();
        TextRange[] ranges = this.myImportStatementRanges;
        int end = ranges[ranges.length - 1].getEndOffset();
        this.replacePartOfAttribute(new TextRange(end, end), ", " + importText);
        this.ensureRangesAreBuilt();
        ranges = this.myImportStatementRanges;
        this.myImports.get().add(element instanceof PsiImportStaticStatement ? new JspxStaticImportStatement(this.myContext, this, ranges[ranges.length - 1]) : new JspxImportStatementImpl(this.myContext, this, ranges[ranges.length - 1]));
    }

    void delete(int index) {
        this.ensureRangesAreBuilt();
        TextRange[] ranges = this.myImportStatementRanges;
        if (ranges.length > 1) {
            TextRange textRange = index > 0 ? new TextRange(ranges[index - 1].getEndOffset(), ranges[index].getEndOffset()) : new TextRange(0, ranges[index + 1].getStartOffset());
            this.myImports.get().remove(index);
            this.replacePartOfAttribute(textRange, "");
        } else {
            try {
                XmlTag parent = this.getAttribute().getParent();
                if (parent.getValue().getTextRange().getLength() == 0 && parent.getAttributes().length == 1) {
                    parent.delete();
                } else {
                    this.myAttribute.delete();
                }
                this.myImportStatementRanges = null;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    void replace(int index, PsiElement element) {
        String importText = JspxImportListAttribute.computeImportText(element);
        if (importText == null) {
            throw new IncorrectOperationException("Can't replace import statement with " + String.valueOf(element));
        }
        this.ensureRangesAreBuilt();
        this.replacePartOfAttribute(this.myImportStatementRanges[index], importText);
    }

    @Nullable
    private static String computeImportText(PsiElement element) {
        if (element instanceof PsiImportStaticStatement) {
            PsiImportStaticStatement importStatement = (PsiImportStaticStatement)element;
            return "static " + importStatement.getQualifiedName() + (importStatement.isOnDemand() ? ".*" : "");
        }
        if (element instanceof PsiImportStatement) {
            PsiImportStatement importStatement = (PsiImportStatement)element;
            return importStatement.getQualifiedName() + (importStatement.isOnDemand() ? ".*" : "");
        }
        return null;
    }

    private void replacePartOfAttribute(TextRange importStatementRange, String newValue) {
        try {
            String value = this.getAttribute().getValue();
            assert (value != null);
            this.getAttribute().setValue(value.substring(0, importStatementRange.getStartOffset()) + newValue + value.substring(importStatementRange.getEndOffset()));
            this.myImportStatementRanges = null;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public XmlAttribute getAttribute() {
        return this.myAttribute;
    }

    int getIndex(JspxImportStatement statement) {
        List<JspxImportStatementImpl> imports = this.myImports.get();
        return imports.indexOf(statement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/jspJava/JspxImportListAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/jspJava/JspxImportListAttribute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllImportStatements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticImportStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

