/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.editor.editor;

import com.intellij.database.explorer.structure.DvFun;
import com.intellij.database.explorer.structure.DvTreeStructure;
import com.intellij.database.explorer.structure.DvTreeStructureService;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbTreeSelectorPopup {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T extends BasicElement> JBPopup createPopup(@NotNull Project project, @Nullable BasicNode selection, @NotNull @NotNull BasicMetaObject<? extends T> @NotNull [] filter, @NotNull BiConsumer<RawDataSource, T> consumer) {
        if (project == null) {
            DbTreeSelectorPopup.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            DbTreeSelectorPopup.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            DbTreeSelectorPopup.$$$reportNull$$$0(2);
        }
        Disposable disposable = Disposer.newDisposable();
        JBPopup popup2 = DbTreeSelectorPopup.createPopup(project, disposable, selection, filter, consumer);
        Disposer.register((Disposable)popup2, (Disposable)disposable);
        disposable = null;
        JBPopup jBPopup = popup2;
        JBPopup jBPopup2 = jBPopup;
        if (jBPopup2 == null) {
            DbTreeSelectorPopup.$$$reportNull$$$0(3);
        }
        return jBPopup2;
        finally {
            if (disposable != null) {
                Disposer.dispose((Disposable)disposable);
            }
        }
    }

    @NotNull
    private static <T extends BasicElement> JBPopup createPopup(@NotNull Project project, @NotNull Disposable disposable, @Nullable BasicNode selection, final @NotNull @NotNull BasicMetaObject<? extends T> @NotNull [] filter, final @NotNull BiConsumer<RawDataSource, T> consumer) {
        if (project == null) {
            DbTreeSelectorPopup.$$$reportNull$$$0(4);
        }
        if (disposable == null) {
            DbTreeSelectorPopup.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            DbTreeSelectorPopup.$$$reportNull$$$0(6);
        }
        if (filter == null) {
            DbTreeSelectorPopup.$$$reportNull$$$0(7);
        }
        final DvTreeStructureService struct = (DvTreeStructureService)project.getService(DvTreeStructureService.class);
        DatabaseStructure structure = DbTreeSelectorPopup.createFilteredStructure(struct, filter);
        AsyncTreeModel treeModel = new AsyncTreeModel((TreeModel)((Object)structure), disposable);
        final Tree tree = new Tree((TreeModel)treeModel);
        MyNodeRenderer rr = new MyNodeRenderer(project, struct);
        TreeSpeedSearch.installOn((JTree)tree, (boolean)true, rr::getPresentableText);
        tree.setRootVisible(false);
        tree.putClientProperty((Object)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        tree.setCellRenderer((TreeCellRenderer)((Object)rr));
        treeModel.getTreePath((Object)selection).onSuccess(p -> TreeUtil.selectPaths((JTree)tree, (TreePath[])new TreePath[]{p}));
        final JBPopup popup2 = DbTreeSelectorPopup.createTreePopup(tree);
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Object o;
                    TreePath path = tree.getSelectionPath();
                    Object object = o = path == null ? null : path.getLastPathComponent();
                    if (o instanceof BasicElement) {
                        DataSourceNode dsn;
                        BasicElement node = (BasicElement)o;
                        BasicMetaObject meta = (BasicMetaObject)ContainerUtil.find((Object[])filter, m -> m == node.getMetaObject());
                        BasicElement target = meta == null ? null : meta.tryCast(node);
                        DataSourceNode dataSourceNode = dsn = target == null ? null : DvFun.findDataSourceNode((BasicNode)node, (DvTreeStructure)struct);
                        if (dsn != null) {
                            consumer.accept(dsn.dataSource, target);
                            popup2.closeOk((InputEvent)e);
                            e.consume();
                        }
                    }
                }
            }
        });
        JBPopup jBPopup = popup2;
        if (jBPopup == null) {
            DbTreeSelectorPopup.$$$reportNull$$$0(8);
        }
        return jBPopup;
    }

    @NotNull
    private static JBPopup createTreePopup(Tree tree) {
        JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)tree, (boolean)false);
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)scroll, (JComponent)tree).setRequestFocus(true).setMinSize((Dimension)JBUI.size((int)300, (int)500)).createPopup();
        if (jBPopup == null) {
            DbTreeSelectorPopup.$$$reportNull$$$0(9);
        }
        return jBPopup;
    }

    @NotNull
    private static DatabaseStructure createFilteredStructure(DvTreeStructureService struct, BasicMetaObject<?>[] filter) {
        final HashSet targets = ContainerUtil.newHashSet((Object[])filter);
        final HashSet<BasicMetaObject> parents = new HashSet<BasicMetaObject>();
        parents.add(null);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            BasicMetaObject target;
            for (BasicMetaObject p = target = (BasicMetaObject)iterator.next(); p != null; p = p.getParent()) {
                parents.add(p);
            }
        }
        return new DatabaseStructure((DvTreeStructure)struct){

            @Override
            @NotNull
            protected JBIterable<? extends BasicNode> getChildrenImpl(BasicNode p) {
                BasicMetaObject<?> meta = 2.getMeta(p);
                if (parents.contains(meta)) {
                    JBIterable jBIterable = super.getChildrenImpl(p).filter(o -> {
                        BasicMetaObject<?> cm = 2.getMeta(o);
                        return cm == null ? !targets.contains(meta) : parents.contains(cm);
                    });
                    if (jBIterable == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return jBIterable;
                }
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    2.$$$reportNull$$$0(1);
                }
                return jBIterable;
            }

            @Override
            public boolean isLeaf(Object node) {
                if (super.isLeaf(node)) {
                    return true;
                }
                BasicMetaObject<?> meta = 2.getMeta(node);
                return targets.contains(meta) && this.getChildren(node).isEmpty();
            }

            @Nullable
            private static BasicMetaObject<?> getMeta(Object o) {
                if (o instanceof BasicObjectNode) {
                    BasicObjectNode n = (BasicObjectNode)o;
                    return n.getMetaObject();
                }
                if (o instanceof Family) {
                    Family f = (Family)o;
                    return f.getMetaObject();
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/editor/editor/DbTreeSelectorPopup$2", "getChildrenImpl"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/editor/editor/DbTreeSelectorPopup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/editor/editor/DbTreeSelectorPopup";
                break;
            }
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreePopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class MyNodeRenderer
    extends NodeRenderer {
        private final PresentationData presentation;
        @NotNull
        private final Project myProject;
        private final DvTreeStructureService myStruct;

        MyNodeRenderer(@NotNull Project project, DvTreeStructureService struct) {
            if (project == null) {
                MyNodeRenderer.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myStruct = struct;
            this.presentation = new PresentationData();
        }

        @Nullable
        String getPresentableText(Object node) {
            ItemPresentation p = this.getPresentation(node);
            return p == null ? null : p.getPresentableText();
        }

        @Nullable
        protected ItemPresentation getPresentation(Object node) {
            if (node instanceof BasicNode) {
                BasicNode n = (BasicNode)node;
                DbNodeDescriptor.updatePresentation(this.presentation, n, this.myProject, this.myStruct.getContext().vo, (DvTreeStructure)this.myStruct, null, true, false);
                return this.presentation;
            }
            return super.getPresentation(node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/editor/editor/DbTreeSelectorPopup$MyNodeRenderer", "<init>"));
        }
    }
}

