/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.editor.DdlCodeFileIface;
import com.intellij.database.editor.DdlEditorContentLoaderKt;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.vfs.DatabaseElementSourceVirtualFileImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u0004\u0018\u00010!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/intellij/database/editor/DdlCodeFileImpl;", "Lcom/intellij/database/editor/DdlCodeFileIface;", "project", "Lcom/intellij/openapi/project/Project;", "delegate", "Lcom/intellij/database/vfs/DatabaseElementSourceVirtualFileImpl;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/vfs/DatabaseElementSourceVirtualFileImpl;)V", "value", "", "isBusy", "()Z", "setBusy", "(Z)V", "setWritableInner", "", "writable", "isValid", "isModifiedByUser", "getContent", "", "setContent", "content", "objectHash", "", "isWritable", "setVisualProgress", "showProgress", "dbElement", "Lcom/intellij/database/psi/DbElement;", "getDbElement", "()Lcom/intellij/database/psi/DbElement;", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "intellij.database.impl"})
public final class DdlCodeFileImpl
implements DdlCodeFileIface {
    @NotNull
    private final Project project;
    @NotNull
    private final DatabaseElementSourceVirtualFileImpl delegate;

    public DdlCodeFileImpl(@NotNull Project project, @NotNull DatabaseElementSourceVirtualFileImpl delegate) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.project = project;
        this.delegate = delegate;
    }

    @Override
    public boolean isBusy() {
        return this.delegate.isBusy();
    }

    @Override
    public void setBusy(boolean value) {
        this.delegate.setBusy(value);
    }

    @Override
    public void setWritableInner(boolean writable) {
        this.delegate.setWritableInner(writable);
    }

    @Override
    public boolean isValid() {
        return this.delegate.isValid();
    }

    @Override
    public boolean isModifiedByUser() {
        return this.delegate.isModifiedByUser();
    }

    @Override
    @NotNull
    public String getContent() {
        String string = this.delegate.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContent(...)");
        return string;
    }

    @Override
    public void setContent(@NotNull String content, int objectHash) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.delegate.setContent(content, objectHash);
    }

    @Override
    public boolean isWritable() {
        return this.delegate.isWritable();
    }

    @Override
    public void setVisualProgress(boolean showProgress) {
        DbImplUtilCore.invokeLaterIfNeeded(() -> DdlCodeFileImpl.setVisualProgress$lambda$0(this, showProgress));
    }

    @Override
    @Nullable
    public DbElement getDbElement() {
        return this.delegate.findElement(this.project);
    }

    @Override
    @Nullable
    public Document getDocument() {
        return FileDocumentManager.getInstance().getDocument((VirtualFile)this.delegate);
    }

    private static final void setVisualProgress$lambda$0(DdlCodeFileImpl this$0, boolean $showProgress) {
        DdlEditorContentLoaderKt.access$setVisualProgress(this$0.project, (VirtualFile)this$0.delegate, $showProgress);
    }
}

