/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.migration.DbMigrationDialog;
import com.intellij.database.model.migration.DbMigrationDialogKt;
import com.intellij.database.model.migration.DbMigrationDiffPanelBase;
import com.intellij.database.model.migration.DbMigrationDiffPanelKt;
import com.intellij.database.model.migration.DbMigrationSideTree;
import com.intellij.database.model.migration.DbMigrationTableDiffPanel;
import com.intellij.database.model.migration.DbMigrationTableDiffPanelKt;
import com.intellij.database.model.migration.DbMigrationTreeModel;
import com.intellij.database.model.migration.DbMigrationTreeTableModel;
import com.intellij.database.model.migration.SdForallCheckbox;
import com.intellij.database.model.migration.SdUtilsKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.ui.Control;
import com.intellij.ui.tree.ui.DefaultControl;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashSet;
import java.util.function.Function;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008d\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0003\u000e03\u0018\u00002\u00020\u00012\u00020\u0002:\u0005@ABCDB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u0012\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016J\b\u0010\u001e\u001a\u00020\u0011H\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0017J\b\u0010 \u001a\u00020\u0011H\u0016J\u000e\u0010!\u001a\b\u0018\u00010\"R\u00020\bH\u0016J\b\u0010#\u001a\u00020\u0011H\u0016J\b\u0010$\u001a\u00020\u0011H\u0016J\"\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u001a\u0010)\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001b2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J$\u0010*\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001b2\n\u0010+\u001a\u00060\"R\u00020\b2\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020\u0011H\u0002J\r\u0010/\u001a\u000200H\u0002\u00a2\u0006\u0002\u00101J\u0015\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002\u00a2\u0006\u0002\u00106J\f\u00107\u001a\u000208*\u000208H\u0002J\b\u00109\u001a\u00020:H\u0002J \u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0014\u0010?\u001a\u00020\u0011*\u00020<2\u0006\u0010&\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel;", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "Lcom/intellij/database/model/migration/DbMigrationDiffPanelBase;", "migrationDialog", "Lcom/intellij/database/model/migration/DbMigrationDialog;", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationDialog;)V", "migrationTree", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "getMigrationTree", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "dividerHeaderCell", "Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel$DividerHeaderCell;", "createHoverListener", "com/intellij/database/model/migration/DbMigrationTableDiffPanel$createHoverListener$1", "()Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel$createHoverListener$1;", "treeStructureChanged", "", "tableDataChanged", "refresh", "setModel", "treeTableModel", "Lcom/intellij/ui/treeStructure/treetable/TreeTableModel;", "updateDividerSize", "isTreeColumn", "", "column", "", "expandMappingNodes", "expandAll", "collapseAll", "refreshTreesUI", "repaintDivider", "getSelectedNode", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "swapSourceLabels", "doRepaint", "editCellAt", "row", "e", "Ljava/util/EventObject;", "processDividerEvent", "checkboxContains", "node", "p", "Ljava/awt/Point;", "reinitializeRenderers", "createHeaderRenderer", "com/intellij/database/model/migration/DbMigrationTableDiffPanel$createHeaderRenderer$1", "()Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel$createHeaderRenderer$1;", "createTableRenderer", "com/intellij/database/model/migration/DbMigrationTableDiffPanel$createTableRenderer$1", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "(Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;)Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel$createTableRenderer$1;", "applyHeaderCellBorder", "Ljavax/swing/JComponent;", "headerCellBorder", "Ljavax/swing/border/Border;", "prepareRenderer", "Ljava/awt/Component;", "renderer", "Ljavax/swing/table/TableCellRenderer;", "applyHoveredBackground", "TableRendererWrapper", "RendererComponentWrapper", "Cell", "DividerCell", "DividerHeaderCell", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbMigrationTableDiffPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationTableDiffPanel.kt\ncom/intellij/database/model/migration/DbMigrationTableDiffPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,400:1\n1915#2,2:401\n1#3:403\n*S KotlinDebug\n*F\n+ 1 DbMigrationTableDiffPanel.kt\ncom/intellij/database/model/migration/DbMigrationTableDiffPanel\n*L\n118#1:401,2\n*E\n"})
public final class DbMigrationTableDiffPanel
extends TreeTable
implements DbMigrationDiffPanelBase {
    @NotNull
    private final DbMigrationDialog migrationDialog;
    @NotNull
    private final DividerHeaderCell dividerHeaderCell;

    public DbMigrationTableDiffPanel(@NotNull DbMigrationDialog migrationDialog) {
        Intrinsics.checkNotNullParameter((Object)((Object)migrationDialog), (String)"migrationDialog");
        super((TreeTableModel)DbMigrationTableDiffPanelKt.access$createTreeTableModel(migrationDialog.getMigrationTree()));
        this.migrationDialog = migrationDialog;
        this.dividerHeaderCell = new DividerHeaderCell();
        this.refresh();
        this.setAutoResizeMode(1);
        this.tableHeader.setReorderingAllowed(false);
        this.tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e != null) {
                    dividerHeaderCell.handleMouseClick(e);
                }
            }
        });
        this.createHoverListener().addTo((JComponent)((Object)this));
    }

    private final DbMigrationTreeModel getMigrationTree() {
        return this.migrationDialog.getMigrationTree();
    }

    private final createHoverListener.1 createHoverListener() {
        return new TableHoverListener(){

            public void onHover(JTable table, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                table.repaint();
            }
        };
    }

    public final void treeStructureChanged() {
        block0: {
            TreeTableModel treeTableModel = this.getTableModel();
            DbMigrationTreeTableModel dbMigrationTreeTableModel = treeTableModel instanceof DbMigrationTreeTableModel ? (DbMigrationTreeTableModel)treeTableModel : null;
            if (dbMigrationTreeTableModel == null) break block0;
            dbMigrationTreeTableModel.treeStructureChanged();
        }
    }

    public final void tableDataChanged() {
        block0: {
            TableModel tableModel = this.getModel();
            AbstractTableModel abstractTableModel = tableModel instanceof AbstractTableModel ? (AbstractTableModel)tableModel : null;
            if (abstractTableModel == null) break block0;
            abstractTableModel.fireTableDataChanged();
        }
    }

    private final void refresh() {
        this.reinitializeRenderers();
        Object object = UIManager.get(JBUI.CurrentTheme.Tree.rowHeightKey());
        Integer treeRowHeight = object instanceof Integer ? (Integer)object : null;
        int height = treeRowHeight != null && treeRowHeight > 0 ? treeRowHeight : JBUIScale.scale((int)20);
        this.setRowHeight(height);
    }

    public void setModel(@Nullable TreeTableModel treeTableModel) {
        super.setModel(treeTableModel);
        SdUtilsKt.setTableColors((JTable)((Object)this));
        this.setRootVisible(DbMigrationTableDiffPanelKt.showDiffRoot());
        this.setShowVerticalLines(true);
        this.setShowHorizontalLines(true);
        this.setIntercellSpacing(new Dimension(1, 1));
        this.updateDividerSize();
        this.getTree().addTreeSelectionListener(arg_0 -> DbMigrationTableDiffPanel.setModel$lambda$0(this, arg_0));
    }

    private final void updateDividerSize() {
        TableColumn divider = this.columnModel.getColumn(1);
        int width = JBUIScale.scale((int)31);
        divider.setMaxWidth(width);
        divider.setMinWidth(width);
    }

    protected boolean isTreeColumn(int column) {
        return column == 0 || column == 2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void expandMappingNodes() {
        void $this$forEach$iv;
        HashSet pathsToExpand = SequencesKt.toHashSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.getMigrationTree().getDividerMapping()), DbMigrationTableDiffPanel::expandMappingNodes$lambda$0));
        Iterable iterable = pathsToExpand;
        TreeTableTree treeTableTree = this.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)treeTableTree, (String)"getTree(...)");
        TreeTableTree treeTableTree2 = treeTableTree;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TreePath p0 = (TreePath)element$iv;
            boolean bl = false;
            treeTableTree2.expandPath(p0);
        }
    }

    @Override
    public void expandAll() {
        TreeUtil.expandAll((JTree)((JTree)this.getTree()));
    }

    @Override
    public void collapseAll() {
        TreeUtil.collapseAll((JTree)((JTree)this.getTree()), (int)-1);
    }

    @Override
    @RequiresEdt
    public void refreshTreesUI() {
        this.setModel(DbMigrationTableDiffPanelKt.access$createTreeTableModel(this.getMigrationTree()));
        this.expandMappingNodes();
        this.refresh();
    }

    @Override
    public void repaintDivider() {
    }

    @Override
    @Nullable
    public DbMigrationTreeModel.Node getSelectedNode() {
        TreePath treePath = this.getTree().getSelectionPath();
        return treePath != null ? DbMigrationDialogKt.last(treePath) : null;
    }

    @Override
    public void swapSourceLabels() {
    }

    @Override
    public void doRepaint() {
        this.repaint();
    }

    public boolean editCellAt(int row, int column, @Nullable EventObject e) {
        boolean bl;
        if (column == 1) {
            this.processDividerEvent(row, e);
            bl = false;
        } else {
            bl = super.editCellAt(row, column, e);
        }
        return bl;
    }

    private final void processDividerEvent(int row, EventObject e) {
        if (!(e instanceof MouseEvent) || ((MouseEvent)e).getID() != 501) {
            return;
        }
        Object object = this.getValueAt(row, 1);
        DbMigrationTreeModel.Node node = object instanceof DbMigrationTreeModel.Node ? (DbMigrationTreeModel.Node)object : null;
        if (node == null) {
            return;
        }
        DbMigrationTreeModel.Node node2 = node;
        if (!node2.getContainsMapping()) {
            return;
        }
        Point point = ((MouseEvent)e).getPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
        if (this.checkboxContains(row, node2, point)) {
            AbstractTableModel atm;
            node2.setIncluded(!node2.getIncluded());
            this.dividerHeaderCell.updateCheckbox();
            object = this.getModel();
            AbstractTableModel abstractTableModel = atm = object instanceof AbstractTableModel ? (AbstractTableModel)object : null;
            if (abstractTableModel != null) {
                abstractTableModel.fireTableCellUpdated(row, 1);
            }
            this.migrationDialog.refreshScript();
        }
    }

    private final boolean checkboxContains(int row, DbMigrationTreeModel.Node node, Point p) {
        DividerCell dividerCell;
        DividerCell $this$checkboxContains_u24lambda_u240 = dividerCell = new DividerCell();
        boolean bl = false;
        $this$checkboxContains_u24lambda_u240.init(row, node);
        return dividerCell.checkboxContainsAbs(p);
    }

    private final void reinitializeRenderers() {
        this.tableHeader.setDefaultRenderer(this.createHeaderRenderer());
        this.setDefaultRenderer(Object.class, new TableRendererWrapper());
    }

    private final createHeaderRenderer.1 createHeaderRenderer() {
        return new TableCellRenderer(this){
            private final JComponent originLabel;
            private final JComponent targetLabel;
            final /* synthetic */ DbMigrationTableDiffPanel this$0;
            {
                this.this$0 = $receiver;
                this.originLabel = this.createSourceLabel(DbMigrationTreeModel.Side.ORIGIN);
                this.targetLabel = this.createSourceLabel(DbMigrationTreeModel.Side.TARGET);
            }

            public final JComponent getOriginLabel() {
                return this.originLabel;
            }

            public final JComponent getTargetLabel() {
                return this.targetLabel;
            }

            private final JComponent createSourceLabel(DbMigrationTreeModel.Side side) {
                return DbMigrationTableDiffPanel.access$applyHeaderCellBorder(this.this$0, DbMigrationDiffPanelKt.createSourceLabel(DbMigrationTableDiffPanel.access$getMigrationDialog$p(this.this$0).getRequest(), side));
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return switch (column) {
                    case 0 -> this.originLabel;
                    case 1 -> DbMigrationTableDiffPanel.access$getDividerHeaderCell$p(this.this$0);
                    case 2 -> this.targetLabel;
                    default -> throw new AssertionError();
                };
            }
        };
    }

    private final createTableRenderer.1 createTableRenderer(DbMigrationTreeModel.Side side) {
        TreeTableTree treeTableTree = this.getTree();
        return new TreeTableCellRenderer(side, this, treeTableTree){
            private RendererComponentWrapper component;
            final /* synthetic */ DbMigrationTableDiffPanel this$0;
            {
                this.this$0 = $receiver;
                super((TreeTable)$receiver, $super_call_param$1);
                TreeTableTree treeTableTree = $receiver.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)treeTableTree, (String)"getTree(...)");
                this.component = new RendererComponentWrapper($side, (Tree)treeTableTree);
                Project p = DbMigrationTableDiffPanel.access$getMigrationDialog$p($receiver).getRequest().getProject();
                DbMigrationSideTree.CellRenderer r = new DbMigrationSideTree.CellRenderer(p, $side, true);
                this.setCellRenderer(r);
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component delegate = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                RendererComponentWrapper rendererComponentWrapper = this.component;
                DbMigrationTableDiffPanel dbMigrationTableDiffPanel = this.this$0;
                RendererComponentWrapper $this$getTableCellRendererComponent_u24lambda_u240 = rendererComponentWrapper;
                boolean bl = false;
                if ($this$getTableCellRendererComponent_u24lambda_u240.getComponentCount() == 0) {
                    $this$getTableCellRendererComponent_u24lambda_u240.add((Component)dbMigrationTableDiffPanel.getTree());
                }
                $this$getTableCellRendererComponent_u24lambda_u240.setAccessibleCtx(delegate.getAccessibleContext());
                $this$getTableCellRendererComponent_u24lambda_u240.setBackground(delegate.getBackground());
                $this$getTableCellRendererComponent_u24lambda_u240.setForeground(delegate.getForeground());
                return (Component)((Object)this.component);
            }
        };
    }

    private final JComponent applyHeaderCellBorder(JComponent $this$applyHeaderCellBorder) {
        Border inside = $this$applyHeaderCellBorder.getBorder();
        $this$applyHeaderCellBorder.setBorder(JBUI.Borders.compound((Border)this.headerCellBorder(), (Border)inside));
        return $this$applyHeaderCellBorder;
    }

    private final Border headerCellBorder() {
        Border border = JBUI.Borders.customLineRight((Color)JBColor.border());
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"customLineRight(...)");
        return border;
    }

    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer2, int row, int column) {
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        Component component = super.prepareRenderer(renderer2, row, column);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"prepareRenderer(...)");
        Component c2 = component;
        this.applyHoveredBackground(c2, row);
        return c2;
    }

    private final void applyHoveredBackground(Component $this$applyHoveredBackground, int row) {
        if (this.isRowSelected(row)) {
            return;
        }
        Object object = this.getValueAt(row, 0);
        DbMigrationTreeModel.Node node = object instanceof DbMigrationTreeModel.Node ? (DbMigrationTreeModel.Node)object : null;
        if (node == null) {
            return;
        }
        DbMigrationTreeModel.Node node2 = node;
        int hoveredRow = TableHoverListener.getHoveredRow((JTable)((JTable)((Object)this)));
        if (hoveredRow < 0) {
            return;
        }
        Object object2 = this.getValueAt(hoveredRow, 0);
        DbMigrationTreeModel.Node node3 = object2 instanceof DbMigrationTreeModel.Node ? (DbMigrationTreeModel.Node)object2 : null;
        if (node3 == null) {
            return;
        }
        DbMigrationTreeModel.Node hovered = node3;
        DbMigrationTreeModel.Node mapping = node2.enclosingMappingNode();
        if (mapping != null && Intrinsics.areEqual((Object)mapping, (Object)hovered.enclosingMappingNode())) {
            $this$applyHoveredBackground.setBackground(this.getHoveredRowBackground());
        }
    }

    private static final void setModel$lambda$0(DbMigrationTableDiffPanel this$0, TreeSelectionEvent it) {
        this$0.migrationDialog.updateCurrentPreviewPage(this$0.getSelectedNode());
    }

    private static final TreePath expandMappingNodes$lambda$0(DbMigrationTreeModel.MappingItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPath().getParentPath();
    }

    public static final /* synthetic */ JComponent access$applyHeaderCellBorder(DbMigrationTableDiffPanel $this, JComponent $receiver) {
        return $this.applyHeaderCellBorder($receiver);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel$Cell;", "Ljavax/swing/JPanel;", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel;)V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "cellBounds", "Ljava/awt/Rectangle;", "getCellBounds", "()Ljava/awt/Rectangle;", "insetX", "", "getInsetX", "()I", "iconX", "iconY", "iconBoundsRel", "iconBoundsAbs", "checkboxContainsAbs", "", "p", "Ljava/awt/Point;", "checkboxContainsRel", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbMigrationTableDiffPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationTableDiffPanel.kt\ncom/intellij/database/model/migration/DbMigrationTableDiffPanel$Cell\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,400:1\n1#2:401\n*E\n"})
    private abstract class Cell
    extends JPanel {
        private final int insetX;

        @Nullable
        public abstract Icon getIcon();

        @NotNull
        public abstract Rectangle getCellBounds();

        public int getInsetX() {
            return this.insetX;
        }

        public final int iconX(@NotNull Rectangle cellBounds, @NotNull Icon icon) {
            Intrinsics.checkNotNullParameter((Object)cellBounds, (String)"cellBounds");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            return (cellBounds.width - this.getInsetX() - icon.getIconWidth()) / 2;
        }

        public final int iconY(@NotNull Rectangle cellBounds, @NotNull Icon icon) {
            Intrinsics.checkNotNullParameter((Object)cellBounds, (String)"cellBounds");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            return (cellBounds.height - icon.getIconHeight()) / 2;
        }

        @NotNull
        public final Rectangle iconBoundsRel(@NotNull Icon icon) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Rectangle cb = this.getCellBounds();
            return new Rectangle(this.iconX(cb, icon), this.iconY(cb, icon), icon.getIconWidth(), icon.getIconHeight());
        }

        @NotNull
        public final Rectangle iconBoundsAbs(@NotNull Icon icon) {
            Rectangle rectangle;
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Rectangle $this$iconBoundsAbs_u24lambda_u240 = rectangle = this.iconBoundsRel(icon);
            boolean bl = false;
            Rectangle cb = this.getCellBounds();
            $this$iconBoundsAbs_u24lambda_u240.translate(cb.x, cb.y);
            return rectangle;
        }

        public final boolean checkboxContainsAbs(@NotNull Point p) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Icon icon = this.getIcon();
            if (icon != null) {
                Icon it = icon;
                boolean bl2 = false;
                bl = this.iconBoundsAbs(it).contains(p);
            } else {
                bl = false;
            }
            return bl;
        }

        public final boolean checkboxContainsRel(@NotNull Point p) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Icon icon = this.getIcon();
            if (icon != null) {
                Icon it = icon;
                boolean bl2 = false;
                bl = this.iconBoundsRel(it).contains(p);
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        protected void paintComponent(@Nullable Graphics g) {
            block0: {
                super.paintComponent(g);
                Icon icon = this.getIcon();
                if (icon == null) break block0;
                Icon it = icon;
                boolean bl = false;
                Rectangle cb = this.getCellBounds();
                it.paintIcon(this, g, this.iconX(cb, it), this.iconY(cb, it));
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u000fJ\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00172\f\u0010\r\u001a\b\u0018\u00010\u000eR\u00020\u000fJ\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J8\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007H\u0016R\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\r\u001a\b\u0018\u00010\u000eR\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006,"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel$DividerCell;", "Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel$Cell;", "Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel;", "Ljavax/swing/table/TableCellRenderer;", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel;)V", "row", "", "getRow", "()Ljava/lang/Integer;", "setRow", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "node", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "getNode", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "setNode", "(Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;)V", "init", "", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "cellBounds", "Ljava/awt/Rectangle;", "getCellBounds", "()Ljava/awt/Rectangle;", "getToolTipText", "", "event", "Ljava/awt/event/MouseEvent;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "column", "intellij.database.impl"})
    private final class DividerCell
    extends Cell
    implements TableCellRenderer {
        @Nullable
        private Integer row;
        @Nullable
        private DbMigrationTreeModel.Node node;

        @Nullable
        public final Integer getRow() {
            return this.row;
        }

        public final void setRow(@Nullable Integer n) {
            this.row = n;
        }

        @Nullable
        public final DbMigrationTreeModel.Node getNode() {
            return this.node;
        }

        public final void setNode(@Nullable DbMigrationTreeModel.Node node) {
            this.node = node;
        }

        public final void init(int row, @NotNull DbMigrationTreeModel.Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.row = row;
            this.node = node;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.getIcon(this.node);
        }

        @Override
        @NotNull
        public Rectangle getCellBounds() {
            Integer n = this.row;
            Intrinsics.checkNotNull((Object)n);
            Rectangle rectangle = DbMigrationTableDiffPanel.this.getCellRect(n, 1, false);
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getCellRect(...)");
            return rectangle;
        }

        @Nullable
        public final Icon getIcon(@Nullable DbMigrationTreeModel.Node node) {
            if (node == null) {
                return null;
            }
            DbMigrationTreeModel.MappingState ms = node.getMappingState();
            if (ms == null) {
                return null;
            }
            return ms.getIncluded() ? AllIcons.Diff.GutterCheckBoxSelected : AllIcons.Diff.GutterCheckBox;
        }

        @Override
        @Nullable
        public String getToolTipText(@Nullable MouseEvent event) {
            String string;
            block6: {
                block5: {
                    if (event == null) break block5;
                    Point point = event.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                    if (this.checkboxContainsRel(point)) break block6;
                }
                return null;
            }
            Object object = this.node;
            if (object != null && (object = ((DbMigrationTreeModel.Node)object).getMappingState()) != null) {
                Object it = object;
                boolean bl = false;
                string = ((DbMigrationTreeModel.MappingState)it).getIncluded() ? DatabaseBundle.message((String)"migration.window.exclude.action", (Object[])new Object[0]) : DatabaseBundle.message((String)"migration.window.include.action", (Object[])new Object[0]);
            } else {
                string = null;
            }
            return string;
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table, @NotNull Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.init(row, (DbMigrationTreeModel.Node)value);
            this.setBackground(isSelected ? RenderingUtil.getSelectionBackground((JTable)table) : RenderingUtil.getBackground((JTable)table));
            return this;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018J\u0006\u0010\u001c\u001a\u00020\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel$DividerHeaderCell;", "Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel$Cell;", "Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel;", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel;)V", "checkbox", "Lcom/intellij/database/model/migration/SdForallCheckbox;", "getCheckbox", "()Lcom/intellij/database/model/migration/SdForallCheckbox;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "insetX", "", "getInsetX", "()I", "cellBounds", "Ljava/awt/Rectangle;", "getCellBounds", "()Ljava/awt/Rectangle;", "getToolTipText", "", "event", "Ljava/awt/event/MouseEvent;", "handleMouseClick", "", "e", "updateCheckbox", "intellij.database.impl"})
    private final class DividerHeaderCell
    extends Cell {
        @NotNull
        private final SdForallCheckbox checkbox;
        private final int insetX;

        public DividerHeaderCell() {
            this.setBorder(DbMigrationTableDiffPanel.this.headerCellBorder());
            this.checkbox = new SdForallCheckbox();
            this.insetX = 1;
        }

        @NotNull
        public final SdForallCheckbox getCheckbox() {
            return this.checkbox;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            return this.checkbox.getIcon();
        }

        @Override
        public int getInsetX() {
            return this.insetX;
        }

        @Override
        @NotNull
        public Rectangle getCellBounds() {
            Rectangle rectangle = DbMigrationTableDiffPanel.this.getTableHeader().getHeaderRect(1);
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getHeaderRect(...)");
            return rectangle;
        }

        @Override
        @Nullable
        public String getToolTipText(@Nullable MouseEvent event) {
            return event != null && this.iconBoundsRel(this.getIcon()).contains(event.getPoint()) ? this.checkbox.getTooltip() : null;
        }

        public final void handleMouseClick(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Point point = e.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            if (this.checkboxContainsAbs(point)) {
                this.checkbox.click(DbMigrationTableDiffPanel.this.getMigrationTree());
                DbMigrationTableDiffPanel.this.migrationDialog.refreshScript();
                DbMigrationTableDiffPanel.this.tableHeader.repaint();
                DbMigrationTableDiffPanel.this.tableDataChanged();
            }
        }

        public final void updateCheckbox() {
            this.checkbox.update(DbMigrationTableDiffPanel.this.getMigrationTree());
            DbMigrationTableDiffPanel.this.tableHeader.repaint();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00102\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel$RendererComponentWrapper;", "Lcom/intellij/ui/components/panels/OpaquePanel;", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;Lcom/intellij/ui/treeStructure/Tree;)V", "accessibleCtx", "Ljavax/accessibility/AccessibleContext;", "getAccessibleCtx", "()Ljavax/accessibility/AccessibleContext;", "setAccessibleCtx", "(Ljavax/accessibility/AccessibleContext;)V", "getAccessibleContext", "paint", "", "g", "Ljava/awt/Graphics;", "getControl", "Lcom/intellij/ui/tree/ui/Control;", "path", "Ljavax/swing/tree/TreePath;", "overrideOriginControl", "supplier", "Ljava/util/function/Function;", "Companion", "intellij.database.impl"})
    private static final class RendererComponentWrapper
    extends OpaquePanel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final DbMigrationTreeModel.Side side;
        @NotNull
        private final Tree tree;
        @Nullable
        private AccessibleContext accessibleCtx;
        @NotNull
        private static final DefaultControl EMPTY_CONTROL = new DefaultControl(EmptyIcon.ICON_0, EmptyIcon.ICON_0, EmptyIcon.ICON_0, EmptyIcon.ICON_0);

        public RendererComponentWrapper(@NotNull DbMigrationTreeModel.Side side, @NotNull Tree tree) {
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            super((LayoutManager)new BorderLayout());
            this.side = side;
            this.tree = tree;
        }

        @Nullable
        public final AccessibleContext getAccessibleCtx() {
            return this.accessibleCtx;
        }

        public final void setAccessibleCtx(@Nullable AccessibleContext accessibleContext) {
            this.accessibleCtx = accessibleContext;
        }

        @Nullable
        public AccessibleContext getAccessibleContext() {
            return this.accessibleCtx;
        }

        public void paint(@Nullable Graphics g) {
            this.overrideOriginControl(this::getControl);
            super.paint(g);
            this.overrideOriginControl(null);
        }

        private final Control getControl(TreePath path) {
            return DbMigrationDialogKt.last(path).getOrigin() == null ? (Control)EMPTY_CONTROL : null;
        }

        private final void overrideOriginControl(Function<TreePath, Control> supplier) {
            if (this.side == DbMigrationTreeModel.Side.ORIGIN) {
                ClientProperty.put((JComponent)((JComponent)this.tree), (Key)Control.CUSTOM_CONTROL, supplier);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel$RendererComponentWrapper$Companion;", "", "<init>", "()V", "EMPTY_CONTROL", "Lcom/intellij/ui/tree/ui/DefaultControl;", "intellij.database.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\b\u001a\u00060\tR\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel$TableRendererWrapper;", "Ljavax/swing/table/TableCellRenderer;", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel;)V", "originRenderer", "Lcom/intellij/ui/treeStructure/treetable/TreeTableCellRenderer;", "getOriginRenderer", "()Lcom/intellij/ui/treeStructure/treetable/TreeTableCellRenderer;", "dividerRenderer", "Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel$DividerCell;", "Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel;", "getDividerRenderer", "()Lcom/intellij/database/model/migration/DbMigrationTableDiffPanel$DividerCell;", "targetRenderer", "getTargetRenderer", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "intellij.database.impl"})
    private final class TableRendererWrapper
    implements TableCellRenderer {
        @NotNull
        private final TreeTableCellRenderer originRenderer;
        @NotNull
        private final DividerCell dividerRenderer;
        @NotNull
        private final TreeTableCellRenderer targetRenderer;

        public TableRendererWrapper() {
            this.originRenderer = DbMigrationTableDiffPanel.this.createTableRenderer(DbMigrationTreeModel.Side.ORIGIN);
            this.dividerRenderer = new DividerCell();
            this.targetRenderer = DbMigrationTableDiffPanel.this.createTableRenderer(DbMigrationTreeModel.Side.TARGET);
        }

        @NotNull
        public final TreeTableCellRenderer getOriginRenderer() {
            return this.originRenderer;
        }

        @NotNull
        public final DividerCell getDividerRenderer() {
            return this.dividerRenderer;
        }

        @NotNull
        public final TreeTableCellRenderer getTargetRenderer() {
            return this.targetRenderer;
        }

        @Override
        @Nullable
        public Component getTableCellRendererComponent(@Nullable JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableCellRenderer r;
            TableCellRenderer tableCellRenderer = r = (switch (column) {
                case 0 -> (TableCellRenderer)this.originRenderer;
                case 1 -> this.dividerRenderer;
                case 2 -> (TableCellRenderer)this.targetRenderer;
                default -> null;
            });
            return tableCellRenderer != null ? tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : null;
        }
    }
}

