/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.codeWithMe.ClientId;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbScopeProvider;
import com.intellij.database.Dbms;
import com.intellij.database.console.migration.ConsolesMigrationUtilsKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasObjectFun;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.RenameQueryGenerator;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.database.view.ui.SqlPreviewComponent;
import com.intellij.database.view.ui.SqlPreviewPanel;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.UsageView;
import com.intellij.util.MergeQuery;
import com.intellij.util.Query;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0003\u0016\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J(\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/psi/DbRenamePsiElementProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;", "<init>", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "createRenameDialog", "Lcom/intellij/refactoring/rename/RenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "nameSuggestionContext", "editor", "Lcom/intellij/openapi/editor/Editor;", "substituteElementToRename", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchInCommentsAndStrings", "DbRenameDialog", "MyRenameProcessor", "Companion", "intellij.database.impl"})
public final class DbRenamePsiElementProcessor
extends RenamePsiElementProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SEARCH_FOR_STORAGE_OCCURRENCES = "sql.rename.search.for.storage.occurrences";
    @Nullable
    private static Function1<? super String, Boolean> ourRunStatementsHook;

    public boolean canProcessElement(@NotNull PsiElement element) {
        LocalDataSource dataSource;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DbElement dbElement = Companion.getDbElement(element);
        if (dbElement == null) {
            return false;
        }
        if (DbSqlUtil.isSqlElement((DbElement)dbElement)) {
            return true;
        }
        LocalDataSource localDataSource = dataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DasDataSource)dbElement.getDataSource()));
        DasModel dasModel = localDataSource != null ? localDataSource.getModel() : null;
        BaseModel model = dasModel instanceof BaseModel ? (BaseModel)dasModel : null;
        Object object = dbElement.getDelegate();
        BasicNamedElement e = object instanceof BasicNamedElement ? (BasicNamedElement)object : null;
        return e != null && model != null && RenameQueryGenerator.canRename((BasicModel)model, e);
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor2) {
        BasicNamedElement target;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DbElement dbElement = Companion.getDbElement(element);
        if (dbElement == null) {
            RenameDialog renameDialog = super.createRenameDialog(project, element, nameSuggestionContext, editor2);
            Intrinsics.checkNotNullExpressionValue((Object)renameDialog, (String)"createRenameDialog(...)");
            return renameDialog;
        }
        LocalDataSource dataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DasDataSource)dbElement.getDataSource()));
        Object object = dbElement.getDelegate();
        BasicNamedElement basicNamedElement = target = object instanceof BasicNamedElement ? (BasicNamedElement)object : null;
        if (dataSource == null || target == null) {
            RenameDialog renameDialog = super.createRenameDialog(project, element, nameSuggestionContext, editor2);
            Intrinsics.checkNotNullExpressionValue((Object)renameDialog, (String)"createRenameDialog(...)");
            return renameDialog;
        }
        return new DbRenameDialog(project, dataSource, dbElement, nameSuggestionContext, editor2);
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return (PsiElement)Companion.getDbElement(element);
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        PsiElement sqlElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        boolean checkStorage = Companion.getSearchReferencesInStorage(project);
        String prefix = DbRenamePsiElementProcessor.Companion.getDbFsPrefix(element);
        DbElement dbElement = (DbElement)element;
        LocalDataSource ds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DasDataSource)dbElement.getDataSource()));
        String objectSrc = ds == null ? null : DbSrcUtils.getPath((Project)dbElement.getProject(), (LocalDataSource)ds, (DasObject)((DasObject)dbElement), (CasingProvider)((CasingProvider)ds.getModel()), (DbSrcFileSystemCore.ItemType)DbSrcFileSystemCore.ItemType.SRC);
        SearchScope scope2 = searchScope instanceof GlobalSearchScope ? (SearchScope)new DelegatingGlobalSearchScope(searchScope, checkStorage, prefix, objectSrc){
            final /* synthetic */ boolean $checkStorage;
            final /* synthetic */ String $prefix;
            final /* synthetic */ String $objectSrc;
            {
                this.$checkStorage = $checkStorage;
                this.$prefix = $prefix;
                this.$objectSrc = $objectSrc;
                super((GlobalSearchScope)$searchScope);
            }

            public boolean contains(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (DbSrcUtilsCore.isDbSrcFile((VirtualFile)file)) {
                    if (!this.$checkStorage) {
                        return false;
                    }
                    if (DbSrcUtils.isOriginal((VirtualFile)file)) {
                        return false;
                    }
                    String string = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    String path = string;
                    if (!StringsKt.startsWith$default((String)path, (String)this.$prefix, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)path, (Object)this.$objectSrc)) {
                        return false;
                    }
                }
                return super.contains(file);
            }
        } : searchScope;
        Query query = ReferencesSearch.search((PsiElement)element, (SearchScope)scope2);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
        Query query2 = query;
        DasObject dasObject = DbSqlUtil.getSqlSourceElement((DbElement)dbElement);
        PsiElement psiElement = sqlElement = dasObject instanceof PsiElement ? (PsiElement)dasObject : null;
        if (sqlElement != null) {
            query2 = (Query)new MergeQuery(query2, ReferencesSearch.search((PsiElement)sqlElement));
        }
        return query2.findAll();
    }

    @JvmStatic
    @Nullable
    public static final DbElement getDbElement(@Nullable PsiElement element) {
        return Companion.getDbElement(element);
    }

    @JvmStatic
    public static final boolean getSearchReferencesInStorage(@NotNull Project project) {
        return Companion.getSearchReferencesInStorage(project);
    }

    @JvmStatic
    public static final void setSearchReferencesInStorage(@NotNull Project project, boolean val) {
        Companion.setSearchReferencesInStorage(project, val);
    }

    @JvmStatic
    @NotNull
    public static final NonFocusableCheckBox createDbSrcSearchBox(@NotNull Project project) {
        return Companion.createDbSrcSearchBox(project);
    }

    public static final /* synthetic */ Function1 access$getOurRunStatementsHook$cp() {
        return ourRunStatementsHook;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\bH\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/psi/DbRenamePsiElementProcessor$Companion;", "", "<init>", "()V", "SEARCH_FOR_STORAGE_OCCURRENCES", "", "ourRunStatementsHook", "Lkotlin/Function1;", "", "setRunStatementsHook", "", "runStatementsHook", "getDbElement", "Lcom/intellij/database/psi/DbElement;", "element", "Lcom/intellij/psi/PsiElement;", "getDbFsPrefix", "getSearchReferencesInStorage", "project", "Lcom/intellij/openapi/project/Project;", "setSearchReferencesInStorage", "val", "createDbSrcSearchBox", "Lcom/intellij/ui/NonFocusableCheckBox;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        public final void setRunStatementsHook(@Nullable Function1<? super String, Boolean> runStatementsHook) {
            ourRunStatementsHook = runStatementsHook;
        }

        @JvmStatic
        @Nullable
        public final DbElement getDbElement(@Nullable PsiElement element) {
            DbElement dbElement;
            DbElement dbElement2 = dbElement = element instanceof DbElement ? (DbElement)element : null;
            if (dbElement == null) {
                dbElement = (DbElement)JBIterable.from((Iterable)((Iterable)DbNavigationUtils.unwrapElements(element))).filter(DbElement.class).first();
            }
            return dbElement;
        }

        private final String getDbFsPrefix(PsiElement element) {
            DbElement e = element instanceof DbElement ? (DbElement)element : null;
            DbElement dbElement = e;
            String id = dbElement != null && (dbElement = dbElement.getDataSource()) != null ? dbElement.getUniqueId() : null;
            return DbSrcFileSystem.getDataSourcePath((Project)element.getProject(), (String)id) + "/";
        }

        @JvmStatic
        public final boolean getSearchReferencesInStorage(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return PropertiesComponent.getInstance((Project)project).getBoolean(DbRenamePsiElementProcessor.SEARCH_FOR_STORAGE_OCCURRENCES, false);
        }

        @JvmStatic
        public final void setSearchReferencesInStorage(@NotNull Project project, boolean val) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PropertiesComponent.getInstance((Project)project).setValue(DbRenamePsiElementProcessor.SEARCH_FOR_STORAGE_OCCURRENCES, val, false);
        }

        @JvmStatic
        @NotNull
        public final NonFocusableCheckBox createDbSrcSearchBox(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            NonFocusableCheckBox box = new NonFocusableCheckBox(DatabaseBundle.message((String)"search.in.loaded.sources", (Object[])new Object[0]));
            box.setSelected(this.getSearchReferencesInStorage(project));
            return box;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\u001dH\u0014J\n\u0010#\u001a\u0004\u0018\u00010$H\u0014J\n\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002J\n\u0010*\u001a\u0004\u0018\u00010(H\u0014J\b\u0010+\u001a\u00020\u001dH\u0014J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020(H\u0002J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020(H\u0002J\b\u0010.\u001a\u00020\u001dH\u0014J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020(H\u0014J\b\u00102\u001a\u000203H\u0002R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/database/psi/DbRenamePsiElementProcessor$DbRenameDialog;", "Lcom/intellij/refactoring/rename/RenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "psiElement", "Lcom/intellij/database/psi/DbElement;", "nameSuggestionContext", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/psi/DbElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)V", "myDataSource", "myRenameGenerator", "Lcom/intellij/database/view/RenameQueryGenerator;", "myDdlPreview", "Lcom/intellij/database/view/ui/SqlPreviewPanel;", "myRenameInStorage", "Ljavax/swing/JCheckBox;", "getCurrentNamespace", "Lcom/intellij/database/model/basic/BasicNamespace;", "getBasicElement", "Lcom/intellij/database/model/basic/BasicNamedElement;", "getPsiElement", "areButtonsValid", "", "createCheckboxes", "", "panel", "Ljavax/swing/JPanel;", "gbConstraints", "Ljava/awt/GridBagConstraints;", "doAction", "createCenterPanel", "Ljavax/swing/JComponent;", "getSearchPath", "Lcom/intellij/database/util/SearchPath;", "generateQuery", "", "name", "getDimensionServiceKey", "processNewNameChanged", "updateName", "regenerateQuery", "canRun", "createRenameProcessor", "Lcom/intellij/refactoring/rename/RenameProcessor;", "newName", "createHandler", "Lcom/intellij/database/view/DatabaseRefactoringHandler;", "intellij.database.impl"})
    public static final class DbRenameDialog
    extends RenameDialog {
        @NotNull
        private final LocalDataSource myDataSource;
        @Nullable
        private RenameQueryGenerator myRenameGenerator;
        @Nullable
        private SqlPreviewPanel myDdlPreview;
        @Nullable
        private JCheckBox myRenameInStorage;

        public DbRenameDialog(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DbElement psiElement, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            super(project, (PsiElement)psiElement, nameSuggestionContext, editor2);
            this.myDataSource = dataSource;
        }

        private final BasicNamespace getCurrentNamespace() {
            DasNamespace dasNamespace = DbImplUtilCore.getSearchPathObjectForSwitch((DbDataSource)this.getPsiElement().getDataSource(), (DasObject)((DasObject)this.getBasicElement().getParent()));
            return dasNamespace instanceof BasicNamespace ? (BasicNamespace)dasNamespace : null;
        }

        private final BasicNamedElement getBasicElement() {
            Object object = this.getPsiElement().getDelegate();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicNamedElement");
            return (BasicNamedElement)object;
        }

        @NotNull
        public DbElement getPsiElement() {
            PsiElement psiElement = super.getPsiElement();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.database.psi.DbElement");
            return (DbElement)psiElement;
        }

        protected boolean areButtonsValid() {
            return true;
        }

        protected void createCheckboxes(@NotNull JPanel panel2, @NotNull GridBagConstraints gbConstraints) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            Intrinsics.checkNotNullParameter((Object)gbConstraints, (String)"gbConstraints");
            gbConstraints.insets = (Insets)JBUI.insetsBottom((int)4);
            gbConstraints.gridwidth = 1;
            gbConstraints.gridx = 0;
            gbConstraints.weighty = 0.0;
            gbConstraints.weightx = 1.0;
            gbConstraints.fill = 1;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            NonFocusableCheckBox inStorageBox = Companion.createDbSrcSearchBox(project);
            this.myRenameInStorage = (JCheckBox)inStorageBox;
            panel2.add((Component)inStorageBox, gbConstraints);
            super.createCheckboxes(panel2, gbConstraints);
        }

        protected void doAction() {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            JCheckBox jCheckBox = this.myRenameInStorage;
            Companion.setSearchReferencesInStorage(project, jCheckBox != null ? jCheckBox.isSelected() : false);
            super.doAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            RenameQueryGenerator generator;
            BasicNamedElement element = this.getBasicElement();
            Project project = this.getProject();
            BasicModel basicModel = element.getModel();
            Intrinsics.checkNotNull((Object)basicModel);
            this.myRenameGenerator = generator = new RenameQueryGenerator(project, basicModel, element);
            generator.setCurrentNamespace(this.getCurrentNamespace());
            Project project2 = this.getProject();
            DbDataSource dbDataSource = this.getPsiElement().getDataSource();
            SearchPath searchPath = this.getSearchPath();
            String string = this.getNewName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNewName(...)");
            String string2 = this.generateQuery(string);
            Runnable runnable = () -> DbRenameDialog.createCenterPanel$lambda$0(this);
            this.myDdlPreview = new SqlPreviewPanel("DbRenameDialog", new SqlPreviewComponent(generator, this, project2, dbDataSource, searchPath, string2, runnable){
                final /* synthetic */ RenameQueryGenerator $generator;
                final /* synthetic */ DbRenameDialog this$0;
                {
                    this.$generator = $generator;
                    this.this$0 = $receiver;
                    super($super_call_param$1, (DasDataSource)$super_call_param$2, $super_call_param$3, $super_call_param$4, false, $super_call_param$5);
                }

                public List<AnAction> createActions(DasDataSource delegate) {
                    Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
                    List<AnAction> list = super.createActions(delegate);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"createActions(...)");
                    List<AnAction> res2 = list;
                    res2.add(0, DatabaseScriptDialog.Companion.createSettingsPopupAction(() -> createCenterPanel.1.createActions$lambda$0(this.$generator), arg_0 -> createCenterPanel.1.createActions$lambda$1(this.$generator, this.this$0, arg_0)));
                    return res2;
                }

                private static final ScriptingAlterTask createActions$lambda$0(RenameQueryGenerator $generator) {
                    return $generator.createTask(null);
                }

                private static final void createActions$lambda$1(RenameQueryGenerator $generator, DbRenameDialog this$0, ScriptingOptions o) {
                    Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                    $generator.setOptions(o);
                    String string = $generator.getTargetElement().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    DbRenameDialog.access$regenerateQuery(this$0, string);
                }
            });
            return this.myDdlPreview;
        }

        private final SearchPath getSearchPath() {
            return ObjectPaths.searchPathOf((DasObject)((DasObject)this.getCurrentNamespace()));
        }

        private final String generateQuery(String name) {
            BasicElement element;
            String name2 = name;
            Dbms dbms = DbImplUtilCore.getDbms((DbElement)this.getPsiElement());
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            BasicElement basicElement = element = DbImplUtilCore.getMaybeBasicElement((DasObject)((DasObject)this.getPsiElement()));
            BasicModel model = basicElement != null ? basicElement.getModel() : null;
            BasicElement basicElement2 = element;
            BasicDatabase database = basicElement2 != null ? basicElement2.getDatabase() : null;
            NamingService service = NamingServices.getNamingService((Dbms)dbms2, (BasicModel)model, (BasicDatabase)database);
            boolean quoted = service.isQuoted(name2);
            if (quoted) {
                name2 = service.unquoteIdentifier(name2);
            }
            RenameQueryGenerator renameQueryGenerator = this.myRenameGenerator;
            Intrinsics.checkNotNull((Object)renameQueryGenerator);
            renameQueryGenerator.setQuoted(quoted);
            RenameQueryGenerator renameQueryGenerator2 = this.myRenameGenerator;
            Intrinsics.checkNotNull((Object)renameQueryGenerator2);
            renameQueryGenerator2.setScripted(DbImplUtilCore.treatAsPlainIdentifier((String)name2, (boolean)quoted, (BasicNamedElement)((BasicNamedElement)(element instanceof BasicModNamedElement ? (BasicModNamedElement)element : null)), (boolean)true));
            RenameQueryGenerator renameQueryGenerator3 = this.myRenameGenerator;
            Intrinsics.checkNotNull((Object)renameQueryGenerator3);
            return renameQueryGenerator3.generate(name2).getScriptText();
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return ((Object)((Object)this)).getClass().getCanonicalName();
        }

        protected void processNewNameChanged() {
            String string = this.getNewName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNewName(...)");
            this.updateName(string);
            super.processNewNameChanged();
        }

        private final void updateName(String name) {
            if (this.myDdlPreview != null && this.myRenameGenerator != null) {
                RenameQueryGenerator renameQueryGenerator = this.myRenameGenerator;
                Intrinsics.checkNotNull((Object)renameQueryGenerator);
                if (!Intrinsics.areEqual((Object)renameQueryGenerator.getTargetElement().getName(), (Object)name)) {
                    this.regenerateQuery(name);
                }
            }
        }

        private final void regenerateQuery(String name) {
            String query = this.generateQuery(name);
            boolean undo = UndoManager.getInstance((Project)this.getProject()).isUndoInProgress();
            if (!undo) {
                SqlPreviewPanel sqlPreviewPanel = this.myDdlPreview;
                Intrinsics.checkNotNull((Object)sqlPreviewPanel);
                sqlPreviewPanel.getPreviewComponent().setQuery(query);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> DbRenameDialog.regenerateQuery$lambda$0(this, query));
            }
        }

        protected void canRun() throws ConfigurationException {
            block3: {
                block2: {
                    if (this.myRenameGenerator == null) break block2;
                    RenameQueryGenerator renameQueryGenerator = this.myRenameGenerator;
                    Intrinsics.checkNotNull((Object)renameQueryGenerator);
                    if (renameQueryGenerator.isRenamed()) break block3;
                }
                throw new ConfigurationException(DatabaseBundle.message((String)"dialog.message.nothing.to.rename", (Object[])new Object[0]));
            }
            super.canRun();
        }

        @NotNull
        protected RenameProcessor createRenameProcessor(@NotNull String newName) {
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            this.updateName(newName);
            DatabaseRefactoringHandler handler2 = this.createHandler();
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PsiElement psiElement = (PsiElement)this.getPsiElement();
            SearchScope searchScope = this.getRefactoringScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getRefactoringScope(...)");
            return new MyRenameProcessor(project, psiElement, handler2, newName, null, searchScope, this.isSearchInComments(), this.isSearchInNonJavaFiles());
        }

        private final DatabaseRefactoringHandler createHandler() {
            DbElement element = this.getPsiElement();
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DatabaseRefactoringHandler databaseRefactoringHandler = new DatabaseRefactoringHandler(project, this.myDataSource, this.getSearchPath());
            SqlPreviewPanel sqlPreviewPanel = this.myDdlPreview;
            Intrinsics.checkNotNull((Object)sqlPreviewPanel);
            String string = sqlPreviewPanel.getPreviewComponent().getQuery();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQuery(...)");
            DatabaseRefactoringHandler handler2 = databaseRefactoringHandler.setStatement(string);
            handler2.include(DasObjectFun.getBasicElement((DbElement)element));
            return handler2;
        }

        private static final void createCenterPanel$lambda$0(DbRenameDialog this$0) {
            this$0.close(1);
        }

        private static final void regenerateQuery$lambda$0(DbRenameDialog this$0, String $query) {
            SqlPreviewPanel sqlPreviewPanel = this$0.myDdlPreview;
            Intrinsics.checkNotNull((Object)sqlPreviewPanel);
            sqlPreviewPanel.getPreviewComponent().setQuery($query);
        }

        public static final /* synthetic */ void access$regenerateQuery(DbRenameDialog $this, String name) {
            $this.regenerateQuery(name);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u001a\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\f\u0018\u00010\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0014J\u001b\u0010*\u001a\u00020\u001b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0014\u00a2\u0006\u0002\u0010.J\u001b\u0010/\u001a\u00020\u001b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0002\u00a2\u0006\u0002\u0010.J\u001c\u00100\u001a\u00020\u001b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0084@\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u0004\u0018\u00010\u0019J\u0013\u00103\u001a\b\u0012\u0004\u0012\u00020-0,H\u0016\u00a2\u0006\u0002\u00104R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor;", "Lcom/intellij/refactoring/rename/RenameProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "psiElement", "Lcom/intellij/psi/PsiElement;", "handler", "Lcom/intellij/database/view/DatabaseRefactoringHandler;", "newName", "", "secondaryRenames", "", "Lcom/intellij/openapi/util/Pair;", "refactoringScope", "Lcom/intellij/psi/search/SearchScope;", "isSearchInComments", "", "isSearchTextOccurrences", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;Lcom/intellij/database/view/DatabaseRefactoringHandler;Ljava/lang/String;Ljava/lang/Iterable;Lcom/intellij/psi/search/SearchScope;ZZ)V", "myHandler", "myExecuteSql", "myExcludedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "myAsyncStarted", "Lkotlinx/coroutines/Job;", "trackNamespaceRename", "", "element", "name", "scheduleIntrospectionScopeUpdate", "o", "Lcom/intellij/database/model/DasObject;", "getNamingService", "Lcom/intellij/database/script/generator/NamingService;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "customizeUsagesView", "viewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usageView", "Lcom/intellij/usages/UsageView;", "execute", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)V", "executeSqlRename", "runStatements", "([Lcom/intellij/usageView/UsageInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAsyncStarted", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbRenamePsiElementProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbRenamePsiElementProcessor.kt\ncom/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,473:1\n42#2,3:474\n*S KotlinDebug\n*F\n+ 1 DbRenamePsiElementProcessor.kt\ncom/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor\n*L\n360#1:474,3\n*E\n"})
    public static class MyRenameProcessor
    extends RenameProcessor {
        @NotNull
        private final DatabaseRefactoringHandler myHandler;
        private boolean myExecuteSql;
        @Nullable
        private VirtualFile myExcludedFile;
        @Nullable
        private Job myAsyncStarted;

        public MyRenameProcessor(@NotNull Project project, @NotNull PsiElement psiElement, @NotNull DatabaseRefactoringHandler handler2, @NotNull String newName, @Nullable Iterable<? extends Pair<PsiElement, String>> secondaryRenames, @NotNull SearchScope refactoringScope, boolean isSearchInComments, boolean isSearchTextOccurrences) {
            BasicElement theElement;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            Intrinsics.checkNotNullParameter((Object)refactoringScope, (String)"refactoringScope");
            super(project, psiElement, newName, refactoringScope, isSearchInComments, isSearchTextOccurrences);
            this.myExecuteSql = true;
            this.myHandler = handler2;
            if (secondaryRenames != null) {
                for (Pair<PsiElement, String> pair : secondaryRenames) {
                    Object object = pair.first;
                    Intrinsics.checkNotNull((Object)object);
                    PsiElement psiElement2 = (PsiElement)object;
                    Object object2 = pair.second;
                    Intrinsics.checkNotNull((Object)object2);
                    this.addElement(psiElement2, (String)object2);
                    Object object3 = pair.first;
                    Intrinsics.checkNotNull((Object)object3);
                    PsiElement psiElement3 = (PsiElement)object3;
                    Object object4 = pair.second;
                    Intrinsics.checkNotNull((Object)object4);
                    this.trackNamespaceRename(psiElement3, (String)object4);
                }
            }
            this.trackNamespaceRename(psiElement, newName);
            DasObject dasObject = psiElement instanceof DasObject ? (DasObject)psiElement : null;
            Object object = theElement = dasObject != null ? DasObjectFun.getBasicElement((DasObject)dasObject) : null;
            if (theElement != null) {
                BasicElement basicElement = ModelFun.enclosingMajorObjectOrIntrospectableArea((BasicElement)theElement);
                this.myHandler.include(basicElement);
                if (basicElement == theElement) {
                    NamingService ns = this.getNamingService(basicElement.getDatabase());
                    boolean newNameIsQuoted = ns.isQuoted(newName);
                    String newRealName = newNameIsQuoted ? ns.unquoteIdentifier(newName) : newName;
                    ObjectPath theObjectPath = ModelFun.getObjectPath((BasicElement)basicElement);
                    ObjectPath objectPath = theObjectPath.parent;
                    ObjectPath newObjectPath = objectPath != null ? objectPath.append(newRealName, basicElement.getKind(), newNameIsQuoted, null) : null;
                    this.myHandler.include(newObjectPath);
                }
            }
        }

        private final void trackNamespaceRename(PsiElement element, String name) {
            if (!(element instanceof DasObject) || !this.myHandler.getDataSource().shouldTrackNamespaces()) {
                return;
            }
            this.scheduleIntrospectionScopeUpdate((DasObject)element, name);
        }

        private final void scheduleIntrospectionScopeUpdate(DasObject o, String newName) {
            if (o.getKind() == ObjectKind.SCHEMA || o.getKind() == ObjectKind.DATABASE) {
                ObjectPath old = ObjectPaths.of((DasObject)o);
                NamingService service = this.getNamingService(null);
                this.myHandler.getScopeUpdater().toRemove(old);
                ObjectPath newPath = ObjectPath.create((String)service.unquoteIdentifier(newName), (ObjectKind)old.kind, (boolean)service.isQuoted(newName), null, (ObjectPath)old.parent);
                this.myHandler.getScopeUpdater().toAdd(newPath);
            }
        }

        private final NamingService getNamingService(BasicDatabase database) {
            Dbms dbms = this.myHandler.getDataSource().getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            DasModel dasModel = this.myHandler.getDataSource().getModel();
            BasicModel model = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
            NamingService service = NamingServices.getNamingService((Dbms)dbms2, (BasicModel)model, (BasicDatabase)database);
            return service;
        }

        protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
            Intrinsics.checkNotNullParameter((Object)viewDescriptor, (String)"viewDescriptor");
            Intrinsics.checkNotNullParameter((Object)usageView, (String)"usageView");
            super.customizeUsagesView(viewDescriptor, usageView);
            JPanel scriptPanel = new JPanel(new BorderLayout());
            scriptPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
            JBCheckBox box = new JBCheckBox(DatabaseBundle.message((String)"execute.sql.script", (Object[])new Object[0]), this.myExecuteSql);
            box.addChangeListener(new ChangeListener(this, box){
                final /* synthetic */ MyRenameProcessor this$0;
                final /* synthetic */ JBCheckBox $box;
                {
                    this.this$0 = $receiver;
                    this.$box = $box;
                }

                public void stateChanged(ChangeEvent e) {
                    MyRenameProcessor.access$setMyExecuteSql$p(this.this$0, this.$box.isSelected());
                }
            });
            String string = DatabaseBundle.message((String)"open.in.console", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = DatabaseBundle.message((String)"open.in.file", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String string3 = ConsolesMigrationUtilsKt.resolveConsolesMigrationDependentString(string, string2);
            JButton manually2 = new JButton(new AbstractAction(this, box, string3){
                final /* synthetic */ MyRenameProcessor this$0;
                final /* synthetic */ JBCheckBox $box;
                {
                    this.this$0 = $receiver;
                    this.$box = $box;
                    super($super_call_param$1);
                }

                public void actionPerformed(ActionEvent e) {
                    if (MyRenameProcessor.access$getMyExcludedFile$p(this.this$0) == null) {
                        MyRenameProcessor.access$setMyExcludedFile$p(this.this$0, DbUIUtil.openInConsole(MyRenameProcessor.access$getMyHandler$p(this.this$0).getProject(), MyRenameProcessor.access$getMyHandler$p(this.this$0).getDataSource(), null, MyRenameProcessor.access$getMyHandler$p(this.this$0).getStatement(), false));
                    } else {
                        Project project = MyRenameProcessor.access$getMyHandler$p(this.this$0).getProject();
                        DasDataSource dasDataSource = (DasDataSource)MyRenameProcessor.access$getMyHandler$p(this.this$0).getDataSource();
                        VirtualFile virtualFile = MyRenameProcessor.access$getMyExcludedFile$p(this.this$0);
                        Intrinsics.checkNotNull((Object)virtualFile);
                        DbUIUtil.openInConsole(project, dasDataSource, virtualFile, MyRenameProcessor.access$getMyHandler$p(this.this$0).getStatement(), null);
                    }
                    this.$box.setSelected(false);
                }
            });
            scriptPanel.add((Component)box, "West");
            scriptPanel.add((Component)manually2, "East");
            usageView.setAdditionalComponent((JComponent)scriptPanel);
        }

        /*
         * Unable to fully structure code
         */
        protected void execute(@NotNull UsageInfo[] usages) {
            Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
            if (!this.myExecuteSql) ** GOTO lbl-1000
            v0 = DbRenamePsiElementProcessor.access$getOurRunStatementsHook$cp();
            if (!(v0 != null ? ((Boolean)v0.invoke((Object)this.myHandler.getStatement())).booleanValue() : false)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = executeInDb = false;
            }
            if (executeInDb) {
                $i$f$service = false;
                serviceClass$iv = DbScopeProvider.class;
                v2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (v2 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                this.myAsyncStarted = DbScopeProvider.launchWithModality$default((DbScopeProvider)((DbScopeProvider)v2), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, usages, null){
                    int label;
                    final /* synthetic */ MyRenameProcessor this$0;
                    final /* synthetic */ UsageInfo[] $usages;
                    {
                        this.this$0 = $receiver;
                        this.$usages = $usages;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.this$0.runStatements(this.$usages, (Continuation<? super Unit>)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
            } else {
                this.executeSqlRename(usages);
            }
        }

        private final void executeSqlRename(UsageInfo[] usages) {
            super.execute(usages);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        protected final Object runStatements(@NotNull UsageInfo[] usages, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof runStatements.1)) ** GOTO lbl-1000
            var4_3 = $completion;
            if ((var4_3.label & -2147483648) != 0) {
                var4_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ MyRenameProcessor this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.runStatements(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = usages;
                    $continuation.label = 1;
                    v0 = this.myHandler.runStatements(true, (Continuation<? super Boolean>)$continuation);
                    if (v0 == var5_5) {
                        return var5_5;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    usages = (UsageInfo[])$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)usages);
                    $continuation.label = 2;
                    v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, usages, null){
                        int label;
                        final /* synthetic */ MyRenameProcessor this$0;
                        final /* synthetic */ UsageInfo[] $usages;
                        {
                            this.this$0 = $receiver;
                            this.$usages = $usages;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    CommandProcessor.getInstance().runUndoTransparentAction(() -> runStatements.2.invokeSuspend$lambda$0(this.this$0, this.$usages));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }

                        private static final void invokeSuspend$lambda$0(MyRenameProcessor this$0, UsageInfo[] $usages) {
                            Project project = MyRenameProcessor.access$getMyProject$p$s687462280(this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"access$getMyProject$p$s687462280(...)");
                            AbstractDatabaseModifier.Companion.notifyImpossibilityOnUndo(project);
                            MyRenameProcessor.access$executeSqlRename(this$0, $usages);
                        }
                    }), (Continuation)$continuation);
                    if (v1 == var5_5) {
                        return var5_5;
                    }
                    ** GOTO lbl32
                }
                case 2: {
                    usages = (UsageInfo[])$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl32:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Nullable
        public final Job getAsyncStarted() {
            return this.myAsyncStarted;
        }

        @NotNull
        public UsageInfo[] findUsages() {
            UsageInfo[] usageInfoArray = super.findUsages();
            JBIterable jBIterable = JBIterable.of((Object[])Arrays.copyOf(usageInfoArray, usageInfoArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            JBIterable usages = jBIterable;
            if (this.myExcludedFile != null) {
                JBIterable jBIterable2 = usages.filter(arg_0 -> MyRenameProcessor.findUsages$lambda$1(arg_0 -> MyRenameProcessor.findUsages$lambda$0(this, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
                usages = jBIterable2;
            }
            List list = usages.toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            List res2 = list;
            Collection collection = res2;
            Intrinsics.checkNotNullExpressionValue((Object)UsageInfo.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return (UsageInfo[])UtilKt.toArray((Collection)collection, (Object[])UsageInfo.EMPTY_ARRAY);
        }

        private static final boolean findUsages$lambda$0(MyRenameProcessor this$0, UsageInfo it) {
            return !Intrinsics.areEqual((Object)it.getVirtualFile(), (Object)this$0.myExcludedFile);
        }

        private static final boolean findUsages$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ void access$setMyExecuteSql$p(MyRenameProcessor $this, boolean bl) {
            $this.myExecuteSql = bl;
        }

        public static final /* synthetic */ VirtualFile access$getMyExcludedFile$p(MyRenameProcessor $this) {
            return $this.myExcludedFile;
        }

        public static final /* synthetic */ void access$setMyExcludedFile$p(MyRenameProcessor $this, VirtualFile virtualFile) {
            $this.myExcludedFile = virtualFile;
        }

        public static final /* synthetic */ DatabaseRefactoringHandler access$getMyHandler$p(MyRenameProcessor $this) {
            return $this.myHandler;
        }

        public static final /* synthetic */ Project access$getMyProject$p$s687462280(MyRenameProcessor $this) {
            return $this.myProject;
        }

        public static final /* synthetic */ void access$executeSqlRename(MyRenameProcessor $this, UsageInfo[] usages) {
            $this.executeSqlRename(usages);
        }
    }
}

