/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.DbModelDumbTransactionManager;
import com.intellij.database.schemaEditor.DbModelTransactionManager;
import com.intellij.database.schemaEditor.DbObjectEditorBuilder;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelListener;
import com.intellij.database.schemaEditor.model.DbModelIdentity;
import com.intellij.database.schemaEditor.model.DbModelModifiedCache;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbObjectModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbStructureObjectModelApplier;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UnprotectedUserDataHolder;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DbEditorModelController
implements Disposable {
    private final Project myProject;
    private final DbObjectEditorBuilder myBuilder;
    private ElementOwner myActualOwner;
    private ElementMatcher myMatcher;
    private DbModelTransactionManager myTransactionManager;
    private Supplier<? extends ScriptingOptions> myScriptingOptions;
    private final ConcurrentMap<Object, ElementIdentity<?>> myFallbackIdCache;
    private final Map<DbModelIdentity<?, ?>, DbEditorModel<?, ?>> myAllModelsWeak;
    private final EventDispatcher<DbEditorModelListener> myEventDispatcher;
    private final DbModelModifiedCache myModifiedCache;
    private final ModalityState myModalityState;
    private final CoroutineScope myCoroutineScope;
    private final UserDataHolder myDataHolder;

    public DbEditorModelController(@NotNull Project project, @NotNull CoroutineScope coroutineScope, @NotNull ModalityState modalityState, @NotNull DbObjectEditorBuilder builder) {
        if (project == null) {
            DbEditorModelController.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            DbEditorModelController.$$$reportNull$$$0(1);
        }
        if (modalityState == null) {
            DbEditorModelController.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            DbEditorModelController.$$$reportNull$$$0(3);
        }
        this(project, coroutineScope, modalityState, builder, new ConcurrentHashMap(), new DbModelDumbTransactionManager());
    }

    private DbEditorModelController(@NotNull Project project, @NotNull CoroutineScope coroutineScope, @NotNull ModalityState modalityState, @NotNull DbObjectEditorBuilder builder, @NotNull ConcurrentMap<Object, ElementIdentity<?>> fallbackIdCache, @NotNull DbModelTransactionManager transactionManager) {
        if (project == null) {
            DbEditorModelController.$$$reportNull$$$0(4);
        }
        if (coroutineScope == null) {
            DbEditorModelController.$$$reportNull$$$0(5);
        }
        if (modalityState == null) {
            DbEditorModelController.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            DbEditorModelController.$$$reportNull$$$0(7);
        }
        if (fallbackIdCache == null) {
            DbEditorModelController.$$$reportNull$$$0(8);
        }
        if (transactionManager == null) {
            DbEditorModelController.$$$reportNull$$$0(9);
        }
        this.myScriptingOptions = () -> DefaultScriptingOptions.INSTANCE;
        this.myAllModelsWeak = CollectionFactory.createConcurrentWeakValueMap((m, hash, k) -> ((DbEditorModelListener)this.getEventDispatcher().getMulticaster()).forgotten((DbModelIdentity<?, ?>)k));
        this.myEventDispatcher = EventDispatcher.create(DbEditorModelListener.class);
        this.myProject = project;
        this.myBuilder = builder;
        this.myModalityState = modalityState;
        this.myModifiedCache = new DbModelModifiedCache(this);
        this.myDataHolder = new UnprotectedUserDataHolder();
        this.myTransactionManager = transactionManager;
        this.myCoroutineScope = coroutineScope;
        this.myFallbackIdCache = fallbackIdCache;
    }

    @NotNull
    public ModalityState getModalityState() {
        ModalityState modalityState = this.myModalityState;
        if (modalityState == null) {
            DbEditorModelController.$$$reportNull$$$0(10);
        }
        return modalityState;
    }

    @NotNull
    public DbEditorModelController copyEmpty(@NotNull Disposable parent2) {
        if (parent2 == null) {
            DbEditorModelController.$$$reportNull$$$0(11);
        }
        DbEditorModelController res2 = new DbEditorModelController(this.myProject, this.myCoroutineScope, this.myModalityState, this.myBuilder, this.myFallbackIdCache, this.myTransactionManager);
        Disposer.register((Disposable)parent2, (Disposable)res2);
        res2.setActualOwner(this.myActualOwner);
        res2.myMatcher = this.myMatcher;
        res2.myScriptingOptions = this.myScriptingOptions;
        DbEditorModelController dbEditorModelController = res2;
        if (dbEditorModelController == null) {
            DbEditorModelController.$$$reportNull$$$0(12);
        }
        return dbEditorModelController;
    }

    @NotNull
    public CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this.myCoroutineScope;
        if (coroutineScope == null) {
            DbEditorModelController.$$$reportNull$$$0(13);
        }
        return coroutineScope;
    }

    @NotNull
    public DbModelTransactionManager getTransactionManager() {
        DbModelTransactionManager dbModelTransactionManager = this.myTransactionManager;
        if (dbModelTransactionManager == null) {
            DbEditorModelController.$$$reportNull$$$0(14);
        }
        return dbModelTransactionManager;
    }

    public void setTransactionManager(@NotNull DbModelTransactionManager consistencyManager) {
        if (consistencyManager == null) {
            DbEditorModelController.$$$reportNull$$$0(15);
        }
        this.myTransactionManager = consistencyManager;
    }

    public void track(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbEditorModelController.$$$reportNull$$$0(16);
        }
        this.myAllModelsWeak.put(model.getModelIdentity(), model);
    }

    @NotNull
    public UserDataHolder getDataHolder() {
        UserDataHolder userDataHolder = this.myDataHolder;
        if (userDataHolder == null) {
            DbEditorModelController.$$$reportNull$$$0(17);
        }
        return userDataHolder;
    }

    @NotNull
    public DbModelModifiedCache getModifiedCache() {
        DbModelModifiedCache dbModelModifiedCache = this.myModifiedCache;
        if (dbModelModifiedCache == null) {
            DbEditorModelController.$$$reportNull$$$0(18);
        }
        return dbModelModifiedCache;
    }

    @NotNull
    public EventDispatcher<DbEditorModelListener> getEventDispatcher() {
        EventDispatcher<DbEditorModelListener> eventDispatcher = this.myEventDispatcher;
        if (eventDispatcher == null) {
            DbEditorModelController.$$$reportNull$$$0(19);
        }
        return eventDispatcher;
    }

    @Nullable
    public <E extends BasicElement, S extends DbModelState> DbEditorModel<E, S> resolveModel(@Nullable DbModelIdentity<E, S> modelId) {
        DbEditorModel<E, S> cachedModel = this.resolveRegisteredOrCachedModel(modelId);
        return cachedModel != null && !this.isModelRegistered(cachedModel) ? null : cachedModel;
    }

    @Nullable
    public <E extends BasicElement, S extends DbModelState> DbEditorModel<E, S> resolveRegisteredOrCachedModel(@Nullable DbModelIdentity<E, S> modelId) {
        return DbEditorModelController.resolveModelImpl(this.myAllModelsWeak, modelId);
    }

    @Nullable
    private static <E extends BasicElement, S extends DbModelState> DbEditorModel<E, S> resolveModelImpl(@NotNull Map<DbModelIdentity<?, ?>, DbEditorModel<?, ?>> models, @Nullable DbModelIdentity<E, S> modelId) {
        if (models == null) {
            DbEditorModelController.$$$reportNull$$$0(20);
        }
        if (modelId == null) {
            return null;
        }
        return models.get(modelId);
    }

    @Nullable
    public <S extends DbModelState> S resolveState(@Nullable ElementIdentity<?> id, @NotNull BasicMetaId modelKey, @NotNull Class<S> clazz) {
        if (modelKey == null) {
            DbEditorModelController.$$$reportNull$$$0(21);
        }
        if (clazz == null) {
            DbEditorModelController.$$$reportNull$$$0(22);
        }
        DbEditorModel model = id == null ? null : this.resolveModel(new DbModelIdentity(id, modelKey));
        Object state = model == null ? null : model.getState();
        return (S)((DbModelState)ObjectUtils.tryCast(state, clazz));
    }

    public boolean isModelRegistered(@Nullable DbEditorModel<?, ?> model) {
        return model != null && model.isRegistered();
    }

    public boolean isModelRegistered(@NotNull DbModelRef<?, ?> model) {
        if (model == null) {
            DbEditorModelController.$$$reportNull$$$0(23);
        }
        return this.isModelRegistered(model.resolveOpt(this));
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DbEditorModelController.$$$reportNull$$$0(24);
        }
        return project;
    }

    @NotNull
    public DbObjectEditorBuilder getBuilder() {
        DbObjectEditorBuilder dbObjectEditorBuilder = this.myBuilder;
        if (dbObjectEditorBuilder == null) {
            DbEditorModelController.$$$reportNull$$$0(25);
        }
        return dbObjectEditorBuilder;
    }

    @NotNull
    public Dbms getDbms(@NotNull ElementIdentity<?> identity) {
        if (identity == null) {
            DbEditorModelController.$$$reportNull$$$0(26);
        }
        Dbms dbms = this.getBuilder().getDbms(this, identity);
        if (dbms == null) {
            DbEditorModelController.$$$reportNull$$$0(27);
        }
        return dbms;
    }

    @NotNull
    public <E extends BasicElement> DbEditorModel<E, DbObjectModelState<E>> createObjectEditorModel(@NotNull ElementIdentity<E> id) {
        DbEditorModel<E, DbObjectModelState<E>> existing;
        if (id == null) {
            DbEditorModelController.$$$reportNull$$$0(28);
        }
        if ((existing = this.getObjectModel(id)) == null) {
            this.myBuilder.createObjectModel(this, id).register();
            existing = this.getObjectModel(id);
            if (existing == null) {
                throw new AssertionError((Object)("Object editor for " + String.valueOf(id) + " is not registered"));
            }
        }
        DbEditorModel<E, DbObjectModelState<E>> dbEditorModel = existing;
        if (dbEditorModel == null) {
            DbEditorModelController.$$$reportNull$$$0(29);
        }
        return dbEditorModel;
    }

    @NotNull
    public <E extends BasicElement> DbStructureObjectModelState<E> createStructureNodeModelState(@NotNull ElementIdentity<E> id) {
        if (id == null) {
            DbEditorModelController.$$$reportNull$$$0(30);
        }
        DbStructureObjectModelState<E> dbStructureObjectModelState = this.createStructureNodeModel(id).getState();
        if (dbStructureObjectModelState == null) {
            DbEditorModelController.$$$reportNull$$$0(31);
        }
        return dbStructureObjectModelState;
    }

    @NotNull
    public <E extends BasicElement> DbEditorModel<E, DbStructureObjectModelState<E>> createStructureNodeModel(@NotNull ElementIdentity<E> id) {
        DbEditorModel<E, DbStructureObjectModelState<E>> existing;
        if (id == null) {
            DbEditorModelController.$$$reportNull$$$0(32);
        }
        if ((existing = this.getStructureNodeModel(id)) == null) {
            this.myBuilder.createStructureNodeModel(this, id).register();
            existing = this.getStructureNodeModel(id);
            if (existing == null) {
                throw new AssertionError((Object)("Structure editor for " + String.valueOf(id) + " is not registered"));
            }
        }
        DbEditorModel<E, DbStructureObjectModelState<E>> dbEditorModel = existing;
        if (dbEditorModel == null) {
            DbEditorModelController.$$$reportNull$$$0(33);
        }
        return dbEditorModel;
    }

    @Nullable
    public <E extends BasicElement> DbObjectModelState<E> getObjectModelState(@NotNull ElementIdentity<E> id) {
        DbEditorModel<E, DbObjectModelState<E>> model;
        if (id == null) {
            DbEditorModelController.$$$reportNull$$$0(34);
        }
        return (model = this.getObjectModel(id)) == null ? null : model.getState();
    }

    @Nullable
    public <E extends BasicElement> DbEditorModel<E, DbObjectModelState<E>> getObjectModel(@NotNull ElementIdentity<E> id) {
        if (id == null) {
            DbEditorModelController.$$$reportNull$$$0(35);
        }
        return this.resolveModel(new DbModelIdentity(id, DbObjectModelApplier.ID));
    }

    @Nullable
    public <E extends BasicElement> DbStructureObjectModelState<E> getStructureNodeModelState(@NotNull ElementIdentity<E> id) {
        DbEditorModel<E, DbStructureObjectModelState<E>> model;
        if (id == null) {
            DbEditorModelController.$$$reportNull$$$0(36);
        }
        return (model = this.getStructureNodeModel(id)) == null ? null : model.getState();
    }

    public <E extends BasicElement> DbEditorModel<E, DbStructureObjectModelState<E>> getStructureNodeModel(@NotNull ElementIdentity<E> id) {
        if (id == null) {
            DbEditorModelController.$$$reportNull$$$0(37);
        }
        return this.resolveModel(new DbModelIdentity(id, DbStructureObjectModelApplier.ID));
    }

    public boolean isReadonly(@NotNull ElementIdentity<?> id) {
        DbDataSource dataSource;
        if (id == null) {
            DbEditorModelController.$$$reportNull$$$0(38);
        }
        return (dataSource = this.getDataSource(id)) != null && !dataSource.isWritable();
    }

    public void setActualOwner(@Nullable ElementOwner actualOwner) {
        this.myActualOwner = actualOwner;
    }

    @Nullable
    public ElementOwner getActualOwner() {
        return this.myActualOwner;
    }

    public <T> T accessActualOwner(@NotNull Function<@Nullable ElementOwner, T> accessor) {
        if (accessor == null) {
            DbEditorModelController.$$$reportNull$$$0(39);
        }
        return accessor.apply(this.myActualOwner);
    }

    public void setScriptingOptions(@NotNull Supplier<? extends ScriptingOptions> scriptingOptions) {
        if (scriptingOptions == null) {
            DbEditorModelController.$$$reportNull$$$0(40);
        }
        this.myScriptingOptions = scriptingOptions;
    }

    public void setElementMatcher(@NotNull ElementMatcher matcher) {
        if (matcher == null) {
            DbEditorModelController.$$$reportNull$$$0(41);
        }
        this.myMatcher = matcher;
    }

    @NotNull
    public ElementMatcher getMatcher() {
        ElementMatcher elementMatcher = this.myMatcher;
        if (elementMatcher == null) {
            DbEditorModelController.$$$reportNull$$$0(42);
        }
        return elementMatcher;
    }

    @Nullable
    public DbDataSource getDataSource(@Nullable ElementIdentity<?> id) {
        return id == null ? null : this.getBuilder().getDataSource(this, id);
    }

    public void dispose() {
    }

    @NotNull
    public ScriptingOptions getScriptingOptions() {
        ScriptingOptions scriptingOptions = this.myScriptingOptions.get();
        if (scriptingOptions == null) {
            DbEditorModelController.$$$reportNull$$$0(43);
        }
        return scriptingOptions;
    }

    public @Unmodifiable Set<DbModelRef<?, ?>> getAllModelsRefs() {
        return ContainerUtil.map2SetNotNull(this.myAllModelsWeak.values(), m -> this.isModelRegistered((DbEditorModel<?, ?>)m) ? new DbModelRef(m) : null);
    }

    public @Unmodifiable Collection<DbEditorModel<?, ?>> getAllModels() {
        return ContainerUtil.map2SetNotNull(this.myAllModelsWeak.values(), m -> this.isModelRegistered((DbEditorModel<?, ?>)m) ? m : null);
    }

    public <E extends BasicElement> void updateStructure(@NotNull ElementIdentity<E> targetId, boolean add) {
        DbStructureObjectModelState<E> state;
        ElementIdentity parent2;
        if (targetId == null) {
            DbEditorModelController.$$$reportNull$$$0(44);
        }
        if ((parent2 = this.getMatcher().getParent(targetId)) == null) {
            return;
        }
        DbStructureObjectModelState<E> dbStructureObjectModelState = state = this.getMatcher().getInlineMetaRef(targetId) != null ? null : this.getStructureNodeModelState(parent2);
        if (state == null) {
            DbEditorModel<E, DbObjectModelState<E>> objModel = this.createObjectEditorModel(targetId);
            objModel.getState().setDropped(!add);
            return;
        }
        if (add) {
            DbEditorModel<E, DbStructureObjectModelState<E>> model = this.getStructureNodeModel(targetId);
            if (model != null) {
                state.addChild(model);
            }
        } else {
            state.removeChild(this, targetId);
        }
    }

    public <E extends BasicElement, T extends BasicElement> ElementIdentity<T> getOrCreateFallbackIdentity(@NotNull ElementIdentity<E> identity, @NotNull BasicMetaReference<E, T> reference, @NotNull Supplier<ElementIdentity<T>> factory) {
        if (identity == null) {
            DbEditorModelController.$$$reportNull$$$0(45);
        }
        if (reference == null) {
            DbEditorModelController.$$$reportNull$$$0(46);
        }
        if (factory == null) {
            DbEditorModelController.$$$reportNull$$$0(47);
        }
        return this.myFallbackIdCache.computeIfAbsent(Pair.create(identity, reference), k -> (ElementIdentity)factory.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 13, 14, 17, 18, 19, 24, 25, 27, 29, 31, 33, 42, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackIdCache";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transactionManager";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DbEditorModelController";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consistencyManager";
                break;
            }
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelKey";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 26: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptingOptions";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetId";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DbEditorModelController";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityState";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "copyEmpty";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransactionManager";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataHolder";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedCache";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventDispatcher";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createObjectEditorModel";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructureNodeModelState";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructureNodeModel";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatcher";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptingOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 42: 
            case 43: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyEmpty";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setTransactionManager";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "track";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveModelImpl";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveState";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isModelRegistered";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDbms";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createObjectEditorModel";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createStructureNodeModelState";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createStructureNodeModel";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getObjectModelState";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getObjectModel";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getStructureNodeModelState";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getStructureNodeModel";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isReadonly";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "accessActualOwner";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setScriptingOptions";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setElementMatcher";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "updateStructure";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateFallbackIdentity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12, 13, 14, 17, 18, 19, 24, 25, 27, 29, 31, 33, 42, 43 -> new IllegalStateException(string);
        };
    }
}

