/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.statistic;

import com.intellij.database.Dbms;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.dbimport.DatabaseTableSource;
import com.intellij.database.dbimport.ImportIndicatorUpdater;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ObjectsSource;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.csv.CsvSource;
import com.intellij.database.dbimport.editor.DbImportDialog;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.statistic.DatabaseUsagesCollectors;
import com.intellij.database.statistic.DbFusImportLoggerKt;
import com.intellij.database.statistic.DialogActivity;
import com.intellij.database.statistic.Result;
import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.RoundedLongEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0013\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J&\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/database/statistic/ImportActivity;", "", "dialogActivity", "Lcom/intellij/database/statistic/DialogActivity;", "fakeDialog", "", "<init>", "(Lcom/intellij/database/statistic/DialogActivity;Z)V", "(Lcom/intellij/database/statistic/DialogActivity;)V", "getDialogActivity", "()Lcom/intellij/database/statistic/DialogActivity;", "getFakeDialog", "()Z", "activity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "started", "", "project", "Lcom/intellij/openapi/project/Project;", "logSourceSettings", "source", "Lcom/intellij/database/dbimport/ReaderTask$Source;", "logCsvSettings", "Lcom/intellij/database/dbimport/csv/CsvSource;", "escapeSeparator", "", "valueSeparator", "finished", "updater", "Lcom/intellij/database/dbimport/ImportIndicatorUpdater;", "info", "Lcom/intellij/database/dbimport/ImportInfo;", "result", "Lcom/intellij/database/statistic/Result;", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbFusImportLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbFusImportLogger.kt\ncom/intellij/database/statistic/ImportActivity\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,292:1\n261#2,3:293\n261#2,3:296\n261#2,3:299\n*S KotlinDebug\n*F\n+ 1 DbFusImportLogger.kt\ncom/intellij/database/statistic/ImportActivity\n*L\n101#1:293,3\n102#1:296,3\n144#1:299,3\n*E\n"})
final class ImportActivity {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final DialogActivity dialogActivity;
    private final boolean fakeDialog;
    private StructuredIdeActivity activity;
    @NotNull
    private static final LongEventField IMPORT_ID;
    @NotNull
    private static final DatabaseUsagesCollectors.DbmsEventField DBMS;
    @NotNull
    private static final EnumEventField<Result> RESULT;
    @NotNull
    private static final EnumEventField<Companion.SourceType> SOURCE_TYPE;
    @NotNull
    private static final RoundedLongEventField SOURCE_SIZE;
    @NotNull
    private static final BooleanEventField EXISTING_TABLE;
    @NotNull
    private static final LongEventField READ_TIME;
    @NotNull
    private static final LongEventField INSERT_TIME;
    @NotNull
    private static final RoundedLongEventField RECORDS;
    @NotNull
    private static final RoundedLongEventField INVALID_RECORDS;
    @NotNull
    private static final IdeActivityDefinition IMPORT_ACTIVITY;
    @NotNull
    private static final String SEPARATOR_CHECKER = "\\\\[nt]|[,;|]|<space>|\\|\\|";
    @NotNull
    private static final StringEventField VALUE_SEPARATOR;
    @NotNull
    private static final StringEventField RECORD_SEPARATOR;
    @NotNull
    private static final BooleanEventField FIRST_COLUMN_IS_HEADER;
    @NotNull
    private static final EnumEventField<Companion.RowHeaderState> FIRST_ROW_IS_HEADER;
    @NotNull
    private static final VarargEventId CSV_IMPORT_EVENT;

    public ImportActivity(@NotNull DialogActivity dialogActivity, boolean fakeDialog) {
        Intrinsics.checkNotNullParameter((Object)dialogActivity, (String)"dialogActivity");
        this.dialogActivity = dialogActivity;
        this.fakeDialog = fakeDialog;
    }

    @NotNull
    public final DialogActivity getDialogActivity() {
        return this.dialogActivity;
    }

    public final boolean getFakeDialog() {
        return this.fakeDialog;
    }

    public ImportActivity(@Nullable DialogActivity dialogActivity) {
        DialogActivity dialogActivity2 = dialogActivity;
        if (dialogActivity2 == null) {
            dialogActivity2 = new DialogActivity();
        }
        this(dialogActivity2, dialogActivity == null);
    }

    public final void started(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.fakeDialog) {
            this.dialogActivity.started(project, DbImportDialog.InvocationType.NO_DIALOG);
        }
        this.dialogActivity.ref();
        this.activity = IdeActivityDefinition.startedWithParent$default((IdeActivityDefinition)IMPORT_ACTIVITY, (Project)project, (StructuredIdeActivity)this.dialogActivity.getActivity(), null, (int)4, null);
    }

    private final void logSourceSettings(ReaderTask.Source source) {
        if (source instanceof CsvSource) {
            this.logCsvSettings((CsvSource)source);
        }
    }

    private final void logCsvSettings(CsvSource source) {
        StructuredIdeActivity structuredIdeActivity = this.activity;
        if (structuredIdeActivity == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activity");
            structuredIdeActivity = null;
        }
        structuredIdeActivity.stageStarted(CSV_IMPORT_EVENT, () -> ImportActivity.logCsvSettings$lambda$0(this, source));
    }

    private final String escapeSeparator(String valueSeparator) {
        String string = StringUtil.escapeStringCharacters((String)valueSeparator);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeStringCharacters(...)");
        return StringsKt.replace$default((String)string, (String)" ", (String)"<space>", (boolean)false, (int)4, null);
    }

    public final void finished(@NotNull ImportIndicatorUpdater updater, @NotNull ImportInfo info2, @NotNull ReaderTask.Source source, @NotNull Result result2) {
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        this.logSourceSettings(source);
        DbDataSource dbDataSource = info2.getContext().getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
        DbDataSource targetSource = dbDataSource;
        CsvSource csvSource = source instanceof CsvSource ? (CsvSource)source : null;
        StructuredIdeActivity structuredIdeActivity = this.activity;
        if (structuredIdeActivity == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activity");
            structuredIdeActivity = null;
        }
        structuredIdeActivity.finished(() -> ImportActivity.finished$lambda$0(targetSource, source, csvSource, info2, result2, updater));
        this.dialogActivity.deref();
        if (this.fakeDialog) {
            this.dialogActivity.closed(true);
        }
    }

    private static final List logCsvSettings$lambda$0(ImportActivity this$0, CsvSource $source) {
        Object[] objectArray = new EventPair[4];
        String string = $source.getFormat().dataRecord.valueSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"valueSeparator");
        objectArray[0] = VALUE_SEPARATOR.with((Object)this$0.escapeSeparator(string));
        String string2 = $source.getFormat().dataRecord.recordSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"recordSeparator");
        objectArray[1] = RECORD_SEPARATOR.with((Object)this$0.escapeSeparator(string2));
        objectArray[2] = FIRST_COLUMN_IS_HEADER.with((Object)$source.getFormat().rowNumbers);
        CsvFormat csvFormat = $source.getFormat();
        Intrinsics.checkNotNullExpressionValue((Object)csvFormat, (String)"getFormat(...)");
        objectArray[3] = FIRST_ROW_IS_HEADER.with((Object)Companion.RowHeaderState.NO_HEADER.get(csvFormat));
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final List finished$lambda$0(DbDataSource $targetSource, ReaderTask.Source $source, CsvSource $csvSource, ImportInfo $info, Result $result, ImportIndicatorUpdater $updater) {
        Object[] objectArray = new EventPair[11];
        DbDataSource dbDataSource = $targetSource;
        if (dbDataSource == null || (dbDataSource = dbDataSource.getDbms()) == null) {
            dbDataSource = Dbms.UNKNOWN;
        }
        objectArray[0] = DBMS.with(dbDataSource);
        Object object = $targetSource;
        if (object == null || (object = object.getVersion()) == null || (object = object.toString()) == null) {
            object = "0";
        }
        objectArray[1] = EventFields.Version.with(object);
        objectArray[2] = SOURCE_TYPE.with((Object)Companion.SourceType.UNKNOWN.get($source));
        CsvSource csvSource = $csvSource;
        objectArray[3] = SOURCE_SIZE.with((Object)(csvSource != null ? csvSource.getSizeInBytes() : -1L));
        objectArray[4] = EXISTING_TABLE.with((Object)$info.getType().tableExists());
        objectArray[5] = RESULT.with((Object)$result);
        objectArray[6] = INSERT_TIME.with((Object)$updater.getInsertingTime());
        objectArray[7] = READ_TIME.with((Object)$updater.getReadingTime());
        objectArray[8] = RECORDS.with((Object)$updater.getLines());
        objectArray[9] = INVALID_RECORDS.with((Object)$updater.getFailedLines());
        objectArray[10] = SOURCE_SIZE.with((Object)((long)$updater.size()));
        return CollectionsKt.listOf((Object[])objectArray);
    }

    static {
        EventFields $this$iv;
        Companion = new Companion(null);
        IMPORT_ID = EventFields.Long$default((String)"import_id", null, (int)2, null);
        DBMS = new DatabaseUsagesCollectors.DbmsEventField("dbms");
        EventField[] eventFieldArray = EventFields.INSTANCE;
        String name$iv = "result";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        RESULT = new EnumEventField(name$iv, Result.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "source_type";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        SOURCE_TYPE = new EnumEventField(name$iv, Companion.SourceType.class, null, transform$iv);
        SOURCE_SIZE = EventFields.RoundedLong$default((String)"source_size", null, (int)2, null);
        EXISTING_TABLE = EventFields.Boolean((String)"existing_table");
        READ_TIME = EventFields.Long$default((String)"read_time_ms", null, (int)2, null);
        INSERT_TIME = EventFields.Long$default((String)"insert_time_ms", null, (int)2, null);
        RECORDS = EventFields.RoundedLong$default((String)"records", null, (int)2, null);
        INVALID_RECORDS = EventFields.RoundedLong$default((String)"invalid_records", null, (int)2, null);
        $this$iv = new EventFields[]{DBMS, EventFields.Version, SOURCE_TYPE, SOURCE_SIZE, EXISTING_TABLE, READ_TIME, INSERT_TIME, RECORDS, INVALID_RECORDS, RESULT, SOURCE_SIZE};
        IMPORT_ACTIVITY = DbFusImportLoggerKt.access$getGROUP$p().registerIdeActivity("import", new EventField[0], (EventField[])$this$iv, DialogActivity.Companion.getIMPORT_DIALOG_ACTIVITY(), true);
        VALUE_SEPARATOR = EventFields.StringValidatedByInlineRegexp((String)"value_separator", (String)SEPARATOR_CHECKER);
        RECORD_SEPARATOR = EventFields.StringValidatedByInlineRegexp((String)"record_separator", (String)SEPARATOR_CHECKER);
        FIRST_COLUMN_IS_HEADER = EventFields.Boolean((String)"first_column_is_header");
        $this$iv = EventFields.INSTANCE;
        name$iv = "first_row_is_header";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        FIRST_ROW_IS_HEADER = new EnumEventField(name$iv, Companion.RowHeaderState.class, null, transform$iv);
        eventFieldArray = new EventField[]{IMPORT_ID, VALUE_SEPARATOR, RECORD_SEPARATOR, FIRST_ROW_IS_HEADER, FIRST_COLUMN_IS_HEADER};
        CSV_IMPORT_EVENT = IMPORT_ACTIVITY.registerStage("csv.import.parameters", eventFieldArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002#$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/database/statistic/ImportActivity$Companion;", "", "<init>", "()V", "IMPORT_ID", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "DBMS", "Lcom/intellij/database/statistic/DatabaseUsagesCollectors$DbmsEventField;", "RESULT", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/database/statistic/Result;", "SOURCE_TYPE", "Lcom/intellij/database/statistic/ImportActivity$Companion$SourceType;", "SOURCE_SIZE", "Lcom/intellij/internal/statistic/eventLog/events/RoundedLongEventField;", "EXISTING_TABLE", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "READ_TIME", "INSERT_TIME", "RECORDS", "INVALID_RECORDS", "IMPORT_ACTIVITY", "Lcom/intellij/internal/statistic/IdeActivityDefinition;", "getIMPORT_ACTIVITY", "()Lcom/intellij/internal/statistic/IdeActivityDefinition;", "SEPARATOR_CHECKER", "", "VALUE_SEPARATOR", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "RECORD_SEPARATOR", "FIRST_COLUMN_IS_HEADER", "FIRST_ROW_IS_HEADER", "Lcom/intellij/database/statistic/ImportActivity$Companion$RowHeaderState;", "CSV_IMPORT_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "SourceType", "RowHeaderState", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IdeActivityDefinition getIMPORT_ACTIVITY() {
            return IMPORT_ACTIVITY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\n"}, d2={"Lcom/intellij/database/statistic/ImportActivity$Companion$RowHeaderState;", "", "<init>", "(Ljava/lang/String;I)V", "NO_HEADER", "AS_DATA_ROW", "SEPARATE", "get", "format", "Lcom/intellij/database/csv/CsvFormat;", "intellij.database.impl"})
        private static final class RowHeaderState
        extends Enum<RowHeaderState> {
            public static final /* enum */ RowHeaderState NO_HEADER = new RowHeaderState();
            public static final /* enum */ RowHeaderState AS_DATA_ROW = new RowHeaderState();
            public static final /* enum */ RowHeaderState SEPARATE = new RowHeaderState();
            private static final /* synthetic */ RowHeaderState[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            @NotNull
            public final RowHeaderState get(@NotNull CsvFormat format) {
                Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                CsvRecordFormat csvRecordFormat = format.headerRecord;
                return csvRecordFormat == null ? NO_HEADER : (Intrinsics.areEqual((Object)csvRecordFormat, (Object)format.dataRecord) ? AS_DATA_ROW : SEPARATE);
            }

            public static RowHeaderState[] values() {
                return (RowHeaderState[])$VALUES.clone();
            }

            public static RowHeaderState valueOf(String value) {
                return Enum.valueOf(RowHeaderState.class, value);
            }

            @NotNull
            public static EnumEntries<RowHeaderState> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = rowHeaderStateArray = new RowHeaderState[]{RowHeaderState.NO_HEADER, RowHeaderState.AS_DATA_ROW, RowHeaderState.SEPARATE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/statistic/ImportActivity$Companion$SourceType;", "", "<init>", "(Ljava/lang/String;I)V", "CSV", "DATABASE", "CACHE", "UNKNOWN", "get", "source", "Lcom/intellij/database/dbimport/ReaderTask$Source;", "intellij.database.impl"})
        private static final class SourceType
        extends Enum<SourceType> {
            public static final /* enum */ SourceType CSV = new SourceType();
            public static final /* enum */ SourceType DATABASE = new SourceType();
            public static final /* enum */ SourceType CACHE = new SourceType();
            public static final /* enum */ SourceType UNKNOWN = new SourceType();
            private static final /* synthetic */ SourceType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            @NotNull
            public final SourceType get(@NotNull ReaderTask.Source source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                ReaderTask.Source source2 = source;
                return source2 instanceof CsvSource ? CSV : (source2 instanceof DatabaseTableSource ? DATABASE : (source2 instanceof ObjectsSource ? CACHE : UNKNOWN));
            }

            public static SourceType[] values() {
                return (SourceType[])$VALUES.clone();
            }

            public static SourceType valueOf(String value) {
                return Enum.valueOf(SourceType.class, value);
            }

            @NotNull
            public static EnumEntries<SourceType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = sourceTypeArray = new SourceType[]{SourceType.CSV, SourceType.DATABASE, SourceType.CACHE, SourceType.UNKNOWN};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

