/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.explorer.structure.DvTreeStructure;
import com.intellij.database.explorer.structure.DvTreeStructureService;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.JBIterable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u0017J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u0019\u001a\u00020\u0017J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u0001J\u0010\u0010!\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\"\u001a\u00020\u0017J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000b\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lcom/intellij/database/view/DatabaseNavBarService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "dv", "Lcom/intellij/database/view/DatabaseView;", "getDv", "()Lcom/intellij/database/view/DatabaseView;", "dv$delegate", "Lkotlin/Lazy;", "treeStructure", "Lcom/intellij/database/explorer/structure/DvTreeStructure;", "getTreeStructure", "()Lcom/intellij/database/explorer/structure/DvTreeStructure;", "treeStructure$delegate", "wrappingService", "Lcom/intellij/database/view/DatabaseNodeWrappingService;", "getWrappingService", "()Lcom/intellij/database/view/DatabaseNodeWrappingService;", "wrappingService$delegate", "getLeafElement", "Lcom/intellij/psi/PsiElement;", "getParent", "wrapper", "getChildren", "Lkotlin/sequences/Sequence;", "getNodeParent", "node", "Lcom/intellij/database/model/basic/BasicNode;", "getNodeChildren", "wrap", "unwrap", "w", "getNodeDisplayText", "", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseNavBarService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseNavBarService.kt\ncom/intellij/database/view/DatabaseNavBarService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,80:1\n30#2,2:81\n30#2,2:83\n*S KotlinDebug\n*F\n+ 1 DatabaseNavBarService.kt\ncom/intellij/database/view/DatabaseNavBarService\n*L\n22#1:81,2\n23#1:83,2\n*E\n"})
public final class DatabaseNavBarService {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy dv$delegate;
    @NotNull
    private final Lazy treeStructure$delegate;
    @NotNull
    private final Lazy wrappingService$delegate;
    @Deprecated
    public static final int nameTextLimit = 40;

    public DatabaseNavBarService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.dv$delegate = LazyKt.lazy(() -> DatabaseNavBarService.dv_delegate$lambda$0(this));
        this.treeStructure$delegate = LazyKt.lazy(() -> DatabaseNavBarService.treeStructure_delegate$lambda$0(this));
        this.wrappingService$delegate = LazyKt.lazy(() -> DatabaseNavBarService.wrappingService_delegate$lambda$0(this));
    }

    private final DatabaseView getDv() {
        Lazy lazy = this.dv$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (DatabaseView)object;
    }

    private final DvTreeStructure getTreeStructure() {
        Lazy lazy = this.treeStructure$delegate;
        return (DvTreeStructure)lazy.getValue();
    }

    private final DatabaseNodeWrappingService getWrappingService() {
        Lazy lazy = this.wrappingService$delegate;
        return (DatabaseNodeWrappingService)lazy.getValue();
    }

    @Nullable
    public final PsiElement getLeafElement() {
        JBIterable<BasicNode> jBIterable = this.getDv().getSelectedNodes();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getSelectedNodes(...)");
        JBIterable<BasicNode> selectedNodes = jBIterable;
        BasicNode basicNode = (BasicNode)selectedNodes.single();
        if (basicNode == null) {
            return null;
        }
        BasicNode selectedNode = basicNode;
        return this.wrap(selectedNode);
    }

    @Nullable
    public final PsiElement getParent(@NotNull PsiElement wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        BasicNode basicNode = this.unwrap(wrapper);
        if (basicNode == null) {
            return null;
        }
        BasicNode node = basicNode;
        Object object = this.getNodeParent(node);
        if (object == null) {
            return null;
        }
        Object parent2 = object;
        PsiElement parentWrapper = this.wrap(parent2);
        return parentWrapper;
    }

    @NotNull
    public final Sequence<PsiElement> getChildren(@NotNull PsiElement wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        BasicNode basicNode = this.unwrap(wrapper);
        if (basicNode == null) {
            return SequencesKt.emptySequence();
        }
        BasicNode node = basicNode;
        return SequencesKt.mapNotNull(this.getNodeChildren(node), (Function1)((Function1)new Function1<Object, PsiElement>((Object)this){

            public final PsiElement invoke(Object p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DatabaseNavBarService)this.receiver).wrap(p0);
            }
        }));
    }

    private final Object getNodeParent(BasicNode node) {
        return this.getTreeStructure().parentOf(node);
    }

    private final Sequence<BasicNode> getNodeChildren(BasicNode node) {
        return this.getTreeStructure().childrenOf(node);
    }

    @Nullable
    public final PsiElement wrap(@NotNull Object node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object object = node;
        return object instanceof BasicNode ? this.getWrappingService().wrap((BasicNode)node) : (object instanceof PsiElement ? (PsiElement)node : null);
    }

    @Nullable
    public final BasicNode unwrap(@NotNull PsiElement w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        return this.getWrappingService().unwrap(w);
    }

    @Nls
    @NotNull
    public final String getNodeDisplayText(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String text = this.getTreeStructure().presentableNameOf(node);
        if (text.length() > 40) {
            String string = StringUtil.shortenTextWithEllipsis((String)text, (int)40, (int)10, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            text = string;
        }
        return text;
    }

    private static final DatabaseView dv_delegate$lambda$0(DatabaseNavBarService this$0) {
        return DatabaseView.getDatabaseView(this$0.project);
    }

    private static final DvTreeStructureService treeStructure_delegate$lambda$0(DatabaseNavBarService this$0) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DvTreeStructureService)object;
    }

    private static final DatabaseNodeWrappingService wrappingService_delegate$lambda$0(DatabaseNavBarService this$0) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<DatabaseNodeWrappingService> serviceClass$iv = DatabaseNodeWrappingService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DatabaseNodeWrappingService)object;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/view/DatabaseNavBarService$Companion;", "", "<init>", "()V", "nameTextLimit", "", "intellij.database.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

