/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewPanel;
import com.intellij.database.view.DatabaseViewService;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.util.ModalityUiUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/view/DatabaseViewDesktopService;", "Lcom/intellij/database/view/DatabaseViewService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "navigateToNode", "", "node", "Lcom/intellij/database/model/basic/BasicNode;", "focus", "", "refreshTree", "nodesToSelect", "", "intellij.database.impl"})
public final class DatabaseViewDesktopService
implements DatabaseViewService {
    @NotNull
    private final Project project;

    public DatabaseViewDesktopService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void navigateToNode(@NotNull BasicNode node, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DatabaseViewPanel panel2 = DatabaseView.getDatabaseView(this.project).getPanelIfAny();
        if (panel2 != null) {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> DatabaseViewDesktopService.navigateToNode$lambda$0(panel2, node, focus));
        }
    }

    public void refreshTree(boolean focus, @Nullable Collection<? extends BasicNode> nodesToSelect) {
        DatabaseViewPanel panel2 = DatabaseView.getDatabaseView(this.project).getPanelIfAny();
        if (panel2 != null) {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> DatabaseViewDesktopService.refreshTree$lambda$0(panel2, nodesToSelect, focus));
        }
    }

    private static final void navigateToNode$lambda$0(DatabaseViewPanel $panel, BasicNode $node, boolean $focus) {
        $panel.selectNode($node, $focus);
    }

    private static final void refreshTree$lambda$0(DatabaseViewPanel $panel, Collection $nodesToSelect, boolean $focus) {
        $panel.refreshView();
        if ($nodesToSelect != null) {
            $panel.selectNodes($nodesToSelect, $focus, false);
        }
        if ($focus) {
            $panel.getTree().requestFocus();
        }
    }
}

