/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.actions.DataSourceSettingsHelperKt;
import com.intellij.database.actions.ddl.CreateObjectAction;
import com.intellij.database.actions.ddl.CreateObjectActionHelper;
import com.intellij.database.actions.ddl.CreateObjectGroup;
import com.intellij.database.actions.ddl.DbModifyObjectDialog;
import com.intellij.database.actions.ddl.DbModifyObjectDialogPanel;
import com.intellij.database.dbimport.editor.DbImportDialog;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasObjectFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaFunKt;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbObject;
import com.intellij.database.schemaEditor.DbObjectEditorBuilder;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiElement;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/view/DbElementPasteProvider;", "", "<init>", "()V", "getDbObjects", "", "Lcom/intellij/database/psi/DbObject;", "canPasteElement", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getParent", "Lcom/intellij/database/model/basic/BasicElement;", "kind", "Lcom/intellij/database/model/ObjectKind;", "getParentKind", "elements", "tryPasteElement", "CloneBootstrapper", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbElementPasteProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbElementPasteProvider.kt\ncom/intellij/database/view/DbElementPasteProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n11705#2:159\n12052#2,3:160\n1#3:163\n1#3:175\n1642#4,10:164\n1915#4:174\n1916#4:176\n1652#4:177\n*S KotlinDebug\n*F\n+ 1 DbElementPasteProvider.kt\ncom/intellij/database/view/DbElementPasteProvider\n*L\n37#1:159\n37#1:160,3\n71#1:175\n71#1:164,10\n71#1:174\n71#1:176\n71#1:177\n*E\n"})
public final class DbElementPasteProvider {
    @NotNull
    public static final DbElementPasteProvider INSTANCE = new DbElementPasteProvider();

    private DbElementPasteProvider() {
    }

    /*
     * WARNING - void declaration
     */
    private final List<DbObject> getDbObjects() {
        List list;
        void $this$mapTo$iv$iv;
        PsiElement[] elements;
        Transferable transferable = DataSourceSettingsHelperKt.getTransferableFromClipboard();
        if (transferable == null) {
            return null;
        }
        Transferable t = transferable;
        PsiElement[] psiElementArray = PsiCopyPasteManager.getElements((Transferable)t);
        if (psiElementArray == null) {
            return null;
        }
        PsiElement[] $this$map$iv = elements = psiElementArray;
        boolean $i$f$map = false;
        PsiElement[] psiElementArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_13 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!(it instanceof DbObject)) {
                return null;
            }
            collection.add((DbObject)it);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        return !((Collection)it).isEmpty() ? list : null;
    }

    public final boolean canPasteElement(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        List<DbObject> list = this.getDbObjects();
        if (list == null) {
            return false;
        }
        List<DbObject> elements = list;
        ObjectKind kind = this.getParentKind(elements);
        if (kind == null) {
            return false;
        }
        return this.getParent(dataContext, kind) != null;
    }

    private final BasicElement getParent(DataContext dataContext, ObjectKind kind) {
        DasObject dasObject;
        BasicElement basicElement = DatabaseContextFun.getSelectedSingleElement(dataContext);
        if (basicElement != null) {
            BasicElement it = basicElement;
            boolean bl = false;
            dasObject = DasUtil.getParentOfKind((DasObject)((DasObject)it), (ObjectKind)kind, (boolean)false);
        } else {
            dasObject = null;
        }
        DasObject dasObject2 = dasObject;
        return dasObject2 instanceof BasicElement ? (BasicElement)dasObject2 : null;
    }

    private final ObjectKind getParentKind(List<? extends DbObject> elements) {
        return (ObjectKind)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)elements), DbElementPasteProvider::getParentKind$lambda$0)));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryPasteElement(@NotNull DataContext dataContext) {
        List list;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        List<DbObject> list2 = this.getDbObjects();
        if (list2 == null) {
            return false;
        }
        List<DbObject> elements = list2;
        ObjectKind kind = this.getParentKind(elements);
        if (kind == null) {
            return false;
        }
        DataSourceNode dsn = DatabaseContextFun.getSelectionRelatedSingleDataSource(dataContext);
        if (dsn == null) {
            return false;
        }
        BasicElement basicElement = this.getParent(dataContext, kind);
        if (basicElement == null) {
            return false;
        }
        BasicElement parent2 = basicElement;
        BasicNamespace currentNamespace = CreateObjectAction.getCurrentNamespace((DasDataSource)dsn.dataSource, (BasicObjectNode)parent2);
        Project project = elements.get(0).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        BasicModel basicModel = parent2.getModel();
        Intrinsics.checkNotNull((Object)basicModel);
        Iterable iterable = elements;
        BasicObjectNode basicObjectNode = (BasicObjectNode)parent2;
        BasicModel basicModel2 = basicModel;
        Project project2 = project;
        boolean $i$f$mapNotNull = false;
        void var10_12 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BasicElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DbObject it = (DbObject)element$iv$iv;
            boolean bl2 = false;
            if (DasObjectFun.getBasicElement((DbElement)((DbElement)it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = list = (List)destination$iv$iv;
        BasicObjectNode basicObjectNode2 = basicObjectNode;
        BasicModel basicModel3 = basicModel2;
        Project project3 = project2;
        CloneBootstrapper bootstrapper = new CloneBootstrapper(project3, basicModel3, basicObjectNode2, list3);
        DbImportDialog.Companion.withCoroutineScopeBoundToDialog((Function1<? super CoroutineScope, ? extends DialogWrapper>)((Function1)arg_0 -> DbElementPasteProvider.tryPasteElement$lambda$1(bootstrapper, dsn, currentNamespace, arg_0)));
        return true;
    }

    private static final ObjectKind getParentKind$lambda$0(DbObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDasParent().getKind();
    }

    private static final DialogWrapper tryPasteElement$lambda$1(CloneBootstrapper $bootstrapper, DataSourceNode $dsn, BasicNamespace $currentNamespace, CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        DbModifyObjectDialog dialog = new DbModifyObjectDialog(cs, $bootstrapper, $dsn.dataSource, ObjectPaths.searchPathOf((DasObject)((DasObject)$currentNamespace)), null);
        dialog.initAndShow();
        return dialog;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J8\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002JZ\u0010\u0012\u001a\n\u0012\u0004\u0012\u0002H\u0017\u0018\u00010\r\"\b\b\u0000\u0010\u0017*\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002JR\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00170\r\"\b\b\u0000\u0010\u0017*\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00112\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001b2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020&2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\rH\u0014J\b\u0010(\u001a\u00020)H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/database/view/DbElementPasteProvider$CloneBootstrapper;", "Lcom/intellij/database/actions/ddl/DbModifyObjectDialogPanel$ObjectEditorBootstrapper;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "myParent", "Lcom/intellij/database/model/basic/BasicObjectNode;", "mySources", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicObjectNode;Ljava/util/List;)V", "createTargetId", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "matcher", "Lcom/intellij/database/schemaEditor/ElementMatcher;", "targetOwner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "createSources", "targetParentId", "sources", "recursive", "", "E", "Lcom/intellij/database/model/basic/BasicElement;", "", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "baseIdx", "", "createObject", "owner", "source", "position", "", "createEditorModelImpl", "Lcom/intellij/database/schemaEditor/model/DbEditorModel;", "controller", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "targetId", "createEditorBuilder", "Lcom/intellij/database/schemaEditor/DbObjectEditorBuilder;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbElementPasteProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbElementPasteProvider.kt\ncom/intellij/database/view/DbElementPasteProvider$CloneBootstrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,158:1\n1512#2:159\n1538#2,3:160\n1541#2,3:170\n383#3,7:163\n221#4,2:173\n*S KotlinDebug\n*F\n+ 1 DbElementPasteProvider.kt\ncom/intellij/database/view/DbElementPasteProvider$CloneBootstrapper\n*L\n101#1:159\n101#1:160,3\n101#1:170,3\n101#1:163,7\n101#1:173,2\n*E\n"})
    private static final class CloneBootstrapper
    extends DbModifyObjectDialogPanel.ObjectEditorBootstrapper {
        @NotNull
        private final BasicObjectNode myParent;
        @NotNull
        private final List<BasicObjectNode> mySources;

        public CloneBootstrapper(@NotNull Project project, @NotNull BasicModel model, @NotNull BasicObjectNode myParent, @NotNull List<? extends BasicObjectNode> mySources) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)myParent, (String)"myParent");
            Intrinsics.checkNotNullParameter(mySources, (String)"mySources");
            super(project, model, null);
            this.myParent = myParent;
            this.mySources = mySources;
        }

        @Override
        @NotNull
        public ElementIdentity<?> createTargetId(@NotNull ElementMatcher matcher, @NotNull ElementOwner targetOwner) {
            Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
            Intrinsics.checkNotNullParameter((Object)targetOwner, (String)"targetOwner");
            boolean hasStructuredEditor = this.getModelController().getBuilder().hasStructuredEditor(this.myParent.getMetaObject());
            ElementOwner elementOwner = matcher.getOriginalOwner();
            Intrinsics.checkNotNull((Object)elementOwner);
            ElementIdentity<?> targetParentId = this.pull(elementOwner, this.myParent);
            List sources = !hasStructuredEditor ? CollectionsKt.take((Iterable)this.mySources, (int)1) : this.mySources;
            ElementIdentity<?> targetId = this.createSources(targetOwner, targetParentId, sources, hasStructuredEditor || this.getModelController().getBuilder().hasStructuredEditor(this.mySources.get(0).getMetaObject()));
            ElementIdentity<?> elementIdentity = targetId;
            if (elementIdentity == null) {
                elementIdentity = targetParentId;
            }
            return elementIdentity;
        }

        /*
         * WARNING - void declaration
         */
        private final ElementIdentity<?> createSources(ElementOwner targetOwner, ElementIdentity<?> targetParentId, List<? extends BasicObjectNode> sources, boolean recursive) {
            void $this$forEach$iv;
            void $this$groupByTo$iv$iv;
            Ref.ObjectRef targetId = new Ref.ObjectRef();
            Object $this$groupBy$iv = sources;
            boolean $i$f$groupBy = false;
            Object object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                void $this$getOrPut$iv$iv$iv;
                BasicObjectNode it = (BasicObjectNode)element$iv$iv;
                boolean bl = false;
                ObjectKind key$iv$iv = it.getMetaObject().kind;
                Map map2 = destination$iv$iv;
                ObjectKind key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                ElementIdentity elementIdentity;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                ObjectKind kind = (ObjectKind)entry.getKey();
                List kSources = (List)entry.getValue();
                Ref.ObjectRef objectRef = targetId;
                BasicMetaObject basicMetaObject = targetParentId.getMetaObject();
                Intrinsics.checkNotNullExpressionValue((Object)basicMetaObject, (String)"getMetaObject(...)");
                if (BasicMetaFunKt.findChild((BasicMetaObject)basicMetaObject, (ObjectKind)kind) != null) {
                    void it;
                    Ref.ObjectRef objectRef2 = objectRef;
                    boolean bl3 = false;
                    Family family = this.myParent.extractObject().familyOf(it.kind);
                    int baseIdx = family != null ? family.size() : 0;
                    elementIdentity = this.createSources(targetOwner, targetParentId, kSources, (BasicMetaObject)it, baseIdx, recursive);
                    objectRef = objectRef2;
                } else {
                    elementIdentity = null;
                }
                objectRef.element = elementIdentity;
            }
            return (ElementIdentity)targetId.element;
        }

        private final <E extends BasicElement> ElementIdentity<E> createSources(ElementOwner targetOwner, ElementIdentity<?> targetParentId, Iterable<? extends BasicObjectNode> sources, BasicMetaObject<E> meta, int baseIdx, boolean recursive) {
            ElementIdentity<E> targetId = null;
            int idx = baseIdx;
            for (BasicObjectNode basicObjectNode : sources) {
                targetId = this.createObject(targetOwner, targetParentId, meta, basicObjectNode, (short)idx++, recursive);
            }
            return targetId;
        }

        private final <E extends BasicElement> ElementIdentity<E> createObject(ElementOwner owner, ElementIdentity<?> targetParentId, BasicMetaObject<E> meta, BasicObjectNode source, short position, boolean recursive) {
            ElementIdentity elementIdentity = owner.create(targetParentId, meta);
            Intrinsics.checkNotNullExpressionValue((Object)elementIdentity, (String)"create(...)");
            ElementIdentity id = elementIdentity;
            BasicElement basicElement = owner.findOrCreate(id);
            Intrinsics.checkNotNull((Object)basicElement);
            BasicElement targetElement = basicElement;
            BasicMetaUtils.copyMatchedProperties((BasicElement)source.extractObject(), (BasicModElement)((BasicModElement)targetElement), (boolean)false, (boolean)false, (boolean)true);
            CreateObjectActionHelper.ensureObjectIsUnique(CreateObjectAction.cursorWithFakeParent(targetElement, this.myParent));
            CreateObjectActionHelper.setPositionIfSupported(this.getBasicModel().getDbms(), CreateObjectAction.cursorWithFakeParent(targetElement, this.myParent), position);
            this.addMatch(owner, id, targetElement);
            if (recursive) {
                for (Family family : source.extractObject().getFamilies()) {
                    BasicMetaObject targetMeta;
                    BasicMetaObject basicMetaObject = ((BasicObjectNode)targetElement).getMetaObject();
                    Intrinsics.checkNotNullExpressionValue((Object)basicMetaObject, (String)"getMetaObject(...)");
                    if (BasicMetaFunKt.findChild((BasicMetaObject)basicMetaObject, (ObjectKind)family.getMetaObject().kind) == null) continue;
                    ElementOwner elementOwner = this.getTargetOwner();
                    Intrinsics.checkNotNull((Object)family);
                    this.createSources(elementOwner, id, (Iterable)family, targetMeta, 0, true);
                }
            }
            return id;
        }

        @Override
        @NotNull
        protected DbEditorModel<?, ?> createEditorModelImpl(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> targetId) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            Intrinsics.checkNotNullParameter(targetId, (String)"targetId");
            controller.createStructureNodeModel(targetId);
            DbEditorModel<?, ?> dbEditorModel = controller.getBuilder().createAppropriateObjectEditorModel(controller, targetId);
            Intrinsics.checkNotNullExpressionValue(dbEditorModel, (String)"createAppropriateObjectEditorModel(...)");
            return dbEditorModel;
        }

        @Override
        @NotNull
        public DbObjectEditorBuilder createEditorBuilder() {
            DbObjectEditorBuilder dbObjectEditorBuilder = CreateObjectGroup.Public.createPublicBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)dbObjectEditorBuilder, (String)"createPublicBuilder(...)");
            return dbObjectEditorBuilder;
        }
    }
}

