/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.diagnostic.DiagnosticMonitor;
import com.intellij.database.explorer.forest.DvNiceFolder;
import com.intellij.database.explorer.structure.DbNodeDecorationLinkParticle;
import com.intellij.database.explorer.structure.DbNodeDecorationParticle;
import com.intellij.database.explorer.structure.DbNodeDecorationSimpleParticle;
import com.intellij.database.explorer.structure.DbTreeNodeDecoration;
import com.intellij.database.explorer.structure.DvExtraNode;
import com.intellij.database.explorer.structure.DvTreeIconItem;
import com.intellij.database.explorer.structure.DvTreeNodeRank;
import com.intellij.database.explorer.structure.DvTreeNodeRankFun;
import com.intellij.database.explorer.structure.DvTreeStructure;
import com.intellij.database.explorer.structure.DvViewOptions;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIntrospectableArea;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiLevelIntrospectableArea;
import com.intellij.database.model.basic.BasicMultiLevelMateDatabase;
import com.intellij.database.model.basic.BasicMultiLevelRoot;
import com.intellij.database.model.basic.BasicMultiLevelSchema;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.LevelFun;
import com.intellij.database.run.actions.IconWithLockOverlay;
import com.intellij.database.run.actions.IconWithLogOverlay;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DbActiveConnectionInfoProviders;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.DvTreeIcons;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.TypePresentationService;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import icons.DatabaseIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001d\u0010\n\u001a\u00070\u0001\u00a2\u0006\u0002\b\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0007H\u0000\u001a:\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0002\u001a\u001a\u0010)\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010$H\u0000\u001a\u0018\u0010*\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u0013H\u0002\u001a\u001a\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020.2\b\u0010\"\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\f\u0010/\u001a\u00020\u0003*\u000200H\u0002\u001a\f\u0010/\u001a\u00020\u0003*\u000201H\u0002\u001a(\u00104\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\t2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0011H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001a\u00102\u001a\u00020\u0003*\u0004\u0018\u00010$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u00068"}, d2={"hidePillsWhenL3RegistryKey", "", "hidePillsWhenL3", "", "getHidePillsWhenL3", "()Z", "getDataSourceForTopNode", "Lcom/intellij/database/model/RawDataSource;", "node", "Lcom/intellij/database/model/basic/BasicNode;", "getNodePrimaryText", "Lorg/jetbrains/annotations/Nls;", "structure", "Lcom/intellij/database/explorer/structure/DvTreeStructure;", "countShowChildrenNum", "", "vo", "Lcom/intellij/database/explorer/structure/DvViewOptions;", "getNodeIcon", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "getDataSourceIcon", "dsn", "Lcom/intellij/database/view/DataSourceNode;", "getLocalDataSourceIcon", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "addLevelIcon", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "area", "Lcom/intellij/database/model/basic/BasicMultiLevelIntrospectableArea;", "dataSource", "level", "Lcom/intellij/database/model/properties/Level;", "declared", "inherited", "extraLow", "nullMeansAuto", "addDetailsLevelIcon", "addSecondIcon", "secondIcon", "isInIntrospectionScope", "namespace", "Lcom/intellij/database/model/basic/BasicNamespace;", "scanToCheckWhetherModelHasLowIntrospectionLevels", "Lcom/intellij/database/model/DasModel;", "Lcom/intellij/database/model/basic/BasicMultiLevelRoot;", "isLow", "(Lcom/intellij/database/model/properties/Level;)Z", "decorateNode", "decoration", "Lcom/intellij/database/explorer/structure/DbTreeNodeDecoration;", "viewOptions", "intellij.database.impl"})
@JvmName(name="DbNodeDescriptorHelper")
@SourceDebugExtension(value={"SMAP\nDbNodeDescriptorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbNodeDescriptorHelper.kt\ncom/intellij/database/view/DbNodeDescriptorHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,312:1\n1#2:313\n*E\n"})
public final class DbNodeDescriptorHelper {
    @NotNull
    private static final String hidePillsWhenL3RegistryKey = "database.view.levels.hide.L3";

    private static final boolean getHidePillsWhenL3() {
        return Registry.Companion.is(hidePillsWhenL3RegistryKey);
    }

    @Nullable
    public static final RawDataSource getDataSourceForTopNode(@NotNull BasicNode node) {
        RawDataSource rawDataSource;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        if (basicNode instanceof DataSourceNode) {
            rawDataSource = ((DataSourceNode)node).dataSource;
        } else if (basicNode instanceof BasicNamespace) {
            BasicModel basicModel = ((BasicNamespace)node).getModel();
            if (basicModel != null) {
                BasicModel it = basicModel;
                boolean bl = false;
                rawDataSource = BasicModelRegistry.Companion.instance().getDataSource(it);
            } else {
                rawDataSource = null;
            }
        } else if (basicNode instanceof BasicIntrospectableArea) {
            BasicModel basicModel = ((BasicIntrospectableArea)node).getModel();
            if (basicModel != null) {
                BasicModel it = basicModel;
                boolean bl = false;
                rawDataSource = BasicModelRegistry.Companion.instance().getDataSource(it);
            } else {
                rawDataSource = null;
            }
        } else {
            rawDataSource = null;
        }
        return rawDataSource;
    }

    @NotNull
    public static final String getNodePrimaryText(@NotNull BasicNode node, @NotNull DvTreeStructure structure) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        String text = structure.presentableNameOf(node);
        if (node instanceof BasicElement && Intrinsics.areEqual((Object)((BasicElement)node).getKind(), (Object)ObjectKind.BODY)) {
            String string = DatabaseBundle.message((String)"ObjectKind.body", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            text = string;
        }
        return text;
    }

    public static final int countShowChildrenNum(@NotNull BasicNode node, @NotNull DvTreeStructure structure, @NotNull DvViewOptions vo) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        Intrinsics.checkNotNullParameter((Object)vo, (String)"vo");
        boolean toCount = node instanceof DvExtraNode ? ((DvExtraNode)node).getShowCount() : (DvTreeNodeRankFun.getTreeNodeRank((BasicNode)node) == DvTreeNodeRank.TL_FAMILY ? true : (node instanceof BasicNamespaceOwner ? !vo.getGroupNamespaces() : false));
        return toCount ? structure.countRealChildrenOf(node) : 0;
    }

    @Nullable
    public static final Icon getNodeIcon(@NotNull Project project, @NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Icon icon = null;
        BasicNode basicNode = node;
        if (basicNode instanceof BasicElement) {
            BasicModel basicModel = ((BasicElement)node).getModel();
            if (basicModel == null || (basicModel = basicModel.getDbms()) == null) {
                basicModel = Dbms.UNKNOWN;
            }
            BasicModel dbms = basicModel;
            ModelHelper modelHelper = ModelFacade.forDbms((Dbms)dbms).getModelHelper();
            Intrinsics.checkNotNullExpressionValue((Object)modelHelper, (String)"getModelHelper(...)");
            ModelHelper helper = modelHelper;
            icon = helper.getIcon((DasObject)node);
        } else if (basicNode instanceof HostFamily) {
            icon = DatabaseIcons.ObjectGroup;
        } else if (basicNode instanceof DvNiceFolder) {
            Icon icon2 = TypePresentationService.getService().getIcon((Object)node);
            if (icon2 == null) {
                Icon icon3 = AllIcons.Nodes.Folder;
                icon2 = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Folder");
            }
            icon = icon2;
        } else if (basicNode instanceof DvExtraNode) {
            Icon icon4 = TypePresentationService.getService().getIcon((Object)node);
            if (icon4 == null) {
                DvTreeIconItem dvTreeIconItem = ((DvExtraNode)node).getIconItem();
                if (dvTreeIconItem != null) {
                    DvTreeIconItem it = dvTreeIconItem;
                    boolean bl = false;
                    icon4 = (Icon)DvTreeIcons.TREE_NODE_ITEMS.get(it);
                } else {
                    icon4 = null;
                }
            }
            icon = icon4;
        } else if (basicNode instanceof DataSourceNode) {
            icon = DbNodeDescriptorHelper.getDataSourceIcon(project, (DataSourceNode)node);
        }
        return icon;
    }

    private static final Icon getDataSourceIcon(Project project, DataSourceNode dsn) {
        if (project.isDisposed()) {
            return null;
        }
        RawDataSource ds = dsn.dataSource;
        boolean isSpinning = DataSourceSyncManager.Companion.getInstance().isActive((DasDataSource)ds);
        Icon icon = isSpinning ? (Icon)AnimatedIcon.Default.INSTANCE : (ds instanceof LocalDataSource ? DbNodeDescriptorHelper.getLocalDataSourceIcon(project, (LocalDataSource)ds) : ds.getIcon(0));
        return icon;
    }

    private static final Icon getLocalDataSourceIcon(Project project, LocalDataSource ds) {
        Icon icon;
        block5: {
            block6: {
                boolean active;
                icon = ds.getBaseIcon();
                if (ds.isReadOnly()) {
                    Icon icon2 = icon;
                    Intrinsics.checkNotNull((Object)icon2);
                    icon = (Icon)((Object)new IconWithLockOverlay(icon2));
                }
                if (icon == null) break block5;
                boolean bl = active = DbImplUtil.isConnected((Project)project, (LocalDataSource)ds) & DbImplUtil.getActiveConnectionCount((LocalDataSource)ds) > 0 || DbActiveConnectionInfoProviders.getActiveConnectionInfo(ds, project) != null;
                if (active) {
                    icon = ExecutionUtil.getLiveIndicator((Icon)icon);
                }
                if (DataSourceFun.isJdbcLogEnabled((DatabaseConnectionPoint)((DatabaseConnectionPoint)ds)) && active) break block6;
                String string = ds.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
                if (!DiagnosticMonitor.INSTANCE.isRecordingDataSource(string)) break block5;
            }
            icon = (Icon)((Object)new IconWithLogOverlay(icon));
        }
        return icon;
    }

    public static final void addLevelIcon(@NotNull PresentationData presentation, @NotNull DataSourceNode dsn) {
        Level level;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        if (!DBIntrospectorFeatures.supportsMultilevelIntrospection((Dbms)dsn.getDbms())) {
            return;
        }
        LocalDataSource localDataSource = dsn.getLocalDataSource();
        if (localDataSource == null) {
            return;
        }
        LocalDataSource lds = localDataSource;
        DbNodeDescriptorHelper.addLevelIcon(presentation, level, (level = lds.getIntrospectionLevel()) != null, false, false, true);
    }

    public static final void addLevelIcon(@NotNull PresentationData presentation, @NotNull BasicMultiLevelIntrospectableArea area, @Nullable RawDataSource dataSource) {
        BasicMultiLevelIntrospectableArea basicMultiLevelIntrospectableArea;
        Level effectiveExplicitLevel;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        LocalDataSource localDataSource = dataSource instanceof LocalDataSource ? (LocalDataSource)dataSource : null;
        if (localDataSource == null) {
            return;
        }
        LocalDataSource lds = localDataSource;
        if (area instanceof BasicNamespace && !DbNodeDescriptorHelper.isInIntrospectionScope((BasicNamespace)area, (RawDataSource)lds)) {
            Icon icon = AllIcons.Nodes.EmptyNode;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"EmptyNode");
            DbNodeDescriptorHelper.addSecondIcon(presentation, icon);
            return;
        }
        if (DbNodeDescriptorHelper.getHidePillsWhenL3()) {
            BasicModel basicModel = area.getModel();
            BasicRoot basicRoot = basicModel != null ? basicModel.getRoot() : null;
            BasicMultiLevelRoot basicMultiLevelRoot = basicRoot instanceof BasicMultiLevelRoot ? (BasicMultiLevelRoot)basicRoot : null;
            if (basicMultiLevelRoot == null) {
                return;
            }
            BasicMultiLevelRoot root = basicMultiLevelRoot;
            if (!DbNodeDescriptorHelper.scanToCheckWhetherModelHasLowIntrospectionLevels(root)) {
                return;
            }
        }
        Level showLevel = null;
        boolean showAsExplicit = false;
        boolean showAsInherited = false;
        boolean showAsExtraLow = false;
        Level explicitLevel = area.getExplicitIntrospectionLevel();
        Level level = explicitLevel;
        if (level == null && (level = ModelFun.effectiveExplicitIntrospectionLevel((BasicMultiLevelIntrospectableArea)area)) == null) {
            level = effectiveExplicitLevel = lds.getIntrospectionLevel();
        }
        if ((basicMultiLevelIntrospectableArea = area) instanceof BasicMultiLevelSchema) {
            Level lastActualLevel = ((BasicMultiLevelSchema)area).getLastIntrospectionLevel();
            Level level2 = effectiveExplicitLevel;
            if (level2 == null) {
                level2 = ModelFun.effectiveIntrospectionLevel((BasicMultiLevelSchema)((BasicMultiLevelSchema)area));
            }
            Level effectiveLevel = level2;
            boolean enough = lastActualLevel != null && (effectiveLevel == null || LevelFun.isGreaterOrEqualsTo((Level)lastActualLevel, (Level)effectiveLevel));
            showLevel = lastActualLevel;
            showAsExtraLow = effectiveExplicitLevel != null && !enough;
            showAsExplicit = effectiveExplicitLevel != null && enough;
            showAsInherited = lastActualLevel == null;
        } else if (basicMultiLevelIntrospectableArea instanceof BasicMultiLevelMateDatabase) {
            showLevel = effectiveExplicitLevel;
            showAsExplicit = explicitLevel != null;
            showAsInherited = explicitLevel == null;
            showAsExtraLow = false;
        } else {
            return;
        }
        DbNodeDescriptorHelper.addLevelIcon(presentation, showLevel, showAsExplicit, showAsInherited, showAsExtraLow, true);
    }

    private static final void addLevelIcon(PresentationData presentation, Level level, boolean declared, boolean inherited, boolean extraLow, boolean nullMeansAuto) {
        Icon icon;
        block17: {
            block15: {
                block18: {
                    block16: {
                        if (level == null) break block15;
                        if (!extraLow) break block16;
                        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                            case 1: {
                                icon = DatabaseIcons.Level1_details;
                                break block17;
                            }
                            case 2: {
                                icon = DatabaseIcons.Level2_details;
                                break block17;
                            }
                            case 3: {
                                icon = DatabaseIcons.Level3_details;
                                break block17;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    if (!declared) break block18;
                    switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                        case 1: {
                            icon = DatabaseIcons.Level1_declared;
                            break block17;
                        }
                        case 2: {
                            icon = DatabaseIcons.Level2_declared;
                            break block17;
                        }
                        case 3: {
                            icon = DatabaseIcons.Level3_declared;
                            break block17;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                    case 1: {
                        icon = DatabaseIcons.Level1_inherited;
                        break block17;
                    }
                    case 2: {
                        icon = DatabaseIcons.Level2_inherited;
                        break block17;
                    }
                    case 3: {
                        icon = DatabaseIcons.Level3_inherited;
                        break block17;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            icon = extraLow ? DatabaseIcons.LevelZeroDetails : (inherited ? DatabaseIcons.LevelAutoInherited : (nullMeansAuto ? DatabaseIcons.LevelAuto : AllIcons.Nodes.EmptyNode));
        }
        Icon icon2 = icon;
        Intrinsics.checkNotNull((Object)icon2);
        Icon levelIcon = icon2;
        DbNodeDescriptorHelper.addSecondIcon(presentation, levelIcon);
    }

    public static final void addDetailsLevelIcon(@NotNull PresentationData presentation, @Nullable Level level) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        if (level == null) {
            return;
        }
        Icon icon = switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1 -> DatabaseIcons.Level1_details;
            case 2 -> DatabaseIcons.Level2_details;
            case 3 -> DatabaseIcons.Level3_details;
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)icon);
        Icon levelIcon = icon;
        DbNodeDescriptorHelper.addSecondIcon(presentation, levelIcon);
    }

    private static final void addSecondIcon(PresentationData presentation, Icon secondIcon) {
        Icon normalIcon = presentation.getIcon(false);
        Icon rowIcon = IconUtil.rowIcon((Icon)normalIcon, (Icon)secondIcon);
        presentation.setIcon(rowIcon);
    }

    public static final boolean isInIntrospectionScope(@NotNull BasicNamespace namespace, @Nullable RawDataSource dataSource) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        if (dataSource instanceof LocalDataSource) {
            TreePattern treePattern = ((LocalDataSource)dataSource).getIntrospectionScope();
            Intrinsics.checkNotNullExpressionValue((Object)treePattern, (String)"getIntrospectionScope(...)");
            TreePattern scope2 = treePattern;
            bl = DataSourceSchemaMapping.isIntrospected((TreePattern)scope2, (DasObject)((DasObject)namespace));
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean scanToCheckWhetherModelHasLowIntrospectionLevels(DasModel $this$scanToCheckWhetherModelHasLowIntrospectionLevels) {
        if ($this$scanToCheckWhetherModelHasLowIntrospectionLevels instanceof BasicModel) {
            BasicRoot basicRoot = ((BasicModel)$this$scanToCheckWhetherModelHasLowIntrospectionLevels).getRoot();
            BasicMultiLevelRoot basicMultiLevelRoot = basicRoot instanceof BasicMultiLevelRoot ? (BasicMultiLevelRoot)basicRoot : null;
            if (basicMultiLevelRoot == null) {
                return false;
            }
            BasicMultiLevelRoot root = basicMultiLevelRoot;
            if (DbNodeDescriptorHelper.isLow(root.getExplicitIntrospectionLevel())) {
                return true;
            }
            for (BasicSchema schema : root.getAllSchemas()) {
                if (!(schema instanceof BasicMultiLevelSchema) || !DbNodeDescriptorHelper.isLow(((BasicMultiLevelSchema)schema).getExplicitIntrospectionLevel())) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean scanToCheckWhetherModelHasLowIntrospectionLevels(BasicMultiLevelRoot $this$scanToCheckWhetherModelHasLowIntrospectionLevels) {
        if (DbNodeDescriptorHelper.isLow($this$scanToCheckWhetherModelHasLowIntrospectionLevels.getExplicitIntrospectionLevel())) {
            return true;
        }
        for (BasicSchema schema : $this$scanToCheckWhetherModelHasLowIntrospectionLevels.getAllSchemas()) {
            if (!(schema instanceof BasicMultiLevelSchema) || !DbNodeDescriptorHelper.isLow(((BasicMultiLevelSchema)schema).getExplicitIntrospectionLevel())) continue;
            return true;
        }
        return false;
    }

    private static final boolean isLow(Level $this$isLow) {
        return $this$isLow == Level.L1 || $this$isLow == Level.L2;
    }

    public static final void decorateNode(@NotNull PresentationData presentation, @NotNull BasicNode node, @NotNull DbTreeNodeDecoration decoration, @NotNull DvViewOptions viewOptions) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)decoration, (String)"decoration");
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        if (CollectionsKt.any((Iterable)decoration.particles) && !viewOptions.getWithCommentsNotDetails()) {
            for (DbNodeDecorationParticle particle : decoration.particles) {
                String text;
                DbNodeDecorationParticle dbNodeDecorationParticle = particle;
                if (dbNodeDecorationParticle instanceof DbNodeDecorationSimpleParticle) {
                    text = ((DbNodeDecorationSimpleParticle)particle).getParticleText(node);
                    presentation.addText(text, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
                    continue;
                }
                if (dbNodeDecorationParticle instanceof DbNodeDecorationLinkParticle) {
                    text = ((DbNodeDecorationLinkParticle)particle).getParticleText(node);
                    presentation.addText(text, DbNodeDescriptor.INACTIVE_LINK_ATTRS);
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.L1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.L2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.L3.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

