/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.editor.DatabaseCompositeTableEditorProviderKt;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.editor.OpenDdlFileDescriptor;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbTargetUtil;
import com.intellij.database.vfs.DatabaseElementSourceVirtualFileImpl;
import com.intellij.database.view.DbNavigationUtilsKt;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/view/SourceNavigationImpl;", "", "dbElement", "Lcom/intellij/database/psi/DbElement;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "requestFocus", "", "<init>", "(Lcom/intellij/database/psi/DbElement;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "start", "", "calculateOffsetAndNavigate", "navigate", "offset", "", "intellij.database.impl"})
final class SourceNavigationImpl {
    @NotNull
    private final DbElement dbElement;
    @NotNull
    private final VirtualFile virtualFile;
    private final boolean requestFocus;

    public SourceNavigationImpl(@NotNull DbElement dbElement, @NotNull VirtualFile virtualFile, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)dbElement, (String)"dbElement");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.dbElement = dbElement;
        this.virtualFile = virtualFile;
        this.requestFocus = requestFocus;
    }

    public final void start() {
        VirtualFile virtualFile = this.virtualFile;
        DatabaseElementSourceVirtualFileImpl databaseElementSourceVirtualFileImpl = virtualFile instanceof DatabaseElementSourceVirtualFileImpl ? (DatabaseElementSourceVirtualFileImpl)virtualFile : null;
        if (databaseElementSourceVirtualFileImpl == null) {
            this.calculateOffsetAndNavigate();
            return;
        }
        DatabaseElementSourceVirtualFileImpl vf = databaseElementSourceVirtualFileImpl;
        if (DatabaseEditorHelper.needsReload(vf)) {
            Project project = this.dbElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            DatabaseEditorHelper.reloadIfNeeded(this.dbElement.getProject(), vf).onSuccess(arg_0 -> SourceNavigationImpl.start$lambda$1(arg_0 -> SourceNavigationImpl.start$lambda$0(this, project2, arg_0), arg_0));
            if (!DatabaseCompositeTableEditorProviderKt.isCompositeEditorEnabled()) {
                this.navigate(0);
            }
        } else {
            this.calculateOffsetAndNavigate();
        }
    }

    private final void calculateOffsetAndNavigate() {
        Project project = this.dbElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String string = DatabaseBundle.message((String)"progress.title.computing.target.symbol", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        int offset = ((Number)ActionUtil.underModalProgress((Project)project2, (String)string, () -> SourceNavigationImpl.calculateOffsetAndNavigate$lambda$0(project2, this))).intValue();
        this.navigate(offset);
    }

    private final void navigate(int offset) {
        OpenDataFileDescriptor openDataFileDescriptor;
        if (DatabaseCompositeTableEditorProviderKt.isCompositeEditorEnabled() && (openDataFileDescriptor = DbNavigationUtilsKt.createDataFileDescriptor$default(this.dbElement, null, null, 6, null)) != null) {
            OpenDataFileDescriptor dataDescriptor = openDataFileDescriptor;
            boolean bl = false;
            Project project = dataDescriptor.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFile virtualFile = dataDescriptor.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            OpenDdlFileDescriptor openDdlFileDescriptor = new OpenDdlFileDescriptor(project, virtualFile, this.dbElement, offset);
            openDdlFileDescriptor.navigate(this.requestFocus);
            return;
        }
        PsiNavigationSupport.getInstance().createNavigatable(this.dbElement.getProject(), this.virtualFile, offset).navigate(this.requestFocus);
    }

    private static final Unit start$lambda$0(SourceNavigationImpl this$0, Project $project, Void it) {
        ApplicationManager.getApplication().invokeLater(this$0::calculateOffsetAndNavigate, $project.getDisposed());
        return Unit.INSTANCE;
    }

    private static final void start$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Integer calculateOffsetAndNavigate$lambda$0(Project $project, SourceNavigationImpl this$0) {
        return DbTargetUtil.calcTargetOffset((Project)$project, (VirtualFile)this$0.virtualFile, (DasObject)((DasObject)this$0.dbElement));
    }
}

