/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.ui.DatabaseSchemaSelectionTreeKt;
import com.intellij.database.view.ui.MyInnerTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.FilteringTree;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.tree.TreePathBackgroundSupplier;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 ;2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001;B3\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0003H\u0014J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$2\u0006\u0010\"\u001a\u00020\u0003H\u0014J$\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010(2\u0006\u0010\"\u001a\u00020\u0003H\u0002J1\u0010,\u001a\u0015\u0012\f\u0012\n /*\u0004\u0018\u00010.0.0-\u00a2\u0006\u0002\b0*\n\u0012\u0006\b\u0001\u0012\u0002010-2\b\u00102\u001a\u0004\u0018\u00010(H\u0002J\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020(0'2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u0014\u00104\u001a\u0004\u0018\u00010*2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0015J\u001a\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006<"}, d2={"Lcom/intellij/database/view/ui/DatabaseSchemaSelectionTree;", "Lcom/intellij/ui/FilteringTree;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "", "Lcom/intellij/ui/tree/TreePathBackgroundSupplier;", "project", "Lcom/intellij/openapi/project/Project;", "dbmses", "", "Lcom/intellij/database/Dbms;", "withToolbar", "", "speedSearch", "Lcom/intellij/ui/speedSearch/SpeedSearchSupply;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;ZLcom/intellij/ui/speedSearch/SpeedSearchSupply;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDbmses", "()Ljava/util/Set;", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "filtered", "getFiltered$intellij_database_impl", "()Z", "setFiltered$intellij_database_impl", "(Z)V", "rebuildTree", "", "getNodeClass", "Ljava/lang/Class;", "createNode", "obj", "getChildren", "", "getGrouped", "dataSources", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "prefix", "", "getDataSource", "applyFilter", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/basic/BasicNamespace;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/database/model/basic/BasicElement;", "ds", "filterIfNeeded", "getText", "getPathBackground", "Ljava/awt/Color;", "path", "Ljavax/swing/tree/TreePath;", "row", "", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseSchemaSelectionTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSchemaSelectionTree.kt\ncom/intellij/database/view/ui/DatabaseSchemaSelectionTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,259:1\n1915#2:260\n1916#2:262\n777#2:263\n873#2,2:264\n1#3:261\n*S KotlinDebug\n*F\n+ 1 DatabaseSchemaSelectionTree.kt\ncom/intellij/database/view/ui/DatabaseSchemaSelectionTree\n*L\n163#1:260\n163#1:262\n192#1:263\n192#1:264,2\n*E\n"})
public final class DatabaseSchemaSelectionTree
extends FilteringTree<DefaultMutableTreeNode, Object>
implements TreePathBackgroundSupplier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<Dbms> dbmses;
    @NotNull
    private final JPanel panel;
    private boolean filtered;

    /*
     * WARNING - void declaration
     */
    public DatabaseSchemaSelectionTree(@NotNull Project project, @NotNull Set<Dbms> dbmses, boolean withToolbar, @Nullable SpeedSearchSupply speedSearch) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dbmses, (String)"dbmses");
        super((Tree)new MyInnerTree(), new DefaultMutableTreeNode(DataSourceStorage.getProjectStorage((Project)project)));
        this.project = project;
        this.dbmses = dbmses;
        this.panel = new JPanel(new BorderLayout());
        this.filtered = true;
        UiUtils.putUserData((JComponent)this.panel, (Key)DatabaseSchemaSelectionTreeKt.access$getTREE_KEY$p(), (Object)((Object)this));
        Object object = this.getTree();
        MyInnerTree myInnerTree = object instanceof MyInnerTree ? (MyInnerTree)((Object)object) : null;
        if (myInnerTree != null) {
            myInnerTree.setColorSupplier(this);
        }
        this.getTree().setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                DefaultMutableTreeNode defaultMutableTreeNode = value instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)value : null;
                Object obj = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
                String string = this.getText(obj);
                if (string == null) {
                    string = "";
                }
                this.append(string);
                Object object = obj;
                this.setIcon(object instanceof LocalDataSource ? ((LocalDataSource)obj).getIcon() : (object instanceof BasicElement ? DbPresentation.getIcon((DasObject)((DasObject)obj)) : (object instanceof String ? AllIcons.Nodes.Folder : null)));
            }
        });
        this.getTree().setVisibleRowCount(10);
        this.getTree().setRootVisible(false);
        object = DatabaseBundle.messagePointer((String)"action.filter.text", (Object[])new Object[0]);
        Object object2 = AllIcons.General.Filter;
        DumbAware filterAction2 = new DumbAware(this, (Supplier<String>)object, (Icon)object2){
            final /* synthetic */ DatabaseSchemaSelectionTree this$0;
            {
                block0: {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2);
                    ShortcutSet shortcutSet = ActionUtil.getMnemonicAsShortcut((AnAction)((AnAction)this));
                    if (shortcutSet == null) break block0;
                    ShortcutSet it = shortcutSet;
                    boolean bl = false;
                    this.registerCustomShortcutSet(it, (JComponent)$receiver.getTree());
                }
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public boolean isSelected(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return this.this$0.getFiltered$intellij_database_impl();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setFiltered$intellij_database_impl(state);
                DatabaseSchemaSelectionTree.access$rebuildTree(this.this$0);
            }
        };
        this.panel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)this.getTree())), "Center");
        if (withToolbar) {
            void $this$_init__u24lambda_u240;
            Object object3 = new AnAction[]{filterAction2};
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup(object3), true);
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
            ActionToolbar toolbar = actionToolbar;
            toolbar.setTargetComponent((JComponent)this.getTree());
            toolbar.setReservePlaceAutoPopupIcon(false);
            object2 = new JPanel(new BorderLayout());
            object3 = object2;
            JPanel jPanel = this.panel;
            boolean bl = false;
            if (speedSearch == null) {
                $this$_init__u24lambda_u240.add((Component)this.installSearchField(), "Center");
            }
            $this$_init__u24lambda_u240.add((Component)toolbar.getComponent(), "East");
            jPanel.add((Component)object2, "North");
        }
        if (speedSearch != null) {
            this.getSearchModel().setSpeedSearch(speedSearch);
        }
        this.rebuildTree();
    }

    public /* synthetic */ DatabaseSchemaSelectionTree(Project project, Set set, boolean bl, SpeedSearchSupply speedSearchSupply, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            speedSearchSupply = null;
        }
        this(project, set, bl, speedSearchSupply);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Set<Dbms> getDbmses() {
        return this.dbmses;
    }

    @NotNull
    public final JPanel getPanel() {
        return this.panel;
    }

    public final boolean getFiltered$intellij_database_impl() {
        return this.filtered;
    }

    public final void setFiltered$intellij_database_impl(boolean bl) {
        this.filtered = bl;
    }

    private final void rebuildTree() {
        this.getSearchModel().updateStructure();
    }

    @NotNull
    protected Class<? extends DefaultMutableTreeNode> getNodeClass() {
        return DefaultMutableTreeNode.class;
    }

    @NotNull
    protected DefaultMutableTreeNode createNode(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return new DefaultMutableTreeNode(obj);
    }

    @NotNull
    protected Iterable<Object> getChildren(@NotNull Object obj) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Object object = obj;
        if (object instanceof DataSourceStorage) {
            List list = ((DataSourceStorage)obj).getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            iterable = this.getGrouped(this.filterIfNeeded(list), "");
        } else if (object instanceof String) {
            List list = DataSourceStorage.getProjectStorage((Project)this.project).getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            iterable = this.getGrouped(this.filterIfNeeded(list), (String)obj);
        } else if (object instanceof LocalDataSource) {
            DasModel dasModel = ((LocalDataSource)obj).getModel();
            JBIterable<BasicNamespace> jBIterable = dasModel instanceof BasicModel ? (JBIterable<BasicNamespace>)dasModel : null;
            iterable = jBIterable != null && (jBIterable = jBIterable.getRoot()) != null && (jBIterable = jBIterable.getChildren()) != null && (jBIterable = this.applyFilter((JBIterable<? extends BasicElement>)jBIterable, (LocalDataSource)obj)) != null ? (Iterable)jBIterable : (Iterable)CollectionsKt.emptyList();
        } else if (object instanceof BasicElement) {
            JBIterable jBIterable = ((BasicElement)obj).getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getChildren(...)");
            iterable = (Iterable)this.applyFilter((JBIterable<? extends BasicElement>)jBIterable, this.getDataSource(obj));
        } else {
            iterable = CollectionsKt.emptyList();
        }
        return iterable;
    }

    private final Iterable<Object> getGrouped(List<? extends LocalDataSource> dataSources, String prefix) {
        LinkedHashSet dss = new LinkedHashSet();
        LinkedHashSet prefixes = new LinkedHashSet();
        Object longPrefix = ((CharSequence)prefix).length() == 0 ? "" : prefix + "/";
        int pLen = ((String)longPrefix).length();
        Iterable $this$forEach$iv = dataSources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalDataSource ds = (LocalDataSource)element$iv;
            boolean bl = false;
            String string = ds.getGroupName();
            if (string == null) {
                string = "";
            }
            String gr = string;
            if (Intrinsics.areEqual((Object)gr, (Object)prefix)) {
                ((Collection)dss).add(ds);
                continue;
            }
            if (!StringsKt.startsWith$default((String)gr, (String)longPrefix, (boolean)false, (int)2, null)) continue;
            Integer n = StringsKt.indexOf$default((CharSequence)gr, (String)"/", (int)pLen, (boolean)false, (int)4, null);
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            Integer n2 = it != -1 ? n : null;
            int e = n2 != null ? n2.intValue() : gr.length();
            Collection collection = prefixes;
            String string2 = gr.substring(0, e);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            collection.add(string2);
        }
        JBIterable jBIterable = JBIterable.from((Iterable)prefixes).append((Iterable)dss);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"append(...)");
        return (Iterable)jBIterable;
    }

    private final LocalDataSource getDataSource(Object obj) {
        return (LocalDataSource)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)this.getSearchModel().getCachedNode(obj), DatabaseSchemaSelectionTree::getDataSource$lambda$0), DatabaseSchemaSelectionTree::getDataSource$lambda$1));
    }

    private final JBIterable<BasicNamespace> applyFilter(JBIterable<? extends BasicElement> $this$applyFilter, LocalDataSource ds) {
        JBIterable jBIterable;
        JBIterable $this$applyFilter_u24lambda_u240 = $this$applyFilter.filter(BasicNamespace.class);
        boolean bl = false;
        if (!this.filtered) {
            jBIterable = $this$applyFilter_u24lambda_u240;
        } else {
            TreePattern scope2 = DbImplUtil.getIntrospectionScope((DasDataSource)((DasDataSource)ds));
            jBIterable = $this$applyFilter_u24lambda_u240.filter(arg_0 -> DatabaseSchemaSelectionTree.applyFilter$lambda$0$1(arg_0 -> DatabaseSchemaSelectionTree.applyFilter$lambda$0$0(scope2, arg_0), arg_0));
        }
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"run(...)");
        return jBIterable;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LocalDataSource> filterIfNeeded(List<? extends LocalDataSource> dataSources) {
        List list;
        block5: {
            block4: {
                List list2;
                void $this$filterTo$iv$iv;
                List list3;
                List it = list3 = dataSources;
                boolean bl = false;
                list = this.filtered && !((Collection)this.dbmses).isEmpty() ? list3 : null;
                if (list == null) break block4;
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    LocalDataSource it2 = (LocalDataSource)element$iv$iv;
                    boolean bl2 = false;
                    if (!this.dbmses.contains(it2.getDbms())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List it3 = list2 = (List)destination$iv$iv;
                boolean bl3 = false;
                list = !((Collection)it3).isEmpty() ? list2 : null;
                if (list != null) break block5;
            }
            list = dataSources;
        }
        return list;
    }

    @NlsSafe
    @Nullable
    protected String getText(@Nullable Object obj) {
        Object object;
        block3: {
            block5: {
                block6: {
                    Object object2;
                    block4: {
                        block2: {
                            object2 = obj;
                            if (!(object2 instanceof LocalDataSource)) break block2;
                            object = ((LocalDataSource)obj).getName();
                            break block3;
                        }
                        if (!(object2 instanceof BasicElement)) break block4;
                        object = ((BasicElement)obj).getName();
                        break block3;
                    }
                    if (!(object2 instanceof String)) break block5;
                    Integer n = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)obj), (String)"/", (int)0, (boolean)false, (int)6, null);
                    int it = ((Number)n).intValue();
                    boolean bl = false;
                    object = it != -1 ? n : null;
                    if (object == null) break block6;
                    int it2 = ((Number)object).intValue();
                    boolean bl2 = false;
                    String string = ((String)obj).substring(it2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    object = string;
                    if (string != null) break block3;
                }
                object = (String)obj;
                break block3;
            }
            object = null;
        }
        return object;
    }

    @Nullable
    public Color getPathBackground(@NotNull TreePath path, int row) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object obj = TreeUtil.getLastUserObject((TreePath)path);
        return obj instanceof LocalDataSource ? DatabaseColorManager.Companion.getColor(this.project, (DasDataSource)obj) : (obj instanceof BasicElement ? DatabaseColorManager.Companion.getColor(this.project, (DasDataSource)this.getDataSource(obj)) : null);
    }

    private static final DefaultMutableTreeNode getDataSource$lambda$0(DefaultMutableTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TreeNode treeNode = it.getParent();
        return treeNode instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)treeNode : null;
    }

    private static final LocalDataSource getDataSource$lambda$1(DefaultMutableTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getUserObject();
        return object instanceof LocalDataSource ? (LocalDataSource)object : null;
    }

    private static final boolean applyFilter$lambda$0$0(TreePattern $scope, BasicNamespace it) {
        return DataSourceSchemaMapping.isIntrospected((TreePattern)$scope, (DasObject)((DasObject)it));
    }

    private static final boolean applyFilter$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$rebuildTree(DatabaseSchemaSelectionTree $this) {
        $this.rebuildTree();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/view/ui/DatabaseSchemaSelectionTree$Companion;", "", "<init>", "()V", "fromUI", "Lcom/intellij/database/view/ui/DatabaseSchemaSelectionTree;", "ui", "Ljavax/swing/JComponent;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDatabaseSchemaSelectionTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSchemaSelectionTree.kt\ncom/intellij/database/view/ui/DatabaseSchemaSelectionTree$Companion\n+ 2 UiUtils.kt\ncom/intellij/openapi/ui/UiUtils\n*L\n1#1,259:1\n61#2:260\n*S KotlinDebug\n*F\n+ 1 DatabaseSchemaSelectionTree.kt\ncom/intellij/database/view/ui/DatabaseSchemaSelectionTree$Companion\n*L\n77#1:260\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final DatabaseSchemaSelectionTree fromUI(@Nullable JComponent ui) {
            DatabaseSchemaSelectionTree databaseSchemaSelectionTree;
            JComponent jComponent = ui;
            if (jComponent != null) {
                void $this$getUserData$iv;
                JComponent jComponent2 = jComponent;
                Key key$iv = DatabaseSchemaSelectionTreeKt.access$getTREE_KEY$p();
                boolean $i$f$getUserData = false;
                Object object = $this$getUserData$iv.getClientProperty(key$iv);
                if (!(object instanceof DatabaseSchemaSelectionTree)) {
                    object = null;
                }
                databaseSchemaSelectionTree = (DatabaseSchemaSelectionTree)((Object)object);
            } else {
                databaseSchemaSelectionTree = null;
            }
            return databaseSchemaSelectionTree;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

