/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.java.ClassInitializerTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElementBase;
import com.intellij.ide.structureView.impl.java.JavaRecordComponentTreeElement;
import com.intellij.ide.structureView.impl.java.PsiFieldTreeElement;
import com.intellij.ide.structureView.impl.java.PsiMethodTreeElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.siyeh.ig.psiutils.PsiElementOrderComparator;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaClassTreeElement
extends JavaClassTreeElementBase<PsiClass> {
    public JavaClassTreeElement(PsiClass cls, boolean inherited) {
        super(inherited, cls);
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        Collection<StructureViewTreeElement> collection = JavaClassTreeElement.getClassChildren((PsiClass)this.getElement());
        if (collection == null) {
            JavaClassTreeElement.$$$reportNull$$$0(0);
        }
        return collection;
    }

    static Collection<StructureViewTreeElement> getClassChildren(PsiClass aClass) {
        if (aClass == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiElement> members = new ArrayList<PsiElement>(JavaClassTreeElement.getOwnChildren(aClass));
        members.sort((Comparator<PsiElement>)PsiElementOrderComparator.getInstance());
        ArrayList<StructureViewTreeElement> children = new ArrayList<StructureViewTreeElement>(members.size());
        for (PsiElement child : members) {
            PsiElement psiElement;
            if (!child.isValid()) continue;
            Objects.requireNonNull(child);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiClass.class, PsiField.class, PsiMethod.class, PsiClassInitializer.class}, (Object)psiElement, n)) {
                case 0: {
                    PsiClass c = (PsiClass)psiElement;
                    children.add((StructureViewTreeElement)new JavaClassTreeElement(c, false));
                    break;
                }
                case 1: {
                    PsiField f = (PsiField)psiElement;
                    children.add((StructureViewTreeElement)new PsiFieldTreeElement(f, false));
                    break;
                }
                case 2: {
                    PsiMethod m = (PsiMethod)psiElement;
                    children.add((StructureViewTreeElement)new PsiMethodTreeElement(m, false));
                    break;
                }
                case 3: {
                    PsiClassInitializer i = (PsiClassInitializer)psiElement;
                    children.add((StructureViewTreeElement)new ClassInitializerTreeElement(i));
                    break;
                }
            }
        }
        PsiRecordHeader header = aClass.getRecordHeader();
        if (header != null) {
            for (PsiRecordComponent recordComponent : header.getRecordComponents()) {
                children.add((StructureViewTreeElement)new JavaRecordComponentTreeElement(recordComponent, false));
            }
        }
        return children;
    }

    @NotNull
    static Set<PsiElement> getOwnChildren(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaClassTreeElement.$$$reportNull$$$0(1);
        }
        HashSet<PsiElement> members = new HashSet<PsiElement>();
        JavaClassTreeElement.addPhysicalElements((PsiMember[])aClass.getFields(), members, aClass);
        JavaClassTreeElement.addPhysicalElements((PsiMember[])aClass.getMethods(), members, aClass);
        JavaClassTreeElement.addPhysicalElements((PsiMember[])aClass.getInnerClasses(), members, aClass);
        JavaClassTreeElement.addPhysicalElements((PsiMember[])aClass.getInitializers(), members, aClass);
        HashSet<PsiElement> hashSet = members;
        if (hashSet == null) {
            JavaClassTreeElement.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static void addPhysicalElements(PsiMember @NotNull [] elements, @NotNull Collection<? super PsiElement> to, @NotNull PsiClass aClass) {
        if (to == null) {
            JavaClassTreeElement.$$$reportNull$$$0(3);
        }
        if (aClass == null) {
            JavaClassTreeElement.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            JavaClassTreeElement.$$$reportNull$$$0(5);
        }
        for (PsiMember element : elements) {
            PsiMember member;
            PsiElement mirror = PsiImplUtil.handleMirror((PsiElement)element);
            if (mirror instanceof LightElement || !(mirror instanceof PsiMember) || !aClass.equals((Object)(member = (PsiMember)mirror).getContainingClass())) continue;
            to.add((PsiElement)mirror);
        }
    }

    public String getPresentableText() {
        PsiClass o = (PsiClass)this.getElement();
        return o == null ? "" : o.getName();
    }

    @Override
    public boolean isPublic() {
        PsiClass o = (PsiClass)this.getElement();
        return o != null && o.getParent() instanceof PsiFile || super.isPublic();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/impl/java/JavaClassTreeElement";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenBase";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/impl/java/JavaClassTreeElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOwnChildren";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPhysicalElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

