/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.ide.structureView.impl.java.ClassInitializerTreeElement;
import com.intellij.ide.structureView.impl.java.JavaAnonymousClassTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElement;
import com.intellij.ide.structureView.impl.java.PropertyGroup;
import com.intellij.ide.structureView.impl.java.PsiFieldTreeElement;
import com.intellij.ide.structureView.impl.java.PsiMethodTreeElement;
import com.intellij.ide.structureView.impl.java.SuperTypeGroup;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeActionWithDefaultState;
import com.intellij.psi.PsiMethod;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class KindSorter
implements Sorter,
TreeActionWithDefaultState {
    public static final Sorter INSTANCE = new KindSorter(false);
    public static final Sorter POPUP_INSTANCE = new KindSorter(true);
    @NonNls
    public static final String ID = "KIND";
    private final boolean isPopup;
    private final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return this.getWeight(o1) - this.getWeight(o2);
        }

        private int getWeight(Object value) {
            if (value instanceof JavaAnonymousClassTreeElement) {
                return 55;
            }
            if (value instanceof JavaClassTreeElement) {
                return KindSorter.this.isPopup ? 53 : 10;
            }
            if (value instanceof ClassInitializerTreeElement) {
                return 15;
            }
            if (value instanceof SuperTypeGroup) {
                return 20;
            }
            if (value instanceof PsiMethodTreeElement) {
                PsiMethodTreeElement methodTreeElement = (PsiMethodTreeElement)value;
                PsiMethod method = methodTreeElement.getMethod();
                return method != null && method.isConstructor() ? 30 : 35;
            }
            if (value instanceof PropertyGroup) {
                return 40;
            }
            if (value instanceof PsiFieldTreeElement) {
                return 50;
            }
            return 60;
        }
    };

    public KindSorter(boolean isPopup) {
        this.isPopup = isPopup;
    }

    @NotNull
    public Comparator getComparator() {
        Comparator comparator = this.COMPARATOR;
        if (comparator == null) {
            KindSorter.$$$reportNull$$$0(0);
        }
        return comparator;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(StructureViewBundle.message((String)"action.structureview.sort.by.kind", (Object[])new Object[0]), null, AllIcons.ObjectBrowser.SortByType);
    }

    @NotNull
    public String getName() {
        return ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/KindSorter", "getComparator"));
    }
}

