/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElementBase;
import com.intellij.ide.structureView.impl.java.PsiMethodTreeElement;
import com.intellij.ide.structureView.impl.java.SuperTypeGroup;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ArrayUtil;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SuperTypesGrouper
implements Grouper {
    public static final Key<WeakReference<PsiMethod>> SUPER_METHOD_KEY = Key.create((String)"StructureTreeBuilder.SUPER_METHOD_KEY");
    @NonNls
    public static final String ID = "SHOW_INTERFACES";

    @NotNull
    public Collection<Group> group(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<TreeElement> children) {
        if (parent == null) {
            SuperTypesGrouper.$$$reportNull$$$0(0);
        }
        if (children == null) {
            SuperTypesGrouper.$$$reportNull$$$0(1);
        }
        if (SuperTypesGrouper.isParentGrouped(parent)) {
            List<Group> list = Collections.emptyList();
            if (list == null) {
                SuperTypesGrouper.$$$reportNull$$$0(2);
            }
            return list;
        }
        HashMap<Group, SuperTypeGroup> groups = new HashMap<Group, SuperTypeGroup>();
        for (TreeElement child : children) {
            PsiMethodTreeElement element;
            PsiMethod method;
            Object[] superMethods;
            PsiElement psiElement;
            JavaClassTreeElementBase treeElement;
            if (child instanceof JavaClassTreeElementBase && (treeElement = (JavaClassTreeElementBase)child).isInherited() && (psiElement = treeElement.getElement()) instanceof PsiMember) {
                PsiMember member = (PsiMember)psiElement;
                PsiClass groupClass = member.getContainingClass();
                if (groupClass == null) continue;
                SuperTypeGroup group = SuperTypesGrouper.getOrCreateGroup(groupClass, SuperTypeGroup.OwnershipType.INHERITS, groups);
                group.addMethod(child);
                continue;
            }
            if (!(child instanceof PsiMethodTreeElement) || (superMethods = (method = (element = (PsiMethodTreeElement)child).getMethod()).findSuperMethods()).length <= 0) continue;
            for (int i = 1; i < superMethods.length; ++i) {
                PsiMethod superMethod = superMethods[i];
                PsiClass containingClass = superMethod.getContainingClass();
                if (containingClass == null || !containingClass.isInterface()) continue;
                ArrayUtil.swap((Object[])superMethods, (int)0, (int)i);
                break;
            }
            PsiMethod superMethod = superMethods[0];
            method.putUserData(SUPER_METHOD_KEY, new WeakReference<PsiMethod>(superMethod));
            PsiClass groupClass = superMethod.getContainingClass();
            boolean overrides = SuperTypesGrouper.methodOverridesSuper(method, superMethod);
            SuperTypeGroup.OwnershipType ownershipType = overrides ? SuperTypeGroup.OwnershipType.OVERRIDES : SuperTypeGroup.OwnershipType.IMPLEMENTS;
            SuperTypeGroup group = SuperTypesGrouper.getOrCreateGroup(groupClass, ownershipType, groups);
            group.addMethod(child);
        }
        Set<Group> set = groups.keySet();
        if (set == null) {
            SuperTypesGrouper.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static SuperTypeGroup getOrCreateGroup(PsiClass groupClass, SuperTypeGroup.OwnershipType ownershipType, Map<Group, SuperTypeGroup> groups) {
        SuperTypeGroup superTypeGroup = new SuperTypeGroup(groupClass, ownershipType);
        SuperTypeGroup existing = groups.get(superTypeGroup);
        if (existing == null) {
            groups.put(superTypeGroup, superTypeGroup);
            existing = superTypeGroup;
        }
        return existing;
    }

    private static boolean isParentGrouped(AbstractTreeNode<?> parent) {
        while (parent != null) {
            if (parent.getValue() instanceof SuperTypeGroup) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private static boolean methodOverridesSuper(PsiMethod method, PsiMethod superMethod) {
        return method.hasModifierProperty("abstract") || !superMethod.hasModifierProperty("abstract");
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(StructureViewBundle.message((String)"action.structureview.group.methods.by.defining.type", (Object[])new Object[0]), null, AllIcons.General.ImplementingMethod);
    }

    @NotNull
    public String getName() {
        return ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/impl/java/SuperTypesGrouper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/impl/java/SuperTypesGrouper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

