/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomModule;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J/\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/dom/inspections/MavenModulesInMaven4Inspection;", "Lcom/intellij/codeInspection/XmlSuppressableInspectionTool;", "<init>", "()V", "getShortName", "", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "replaceModulesToSubprojects", "Lcom/intellij/codeInspection/LocalQuickFix;", "model", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "intellij.maven"})
public final class MavenModulesInMaven4Inspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public String getShortName() {
        return "MavenModulesInMaven4";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (file2 instanceof XmlFile && file2.isPhysical()) {
            if (!MavenDomUtil.isProjectFileWithModel410(file2)) {
                return null;
            }
            DomFileElement domFileElement = DomManager.getDomManager((Project)file2.getProject()).getFileElement((XmlFile)file2, MavenDomProjectModel.class);
            if (domFileElement == null) {
                return null;
            }
            DomFileElement dom = domFileElement;
            DomElement domElement = dom.getRootElement();
            Intrinsics.checkNotNullExpressionValue((Object)domElement, (String)"getRootElement(...)");
            MavenDomProjectModel model = (MavenDomProjectModel)domElement;
            if (!model.getModules().exists()) {
                return null;
            }
            XmlTag xmlTag = model.getModules().getXmlTag();
            if (xmlTag == null) {
                return null;
            }
            XmlTag tag = xmlTag;
            LocalQuickFix fix2 = this.replaceModulesToSubprojects(model);
            ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)tag, MavenDomBundle.message("inspection.modules.tag.in.maven.4", new Object[0]), fix2, ProblemHighlightType.WARNING, isOnTheFly)};
            return problemDescriptorArray;
        }
        return null;
    }

    private final LocalQuickFix replaceModulesToSubprojects(MavenDomProjectModel model) {
        return new LocalQuickFix(model){
            final /* synthetic */ MavenDomProjectModel $model;
            {
                this.$model = $model;
            }

            public String getFamilyName() {
                String string = MavenDomBundle.message("inspection.modules.tag.in.maven.4", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public String getName() {
                String string = MavenDomBundle.message("inspection.modules.tag.in.maven.4.name", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            /*
             * WARNING - void declaration
             */
            public void applyFix(Project project, ProblemDescriptor descriptor2) {
                block2: {
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    List<MavenDomModule> list = this.$model.getModules().getModules();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getModules(...)");
                    Iterable $this$map$iv = list;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        MavenDomModule mavenDomModule = (MavenDomModule)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getStringValue());
                    }
                    List modulesList = (List)destination$iv$iv;
                    XmlElementFactory factory = XmlElementFactory.getInstance((Project)project);
                    XmlTag xmlTag = factory.createTagFromText((CharSequence)"<subprojects/>");
                    Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"createTagFromText(...)");
                    XmlTag subprojectsTag = xmlTag;
                    Iterable $this$forEach$iv = modulesList;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        XmlTag tag;
                        String it = (String)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)factory.createTagFromText((CharSequence)("<subproject>" + it + "</subproject>")), (String)"createTagFromText(...)");
                        subprojectsTag.addSubTag(tag, false);
                    }
                    XmlTag xmlTag2 = this.$model.getModules().getXmlTag();
                    if (xmlTag2 == null) break block2;
                    xmlTag2.replace((PsiElement)subprojectsTag);
                }
            }
        };
    }
}

