/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.openapi.externalSystem.service.ui.ExternalSystemJdkComboBox;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.ui.JBFont;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.IntStream;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenPropertiesPanel;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenRunnerPanel {
    protected final Project myProject;
    private final boolean myRunConfigurationMode;
    private JCheckBox myDelegateToMavenCheckbox;
    private RawCommandLineEditor myVMParametersEditor;
    private EnvironmentVariablesComponent myEnvVariablesComponent;
    private JLabel myJdkLabel;
    private ExternalSystemJdkComboBox myJdkCombo;
    private ComboBox<String> myTargetJdkCombo;
    private JCheckBox mySkipTestsCheckBox;
    private MavenPropertiesPanel myPropertiesPanel;
    private Map<String, String> myProperties;
    private String myTargetName;

    public MavenRunnerPanel(@NotNull Project p, boolean isRunConfiguration) {
        if (p == null) {
            MavenRunnerPanel.$$$reportNull$$$0(0);
        }
        this.myProject = p;
        this.myRunConfigurationMode = isRunConfiguration;
    }

    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets.bottom = 5;
        this.myDelegateToMavenCheckbox = new JCheckBox(MavenConfigurableBundle.message("maven.settings.runner.delegate", new Object[0]));
        if (!this.myRunConfigurationMode) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.gridwidth = 0;
            panel.add((Component)this.myDelegateToMavenCheckbox, c);
        }
        c.gridwidth = 1;
        JLabel labelVMParameters = new JLabel(MavenConfigurableBundle.message("maven.settings.runner.vm.options", new Object[0]));
        this.myVMParametersEditor = new RawCommandLineEditor();
        labelVMParameters.setLabelFor((Component)this.myVMParametersEditor);
        this.myVMParametersEditor.setDialogCaption(labelVMParameters.getText());
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        panel.add((Component)labelVMParameters, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets.left = 10;
        panel.add((Component)this.myVMParametersEditor, c);
        JLabel labelOverrideJvmConfig = new JLabel(MavenConfigurableBundle.message("maven.settings.vm.options.tooltip", new Object[0]));
        labelOverrideJvmConfig.setFont((Font)JBFont.small());
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 1.0;
        c.insets.left = 20;
        panel.add((Component)labelOverrideJvmConfig, c);
        c.insets.left = 0;
        this.myJdkLabel = new JLabel(MavenConfigurableBundle.message("maven.settings.runner.jre", new Object[0]));
        this.myJdkCombo = new ExternalSystemJdkComboBox(this.myProject);
        this.myJdkLabel.setLabelFor((Component)this.myJdkCombo);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        panel.add((Component)this.myJdkLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets.left = 10;
        c.fill = 2;
        panel.add((Component)this.myJdkCombo, c);
        this.myTargetJdkCombo = new ComboBox();
        ComponentUtil.putClientProperty(this.myTargetJdkCombo, (Key)UserActivityWatcher.DO_NOT_WATCH, (Object)true);
        this.myTargetJdkCombo.setVisible(false);
        panel.add((Component)this.myTargetJdkCombo, c);
        c.insets.left = 0;
        this.myEnvVariablesComponent = new EnvironmentVariablesComponent();
        this.myEnvVariablesComponent.setPassParentEnvs(true);
        this.myEnvVariablesComponent.setLabelLocation("West");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 2;
        panel.add((Component)this.myEnvVariablesComponent, c);
        c.gridwidth = 1;
        JPanel propertiesPanel = new JPanel(new BorderLayout());
        propertiesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)MavenConfigurableBundle.message("maven.settings.runner.properties", new Object[0]), (boolean)false));
        this.mySkipTestsCheckBox = new JCheckBox(MavenConfigurableBundle.message("maven.settings.runner.skip.tests", new Object[0]));
        propertiesPanel.add((Component)this.mySkipTestsCheckBox, "North");
        this.collectProperties();
        this.myPropertiesPanel = new MavenPropertiesPanel(this.myProperties);
        propertiesPanel.add((Component)((Object)this.myPropertiesPanel), "Center");
        this.myPropertiesPanel.getTable().setShowGrid(false);
        this.myPropertiesPanel.getEmptyText().setText(MavenConfigurableBundle.message("maven.settings.runner.properties.not.defined", new Object[0]));
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridheight = 0;
        c.gridwidth = 0;
        c.fill = 1;
        panel.add((Component)propertiesPanel, c);
        return panel;
    }

    private void collectProperties() {
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.myProject);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (manager.isMavenizedProject()) {
            for (MavenProject each : manager.getProjects()) {
                Properties properties = each.getProperties();
                result.putAll(properties);
            }
        }
        this.myProperties = result;
    }

    protected void getData(MavenRunnerSettings data) {
        this.myDelegateToMavenCheckbox.setSelected(data.isDelegateBuildToMaven());
        this.myVMParametersEditor.setText(data.getVmOptions());
        this.mySkipTestsCheckBox.setSelected(data.isSkipTests());
        this.myJdkCombo.refreshData(data.getJreName());
        this.myTargetJdkCombo.setSelectedItem((Object)data.getJreName());
        this.myPropertiesPanel.setDataFromMap(data.getMavenProperties());
        this.myEnvVariablesComponent.setEnvs(data.getEnvironmentProperties());
        this.myEnvVariablesComponent.setPassParentEnvs(data.isPassParentEnv());
    }

    protected void setData(MavenRunnerSettings data) {
        data.setDelegateBuildToMaven(this.myDelegateToMavenCheckbox.isSelected());
        data.setVmOptions(this.myVMParametersEditor.getText().trim());
        data.setSkipTests(this.mySkipTestsCheckBox.isSelected());
        if (this.myTargetName == null) {
            data.setJreName(this.myJdkCombo.getSelectedValue());
        } else {
            data.setJreName(StringUtil.notNullize((String)((String)this.myTargetJdkCombo.getItem()), (String)"#USE_PROJECT_JDK"));
        }
        data.setMavenProperties(this.myPropertiesPanel.getDataAsMap());
        data.setEnvironmentProperties(this.myEnvVariablesComponent.getEnvs());
        data.setPassParentEnv(this.myEnvVariablesComponent.isPassParentEnvs());
    }

    public Project getProject() {
        return this.myProject;
    }

    @ApiStatus.Internal
    void applyTargetEnvironmentConfiguration(@Nullable String targetName) {
        boolean targetChanged;
        boolean localTarget = targetName == null;
        boolean bl = targetChanged = !Objects.equals(this.myTargetName, targetName);
        if (targetChanged) {
            this.myTargetName = targetName;
            this.updateJdkComponents(targetName);
            if (localTarget) {
                this.myJdkCombo.refreshData(null);
            }
        } else if (!localTarget) {
            this.updateJdkComponents(targetName);
        }
    }

    private void updateJdkComponents(@Nullable String targetName) {
        boolean localTarget = targetName == null;
        this.myTargetJdkCombo.setVisible(!localTarget);
        this.myJdkCombo.setVisible(localTarget);
        if (!localTarget) {
            List<String> items = IntStream.range(0, this.myTargetJdkCombo.getItemCount()).mapToObj(i2 -> (String)this.myTargetJdkCombo.getItemAt(i2)).toList();
            ArrayList<String> targetItems = new ArrayList<String>();
            TargetEnvironmentConfiguration targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)TargetEnvironmentsManager.getInstance((Project)this.myProject).getTargets().findByName(targetName);
            if (targetEnvironmentConfiguration != null) {
                for (LanguageRuntimeConfiguration runtimeConfiguration : targetEnvironmentConfiguration.getRuntimes().resolvedConfigs()) {
                    if (!(runtimeConfiguration instanceof JavaLanguageRuntimeConfiguration)) continue;
                    String homePath = ((JavaLanguageRuntimeConfiguration)runtimeConfiguration).getHomePath();
                    targetItems.add(homePath);
                }
            }
            if (!items.equals(targetItems)) {
                this.myTargetJdkCombo.removeAllItems();
                targetItems.forEach(arg_0 -> this.myTargetJdkCombo.addItem(arg_0));
            }
            this.myJdkLabel.setLabelFor((Component)this.myTargetJdkCombo);
        } else {
            this.myJdkLabel.setLabelFor((Component)this.myJdkCombo);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/idea/maven/execution/MavenRunnerPanel", "<init>"));
    }
}

