/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution.run.configuration;

import com.intellij.openapi.externalSystem.service.ui.util.AsyncDistributionsInfo;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.distribution.AbstractDistributionInfo;
import com.intellij.openapi.roots.ui.distribution.DistributionInfo;
import com.intellij.openapi.roots.ui.distribution.LocalDistributionInfo;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.maven3.Bundled3DistributionInfo;
import org.jetbrains.idea.maven.maven4.Bundled4DistributionInfo;
import org.jetbrains.idea.maven.project.BundledMaven3;
import org.jetbrains.idea.maven.project.BundledMaven4;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenHomeType;
import org.jetbrains.idea.maven.project.MavenInSpecificPath;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenWrapper;
import org.jetbrains.idea.maven.project.StaticResolvedMavenHomeType;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0002 !B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0016\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u001aj\b\u0012\u0004\u0012\u00020\u0016`\u001bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/idea/maven/execution/run/configuration/MavenDistributionsInfo;", "Lcom/intellij/openapi/externalSystem/service/ui/util/AsyncDistributionsInfo;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "editorLabel", "", "getEditorLabel", "()Ljava/lang/String;", "settingsName", "getSettingsName", "settingsHint", "getSettingsHint", "comboBoxActionName", "getComboBoxActionName", "fileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "getFileChooserDescriptor", "()Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "distributions", "", "Lcom/intellij/openapi/roots/ui/distribution/DistributionInfo;", "getDistributions", "()Ljava/util/List;", "distributionsLateInit", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "isReady", "", "prepare", "", "WrappedDistributionInfo", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenDistributionsInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenDistributionsInfo.kt\norg/jetbrains/idea/maven/execution/run/configuration/MavenDistributionsInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1586#2:85\n1661#2,3:86\n*S KotlinDebug\n*F\n+ 1 MavenDistributionsInfo.kt\norg/jetbrains/idea/maven/execution/run/configuration/MavenDistributionsInfo\n*L\n50#1:85\n50#1:86,3\n*E\n"})
public final class MavenDistributionsInfo
implements AsyncDistributionsInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String editorLabel;
    @NotNull
    private final String settingsName;
    @Nullable
    private final String settingsHint;
    @NotNull
    private final String comboBoxActionName;
    private ArrayList<DistributionInfo> distributionsLateInit;

    public MavenDistributionsInfo(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        String string = MavenConfigurableBundle.message("maven.run.configuration.distribution.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.editorLabel = string;
        String string2 = MavenConfigurableBundle.message("maven.run.configuration.distribution.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.settingsName = string2;
        String string3 = MavenConfigurableBundle.message("maven.run.configuration.specify.distribution.action.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        this.comboBoxActionName = string3;
    }

    @NotNull
    public String getEditorLabel() {
        return this.editorLabel;
    }

    @NotNull
    public String getSettingsName() {
        return this.settingsName;
    }

    @Nullable
    public String getSettingsHint() {
        return this.settingsHint;
    }

    @NotNull
    public String getComboBoxActionName() {
        return this.comboBoxActionName;
    }

    @NotNull
    public FileChooserDescriptor getFileChooserDescriptor() {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(MavenProjectBundle.message("maven.select.maven.home.directory", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withTitle(...)");
        return fileChooserDescriptor;
    }

    @NotNull
    public List<DistributionInfo> getDistributions() {
        List list;
        if (!this.isReady()) {
            list = CollectionsKt.emptyList();
        } else {
            ArrayList<DistributionInfo> arrayList = this.distributionsLateInit;
            if (arrayList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"distributionsLateInit");
                arrayList = null;
            }
            list = arrayList;
        }
        return list;
    }

    public boolean isReady() {
        return this.distributionsLateInit != null;
    }

    /*
     * WARNING - void declaration
     */
    public void prepare() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$prepare_u24lambda_u240;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = new ArrayList();
        MavenDistributionsInfo mavenDistributionsInfo = this;
        boolean bl = false;
        UtilKt.addIfNotNull((List)((List)$this$prepare_u24lambda_u240), (Object)Companion.asDistributionInfo(MavenWrapper.INSTANCE));
        Iterable iterable = MavenUtil.getSystemMavenHomeVariants(this.project);
        Companion companion = Companion;
        void var6_7 = $this$prepare_u24lambda_u240;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            MavenHomeType mavenHomeType = (MavenHomeType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(companion.asDistributionInfo((MavenHomeType)p0));
        }
        var6_7.addAll((List)destination$iv$iv);
        mavenDistributionsInfo.distributionsLateInit = arrayList;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/maven/execution/run/configuration/MavenDistributionsInfo$Companion;", "", "<init>", "()V", "asDistributionInfo", "Lcom/intellij/openapi/roots/ui/distribution/DistributionInfo;", "mavenHomeType", "Lorg/jetbrains/idea/maven/project/MavenHomeType;", "asMavenHome", "distribution", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenDistributionsInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenDistributionsInfo.kt\norg/jetbrains/idea/maven/execution/run/configuration/MavenDistributionsInfo$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DistributionInfo asDistributionInfo(@NotNull MavenHomeType mavenHomeType) {
            DistributionInfo distributionInfo;
            String string;
            MavenHomeType mavenHomeType2;
            Intrinsics.checkNotNullParameter((Object)mavenHomeType, (String)"mavenHomeType");
            StaticResolvedMavenHomeType staticResolvedMavenHomeType = mavenHomeType2 = mavenHomeType instanceof StaticResolvedMavenHomeType ? (StaticResolvedMavenHomeType)mavenHomeType : null;
            if (mavenHomeType2 != null) {
                StaticResolvedMavenHomeType it = mavenHomeType2;
                boolean bl = false;
                string = MavenUtil.getMavenVersion(MavenUtil.getMavenHomePath(it));
            } else {
                string = null;
            }
            String version = string;
            mavenHomeType2 = mavenHomeType;
            if (mavenHomeType2 instanceof BundledMaven3) {
                distributionInfo = (DistributionInfo)new Bundled3DistributionInfo(version);
            } else if (mavenHomeType2 instanceof BundledMaven4) {
                distributionInfo = (DistributionInfo)new Bundled4DistributionInfo(version);
            } else if (mavenHomeType2 instanceof MavenWrapper) {
                distributionInfo = (DistributionInfo)new WrappedDistributionInfo();
            } else if (mavenHomeType2 instanceof MavenInSpecificPath) {
                distributionInfo = (DistributionInfo)new LocalDistributionInfo(((MavenInSpecificPath)mavenHomeType).getMavenHome());
            } else {
                throw new NoWhenBranchMatchedException(mavenHomeType.getClass().toString());
            }
            return distributionInfo;
        }

        @NotNull
        public final MavenHomeType asMavenHome(@NotNull DistributionInfo distribution) {
            MavenHomeType mavenHomeType;
            Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
            DistributionInfo distributionInfo = distribution;
            if (distributionInfo instanceof Bundled3DistributionInfo) {
                mavenHomeType = BundledMaven3.INSTANCE;
            } else if (distributionInfo instanceof Bundled4DistributionInfo) {
                mavenHomeType = BundledMaven4.INSTANCE;
            } else if (distributionInfo instanceof WrappedDistributionInfo) {
                mavenHomeType = MavenWrapper.INSTANCE;
            } else if (distributionInfo instanceof LocalDistributionInfo) {
                mavenHomeType = new MavenInSpecificPath(((LocalDistributionInfo)distribution).getPath());
            } else {
                throw new NoWhenBranchMatchedException(distribution.getClass().toString());
            }
            return mavenHomeType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/maven/execution/run/configuration/MavenDistributionsInfo$WrappedDistributionInfo;", "Lcom/intellij/openapi/roots/ui/distribution/AbstractDistributionInfo;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "intellij.maven"})
    public static final class WrappedDistributionInfo
    extends AbstractDistributionInfo {
        @NotNull
        private final String name;
        @Nullable
        private final String description;

        public WrappedDistributionInfo() {
            String string = MavenProjectBundle.message("maven.wrapper.version.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.name = string;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }
    }
}

