/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenConfiguratorsKt;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenEncodingConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "<init>", "()V", "PREPARED_MAPPER", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/idea/maven/importing/MavenEncodingConfigurator$EncodingMapper;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "beforeModelApplied", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableModelContext;", "afterModelApplied", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$AppliedModelContext;", "mapEncodings", "mavenProjects", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/idea/maven/project/MavenProject;", "project", "Lcom/intellij/openapi/project/Project;", "fillResourceEncoding", "mavenProject", "encodingMapper", "fillSourceEncoding", "getCharset", "Ljava/nio/charset/Charset;", "name", "", "EncodingMapper", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenEncodingConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenEncodingConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenEncodingConfigurator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1342#2,2:113\n1#3:115\n1586#4:116\n1661#4,3:117\n1915#4,2:120\n1915#4,2:122\n*S KotlinDebug\n*F\n+ 1 MavenEncodingConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenEncodingConfigurator\n*L\n39#1:113,2\n88#1:116\n88#1:117,3\n88#1:120,2\n95#1:122,2\n*E\n"})
public final class MavenEncodingConfigurator
implements MavenWorkspaceConfigurator {
    @NotNull
    private final Key<EncodingMapper> PREPARED_MAPPER;

    public MavenEncodingConfigurator() {
        Key key = Key.create((String)"ENCODING_MAPPER");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.PREPARED_MAPPER = key;
    }

    @Override
    public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Sequence allMavenProjects = SequencesKt.map((Sequence)SequencesKt.filter(context2.getMavenProjectsWithModules(), MavenEncodingConfigurator::beforeModelApplied$lambda$0), MavenEncodingConfigurator::beforeModelApplied$lambda$1);
        EncodingMapper mapper = this.mapEncodings((Sequence<MavenProject>)allMavenProjects, context2.getProject());
        this.PREPARED_MAPPER.set((UserDataHolder)context2, (Object)mapper);
    }

    @Override
    public void afterModelApplied(@NotNull MavenWorkspaceConfigurator.AppliedModelContext context2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            EncodingMapper encodingMapper = (EncodingMapper)this.PREPARED_MAPPER.get((UserDataHolder)context2);
            if (encodingMapper == null) break block0;
            encodingMapper.applyCollectedInfo();
        }
    }

    private final EncodingMapper mapEncodings(Sequence<MavenProject> mavenProjects, Project project) {
        EncodingMapper encodingMapper = new EncodingMapper(project);
        Sequence<MavenProject> $this$forEach$iv = mavenProjects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MavenProject mavenProject = (MavenProject)element$iv;
            boolean bl = false;
            ReadAction.compute(() -> MavenEncodingConfigurator.mapEncodings$lambda$0$0(this, mavenProject, encodingMapper));
            ReadAction.compute(() -> MavenEncodingConfigurator.mapEncodings$lambda$0$1(this, project, mavenProject, encodingMapper));
        }
        return encodingMapper;
    }

    /*
     * WARNING - void declaration
     */
    private final void fillResourceEncoding(Project project, MavenProject mavenProject, EncodingMapper encodingMapper) {
        block3: {
            Object object = mavenProject.getResourceEncoding(project);
            if (object == null) break block3;
            String p0 = object;
            boolean bl = false;
            Charset charset = this.getCharset(p0);
            object = charset;
            if (charset != null) {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                Object charset2 = object;
                boolean bl2 = false;
                Iterable $this$map$iv = mavenProject.getResources();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MavenResource mavenResource = (MavenResource)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getDirectory());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)it);
                    encodingMapper.processDir(it, (Charset)charset2);
                }
            }
        }
    }

    private final void fillSourceEncoding(MavenProject mavenProject, EncodingMapper encodingMapper) {
        block2: {
            Object object = mavenProject.getSourceEncoding();
            if (object == null) break block2;
            String p0 = object;
            boolean bl = false;
            Charset charset = this.getCharset(p0);
            object = charset;
            if (charset != null) {
                Object charset2 = object;
                boolean bl2 = false;
                Iterable $this$forEach$iv = mavenProject.getSources();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    encodingMapper.processDir(it, (Charset)charset2);
                }
            }
        }
    }

    private final Charset getCharset(String name) {
        try {
            return Charset.forName(name);
        }
        catch (UnsupportedCharsetException e) {
            MavenLog.LOG.warn("Charset " + name + " is not supported");
            return null;
        }
        catch (IllegalCharsetNameException e) {
            MavenLog.LOG.warn("Charset " + name + " is illegal");
            return null;
        }
    }

    private static final boolean beforeModelApplied$lambda$0(MavenWorkspaceConfigurator.MavenProjectWithModules it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MavenConfiguratorsKt.hasChanges(it);
    }

    private static final MavenProject beforeModelApplied$lambda$1(MavenWorkspaceConfigurator.MavenProjectWithModules it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMavenProject();
    }

    private static final Unit mapEncodings$lambda$0$0(MavenEncodingConfigurator this$0, MavenProject $mavenProject, EncodingMapper $encodingMapper) {
        this$0.fillSourceEncoding($mavenProject, $encodingMapper);
        return Unit.INSTANCE;
    }

    private static final Unit mapEncodings$lambda$0$1(MavenEncodingConfigurator this$0, Project $project, MavenProject $mavenProject, EncodingMapper $encodingMapper) {
        this$0.fillResourceEncoding($project, $mavenProject, $encodingMapper);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tJ\u0006\u0010\u0017\u001a\u00020\u0013R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R^\u0010\r\u001aR\u0012\u000e\b\u0001\u0012\n \u000f*\u0004\u0018\u00010\b0\b\u0012\u000e\b\u0001\u0012\n \u000f*\u0004\u0018\u00010\t0\t \u000f*'\u0012\u000e\b\u0001\u0012\n \u000f*\u0004\u0018\u00010\b0\b\u0012\u000e\b\u0001\u0012\n \u000f*\u0004\u0018\u00010\t0\t0\u0011\u00a2\u0006\u0002\b\u00100\u000e\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenEncodingConfigurator$EncodingMapper;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "newPointerMappings", "Ljava/util/LinkedHashMap;", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "Ljava/nio/charset/Charset;", "Lkotlin/collections/LinkedHashMap;", "encodingManager", "Lcom/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl;", "oldPointerMappings", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "processDir", "", "directory", "", "charset", "applyCollectedInfo", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenEncodingConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenEncodingConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenEncodingConfigurator$EncodingMapper\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,112:1\n42#2,3:113\n42#2,3:116\n221#3,2:119\n*S KotlinDebug\n*F\n+ 1 MavenEncodingConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenEncodingConfigurator$EncodingMapper\n*L\n60#1:113,3\n63#1:116,3\n66#1:119,2\n*E\n"})
    private static final class EncodingMapper {
        @NotNull
        private final LinkedHashMap<VirtualFilePointer, Charset> newPointerMappings;
        @NotNull
        private final EncodingProjectManagerImpl encodingManager;
        @NotNull
        private final Map<? extends VirtualFilePointer, ? extends Charset> oldPointerMappings;

        public EncodingMapper(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.newPointerMappings = new LinkedHashMap();
            EncodingProjectManager encodingProjectManager = EncodingProjectManager.getInstance((Project)project);
            Intrinsics.checkNotNull((Object)encodingProjectManager, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl");
            this.encodingManager = (EncodingProjectManagerImpl)encodingProjectManager;
            Map map = this.encodingManager.getAllPointersMappings();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAllPointersMappings(...)");
            this.oldPointerMappings = map;
        }

        public final void processDir(@NotNull String directory, @NotNull Charset charset) {
            VirtualFilePointer virtualFilePointer;
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            VirtualFile dirVfile = LocalFileSystem.getInstance().findFileByIoFile(new File(directory));
            if (dirVfile != null) {
                $i$f$service = false;
                serviceClass$iv = VirtualFilePointerManager.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                virtualFilePointer = ((VirtualFilePointerManager)object).create(dirVfile, (Disposable)this.encodingManager, null);
            } else {
                $i$f$service = false;
                serviceClass$iv = VirtualFilePointerManager.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                virtualFilePointer = ((VirtualFilePointerManager)object).create(VfsUtilCore.fileToUrl((File)new File(directory).getAbsoluteFile()), (Disposable)this.encodingManager, null);
            }
            VirtualFilePointer virtualFilePointer2 = virtualFilePointer;
            Intrinsics.checkNotNull((Object)virtualFilePointer2);
            VirtualFilePointer pointer = virtualFilePointer2;
            ((Map)this.newPointerMappings).put(pointer, charset);
            Map map = this.encodingManager.getAllPointersMappings();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAllPointersMappings(...)");
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                VirtualFilePointer filePointer = (VirtualFilePointer)it.getKey();
                if (!FileUtil.isAncestor((String)directory, (String)URLUtil.urlToPath((String)filePointer.getUrl()), (boolean)false)) continue;
                ((Map)this.newPointerMappings).put(filePointer, charset);
            }
        }

        public final void applyCollectedInfo() {
            if (this.newPointerMappings.isEmpty()) {
                return;
            }
            Map pointerMapping = MapsKt.plus(this.oldPointerMappings, (Map)this.newPointerMappings);
            this.encodingManager.setPointerMapping(pointerMapping);
        }
    }
}

