/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.maven3;

import com.intellij.maven.server.telemetry.MavenServerTelemetryClasspathUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenClasspathBuilder;
import org.jetbrains.idea.maven.MavenVersionAwareSupportExtension;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.BundledMaven3;
import org.jetbrains.idea.maven.project.StaticResolvedMavenHomeType;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.impl.BundledMavenDownloader;

public class Maven3Support
implements MavenVersionAwareSupportExtension {
    @NonNls
    private static final String MAIN_CLASS36 = "org.jetbrains.idea.maven.server.RemoteMavenServer36";

    @Override
    public boolean isSupportedByExtension(@NotNull Path mavenHome) {
        String version;
        if (mavenHome == null) {
            Maven3Support.$$$reportNull$$$0(0);
        }
        return StringUtil.compareVersionNumbers((String)(version = MavenUtil.getMavenVersion(mavenHome)), (String)"3.1") >= 0 && StringUtil.compareVersionNumbers((String)version, (String)"4") < 0;
    }

    @Override
    @Nullable
    public Path getMavenHomeFile(@Nullable StaticResolvedMavenHomeType mavenHomeType) {
        if (mavenHomeType == null) {
            return null;
        }
        if (mavenHomeType == BundledMaven3.INSTANCE) {
            return MavenDistributionsCache.resolveEmbeddedMavenHome().getMavenHome();
        }
        return null;
    }

    @Override
    @NotNull
    public List<Path> collectClassPathAndLibsFolder(@NotNull MavenDistribution distribution) {
        if (distribution == null) {
            Maven3Support.$$$reportNull$$$0(1);
        }
        ArrayList<Path> classpath = new ArrayList<Path>();
        if (MavenUtil.isRunningFromSources()) {
            MavenLog.LOG.debug("collecting classpath for local run");
            this.prepareClassPathForLocalRunAndUnitTests(distribution.getVersion(), classpath);
        } else {
            MavenLog.LOG.debug("collecting classpath for production");
            this.prepareClassPathForProduction(distribution.getVersion(), classpath);
        }
        MavenClasspathBuilder.addMavenLibs(classpath, distribution.getMavenHome());
        MavenLog.LOG.debug("Collected classpath = ", new Object[]{classpath});
        ArrayList<Path> arrayList = classpath;
        if (arrayList == null) {
            Maven3Support.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private void prepareClassPathForProduction(@NotNull String mavenVersion, List<Path> classpath) {
        if (mavenVersion == null) {
            Maven3Support.$$$reportNull$$$0(3);
        }
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
            MavenClasspathBuilder.addMavenServerLibraries(classpath, "intellij.maven.server3", "intellij.maven.server36");
        } else {
            MavenClasspathBuilder.addMavenServerLibraries(classpath, "intellij.maven.server3");
        }
    }

    private void prepareClassPathForLocalRunAndUnitTests(@NotNull String mavenVersion, List<Path> classpath) {
        if (mavenVersion == null) {
            Maven3Support.$$$reportNull$$$0(4);
        }
        BuildDependenciesCommunityRoot communityRoot = new BuildDependenciesCommunityRoot(Path.of(PathManager.getCommunityHomePath(), new String[0]));
        BundledMavenDownloader.INSTANCE.downloadMaven3LibsSync(communityRoot);
        classpath.add(PathManager.getJarForClass(MavenId.class));
        classpath.add(MavenUtil.locateModuleOutput("intellij.maven.server"));
        classpath.add(MavenUtil.locateModuleOutput("intellij.maven.server.telemetry"));
        classpath.addAll(MavenUtil.collectClasspath(MavenServerTelemetryClasspathUtil.TELEMETRY_CLASSES));
        Path parentFile = MavenUtil.getMavenPluginParentFile();
        classpath.add(MavenUtil.locateModuleOutput("intellij.maven.server.m3.common"));
        MavenClasspathBuilder.addDir(classpath, parentFile.resolve("maven3-server-common/lib"), (Function1<? super Path, Boolean>)((Function1)f -> true));
        classpath.add(MavenUtil.locateModuleOutput("intellij.maven.server.m3.impl"));
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
            classpath.add(MavenUtil.locateModuleOutput("intellij.maven.server.m36.impl"));
        }
    }

    @Override
    public String getMainClass(MavenDistribution distribution) {
        if (StringUtil.compareVersionNumbers((String)distribution.getVersion(), (String)"3.6") >= 0) {
            return MAIN_CLASS36;
        }
        return "org.jetbrains.idea.maven.server.RemoteMavenServer";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenHome";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/maven3/Maven3Support";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/maven3/Maven3Support";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassPathAndLibsFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedByExtension";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectClassPathAndLibsFolder";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForProduction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForLocalRunAndUnitTests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

