/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public abstract class MavenOpenOrCreateFilesAction
extends MavenAction {
    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MavenOpenOrCreateFilesAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Presentation p = e.getPresentation();
        List<File> files2 = this.getFiles(e);
        if (files2.isEmpty()) {
            p.setEnabled(false);
            return;
        }
        List<VirtualFile> virtualFiles = MavenOpenOrCreateFilesAction.collectVirtualFiles(files2);
        boolean enabled = true;
        if (files2.size() == 1 && virtualFiles.isEmpty()) {
            p.setText(MavenProjectBundle.message("action.Maven.create.file", files2.get(0).getName()));
        } else {
            enabled = virtualFiles.size() == files2.size();
            p.setText(MavenProjectBundle.message("action.Maven.open.file", files2.get(0).getName()));
        }
        p.setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            MavenOpenOrCreateFilesAction.$$$reportNull$$$0(1);
        }
        if ((project = MavenActionUtil.getProject(e.getDataContext())) == null) {
            return;
        }
        List<File> files2 = this.getFiles(e);
        List<VirtualFile> virtualFiles = MavenOpenOrCreateFilesAction.collectVirtualFiles(files2);
        if (files2.size() == 1 && virtualFiles.isEmpty()) {
            WriteCommandAction.writeCommandAction((Project)project).withName(e.getPresentation().getText()).run(() -> {
                File file2 = (File)files2.get(0);
                try {
                    VirtualFile virtualFile = VfsUtil.createDirectoryIfMissing((String)file2.getParent());
                    if (virtualFile != null) {
                        VirtualFile newFile = virtualFile.createChildData((Object)this, file2.getName());
                        virtualFiles.add(newFile);
                        MavenUtil.runFileTemplate(project, newFile, this.getFileTemplate());
                    }
                }
                catch (IOException ex) {
                    MavenUtil.showError(project, MavenProjectBundle.message("notification.title.cannot.create", file2.getName()), ex);
                }
            });
            return;
        }
        for (VirtualFile each : virtualFiles) {
            PsiNavigationSupport.getInstance().createNavigatable(project, each, -1).navigate(true);
        }
    }

    private static List<VirtualFile> collectVirtualFiles(List<File> files2) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (File each : files2) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(each);
            if (virtualFile == null) continue;
            result.add(virtualFile);
        }
        return result;
    }

    protected abstract List<File> getFiles(AnActionEvent var1);

    protected abstract String getFileTemplate();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/jetbrains/idea/maven/project/actions/MavenOpenOrCreateFilesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

