/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.mediator.daemon;

import com.intellij.execution.process.mediator.common.QuotaOptions;
import com.intellij.execution.process.mediator.common.QuotaState;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\r\u000e\u000fB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0005H&J\b\u0010\n\u001a\u00020\u0000H&J\b\u0010\u000b\u001a\u00020\fH&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0003\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/process/mediator/daemon/QuotaStopwatch;", "", "<init>", "()V", "options", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "getOptions", "()Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "adjust", "newOptions", "refresh", "toState", "Lcom/intellij/execution/process/mediator/common/QuotaState;", "New", "Active", "Expired", "Lcom/intellij/execution/process/mediator/daemon/QuotaStopwatch$Active;", "Lcom/intellij/execution/process/mediator/daemon/QuotaStopwatch$Expired;", "Lcom/intellij/execution/process/mediator/daemon/QuotaStopwatch$New;", "intellij.execution.process.mediator.daemon"})
abstract sealed class QuotaStopwatch {
    private QuotaStopwatch() {
    }

    @NotNull
    public abstract QuotaOptions getOptions();

    @NotNull
    public abstract QuotaStopwatch adjust(@NotNull QuotaOptions var1);

    @NotNull
    public abstract QuotaStopwatch refresh();

    @NotNull
    public abstract QuotaState toState();

    public /* synthetic */ QuotaStopwatch(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u0005J\b\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0001H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0083\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/execution/process/mediator/daemon/QuotaStopwatch$Active;", "Lcom/intellij/execution/process/mediator/daemon/QuotaStopwatch;", "options", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "startTimeMillis", "", "<init>", "(Lcom/intellij/execution/process/mediator/common/QuotaOptions;J)V", "getOptions", "()Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "isUnlimited", "", "()Z", "elapsed", "remaining", "isExpired", "adjust", "newOptions", "refresh", "toState", "Lcom/intellij/execution/process/mediator/common/QuotaState$Active;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.execution.process.mediator.daemon"})
    public static final class Active
    extends QuotaStopwatch {
        @NotNull
        private final QuotaOptions options;
        private final long startTimeMillis;

        public Active(@NotNull QuotaOptions options, long startTimeMillis) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(null);
            this.options = options;
            this.startTimeMillis = startTimeMillis;
        }

        public /* synthetic */ Active(QuotaOptions quotaOptions, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = System.currentTimeMillis();
            }
            this(quotaOptions, l);
        }

        @Override
        @NotNull
        public QuotaOptions getOptions() {
            return this.options;
        }

        public final boolean isUnlimited() {
            return this.getOptions().isUnlimited();
        }

        public final long elapsed() {
            return this.isUnlimited() ? 0L : System.currentTimeMillis() - this.startTimeMillis;
        }

        public final long remaining() {
            return this.isUnlimited() ? Long.MAX_VALUE : this.getOptions().getTimeLimitMs() - this.elapsed();
        }

        private final boolean isExpired() {
            return this.remaining() <= 0L;
        }

        @Override
        @NotNull
        public QuotaStopwatch adjust(@NotNull QuotaOptions newOptions) {
            Intrinsics.checkNotNullParameter((Object)newOptions, (String)"newOptions");
            return this.isExpired() ? (QuotaStopwatch)Expired.INSTANCE : (QuotaStopwatch)Active.copy$default(this, this.getOptions().adjust(newOptions), 0L, 2, null);
        }

        @Override
        @NotNull
        public QuotaStopwatch refresh() {
            return this.isExpired() ? (QuotaStopwatch)Expired.INSTANCE : (!this.getOptions().isRefreshable() ? (QuotaStopwatch)this : (QuotaStopwatch)Active.copy$default(this, null, System.currentTimeMillis(), 1, null));
        }

        @NotNull
        public QuotaState.Active toState() {
            return new QuotaState.Active(this.getOptions(), this.elapsed());
        }

        @NotNull
        public final QuotaOptions component1() {
            return this.options;
        }

        private final long component2() {
            return this.startTimeMillis;
        }

        @NotNull
        public final Active copy(@NotNull QuotaOptions options, long startTimeMillis) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new Active(options, startTimeMillis);
        }

        public static /* synthetic */ Active copy$default(Active active, QuotaOptions quotaOptions, long l, int n, Object object) {
            if ((n & 1) != 0) {
                quotaOptions = active.options;
            }
            if ((n & 2) != 0) {
                l = active.startTimeMillis;
            }
            return active.copy(quotaOptions, l);
        }

        @NotNull
        public String toString() {
            return "Active(options=" + this.options + ", startTimeMillis=" + this.startTimeMillis + ")";
        }

        public int hashCode() {
            int result = this.options.hashCode();
            result = result * 31 + Long.hashCode(this.startTimeMillis);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Active)) {
                return false;
            }
            Active active = (Active)other;
            if (!Intrinsics.areEqual((Object)this.options, (Object)active.options)) {
                return false;
            }
            return this.startTimeMillis == active.startTimeMillis;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0001H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/process/mediator/daemon/QuotaStopwatch$Expired;", "Lcom/intellij/execution/process/mediator/daemon/QuotaStopwatch;", "<init>", "()V", "options", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "getOptions", "()Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "adjust", "newOptions", "refresh", "toState", "Lcom/intellij/execution/process/mediator/common/QuotaState$Expired;", "intellij.execution.process.mediator.daemon"})
    public static final class Expired
    extends QuotaStopwatch {
        @NotNull
        public static final Expired INSTANCE = new Expired();

        private Expired() {
            super(null);
        }

        @Override
        @NotNull
        public QuotaOptions getOptions() {
            return QuotaOptions.Companion.getEXCEEDED();
        }

        @Override
        @NotNull
        public QuotaStopwatch adjust(@NotNull QuotaOptions newOptions) {
            Intrinsics.checkNotNullParameter((Object)newOptions, (String)"newOptions");
            return this;
        }

        @Override
        @NotNull
        public QuotaStopwatch refresh() {
            return this;
        }

        @NotNull
        public QuotaState.Expired toState() {
            return QuotaState.Expired.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u0001H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/execution/process/mediator/daemon/QuotaStopwatch$New;", "Lcom/intellij/execution/process/mediator/daemon/QuotaStopwatch;", "options", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "<init>", "(Lcom/intellij/execution/process/mediator/common/QuotaOptions;)V", "getOptions", "()Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "adjust", "newOptions", "refresh", "toState", "Lcom/intellij/execution/process/mediator/common/QuotaState$New;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.execution.process.mediator.daemon"})
    public static final class New
    extends QuotaStopwatch {
        @NotNull
        private final QuotaOptions options;

        public New(@NotNull QuotaOptions options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(null);
            this.options = options;
        }

        @Override
        @NotNull
        public QuotaOptions getOptions() {
            return this.options;
        }

        @Override
        @NotNull
        public QuotaStopwatch adjust(@NotNull QuotaOptions newOptions) {
            Intrinsics.checkNotNullParameter((Object)newOptions, (String)"newOptions");
            return this.copy(this.getOptions().adjust(newOptions));
        }

        @Override
        @NotNull
        public QuotaStopwatch refresh() {
            return new Active(this.getOptions(), 0L, 2, null);
        }

        @NotNull
        public QuotaState.New toState() {
            return new QuotaState.New(this.getOptions());
        }

        @NotNull
        public final QuotaOptions component1() {
            return this.options;
        }

        @NotNull
        public final New copy(@NotNull QuotaOptions options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new New(options);
        }

        public static /* synthetic */ New copy$default(New new_, QuotaOptions quotaOptions, int n, Object object) {
            if ((n & 1) != 0) {
                quotaOptions = new_.options;
            }
            return new_.copy(quotaOptions);
        }

        @NotNull
        public String toString() {
            return "New(options=" + this.options + ")";
        }

        public int hashCode() {
            return this.options.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof New)) {
                return false;
            }
            New new_ = (New)other;
            return Intrinsics.areEqual((Object)this.options, (Object)new_.options);
        }
    }
}

