/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.util;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.impl.CssImportImpl;
import com.intellij.psi.css.impl.stubs.CssImportStub;
import com.intellij.psi.css.reference.TemplateCssClassOrIdReference;
import com.intellij.psi.css.resolve.CssReferenceProviderUtil;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.stubs.StubBuildCachedValuesManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssResolveUtil {
    private static final StubBuildCachedValuesManager.StubBuildCachedValueProvider<String[], CssImport> GET_URI_STRINGS_PROVIDER_NEW = new StubBuildCachedValuesManager.StubBuildCachedValueProvider("css.import.uriStrings", importElement -> {
        SmartList result = new SmartList();
        for (PsiElement element : importElement.getUriElements()) {
            Pair<String, TextRange> data = CssReferenceProviderUtil.getFileReferenceData(element);
            if (data == null) continue;
            result.add((String)data.first);
        }
        return CachedValueProvider.Result.create((Object)ArrayUtilRt.toStringArray((Collection)result), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    });

    private CssResolveUtil() {
    }

    @NotNull
    public static List<String> consumeClassNames(@NotNull String attributeValue, @Nullable PsiElement element, @Nullable PairConsumer<? super String, ? super TextRange> consumer) {
        XmlAttribute attr;
        PsiElement endIndex2;
        int phpStartIndex;
        if (attributeValue == null) {
            CssResolveUtil.$$$reportNull$$$0(0);
        }
        if ((phpStartIndex = attributeValue.indexOf("<?")) >= 0) {
            int endIndex2;
            int phpEndIndex;
            SmartList result = new SmartList();
            if (phpStartIndex > 0) {
                result.addAll(CssResolveUtil.consumeClassNames(attributeValue.substring(0, phpStartIndex), element, consumer));
            }
            if ((phpEndIndex = attributeValue.lastIndexOf("?>")) > 0 && (endIndex2 = phpEndIndex + "?>".length()) < attributeValue.length()) {
                result.addAll(CssResolveUtil.consumeClassNames(attributeValue.substring(endIndex2), element, (PairConsumer<? super String, ? super TextRange>)((PairConsumer)(s, range) -> {
                    if (consumer != null) {
                        consumer.consume(s, (Object)range.shiftRight(endIndex2));
                    }
                })));
            }
            SmartList smartList = result;
            if (smartList == null) {
                CssResolveUtil.$$$reportNull$$$0(1);
            }
            return smartList;
        }
        String delimiters = " \t";
        if (element != null && (endIndex2 = element.getParent()) instanceof XmlAttribute && (attr = (XmlAttribute)endIndex2).getName().endsWith("Classes")) {
            delimiters = " \t,";
        }
        StringTokenizer st = new StringTokenizer(attributeValue, delimiters);
        ArrayList<String> names = new ArrayList<String>();
        int offset = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            names.add(token);
            offset = attributeValue.indexOf(token, offset);
            if (consumer != null) {
                consumer.consume((Object)token, (Object)TextRange.create((int)offset, (int)(offset + token.length())));
            }
            offset += token.length();
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            CssResolveUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public static boolean checkTagForMatching(@NotNull XmlTag tag, String attrNameToCheck, @Nullable String selectorName, @NotNull CssResolver resolver) {
        if (tag == null) {
            CssResolveUtil.$$$reportNull$$$0(3);
        }
        if (resolver == null) {
            CssResolveUtil.$$$reportNull$$$0(4);
        }
        if (selectorName == null) {
            return false;
        }
        boolean caseInsensitive = tag instanceof HtmlTag;
        String attributeValue = resolver.getAttributeValue(tag, attrNameToCheck);
        if (attributeValue == null) {
            for (String work : CssResolveUtil.findAppropriateClassOrIdAttributeValues(tag, attrNameToCheck, resolver)) {
                if (!CssResolveUtil.containsWord(caseInsensitive, work, selectorName)) continue;
                return true;
            }
        } else {
            return CssResolveUtil.containsWord(caseInsensitive, attributeValue, selectorName);
        }
        return false;
    }

    private static boolean containsWord(boolean caseInsensitive, String text, String word) {
        for (String styleName : StringUtil.tokenize((String)text, (String)"\t ")) {
            if (!(caseInsensitive ? styleName.equalsIgnoreCase(word) : styleName.equals(word))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<String> findAppropriateClassOrIdAttributeValues(@NotNull XmlTag tag, String attrNameToCheck, @NotNull CssResolver resolver) {
        String attrName;
        XmlAttribute attrValue;
        if (tag == null) {
            CssResolveUtil.$$$reportNull$$$0(5);
        }
        if (resolver == null) {
            CssResolveUtil.$$$reportNull$$$0(6);
        }
        XmlAttribute xmlAttribute = attrValue = (attrName = resolver.getResolvedAttrName()) != null ? tag.getAttribute(attrName) : null;
        if (attrValue != null) {
            XmlAttributeValue valueElement = attrValue.getValueElement();
            String value = resolver.getAttributeValue(tag, attrName);
            List<String> list = value != null ? CssResolveUtil.consumeClassNames(value, (PsiElement)valueElement, null) : Collections.emptyList();
            if (list == null) {
                CssResolveUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (XmlAttribute attribute : tag.getAttributes()) {
            String value;
            Object[] references;
            XmlAttributeValue xmlAttributeValue;
            if (!StringUtil.containsIgnoreCase((String)attribute.getName(), (String)attrNameToCheck) || (xmlAttributeValue = attribute.getValueElement()) == null || ContainerUtil.findInstance((Object[])(references = xmlAttributeValue.getReferences()), TemplateCssClassOrIdReference.class) == null || (value = resolver.getAttributeValue(tag, attribute.getName())) == null) continue;
            result.addAll(CssResolveUtil.consumeClassNames(value, (PsiElement)xmlAttributeValue, null));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            CssResolveUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static PsiFile @NotNull [] resolveImport(@NotNull CssImport importElement) {
        if (importElement == null) {
            CssResolveUtil.$$$reportNull$$$0(9);
        }
        ArrayList result = new ArrayList();
        for (PsiElement element : importElement.getUriElements()) {
            Collections.addAll(result, CssResolveManager.getInstance().resolveFiles(element));
        }
        PsiFile[] psiFileArray = !result.isEmpty() ? result.toArray(PsiFile.EMPTY_ARRAY) : PsiFile.EMPTY_ARRAY;
        if (psiFileArray == null) {
            CssResolveUtil.$$$reportNull$$$0(10);
        }
        return psiFileArray;
    }

    public static String @NotNull [] getUriStrings(@NotNull CssImport importElement) {
        CssImportImpl cssImportImpl;
        CssImportStub stub;
        if (importElement == null) {
            CssResolveUtil.$$$reportNull$$$0(11);
        }
        if (importElement instanceof CssImportImpl && (stub = (CssImportStub)(cssImportImpl = (CssImportImpl)importElement).getStub()) != null) {
            String[] stringArray = stub.getPaths();
            if (stringArray == null) {
                CssResolveUtil.$$$reportNull$$$0(12);
            }
            return stringArray;
        }
        String[] stringArray = (String[])StubBuildCachedValuesManager.getCachedValueStubBuildOptimized((PsiElement)importElement, GET_URI_STRINGS_PROVIDER_NEW);
        if (stringArray == null) {
            CssResolveUtil.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 7, 8, 10, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/util/CssResolveUtil";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/util/CssResolveUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "consumeClassNames";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findAppropriateClassOrIdAttributeValues";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImport";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUriStrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "consumeClassNames";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkTagForMatching";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAppropriateClassOrIdAttributeValues";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveImport";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUriStrings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 7, 8, 10, 12, 13 -> new IllegalStateException(string);
        };
    }
}

