/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.RelaxedNames;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigFileContributor;
import com.intellij.quarkus.config.QsMetaConfigKeyManager;
import com.intellij.quarkus.config.jam.MicroprofileConfigProperty;
import com.intellij.quarkus.config.smallrye.SmallRyeConfigUtils;
import com.intellij.util.Processor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/quarkus/config/QsConfigMethodUsageSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "parameters", "consumer", "Lcom/intellij/util/Processor;", "processConfigPropertiesInterfaceKey", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "processConfigPropertiesClassKey", "findMetaConfigKeyInModule", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsConfigMethodUsageSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsConfigMethodUsageSearcher.kt\ncom/intellij/quarkus/config/QsConfigMethodUsageSearcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class QsConfigMethodUsageSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public QsConfigMethodUsageSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters parameters, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary(parameters.getProject())) {
            return;
        }
        PsiMethod psiMethod = parameters.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"getMethod(...)");
        PsiMethod psiMethod2 = psiMethod;
        if (psiMethod2.hasModifier(JvmModifier.STATIC) || !psiMethod2.hasModifier(JvmModifier.PUBLIC)) {
            return;
        }
        PsiClass psiClass = psiMethod2.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass psiClass2 = psiClass;
        if (!psiClass2.isValid()) {
            return;
        }
        if (psiClass2.isInterface()) {
            this.processConfigPropertiesInterfaceKey(parameters, psiMethod2);
        } else {
            this.processConfigPropertiesClassKey(parameters, psiMethod2);
        }
    }

    private final void processConfigPropertiesInterfaceKey(MethodReferencesSearch.SearchParameters parameters, PsiMethod psiMethod) {
        Object object;
        String name;
        MicroprofileConfigProperty configProperty;
        JvmParameter[] jvmParameterArray = psiMethod.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"getParameters(...)");
        if (!(((Object[])jvmParameterArray).length == 0)) {
            return;
        }
        HashSet<Object> names = new HashSet<Object>();
        JamMemberMeta[] jamMemberMetaArray = new JamMemberMeta[]{MicroprofileConfigProperty.Companion.getMETHOD_META()};
        MicroprofileConfigProperty microprofileConfigProperty = configProperty = (MicroprofileConfigProperty)JamService.getJamService((Project)parameters.getProject()).getJamElement((PsiElement)psiMethod, jamMemberMetaArray);
        String configName = microprofileConfigProperty != null ? microprofileConfigProperty.getName() : null;
        CharSequence charSequence = configName;
        if (charSequence == null || charSequence.length() == 0) {
            String string = PropertyUtilBase.getPropertyName((PsiMethod)psiMethod);
            if (string == null) {
                String string2 = psiMethod.getName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            }
            name = string;
            names.add(name);
            String string3 = RelaxedNames.camelCaseToHyphen((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"camelCaseToHyphen(...)");
            String string4 = string3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            v6 = names.add(string4);
        } else {
            v6 = names.add(configName);
        }
        names.remove(psiMethod.getName());
        Project project = psiMethod.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (SmallRyeConfigUtils.INSTANCE.hasSmallRyeConfig$intellij_quarkus(project) && (name = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiMethod))) != null) {
            String module = name;
            boolean bl = false;
            object = this.findMetaConfigKeyInModule((Module)module, psiMethod);
            if (object != null) {
                Object metaConfigKey = object;
                boolean bl2 = false;
                String string = metaConfigKey.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                char[] cArray = new char[]{'.'};
                names.add(CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null)));
            }
        }
        if (names.isEmpty()) {
            return;
        }
        SearchScope searchScope = parameters.getEffectiveSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getEffectiveSearchScope(...)");
        SearchScope searchScope2 = QsConfigFileContributor.Companion.getReferenceSearchScope(searchScope);
        Iterator iterator = names.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        object = iterator;
        while (object.hasNext()) {
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            String name2 = (String)e;
            parameters.getOptimizer().searchWord(name2, searchScope2, (short)255, true, (PsiElement)psiMethod);
        }
    }

    private final void processConfigPropertiesClassKey(MethodReferencesSearch.SearchParameters parameters, PsiMethod psiMethod) {
        if (!PropertyUtilBase.isSimplePropertySetter((PsiMethod)psiMethod)) {
            return;
        }
        String string = PropertyUtilBase.getPropertyName((PsiMethod)psiMethod);
        if (string == null) {
            return;
        }
        String name = string;
        SearchScope searchScope = parameters.getEffectiveSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getEffectiveSearchScope(...)");
        SearchScope searchScope2 = QsConfigFileContributor.Companion.getReferenceSearchScope(searchScope);
        parameters.getOptimizer().searchWord(name, searchScope2, (short)255, true, (PsiElement)psiMethod);
        String string2 = RelaxedNames.camelCaseToHyphen((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"camelCaseToHyphen(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String hyphenedName = string3;
        if (!Intrinsics.areEqual((Object)hyphenedName, (Object)name)) {
            parameters.getOptimizer().searchWord(hyphenedName, searchScope2, (short)255, true, (PsiElement)psiMethod);
        }
    }

    private final MetaConfigKey findMetaConfigKeyInModule(Module module, PsiMethod psiMethod) {
        for (MetaConfigKey key : QsMetaConfigKeyManager.Companion.getInstance().getAllMetaConfigKeys(module)) {
            PsiElement declaration;
            if (key.getDeclarationResolveResult() != MetaConfigKey.DeclarationResolveResult.PROPERTY || !((declaration = key.getDeclaration().getNavigationElement()) instanceof PsiMethod) || !psiMethod.getManager().areElementsEquivalent(declaration, (PsiElement)psiMethod)) continue;
            return key;
        }
        return null;
    }
}

