/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.Property;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.QsMetaConfigKeyManager;
import com.intellij.quarkus.config.properties.QsPropertiesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/quarkus/config/properties/QsPropertyKeyMetaConfigKeyReference;", "Lcom/intellij/microservices/jvm/config/MetaConfigKeyReference;", "Lcom/intellij/psi/PsiElement;", "element", "property", "Lcom/intellij/lang/properties/psi/Property;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/lang/properties/psi/Property;)V", "calculateDefaultRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getReferenceDisplayText", "", "getVariants", "", "", "()[Ljava/lang/Object;", "getProfilePrefix", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsPropertyKeyMetaConfigKeyReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsPropertyKeyMetaConfigKeyReference.kt\ncom/intellij/quarkus/config/properties/QsPropertyKeyMetaConfigKeyReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1642#2,10:44\n1915#2:54\n1916#2:56\n1652#2:57\n777#2:58\n873#2,2:59\n1586#2:61\n1661#2,3:62\n1#3:55\n*S KotlinDebug\n*F\n+ 1 QsPropertyKeyMetaConfigKeyReference.kt\ncom/intellij/quarkus/config/properties/QsPropertyKeyMetaConfigKeyReference\n*L\n29#1:44,10\n29#1:54\n29#1:56\n29#1:57\n31#1:58\n31#1:59,2\n31#1:61\n31#1:62,3\n29#1:55\n*E\n"})
public final class QsPropertyKeyMetaConfigKeyReference
extends MetaConfigKeyReference<PsiElement> {
    @NotNull
    private final Property property;

    public QsPropertyKeyMetaConfigKeyReference(@NotNull PsiElement element, @NotNull Property property) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        MetaConfigKeyManager metaConfigKeyManager = QsMetaConfigKeyManager.Companion.getInstance();
        String string = ((IProperty)property).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        super(metaConfigKeyManager, element, QsConfigUtils.INSTANCE.trimProfile(string));
        this.property = property;
    }

    @NotNull
    protected TextRange calculateDefaultRangeInElement() {
        TextRange defaultRange = super.calculateDefaultRangeInElement();
        String string = defaultRange.substring(this.getElement().getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String keyText = string;
        String trimmedText = QsConfigUtils.INSTANCE.trimProfile(keyText);
        if (trimmedText.length() < keyText.length()) {
            defaultRange = defaultRange.cutOut(TextRange.create((int)(keyText.length() - trimmedText.length()), (int)keyText.length()));
        }
        TextRange textRange = defaultRange;
        Intrinsics.checkNotNull((Object)textRange);
        return QsPropertiesUtils.INSTANCE.adjustMapTypeKeyReferenceRange$intellij_quarkus(textRange, this.getResolvedKey(), trimmedText);
    }

    @NotNull
    public String getReferenceDisplayText() {
        String string = this.property.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return QsConfigUtils.INSTANCE.trimProfile(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object[] getVariants() {
        Iterable $this$mapNotNullTo$iv$iv;
        String profile = this.getProfilePrefix();
        List list = this.property.getPropertiesFile().getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProperties(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            IProperty p0 = (IProperty)element$iv$iv;
            boolean bl2 = false;
            if (p0.getKey() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List properties = (List)destination$iv$iv;
        if (((CharSequence)profile).length() > 0) {
            void $this$mapTo$iv$iv;
            String it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = properties;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)profile, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.substring(profile.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                collection.add(string);
            }
            properties = (List)destination$iv$iv;
        }
        Set existingKeys = CollectionsKt.toSet((Iterable)properties);
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        MetaConfigKeyManager metaConfigKeyManager = this.getConfigKeyManager();
        Intrinsics.checkNotNullExpressionValue((Object)metaConfigKeyManager, (String)"getConfigKeyManager(...)");
        return QsPropertiesUtils.INSTANCE.getMetaConfigKeyVariants$intellij_quarkus(psiElement, metaConfigKeyManager, existingKeys);
    }

    private final String getProfilePrefix() {
        TextRange defaultRange = super.calculateDefaultRangeInElement();
        String string = defaultRange.substring(this.getElement().getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String keyText = string;
        String trimmedText = QsConfigUtils.INSTANCE.trimProfile(keyText);
        String string2 = keyText.substring(0, keyText.length() - trimmedText.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }
}

