/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.timeTracking;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitMessageProvider;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.timeTracking.TimeTrackingPlaceholderProvider;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class TaskCommitMessageProvider
implements CommitMessageProvider {
    @Nullable
    public String getCommitMessage(@NotNull LocalChangeList forChangelist, @NotNull Project project) {
        LocalTask task;
        if (forChangelist == null) {
            TaskCommitMessageProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            TaskCommitMessageProvider.$$$reportNull$$$0(1);
        }
        if ((task = TaskManager.getManager((Project)project).getAssociatedTask(forChangelist)) == null) {
            return null;
        }
        TaskRepository repository = task.getRepository();
        if (repository == null || !repository.isShouldFormatCommitMessage()) {
            return null;
        }
        String oldComment = forChangelist.getComment();
        String comment = TaskUtil.getChangeListComment((Task)task);
        if (oldComment == null) {
            return comment;
        }
        Matcher matcher = TaskRepository.TIME_SPENT_PATTERN.matcher(oldComment);
        if (!matcher.find()) {
            return null;
        }
        return matcher.replaceAll(new TimeTrackingPlaceholderProvider().getPlaceholderValue(task, "time"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "forChangelist";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/tasks/timeTracking/TaskCommitMessageProvider";
        objectArray[2] = "getCommitMessage";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

