/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootMainClassInfoProvider;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class SpringInitializrRunConfigurationService
implements Disposable {
    private final ExecutorService myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)(SpringInitializrRunConfigurationService.class.getSimpleName() + " Pool"), (int)1);

    public static SpringInitializrRunConfigurationService getInstance() {
        return (SpringInitializrRunConfigurationService)ApplicationManager.getApplication().getService(SpringInitializrRunConfigurationService.class);
    }

    public void createRunConfiguration(@NotNull Module module, @NotNull Condition<? super Module> condition) {
        if (module == null) {
            SpringInitializrRunConfigurationService.$$$reportNull$$$0(0);
        }
        if (condition == null) {
            SpringInitializrRunConfigurationService.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ReadAction.run(() -> {
                if (condition.value((Object)module)) {
                    SpringInitializrRunConfigurationService.updateSpringBootRunConfiguration(SpringBootApplicationConfigurationTypeBase.getInstance(), module);
                }
            });
            return;
        }
        ReadAction.nonBlocking(() -> {
            if (condition.value((Object)module)) {
                SpringInitializrRunConfigurationService.updateSpringBootRunConfiguration(SpringBootApplicationConfigurationTypeBase.getInstance(), module);
            }
        }).inSmartMode(module.getProject()).expireWith((Disposable)this).expireWith((Disposable)module).coalesceBy(new Object[]{SpringInitializrRunConfigurationService.class, module}).submit((Executor)this.myExecutorService);
    }

    public void dispose() {
        this.myExecutorService.shutdownNow();
    }

    private static void updateSpringBootRunConfiguration(@NotNull SpringBootApplicationConfigurationTypeBase springBootType, @NotNull Module module) {
        List applications;
        if (springBootType == null) {
            SpringInitializrRunConfigurationService.$$$reportNull$$$0(2);
        }
        if (module == null) {
            SpringInitializrRunConfigurationService.$$$reportNull$$$0(3);
        }
        if ((applications = SpringBootApplicationService.getInstance().getSpringApplications(module)).size() != 1) {
            return;
        }
        PsiClass springBootApp = (PsiClass)applications.get(0);
        if (!SpringBootMainClassInfoProvider.Companion.getInstance().hasMainMethod(springBootApp) || springBootApp == null) {
            return;
        }
        List<SpringBootApplicationRunConfigurationBase> existingConfigurations = SpringInitializrRunConfigurationService.getSpringBootRunConfigurations(module, (ConfigurationType)springBootType);
        SpringInitializrRunConfigurationService.updateExistingSpringBootRunConfiguration(existingConfigurations);
        if (SpringInitializrRunConfigurationService.hasSpringBootRunConfiguration((JvmClass)springBootApp, module, existingConfigurations)) {
            return;
        }
        SpringInitializrRunConfigurationService.createSpringBootRunConfiguration(springBootApp.getQualifiedName(), springBootType, module);
    }

    private static void createSpringBootRunConfiguration(@Nullable String springBootApp, @NotNull SpringBootApplicationConfigurationTypeBase springBootType, @NotNull Module module) {
        if (springBootType == null) {
            SpringInitializrRunConfigurationService.$$$reportNull$$$0(4);
        }
        if (module == null) {
            SpringInitializrRunConfigurationService.$$$reportNull$$$0(5);
        }
        if (springBootApp == null) {
            return;
        }
        try {
            RunManager runManager = RunManager.getInstance((Project)module.getProject());
            RunnerAndConfigurationSettings settings = runManager.createConfiguration("", springBootType.getDefaultConfigurationFactory());
            SpringBootApplicationRunConfiguration newRunConfig = (SpringBootApplicationRunConfiguration)settings.getConfiguration();
            newRunConfig.setModule(module);
            newRunConfig.setSpringBootMainClass(springBootApp);
            newRunConfig.setDefaultFrameDeactivationUpdatePolicy();
            settings.setName(newRunConfig.suggestedName());
            newRunConfig.setGeneratedName();
            runManager.setUniqueNameIfNeeded(settings);
            runManager.addConfiguration(settings);
            if (runManager.getAllSettings().size() == 1) {
                runManager.setSelectedConfiguration(settings);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            Logger.getInstance(SpringInitializrRunConfigurationService.class).error("Error creating Spring Boot run configuration for " + springBootApp, t);
        }
    }

    private static List<SpringBootApplicationRunConfigurationBase> getSpringBootRunConfigurations(@NotNull Module module, @NotNull ConfigurationType springBootType) {
        if (module == null) {
            SpringInitializrRunConfigurationService.$$$reportNull$$$0(6);
        }
        if (springBootType == null) {
            SpringInitializrRunConfigurationService.$$$reportNull$$$0(7);
        }
        return RunManager.getInstance((Project)module.getProject()).getConfigurationsList(springBootType).stream().filter(SpringBootApplicationRunConfigurationBase.class::isInstance).map(SpringBootApplicationRunConfigurationBase.class::cast).toList();
    }

    private static void updateExistingSpringBootRunConfiguration(List<SpringBootApplicationRunConfigurationBase> existingConfigurations) {
        existingConfigurations.forEach(configuration -> {
            if (configuration instanceof SpringBootApplicationRunConfiguration) {
                SpringBootApplicationRunConfiguration c = (SpringBootApplicationRunConfiguration)configuration;
                c.getExtender().restoreCorruptedDefaults();
            }
        });
    }

    private static boolean hasSpringBootRunConfiguration(@NotNull JvmClass applicationClass, @NotNull Module module, List<SpringBootApplicationRunConfigurationBase> existingConfigurations) {
        if (applicationClass == null) {
            SpringInitializrRunConfigurationService.$$$reportNull$$$0(8);
        }
        if (module == null) {
            SpringInitializrRunConfigurationService.$$$reportNull$$$0(9);
        }
        return ContainerUtil.exists(existingConfigurations, sbConfig -> {
            String mainClass = sbConfig.getSpringBootMainClass();
            if (mainClass == null) {
                return false;
            }
            if (mainClass.equals(applicationClass.getQualifiedName())) {
                Module configModule = sbConfig.getModule();
                if (configModule == null) {
                    sbConfig.setModule(module);
                    return true;
                }
                if (configModule.equals((Object)module)) {
                    return true;
                }
                HashSet dependentModules = new HashSet();
                ModuleUtilCore.collectModulesDependsOn((Module)module, dependentModules);
                if (dependentModules.contains(configModule)) {
                    return true;
                }
                if (sbConfig.getMainClass() == null) {
                    sbConfig.setModule(module);
                    return true;
                }
            }
            return false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBootType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/SpringInitializrRunConfigurationService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createRunConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSpringBootRunConfiguration";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createSpringBootRunConfiguration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpringBootRunConfigurations";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSpringBootRunConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

