/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.debugger.impl.attach.JavaDebuggerAttachUtil;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.remote.RemoteProcess;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.AsyncLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

class JmxServiceUrlLiveProperty
extends AsyncLiveProperty<String> {
    private static final String JMX_CONNECTION_ADDRESS_PROPERTY = "com.sun.management.jmxremote.localConnectorAddress";
    private static final String LOCAL_JMX_CONNECTOR_URL = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
    private final ProcessHandler myProcessHandler;
    private final SpringBootApplicationRunConfigurationBase myConfiguration;

    JmxServiceUrlLiveProperty(LifecycleErrorHandler errorHandler, Disposable parent, ProcessHandler processHandler, SpringBootApplicationRunConfigurationBase configuration) {
        super(errorHandler, parent, "");
        this.myProcessHandler = processHandler;
        this.myConfiguration = configuration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doCompute() throws LifecycleException {
        String url22;
        VirtualMachine vm;
        try {
            vm = this.attachVirtualMachine();
            if (vm == null) {
                throw new AttachNotSupportedException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.process.not.found", new Object[0]));
            }
        }
        catch (AttachNotSupportedException | IOException e) {
            String url = this.getConnectionUrlByPort();
            if (url == null) throw new LifecycleException(null, new LifecycleException("", e));
            return url;
        }
        catch (ProcessCanceledException ignored) {
            return null;
        }
        catch (Throwable e) {
            String url22 = this.getConnectionUrlByPort();
            if (url22 != null) {
                return url22;
            }
            Throwable cause = e.getCause();
            if (cause == null) throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.jmx.service.url", new Object[0]), e);
            if (cause instanceof Exception) throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.jmx.service.url", new Object[0]), e);
            throw new LifecycleException(null, new LifecycleException("", e));
        }
        try {
            String url = vm.getAgentProperties().getProperty(JMX_CONNECTION_ADDRESS_PROPERTY);
            if (StringUtil.isEmpty((String)url)) {
                throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.jmx.agent.not.loaded", new Object[0]), null);
            }
            url22 = url;
        }
        catch (Throwable e) {
            try {
                String url3 = this.getConnectionUrlByPort();
                if (url3 == null) throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.jmx.service.url", new Object[0]), e);
                String string = url3;
                return string;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    vm.detach();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            vm.detach();
            return url22;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return url22;
    }

    @Nullable
    private String getConnectionUrlByPort() {
        Integer jmxPort = (Integer)this.myProcessHandler.getUserData(SpringBootApplicationLifecycleManager.JMX_PORT);
        if (jmxPort == null || jmxPort <= 0) {
            return null;
        }
        return String.format(LOCAL_JMX_CONNECTOR_URL, NetUtils.getLocalHostString(), jmxPort);
    }

    @Nullable
    private VirtualMachine attachVirtualMachine() throws IOException, AttachNotSupportedException {
        if (this.myProcessHandler instanceof BaseProcessHandler) {
            return JmxServiceUrlLiveProperty.attachByProcess(((BaseProcessHandler)this.myProcessHandler).getProcess());
        }
        String processUID = (String)this.myProcessHandler.getUserData(SpringBootApplicationLifecycleManagerImpl.PROCESS_UID);
        if (processUID == null) {
            return null;
        }
        String className = (String)ReadAction.nonBlocking(() -> {
            PsiClass mainClass = this.myConfiguration.getMainClass();
            return mainClass == null ? this.myConfiguration.getSpringBootMainClass() : mainClass.getQualifiedName();
        }).expireWith((Disposable)this).inSmartMode(this.myConfiguration.getProject()).executeSynchronously();
        return JmxServiceUrlLiveProperty.attachByEnv(className, processUID);
    }

    @Nullable
    private static VirtualMachine attachByProcess(Process process) throws IOException, AttachNotSupportedException {
        String pid;
        if (process instanceof RemoteProcess) {
            return null;
        }
        try {
            pid = String.valueOf(OSProcessUtil.getProcessID((Process)process));
        }
        catch (IllegalStateException ignored) {
            return null;
        }
        return JavaDebuggerAttachUtil.attachVirtualMachine((String)pid);
    }

    @Nullable
    private static VirtualMachine attachByEnv(String className, String processUID) {
        List descriptors = ContainerUtil.filter(VirtualMachine.list(), descriptor -> {
            String displayName = descriptor.displayName();
            if (displayName == null) {
                return false;
            }
            String descriptorClassName = StringUtil.substringBefore((String)displayName, (String)" ");
            if (descriptorClassName == null) {
                descriptorClassName = displayName;
            }
            return className.equals(descriptorClassName);
        });
        for (VirtualMachineDescriptor descriptor2 : descriptors) {
            try {
                VirtualMachine vm = JavaDebuggerAttachUtil.attachVirtualMachine((String)descriptor2.id());
                Properties properties = vm.getSystemProperties();
                String value = properties.getProperty("ij.spring.boot.application.process");
                if (!processUID.equals(value)) continue;
                return vm;
            }
            catch (AttachNotSupportedException | IOException exception) {
            }
        }
        return null;
    }
}

