/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.Disposable;
import com.intellij.spring.boot.run.lifecycle.AsyncApplicationLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootModuleDescriptor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class ServerConfigurationLiveProperty
extends AsyncApplicationLiveProperty<SpringBootApplicationServerConfiguration> {
    public ServerConfigurationLiveProperty(LiveProperty<SpringBootModuleDescriptor> moduleDescriptor, LiveProperty<String> serviceUrl, LifecycleErrorHandler errorHandler, Disposable parent) {
        super(moduleDescriptor, serviceUrl, errorHandler, parent);
    }

    @Override
    @VisibleForTesting
    public SpringBootApplicationServerConfiguration doCompute() {
        MyApplicationServerConfiguration myApplicationServerConfiguration;
        block9: {
            SpringBootApplicationConnector connector = this.getApplicationConnector();
            try {
                boolean sslEnabled = false;
                Object keyStore = connector.getProperty("server.ssl.key-store");
                if (keyStore != null) {
                    sslEnabled = connector.getBooleanProperty("server.ssl.enabled", true);
                }
                Object contextPath = connector.getProperty(SpringBootApplicationConnector.SERVER_CONTEXT_PATH_PROPERTY);
                Object servletPath = connector.getProperty(SpringBootApplicationConnector.SERVER_SERVLET_PATH_PROPERTY);
                Object address = connector.getProperty("server.address");
                myApplicationServerConfiguration = new MyApplicationServerConfiguration(sslEnabled, contextPath == null ? null : contextPath.toString(), servletPath == null ? null : servletPath.toString(), address == null ? null : address.toString());
                if (connector == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connector != null) {
                        try {
                            connector.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ignored) {
                    return null;
                }
            }
            connector.close();
        }
        return myApplicationServerConfiguration;
    }

    private static final class MyApplicationServerConfiguration
    implements SpringBootApplicationServerConfiguration {
        private final boolean mySslEnabled;
        private final String myContextPath;
        private final String myServletPath;
        private final String myAddress;

        MyApplicationServerConfiguration(boolean sslEnabled, String contextPath, String servletPath, String address) {
            this.mySslEnabled = sslEnabled;
            this.myContextPath = contextPath;
            this.myServletPath = servletPath;
            this.myAddress = address;
        }

        public boolean isSslEnabled() {
            return this.mySslEnabled;
        }

        @Nullable
        public String getContextPath() {
            return this.myContextPath;
        }

        @Nullable
        public String getServletPath() {
            return this.myServletPath;
        }

        @Nullable
        public String getAddress() {
            return this.myAddress;
        }
    }
}

