/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trace.consent.storage.logging;

import com.intellij.internal.statistic.StatisticsServiceScope;
import com.intellij.internal.statistic.config.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.DefaultEventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFileWriter;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.trace.consent.model.TraceStateEvent;
import com.intellij.platform.trace.consent.storage.serialization.TraceStateEventSerializer;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/trace/consent/storage/logging/TraceStateEventLogFileWriter;", "Lcom/intellij/openapi/Disposable;", "maxFileSizeInBytes", "", "eventLogDir", "Ljava/nio/file/Path;", "<init>", "(ILjava/nio/file/Path;)V", "value", "Lcom/intellij/internal/statistic/eventLog/EventLogFileWriter;", "logger", "setLogger", "(Lcom/intellij/internal/statistic/eventLog/EventLogFileWriter;)V", "log", "", "event", "Lcom/intellij/platform/trace/consent/model/TraceStateEvent;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "dispose", "initializeLogger", "createEventLogFileWriter", "scheduleFlushInTestMode", "fileWriter", "Companion", "intellij.platform.trace.consent"})
@SourceDebugExtension(value={"SMAP\nTraceStateEventLogFileWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TraceStateEventLogFileWriter.kt\ncom/intellij/platform/trace/consent/storage/logging/TraceStateEventLogFileWriter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n13#2:80\n*S KotlinDebug\n*F\n+ 1 TraceStateEventLogFileWriter.kt\ncom/intellij/platform/trace/consent/storage/logging/TraceStateEventLogFileWriter\n*L\n74#1:80\n*E\n"})
public final class TraceStateEventLogFileWriter
implements Disposable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Path eventLogDir;
    @Nullable
    private EventLogFileWriter logger;
    @NotNull
    private static final Logger LOG;
    private static final long LOG_RETENTION_PERIOD;
    private static final long TEST_MODE_FLUSH_DELAY;
    @Deprecated
    public static final int MAX_FILE_SIZE_BYTES = 5120;

    public TraceStateEventLogFileWriter(int maxFileSizeInBytes, @NotNull Path eventLogDir) {
        Intrinsics.checkNotNullParameter((Object)eventLogDir, (String)"eventLogDir");
        this.eventLogDir = eventLogDir;
        this.initializeLogger(maxFileSizeInBytes);
    }

    public /* synthetic */ TraceStateEventLogFileWriter(int n, Path path, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 5120;
        }
        if ((n2 & 2) != 0) {
            Path path2 = PathManager.getCommonDataPath().resolve("consentOptions/consent-log-data");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            path = path2;
        }
        this(n, path);
    }

    private final void setLogger(EventLogFileWriter value) {
        EventLogFileWriter eventLogFileWriter = this.logger;
        if (eventLogFileWriter != null) {
            eventLogFileWriter.close();
        }
        this.logger = value;
    }

    public final void log(@NotNull TraceStateEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EventLogFileWriter eventLogFileWriter = this.logger;
            if (eventLogFileWriter == null) break block0;
            eventLogFileWriter.log(TraceStateEventSerializer.INSTANCE.serializeEncrypted(event));
        }
    }

    @NotNull
    public final EventLogFilesProvider getLogFilesProvider() {
        return (EventLogFilesProvider)new DefaultEventLogFilesProvider(this.eventLogDir, () -> TraceStateEventLogFileWriter.getLogFilesProvider$lambda$0(this));
    }

    public void dispose() {
        this.setLogger(null);
    }

    private final void initializeLogger(int maxFileSizeInBytes) {
        block2: {
            Object object;
            Object object2 = this;
            try {
                TraceStateEventLogFileWriter $this$initializeLogger_u24lambda_u240 = object2;
                boolean bl = false;
                EventLogFileWriter fileWriter = $this$initializeLogger_u24lambda_u240.createEventLogFileWriter(maxFileSizeInBytes);
                $this$initializeLogger_u24lambda_u240.setLogger(fileWriter);
                $this$initializeLogger_u24lambda_u240.scheduleFlushInTestMode(fileWriter);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object e = object = throwable;
            boolean bl = false;
            LOG.warn("Unable to initialize logging for feature usage", (Throwable)e);
        }
    }

    private final EventLogFileWriter createEventLogFileWriter(int maxFileSizeInBytes) {
        Function1 logFilePathProvider = TraceStateEventLogFileWriter::createEventLogFileWriter$lambda$0;
        return new EventLogFileWriter(this.eventLogDir, maxFileSizeInBytes, logFilePathProvider, LOG_RETENTION_PERIOD, null);
    }

    private final void scheduleFlushInTestMode(EventLogFileWriter fileWriter) {
        if (StatisticsRecorderUtil.isTestModeEnabled((String)"TRACE")) {
            BuildersKt.launch$default((CoroutineScope)StatisticsServiceScope.Companion.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(fileWriter, null){
                int label;
                final /* synthetic */ EventLogFileWriter $fileWriter;
                {
                    this.$fileWriter = $fileWriter;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)TraceStateEventLogFileWriter.access$getCompanion$p().getTEST_MODE_FLUSH_DELAY-UwyO8pc(), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.$fileWriter.flush();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private static final String getLogFilesProvider$lambda$0(TraceStateEventLogFileWriter this$0) {
        EventLogFileWriter eventLogFileWriter = this$0.logger;
        return eventLogFileWriter != null ? eventLogFileWriter.getActiveLogName() : null;
    }

    private static final File createEventLogFileWriter$lambda$0(Path directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return EventLogFile.Companion.create(directory, EventLogBuildType.RELEASE, "").getFile();
    }

    public TraceStateEventLogFileWriter() {
        this(0, null, 3, null);
    }

    public static final /* synthetic */ Companion access$getCompanion$p() {
        return Companion;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TraceStateEventLogFileWriter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        LOG_RETENTION_PERIOD = Duration.times-UwyO8pc((long)DurationKt.toDuration((int)365, (DurationUnit)DurationUnit.DAYS), (int)100);
        TEST_MODE_FLUSH_DELAY = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0013\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/trace/consent/storage/logging/TraceStateEventLogFileWriter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "LOG_RETENTION_PERIOD", "Lkotlin/time/Duration;", "getLOG_RETENTION_PERIOD-UwyO8pc", "()J", "J", "TEST_MODE_FLUSH_DELAY", "getTEST_MODE_FLUSH_DELAY-UwyO8pc", "MAX_FILE_SIZE_BYTES", "", "intellij.platform.trace.consent"})
    private static final class Companion {
        private Companion() {
        }

        public final long getLOG_RETENTION_PERIOD-UwyO8pc() {
            return LOG_RETENTION_PERIOD;
        }

        public final long getTEST_MODE_FLUSH_DELAY-UwyO8pc() {
            return TEST_MODE_FLUSH_DELAY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

