/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberInfo;
import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberInfoModel;
import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberSelectionTable;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveModuleDestination;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveModuleMembersProcessor;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveSymbolDialog;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.ui.JSVisibilityPanel;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.ui.AbstractMemberSelectionTable;
import com.intellij.refactoring.ui.MemberSelectionPanelBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MoveModuleMembersDialog
extends ES6MoveSymbolDialog {
    private final ES6ModuleMemberSelectionTable mySelectionTable;
    @NotNull
    private final PsiElement mySourceModuleOrFile;
    @Nullable
    private final MoveCallback myMoveCallback;
    private final JSVisibilityPanel myVisibilityPanel;

    public ES6MoveModuleMembersDialog(@NotNull Project project, @NotNull String fromPath, @NotNull String toPath, @NotNull Collection<JSQualifiedNamedElement> selectedElements, @NotNull PsiElement sourceModuleOrFile, @Nullable MoveCallback moveCallback) {
        if (project == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(0);
        }
        if (fromPath == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(1);
        }
        if (toPath == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(2);
        }
        if (selectedElements == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(3);
        }
        if (sourceModuleOrFile == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(4);
        }
        super(project, fromPath, toPath, sourceModuleOrFile);
        this.mySourceModuleOrFile = sourceModuleOrFile;
        this.myMoveCallback = moveCallback;
        this.setTitle(JavaScriptBundle.message((String)"es6.move.module.members.refactoring.name", (Object[])new Object[0]));
        ES6ModuleMemberInfoModel memberInfoModel = new ES6ModuleMemberInfoModel(sourceModuleOrFile);
        List moduleMemberInfos = ES6ModuleMemberInfo.getModuleMembers((PsiElement)sourceModuleOrFile, selectedElements);
        this.mySelectionTable = new ES6ModuleMemberSelectionTable(moduleMemberInfos, (MemberInfoModel<JSQualifiedNamedElement, ES6ModuleMemberInfo>)memberInfoModel);
        this.mySelectionTable.addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        memberInfoModel.memberInfoChanged(new MemberInfoChange((Collection)moduleMemberInfos));
        this.mySelectionTable.setShowColumns(false);
        this.mySelectionTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)400, (int)-1));
        this.mySelectionTable.setVisibleRowCount(8);
        this.myCenterPanel.add((Component)new MemberSelectionPanelBase(JavaScriptBundle.message((String)"es6.move.module.members.table.title", (Object[])new Object[0]), (AbstractMemberSelectionTable)this.mySelectionTable), "Center");
        this.myVisibilityPanel = new JSVisibilityPanel();
        this.myVisibilityPanel.configureOptions(true, true, false, false, false, false);
        this.myVisibilityPanel.setVisibility("escalate");
        this.myVisibilityPanel.setVisible(ES6PsiUtil.isExternalModule((PsiElement)sourceModuleOrFile));
        this.myCenterPanel.add((Component)this.myVisibilityPanel, "East");
        this.init();
    }

    public String getSelectedVisibility() {
        return this.myVisibilityPanel.getVisibility();
    }

    public List<JSQualifiedNamedElement> getSelectedElements() {
        return ContainerUtil.map((Collection)this.mySelectionTable.getSelectedMemberInfos(), el -> (JSQualifiedNamedElement)el.getMember());
    }

    @Override
    protected void doAction() {
        String message = this.validateData();
        if (!StringUtil.isEmpty((String)message)) {
            CommonRefactoringUtil.showErrorMessage((String)JavaScriptBundle.message((String)"es6.move.module.members.refactoring.name", (Object[])new Object[0]), (String)message, null, (Project)this.myProject);
            return;
        }
        ES6MoveModuleDestination toModule = this.getDestination();
        if (toModule == null) {
            return;
        }
        try {
            this.invokeRefactoring(this.createProcessor(toModule, this.getSelectedElements(), "escalate".equals(this.getSelectedVisibility())));
        }
        catch (IncorrectOperationException e) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), null, (Project)this.myProject);
        }
        super.doAction();
    }

    @NotNull
    public BaseRefactoringProcessor createProcessor(@NotNull ES6MoveModuleDestination toModule, @NotNull List<JSQualifiedNamedElement> elements, boolean escalateVisibility) {
        if (toModule == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(6);
        }
        return new ES6MoveModuleMembersProcessor(elements, toModule, this.mySourceModuleOrFile, escalateVisibility, (Consumer<? super Collection<JSQualifiedNamedElement>>)((Consumer)newElements -> {
            JSQualifiedNamedElement first;
            if (this.isOpenInEditor() && (first = (JSQualifiedNamedElement)ContainerUtil.getFirstItem((Collection)newElements)) != null) {
                EditorHelper.openInEditor((PsiElement)first);
            }
            if (this.myMoveCallback != null) {
                this.myMoveCallback.refactoringCompleted();
            }
        }));
    }

    @NlsContexts.DialogMessage
    @Nullable
    private String validateData() {
        if (this.getSelectedElements().isEmpty()) {
            return JavaScriptBundle.message((String)"es6.move.module.members.refactoring.dialog.error.no.selected.items", (Object[])new Object[0]);
        }
        String modulePath = this.getModuleString();
        if (StringUtil.isEmpty((String)modulePath)) {
            return JavaScriptBundle.message((String)"es6.move.module.members.refactoring.dialog.error.incorrect.module", (Object[])new Object[0]);
        }
        if (StringUtil.equals((CharSequence)this.myFromField.getText(), (CharSequence)modulePath)) {
            return JavaScriptBundle.message((String)"es6.move.module.members.refactoring.dialog.error.modules.same", (Object[])new Object[0]);
        }
        String fileCreationError = ES6MoveModuleMembersDialog.checkOrCreateFile(this.mySourceModuleOrFile, modulePath, this.getTitle(), false);
        if (fileCreationError != null) {
            return fileCreationError;
        }
        PsiElement toModule = ES6MoveModuleDestination.getModule(ES6MoveModuleMembersDialog.getDestinationPsiFile(this.mySourceModuleOrFile, this.getModuleString()));
        if (toModule == null) {
            return null;
        }
        if (!ES6MoveModuleMembersDialog.isCompatibleLanguage(this.mySourceModuleOrFile, toModule)) {
            return JavaScriptBundle.message((String)"es6.move.module.members.incompatible.language", (Object[])new Object[0]);
        }
        return null;
    }

    private static boolean isCompatibleLanguage(@NotNull PsiElement source, @NotNull PsiElement destination) {
        if (source == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(7);
        }
        if (destination == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(8);
        }
        DialectOptionHolder sourceDialect = DialectDetector.dialectOfElement((PsiElement)source);
        DialectOptionHolder destinationDialect = DialectDetector.dialectOfElement((PsiElement)destination);
        if (sourceDialect == null || destinationDialect == null) {
            return false;
        }
        if (sourceDialect.isTypeScript) {
            return destinationDialect.isTypeScript;
        }
        if (sourceDialect.isFlow) {
            return destinationDialect.isFlow;
        }
        if (destinationDialect.isFlow) {
            return sourceDialect.isJavaScript();
        }
        return sourceDialect.isECMA6 && destinationDialect.isECMA6;
    }

    @NlsContexts.DialogMessage
    @Nullable
    public static String checkOrCreateFile(@NotNull PsiElement sourceModule, @NotNull String path, @NlsContexts.DialogTitle @NotNull String messageTitle, boolean createPhysicalFile) {
        if (sourceModule == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(9);
        }
        if (path == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(10);
        }
        if (messageTitle == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(11);
        }
        Project project = sourceModule.getProject();
        PsiFile destinationPsi = ES6MoveModuleMembersDialog.getDestinationPsiFile(sourceModule, path = FileUtil.toSystemIndependentName((String)path));
        if (destinationPsi != null) {
            if (destinationPsi instanceof XmlFile && destinationPsi != sourceModule && JSUtils.findScriptTagContent((XmlFile)((XmlFile)destinationPsi)) == null) {
                return JavaScriptBundle.message((String)"es6.move.module.members.refactoring.dialog.error.no.script.tag", (Object[])new Object[0]);
            }
            return null;
        }
        String fileName = VfsUtil.extractFileName((String)path);
        String parentDir = VfsUtil.getParentDir((String)path);
        if (parentDir == null || fileName == null) {
            return JavaScriptBundle.message((String)"es6.move.module.members.refactoring.dialog.error.incorrect.module", (Object[])new Object[0]);
        }
        if (!ES6MoveModuleMembersDialog.isValidFileName(fileName)) {
            return JavaScriptBundle.message((String)"es6.move.module.members.refactoring.dialog.error.invalid.file.name", (Object[])new Object[0]);
        }
        FileType destinationFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (!TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(destinationFileType) && !DialectDetector.JAVASCRIPT_FILE_TYPES.contains(destinationFileType)) {
            return JavaScriptBundle.message((String)"es6.move.module.members.refactoring.file.does.not.exist", (Object[])new Object[]{fileName});
        }
        if (!createPhysicalFile) {
            return null;
        }
        int answer = Messages.showYesNoDialog((Project)project, (String)JavaScriptBundle.message((String)"es6.move.module.members.refactoring.create.file.message", (Object[])new Object[]{fileName}), (String)messageTitle, (Icon)Messages.getQuestionIcon());
        if (answer == 0) {
            try {
                WriteCommandAction.writeCommandAction((Project)project).withName(JavaScriptBundle.message((String)"es6.move.module.members.refactoring.create.file", (Object[])new Object[0])).run(() -> {
                    VirtualFile directories = VfsUtil.createDirectories((String)parentDir);
                    directories.createChildData((Object)sourceModule, fileName);
                });
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }
        return null;
    }

    private static boolean isValidFileName(@NotNull String fileName) {
        if (fileName == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(12);
        }
        if (!PathUtil.isValidFileName((String)fileName)) {
            return false;
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return true;
        }
        return PathUtil.isValidFileName((String)fileName.substring(0, index));
    }

    @Nullable
    private static PsiFile getDestinationPsiFile(@NotNull PsiElement context, String path) {
        if (context == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(13);
        }
        path = FileUtil.toSystemIndependentName((String)path);
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (vFile == null) {
            return null;
        }
        return context.getManager().findFile(vFile);
    }

    @Nullable
    private ES6MoveModuleDestination getDestination() {
        return ES6MoveModuleDestination.getModuleDestination(this.mySourceModuleOrFile, this.getModuleString());
    }

    public String getModuleString() {
        return this.myModuleField.getText();
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.javascript.move.symbol";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedElements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceModuleOrFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toModule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceModule";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageTitle";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createProcessor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompatibleLanguage";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOrCreateFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidFileName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getDestinationPsiFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

