/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.editor.ES6CopyPasteProcessorBase;
import com.intellij.lang.ecmascript6.editor.JSCopyPasteProcessorBase;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.editor.JSCopyPasteService;
import com.intellij.lang.javascript.frameworks.jsx.JSXCopyPasteActionsProvider;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J8\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J>\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J8\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001e0\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001e0\u001dH\u0002J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010#\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/lang/javascript/frameworks/jsx/JSXCopyPasteTagProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePreProcessor;", "<init>", "()V", "preprocessOnCopy", "", "file", "Lcom/intellij/psi/PsiFile;", "startOffsets", "", "endOffsets", "text", "isFileAcceptable", "", "preprocessOnPaste", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rawText", "Lcom/intellij/openapi/editor/RawText;", "processAsync", "", "offset", "", "parentPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "addUnblockDocument", "", "Lkotlin/Function0;", "document", "Lcom/intellij/openapi/editor/Document;", "providerActions", "isPossibleContentWithTag", "requiresAllDocumentsToBeCommitted", "JSXCopyPasteActionsData", "intellij.javascript.codeinsight"})
@SourceDebugExtension(value={"SMAP\nJSXCopyPasteTagProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSXCopyPasteTagProcessor.kt\ncom/intellij/lang/javascript/frameworks/jsx/JSXCopyPasteTagProcessor\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n30#2,2:119\n18#3:121\n1391#4:122\n1480#4,5:123\n1915#4,2:128\n*S KotlinDebug\n*F\n+ 1 JSXCopyPasteTagProcessor.kt\ncom/intellij/lang/javascript/frameworks/jsx/JSXCopyPasteTagProcessor\n*L\n67#1:119,2\n78#1:121\n86#1:122\n86#1:123,5\n95#1:128,2\n*E\n"})
public final class JSXCopyPasteTagProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(@NotNull PsiFile file, @NotNull int[] startOffsets, @NotNull int[] endOffsets, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return null;
    }

    private final boolean isFileAcceptable(PsiFile file) {
        return file instanceof JSFile || file instanceof XmlFile;
    }

    @NotNull
    public String preprocessOnPaste(@Nullable Project project, @Nullable PsiFile file, @Nullable Editor editor, @NotNull String text, @Nullable RawText rawText) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (project == null || file == null || !this.isFileAcceptable(file) || JSXCopyPasteActionsProvider.Companion.enabledProviders().isEmpty() || editor == null) {
            return text;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement context = JSCopyPasteProcessorBase.Companion.getContextElementOrFile(file, offset);
        if (!DialectDetector.isJSX((PsiElement)context) || ES6CopyPasteProcessorBase.Companion.isInvalidImportPasteContext(context) || !this.isPossibleContentWithTag(text)) {
            return text;
        }
        PsiElement contextPointerElement = context instanceof PsiFile ? context : context.getParent();
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(contextPointerElement, file);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        SmartPsiElementPointer contextPointer = smartPsiElementPointer;
        this.processAsync(project, editor, text, file, offset, (SmartPsiElementPointer<PsiElement>)contextPointer);
        return text;
    }

    private final void processAsync(Project project, Editor editor, String text, PsiFile file, int offset, SmartPsiElementPointer<PsiElement> parentPointer) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<JSCopyPasteService> serviceClass$iv = JSCopyPasteService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        JSCopyPasteService jSCopyPasteService = (JSCopyPasteService)object;
        String string = JavaScriptBundle.message((String)"jsx.convert.html.to.jsx.progress", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = JavaScriptBundle.message((String)"jsx.convert.html.to.jsx.command.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        jSCopyPasteService.scheduleOnPasteProcessing(file, string, string2, () -> JSXCopyPasteTagProcessor.processAsync$lambda$0(project, file, offset, text, parentPointer, this, editor), arg_0 -> JSXCopyPasteTagProcessor.processAsync$lambda$1(parentPointer, project, editor, file, text, arg_0));
    }

    private final List<Function0<Unit>> addUnblockDocument(Project project, Document document, List<? extends Function0<Unit>> providerActions) {
        return CollectionsKt.plus((Collection)providerActions, () -> JSXCopyPasteTagProcessor.addUnblockDocument$lambda$0(project, document));
    }

    private final boolean isPossibleContentWithTag(String text) {
        String trimmedText = ((Object)StringsKt.trim((CharSequence)text)).toString();
        if (!StringsKt.startsWith$default((String)trimmedText, (String)"<", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)trimmedText, (String)">", (boolean)false, (int)2, null)) {
            return false;
        }
        char firstLetter = trimmedText.charAt(1);
        return Character.isLetter(firstLetter) && Character.isLowerCase(firstLetter);
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final List processAsync$lambda$0(Project $project, PsiFile $file, int $offset, String $text, SmartPsiElementPointer $parentPointer, JSXCopyPasteTagProcessor this$0, Editor $editor) {
        void $this$flatMapTo$iv$iv;
        if ($project.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        PsiElement newContext = JSCopyPasteProcessorBase.Companion.getContextElementOrFile($file, $offset);
        ASTNode aSTNode = JSChangeUtil.createStatementFromTextWithContext((String)("<>" + $text + "</>"), (PsiElement)newContext);
        if (aSTNode == null || (aSTNode = aSTNode.getPsi()) == null) {
            return CollectionsKt.emptyList();
        }
        ASTNode parentStatement = aSTNode;
        PsiElement $this$asSafely$iv = parentStatement.getFirstChild();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof JSXmlLiteralExpression)) {
            psiElement = null;
        }
        JSXmlLiteralExpression jSXmlLiteralExpression = (JSXmlLiteralExpression)psiElement;
        if (jSXmlLiteralExpression == null) {
            return CollectionsKt.emptyList();
        }
        JSXmlLiteralExpression fragmentCandidate = jSXmlLiteralExpression;
        if (PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)fragmentCandidate), PsiErrorElement.class) != null) {
            return CollectionsKt.emptyList();
        }
        JSXCopyPasteActionsData copyPasteActionsData = new JSXCopyPasteActionsData((SmartPsiElementPointer<PsiElement>)$parentPointer, (XmlTag)fragmentCandidate);
        List<JSXCopyPasteActionsProvider> enabledProviders = JSXCopyPasteActionsProvider.Companion.enabledProviders();
        Iterable $this$flatMap$iv = enabledProviders;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable iterable2;
            JSXCopyPasteActionsProvider provider = (JSXCopyPasteActionsProvider)element$iv$iv;
            boolean bl = false;
            List<Function0<Unit>> providerActions = provider.provideActions(copyPasteActionsData);
            if (providerActions.isEmpty() || Intrinsics.areEqual((Object)CollectionsKt.last(enabledProviders), (Object)provider)) {
                iterable2 = providerActions;
            } else {
                Document document = $editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                iterable2 = this$0.addUnblockDocument($project, document, providerActions);
            }
            Iterable list$iv$iv = iterable2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit processAsync$lambda$1(SmartPsiElementPointer $parentPointer, Project $project, Editor $editor, PsiFile $file, String $text, List actions) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
            Iterable $this$forEach$iv = actions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
            PsiElement psiElement = $parentPointer.getElement();
            if (psiElement == null || (psiElement = psiElement.getTextRange()) == null) break block1;
            PsiElement it = psiElement;
            boolean bl = false;
            PsiDocumentManager.getInstance((Project)$project).commitDocument($editor.getDocument());
            CodeStyleManager.getInstance((Project)$project).reformatText($file, it.getStartOffset(), it.getEndOffset() + $text.length());
        }
        return Unit.INSTANCE;
    }

    private static final Unit addUnblockDocument$lambda$0(Project $project, Document $document) {
        PsiDocumentManager.getInstance((Project)$project).doPostponedOperationsAndUnblockDocument($document);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/frameworks/jsx/JSXCopyPasteTagProcessor$JSXCopyPasteActionsData;", "", "contextPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "dataFragment", "Lcom/intellij/psi/xml/XmlTag;", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/psi/xml/XmlTag;)V", "getContextPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "getDataFragment", "()Lcom/intellij/psi/xml/XmlTag;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.javascript.codeinsight"})
    public static final class JSXCopyPasteActionsData {
        @NotNull
        private final SmartPsiElementPointer<PsiElement> contextPointer;
        @NotNull
        private final XmlTag dataFragment;

        public JSXCopyPasteActionsData(@NotNull SmartPsiElementPointer<PsiElement> contextPointer, @NotNull XmlTag dataFragment) {
            Intrinsics.checkNotNullParameter(contextPointer, (String)"contextPointer");
            Intrinsics.checkNotNullParameter((Object)dataFragment, (String)"dataFragment");
            this.contextPointer = contextPointer;
            this.dataFragment = dataFragment;
        }

        @NotNull
        public final SmartPsiElementPointer<PsiElement> getContextPointer() {
            return this.contextPointer;
        }

        @NotNull
        public final XmlTag getDataFragment() {
            return this.dataFragment;
        }

        @NotNull
        public final SmartPsiElementPointer<PsiElement> component1() {
            return this.contextPointer;
        }

        @NotNull
        public final XmlTag component2() {
            return this.dataFragment;
        }

        @NotNull
        public final JSXCopyPasteActionsData copy(@NotNull SmartPsiElementPointer<PsiElement> contextPointer, @NotNull XmlTag dataFragment) {
            Intrinsics.checkNotNullParameter(contextPointer, (String)"contextPointer");
            Intrinsics.checkNotNullParameter((Object)dataFragment, (String)"dataFragment");
            return new JSXCopyPasteActionsData(contextPointer, dataFragment);
        }

        public static /* synthetic */ JSXCopyPasteActionsData copy$default(JSXCopyPasteActionsData jSXCopyPasteActionsData, SmartPsiElementPointer smartPsiElementPointer, XmlTag xmlTag, int n, Object object) {
            if ((n & 1) != 0) {
                smartPsiElementPointer = jSXCopyPasteActionsData.contextPointer;
            }
            if ((n & 2) != 0) {
                xmlTag = jSXCopyPasteActionsData.dataFragment;
            }
            return jSXCopyPasteActionsData.copy(smartPsiElementPointer, xmlTag);
        }

        @NotNull
        public String toString() {
            return "JSXCopyPasteActionsData(contextPointer=" + this.contextPointer + ", dataFragment=" + this.dataFragment + ")";
        }

        public int hashCode() {
            int result2 = this.contextPointer.hashCode();
            result2 = result2 * 31 + this.dataFragment.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JSXCopyPasteActionsData)) {
                return false;
            }
            JSXCopyPasteActionsData jSXCopyPasteActionsData = (JSXCopyPasteActionsData)other;
            if (!Intrinsics.areEqual(this.contextPointer, jSXCopyPasteActionsData.contextPointer)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dataFragment, (Object)jSXCopyPasteActionsData.dataFragment);
        }
    }
}

