/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.frameworks.jsx.inspections.SurroundWithTagFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.XmlCustomTagHighlightingPassKt;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/javascript/frameworks/jsx/inspections/JSXDomNestingInspection;", "Lcom/intellij/codeInspection/htmlInspections/HtmlLocalInspectionTool;", "<init>", "()V", "checkTag", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkText", "text", "Lcom/intellij/psi/xml/XmlText;", "isValidParent", "tagName", "", "parentTagName", "Companion", "intellij.javascript.codeinsight"})
public final class JSXDomNestingInspection
extends HtmlLocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, Set<String>> validChildren;
    @NotNull
    private static final Set<String> tagsRequiringKnownParent;

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!DialectDetector.isJSX((PsiElement)((PsiElement)tag))) {
            return;
        }
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (XmlCustomTagHighlightingPassKt.isCustomTag((PsiFile)psiFile, (XmlTag)tag)) {
            return;
        }
        PsiElement parent = tag.getParent();
        if (parent instanceof XmlTag) {
            PsiFile psiFile2 = holder.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
            if (!XmlCustomTagHighlightingPassKt.isCustomTag((PsiFile)psiFile2, (XmlTag)((XmlTag)parent)) && !Intrinsics.areEqual((Object)((XmlTag)parent).getName(), (Object)"")) {
                String string = tag.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = ((XmlTag)parent).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!this.isValidParent(string, string2)) {
                    PsiElement problemElement;
                    ASTNode aSTNode = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode());
                    Object nameElement = aSTNode != null ? aSTNode.getPsi() : null;
                    PsiElement psiElement = nameElement;
                    if (psiElement == null) {
                        psiElement = problemElement = (PsiElement)tag;
                    }
                    if (Intrinsics.areEqual((Object)((XmlTag)parent).getName(), (Object)"table") && Intrinsics.areEqual((Object)tag.getName(), (Object)"tr")) {
                        Object[] objectArray = new Object[]{tag.getName(), ((XmlTag)parent).getName()};
                        String string3 = JavaScriptBundle.message((String)"jsx.dom.nesting.inspection.message.tr", (Object[])objectArray);
                        objectArray = new LocalQuickFix[]{new SurroundWithTagFix("tbody")};
                        holder.registerProblem(problemElement, string3, (LocalQuickFix[])objectArray);
                    } else {
                        Object[] objectArray = new Object[]{tag.getName(), ((XmlTag)parent).getName()};
                        holder.registerProblem(problemElement, JavaScriptBundle.message((String)"jsx.dom.nesting.inspection.message", (Object[])objectArray), new LocalQuickFix[0]);
                    }
                }
            }
        }
    }

    protected void checkText(@NotNull XmlText text, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!DialectDetector.isJSX((PsiElement)((PsiElement)text))) {
            return;
        }
        PsiElement parent = text.getParent();
        if (parent instanceof XmlTag) {
            PsiFile psiFile = holder.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
            if (!XmlCustomTagHighlightingPassKt.isCustomTag((PsiFile)psiFile, (XmlTag)((XmlTag)parent))) {
                String string = ((XmlTag)parent).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!this.isValidParent("#text", string)) {
                    Object[] objectArray = new Object[]{((XmlTag)parent).getName()};
                    holder.registerProblem((PsiElement)text, JavaScriptBundle.message((String)"jsx.dom.nesting.inspection.message.text", (Object[])objectArray), new LocalQuickFix[0]);
                }
            }
        }
    }

    private final boolean isValidParent(String tagName, String parentTagName) {
        Set<String> validChildrenSet = validChildren.get(parentTagName);
        if (validChildrenSet != null) {
            return validChildrenSet.contains(tagName);
        }
        return !tagsRequiringKnownParent.contains(tagName);
    }

    static {
        Object[] objectArray = new Pair[13];
        Object[] objectArray2 = new String[]{"hr", "option", "optgroup", "#text"};
        objectArray[0] = TuplesKt.to((Object)"select", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"option", "#text"};
        objectArray[1] = TuplesKt.to((Object)"optgroup", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray[2] = TuplesKt.to((Object)"option", (Object)SetsKt.setOf((Object)"#text"));
        objectArray2 = new String[]{"th", "td", "style", "script", "template"};
        objectArray[3] = TuplesKt.to((Object)"tr", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"tr", "style", "script", "template"};
        objectArray[4] = TuplesKt.to((Object)"tbody", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"tr", "style", "script", "template"};
        objectArray[5] = TuplesKt.to((Object)"thead", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"tr", "style", "script", "template"};
        objectArray[6] = TuplesKt.to((Object)"tfoot", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"col", "template"};
        objectArray[7] = TuplesKt.to((Object)"colgroup", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"caption", "colgroup", "tbody", "tfoot", "thead", "style", "script", "template"};
        objectArray[8] = TuplesKt.to((Object)"table", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"base", "basefont", "bgsound", "link", "meta", "title", "noscript", "noframes", "style", "script", "template"};
        objectArray[9] = TuplesKt.to((Object)"head", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"head", "body", "frameset"};
        objectArray[10] = TuplesKt.to((Object)"html", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray[11] = TuplesKt.to((Object)"frameset", (Object)SetsKt.setOf((Object)"frame"));
        objectArray[12] = TuplesKt.to((Object)"#document", (Object)SetsKt.setOf((Object)"html"));
        validChildren = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"body", "caption", "col", "colgroup", "frameset", "frame", "head", "html", "tbody", "td", "tfoot", "th", "thead", "tr"};
        tagsRequiringKnownParent = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/javascript/frameworks/jsx/inspections/JSXDomNestingInspection$Companion;", "", "<init>", "()V", "validChildren", "", "", "", "tagsRequiringKnownParent", "intellij.javascript.codeinsight"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

