/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRemoveElementLocalQuickFix
extends FixAndIntentionAction
implements BatchQuickFix {
    private static final Logger LOG = Logger.getInstance(JSRemoveElementLocalQuickFix.class);
    private final String myDescription;

    public JSRemoveElementLocalQuickFix(String description) {
        this.myDescription = description;
    }

    @NotNull
    public String getName() {
        String string = JavaScriptBundle.message((String)"js.unused.symbol.remove", (Object[])new Object[]{this.myDescription});
        if (string == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(Project project, PsiElement psiElement, @NotNull PsiFile file, @Nullable Editor editor) {
        Document document;
        PsiElement element;
        if (file == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(1);
        }
        if ((element = JSRemoveElementLocalQuickFix.walkUpToDeleteTarget(psiElement)) == null) {
            return;
        }
        editor = editor == null ? PsiEditorUtil.findEditor((PsiElement)psiElement) : editor;
        Document document2 = document = editor != null ? editor.getDocument() : null;
        if (document == null) {
            return;
        }
        MyPostRemover replacer = new MyPostRemover(element, document);
        Runnable afterRefactoring = () -> DocumentUtil.writeInRunUndoTransparentAction(() -> replacer.replaceAndReformat());
        SafeDeleteHandler.invoke((Project)project, (PsiElement[])new PsiElement[]{element}, null, (boolean)false, null, (Runnable)afterRefactoring, (boolean)true);
    }

    public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        if (project == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(2);
        }
        if (psiElementsToIgnore == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptors == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(4);
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        SmartList postRemovers = new SmartList();
        SmartList toDelete = new SmartList();
        for (CommonProblemDescriptor descriptor : descriptors) {
            Document document;
            PsiElement element = ((ProblemDescriptor)descriptor).getPsiElement();
            if (element == null || (element = JSRemoveElementLocalQuickFix.walkUpToDeleteTarget(element)) == null || (document = psiDocumentManager.getDocument(element.getContainingFile())) == null) continue;
            toDelete.add(element);
            postRemovers.add(new MyPostRemover(element, document));
        }
        psiElementsToIgnore.addAll((Collection<PsiElement>)toDelete);
        Runnable afterRefactoring = () -> JSRemoveElementLocalQuickFix.lambda$applyFix$4((List)postRemovers, refreshViews);
        SafeDeleteHandler.invoke((Project)project, (PsiElement[])PsiUtilCore.toPsiElementArray((Collection)toDelete), (boolean)false, (Runnable)afterRefactoring);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static PsiElement walkUpToDeleteTarget(@NotNull PsiElement psiElement) {
        PsiElement element;
        if (psiElement == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(5);
        }
        for (element = psiElement; element != null && !(element instanceof JSNamedElement) && !(element instanceof ES6ExportDefaultAssignment); element = element.getParent()) {
        }
        if (element == null) {
            LOG.info("Was not able to remove element: " + psiElement.getText());
        }
        if (element != null && element.getParent() instanceof ES6ExportDefaultAssignment) {
            element = element.getParent();
        }
        return element;
    }

    private static /* synthetic */ void lambda$applyFix$4(List postRemovers, Runnable refreshViews) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            postRemovers.forEach(r -> r.replaceAndReformat());
            if (refreshViews != null) {
                refreshViews.run();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementsToIgnore";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "walkUpToDeleteTarget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private static class MyPostRemover {
        private final List<MyLeftRightContext> myContexts;
        private final PsiFile myContainingFile;
        @NotNull
        private final PsiElement myElement;
        @NotNull
        private final Document myDocument;
        @NotNull
        private final NewLineEraser myEraser;
        @Nullable
        private final PsiElement myElementToReplace;
        @NotNull
        private final SmartPsiElementPointer<PsiElement> myScope;

        MyPostRemover(@NotNull PsiElement element, @NotNull Document document) {
            if (element == null) {
                MyPostRemover.$$$reportNull$$$0(0);
            }
            if (document == null) {
                MyPostRemover.$$$reportNull$$$0(1);
            }
            this.myElement = element;
            this.myDocument = document;
            this.myContexts = MyPostRemover.createContextList(element, document);
            this.myContainingFile = element.getContainingFile();
            this.myScope = SmartPointerManager.createPointer((PsiElement)JSChangeUtil.getScopeElementInFile((PsiElement)element));
            this.myEraser = new NewLineEraser(element);
            this.myElementToReplace = MyPostRemover.createElementToReplace(element);
        }

        public void replaceAndReformat() {
            PsiElement scope = this.myScope.getElement();
            if (this.myElementToReplace == null || scope == null) {
                PsiDocumentManager.getInstance((Project)this.myContainingFile.getProject()).doPostponedOperationsAndUnblockDocument(this.myDocument);
                this.reformat();
                return;
            }
            PsiElement inserted = this.insertReplacerIntoContext(this.myElementToReplace);
            if (inserted != null) {
                this.myEraser.process(inserted);
                return;
            }
            scope.add(this.myElementToReplace);
        }

        private void reformat() {
            if (this.myElement.isValid()) {
                return;
            }
            MyLeftRightContext context = this.getRemainingContext();
            if (context == null) {
                return;
            }
            TextRange range = context.getTextRangeIfValid();
            assert (range != null);
            if (context.isInline()) {
                FormatFixer.create((PsiFile)this.myContainingFile, (TextRange)range, (Document)this.myDocument, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
            } else if (!range.isEmpty()) {
                Project project = this.myContainingFile.getProject();
                String text = this.myDocument.getText(range);
                Object trim = StringUtil.trim((String)text);
                if (!StringUtil.isEmptyOrSpaces((String)trim)) {
                    trim = (String)trim + "\n";
                }
                if (context.isWholeFile() || range.getStartOffset() == 0) {
                    if (range.getLength() > 0) {
                        this.myDocument.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)trim);
                        PsiDocumentManager.getInstance((Project)project).commitDocument(this.myDocument);
                    }
                } else {
                    this.myDocument.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)((context.myNewLineBeforeRight ? "\n" : "") + (String)trim));
                    PsiDocumentManager.getInstance((Project)project).commitDocument(this.myDocument);
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(this.myContainingFile, range);
                }
            }
        }

        public PsiElement insertReplacerIntoContext(@NotNull PsiElement replacer) {
            MyLeftRightContext remainingContext;
            if (replacer == null) {
                MyPostRemover.$$$reportNull$$$0(2);
            }
            if ((remainingContext = this.getRemainingContext()) != null && remainingContext.myParent != null) {
                if (remainingContext.myRight != null) {
                    return JSChangeUtil.doDoAddBefore((PsiElement)remainingContext.myParent, (PsiElement)replacer, (PsiElement)remainingContext.myRight);
                }
                if (remainingContext.myLeft != null) {
                    return JSChangeUtil.doAddAfter((PsiElement)remainingContext.myParent, (PsiElement)replacer, (PsiElement)remainingContext.myLeft);
                }
                if (remainingContext.myParent.getNode().getElementType().equals(replacer.getNode().getElementType())) {
                    return remainingContext.myParent.replace(replacer);
                }
            }
            return null;
        }

        @Nullable
        private MyLeftRightContext getRemainingContext() {
            return (MyLeftRightContext)ContainerUtil.find(this.myContexts, c -> c.getTextRangeIfValid() != null);
        }

        @NotNull
        private static List<MyLeftRightContext> createContextList(@NotNull PsiElement element, @NotNull Document document) {
            MyLeftRightContext context;
            if (element == null) {
                MyPostRemover.$$$reportNull$$$0(3);
            }
            if (document == null) {
                MyPostRemover.$$$reportNull$$$0(4);
            }
            SmartList result2 = new SmartList();
            PsiElement current = element;
            while (!(current instanceof PsiFile) && !(current instanceof JSEmbeddedContent) && (context = new MyLeftRightContext(current, document)).getParent() != null) {
                result2.add(context);
                current = context.getParent();
            }
            SmartList smartList = result2;
            if (smartList == null) {
                MyPostRemover.$$$reportNull$$$0(5);
            }
            return smartList;
        }

        @Nullable
        private static PsiElement createElementToReplace(PsiElement element) {
            String name;
            JSExpression expression;
            JSFunction function;
            if (element instanceof JSParameter && (function = ((JSParameter)element).getDeclaringFunction()) != null) {
                JSParameterList list = function.getParameterList();
                if (function.isArrowFunction() && list != null && TreeUtil.findChildBackward((ASTNode)list.getNode(), (IElementType)JSTokenTypes.RPAR) == null) {
                    JSFunctionExpression dummyFunction = (JSFunctionExpression)JSPsiElementFactory.createJSExpression((String)"() => {}", (PsiElement)element, JSFunctionExpression.class);
                    return dummyFunction.getParameterList();
                }
            }
            if (element instanceof ES6ExportDefaultAssignment && (expression = ((ES6ExportDefaultAssignment)element).getExpression()) != null && !StringUtil.isEmptyOrSpaces((String)(name = expression.getName()))) {
                if (expression instanceof JSFunctionExpression) {
                    return JSFunctionsRefactoringUtil.createFunctionDeclaration((JSFunctionExpression)((JSFunctionExpression)expression), (String)name);
                }
                if (expression instanceof JSClassExpression) {
                    return JSRefactoringUtil.classDeclarationFromClassExpression((JSClass)((JSClassExpression)expression), (String)name, (boolean)false);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyPostRemover";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyPostRemover";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createContextList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "insertReplacerIntoContext";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createContextList";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyLeftRightContext {
        @Nullable
        private PsiElement myLeft;
        @Nullable
        private PsiElement myRight;
        private final boolean myLeftWasComma;
        private final boolean myRightWasComma;
        private final boolean myNewLineBeforeRight;
        @Nullable
        private final PsiElement myParent;
        private final boolean myInline;

        MyLeftRightContext(@NotNull PsiElement element, @NotNull Document document) {
            PsiWhiteSpace whitespace;
            if (element == null) {
                MyLeftRightContext.$$$reportNull$$$0(0);
            }
            if (document == null) {
                MyLeftRightContext.$$$reportNull$$$0(1);
            }
            PsiElement backwardNoComment = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element);
            this.myLeftWasComma = backwardNoComment != null && backwardNoComment.getNode().getElementType() == JSTokenTypes.COMMA;
            this.myLeft = PsiTreeUtil.skipWhitespacesBackward((PsiElement)(this.myLeftWasComma ? backwardNoComment : element));
            PsiElement forwardNoComment = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
            this.myRightWasComma = forwardNoComment != null && forwardNoComment.getNode().getElementType() == JSTokenTypes.COMMA;
            this.myRight = PsiTreeUtil.skipWhitespacesForward((PsiElement)(this.myRightWasComma ? forwardNoComment : element));
            PsiElement psiElement = (this.myRightWasComma ? forwardNoComment : element).getNextSibling();
            this.myNewLineBeforeRight = psiElement instanceof PsiWhiteSpace && (whitespace = (PsiWhiteSpace)psiElement).textContains('\n');
            this.myParent = element.getParent();
            this.myInline = this.myLeft != null && this.myRight != null && document.getLineNumber(this.myLeft.getTextRange().getEndOffset()) == document.getLineNumber(this.myRight.getTextRange().getStartOffset());
        }

        boolean isInline() {
            return this.myInline;
        }

        @Nullable
        PsiElement getParent() {
            return this.myParent;
        }

        @Nullable
        TextRange getTextRangeIfValid() {
            int endOffset;
            PsiElement previous;
            PsiElement next;
            boolean nextValid;
            if (this.myParent == null || !this.myParent.isValid()) {
                return null;
            }
            boolean prevValid = this.myLeft != null && this.myLeft.isValid();
            boolean bl = nextValid = this.myRight != null && this.myRight.isValid();
            if (prevValid && this.myLeftWasComma && (next = this.myLeft.getNextSibling()) != null && next.isValid() && next.getNode().getElementType() == JSTokenTypes.COMMA) {
                this.myLeft = next;
            }
            if (nextValid && this.myRightWasComma && (previous = this.myRight.getPrevSibling()) != null && previous.isValid() && previous.getNode().getElementType() == JSTokenTypes.COMMA) {
                this.myRight = previous;
            }
            int startOffset = prevValid ? this.myLeft.getTextRange().getEndOffset() : this.myParent.getTextRange().getStartOffset();
            int n = endOffset = nextValid ? this.myRight.getTextRange().getStartOffset() : this.myParent.getTextRange().getEndOffset();
            if (startOffset > endOffset) {
                return new TextRange(startOffset, startOffset);
            }
            return new TextRange(startOffset, endOffset);
        }

        boolean isWholeFile() {
            return this.myParent instanceof PsiFile && this.myLeft == null && this.myRight == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyLeftRightContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

