/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.dataflow;

import com.intellij.lang.javascript.psi.JSExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSVariableInfo {
    @NotNull
    Set<JSExpression> variablesOverwritten;
    @NotNull
    Set<JSExpression> variablesWritten;
    @NotNull
    Set<JSExpression> variablesRead;

    JSVariableInfo(@NotNull Set<JSExpression> variablesWritten, @Nullable Set<JSExpression> variablesOverwritten, @NotNull Set<JSExpression> variablesRead) {
        if (variablesWritten == null) {
            JSVariableInfo.$$$reportNull$$$0(0);
        }
        if (variablesRead == null) {
            JSVariableInfo.$$$reportNull$$$0(1);
        }
        this.variablesWritten = variablesWritten;
        this.variablesOverwritten = variablesOverwritten == null ? Collections.emptySet() : variablesOverwritten;
        this.variablesRead = variablesRead;
    }

    JSVariableInfo() {
        this(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    @NotNull
    JSVariableInfo cloneState() {
        HashSet<JSExpression> written = this.variablesWritten.isEmpty() ? Collections.emptySet() : new HashSet<JSExpression>(this.variablesWritten);
        HashSet<JSExpression> overWritten = this.variablesOverwritten.isEmpty() ? Collections.emptySet() : new HashSet<JSExpression>(this.variablesOverwritten);
        HashSet<JSExpression> read = this.variablesRead.isEmpty() ? Collections.emptySet() : new HashSet<JSExpression>(this.variablesRead);
        return new JSVariableInfo(written, overWritten, read);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JSVariableInfo)) {
            return false;
        }
        JSVariableInfo that = (JSVariableInfo)o;
        if (!this.variablesWritten.equals(that.variablesWritten)) {
            return false;
        }
        if (!this.variablesOverwritten.equals(that.variablesOverwritten)) {
            return false;
        }
        return this.variablesRead.equals(that.variablesRead);
    }

    public int hashCode() {
        int result2 = this.variablesWritten.hashCode();
        result2 = 31 * result2 + this.variablesOverwritten.hashCode();
        result2 = 31 * result2 + this.variablesRead.hashCode();
        return result2;
    }

    public void addReads(@NotNull Collection<JSExpression> expressions) {
        if (expressions == null) {
            JSVariableInfo.$$$reportNull$$$0(2);
        }
        if (this.variablesRead.isEmpty()) {
            if (expressions.isEmpty()) {
                return;
            }
            this.variablesRead = new HashSet<JSExpression>(expressions);
            return;
        }
        this.variablesRead.addAll(expressions);
    }

    public void addWrite(@NotNull JSExpression expression) {
        if (expression == null) {
            JSVariableInfo.$$$reportNull$$$0(3);
        }
        if (this.variablesWritten.isEmpty()) {
            this.variablesWritten = new HashSet<JSExpression>();
        }
        this.variablesWritten.add(expression);
    }

    public void addWrites(@NotNull Collection<JSExpression> expressions) {
        if (expressions == null) {
            JSVariableInfo.$$$reportNull$$$0(4);
        }
        if (this.variablesWritten.isEmpty()) {
            if (expressions.isEmpty()) {
                return;
            }
            this.variablesWritten = new HashSet<JSExpression>(expressions);
            return;
        }
        this.variablesWritten.addAll(expressions);
    }

    public void intersectOverwrittenWith(@NotNull Collection<JSExpression> expressions) {
        if (expressions == null) {
            JSVariableInfo.$$$reportNull$$$0(5);
        }
        if (this.variablesOverwritten.isEmpty()) {
            return;
        }
        this.variablesOverwritten.removeIf(el -> !expressions.contains(el));
    }

    public void addOverwritten(@NotNull JSExpression expression) {
        if (expression == null) {
            JSVariableInfo.$$$reportNull$$$0(6);
        }
        if (this.variablesOverwritten.isEmpty()) {
            this.variablesOverwritten = new HashSet<JSExpression>();
        }
        this.variablesOverwritten.add(expression);
    }

    @NotNull
    Set<JSExpression> getVariablesOverwritten() {
        Set<JSExpression> set = this.variablesOverwritten;
        if (set == null) {
            JSVariableInfo.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    Set<JSExpression> getVariablesWritten() {
        Set<JSExpression> set = this.variablesWritten;
        if (set == null) {
            JSVariableInfo.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    Set<JSExpression> getVariablesRead() {
        Set<JSExpression> set = this.variablesRead;
        if (set == null) {
            JSVariableInfo.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variablesWritten";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variablesRead";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/dataflow/JSVariableInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/dataflow/JSVariableInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesOverwritten";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesWritten";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesRead";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addReads";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addWrite";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addWrites";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "intersectOverwrittenWith";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addOverwritten";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

