/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSConvertLoopsUtils;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConvertIndexedToForEachIntention
extends JavaScriptIntention {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSConvertIndexedToForEachIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSConvertIndexedToForEachIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSForStatement forStatement = JSConvertIndexedToForEachIntention.findForStatement(element);
        if (forStatement == null) {
            return false;
        }
        Pair<PsiElement, JSExpression> loopInfo = JSConvertLoopsUtils.getSequentiallyIteratedArrayIndexedFor(forStatement);
        if (loopInfo == null || loopInfo.first == null || loopInfo.second == null) {
            return false;
        }
        JSExpression collectionExpression = (JSExpression)loopInfo.second;
        PsiElement indexVariable = (PsiElement)loopInfo.first;
        return JSConvertLoopsUtils.canExtractLoopBodyToFunction((JSLoopStatement)forStatement, collectionExpression, indexVariable);
    }

    @Nullable
    private static JSForStatement findForStatement(@NotNull PsiElement element) {
        JSStatement forStatement;
        if (element == null) {
            JSConvertIndexedToForEachIntention.$$$reportNull$$$0(2);
        }
        if (!((forStatement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSForStatement.class, JSBlockStatement.class})) instanceof JSForStatement)) {
            return null;
        }
        return (JSForStatement)forStatement;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSForStatement forStatement;
        if (project == null) {
            JSConvertIndexedToForEachIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JSConvertIndexedToForEachIntention.$$$reportNull$$$0(4);
        }
        if ((forStatement = JSConvertIndexedToForEachIntention.findForStatement(element)) == null) {
            return;
        }
        Pair<PsiElement, JSExpression> loopInfo = JSConvertLoopsUtils.getSequentiallyIteratedArrayIndexedFor(forStatement);
        if (loopInfo == null) {
            return;
        }
        PsiElement indexVariable = (PsiElement)loopInfo.first;
        JSExpression collectionExpression = (JSExpression)loopInfo.second;
        JSConvertIndexedToForEachIntention.replaceWithForEach(project, editor, (JSLoopStatement)forStatement, collectionExpression, indexVariable);
    }

    public static void replaceWithForEach(@NotNull Project project, @Nullable Editor editor, @NotNull JSLoopStatement loopStatement, @Nullable JSExpression collectionExpression, @Nullable PsiElement indexVariable) {
        if (project == null) {
            JSConvertIndexedToForEachIntention.$$$reportNull$$$0(5);
        }
        if (loopStatement == null) {
            JSConvertIndexedToForEachIntention.$$$reportNull$$$0(6);
        }
        if (indexVariable == null || collectionExpression == null) {
            return;
        }
        JSStatement body = loopStatement.getBody();
        if (body == null) {
            return;
        }
        JSRefactoringUtil.addBracesToStatement((PsiElement)body);
        PsiElement collectionReference = JSConvertLoopsUtils.resolveCollectionReference(collectionExpression);
        if (collectionReference == null) {
            return;
        }
        JSVarStatement assignment = JSConvertLoopsUtils.findCollectionItemAssignment(body, collectionReference, indexVariable);
        JSStatement forEachCall = JSConvertLoopsUtils.replaceLoopWithForEachFunction(project, loopStatement, collectionExpression, indexVariable, assignment);
        if (forEachCall != null && assignment == null) {
            JSConvertLoopsUtils.invokeReplaceArgumentNameTemplate(project, editor, forEachCall);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            JSConvertIndexedToForEachIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"js.convert.indexed.for.to.foreach.intention.family", (Object[])new Object[0]);
        if (string == null) {
            JSConvertIndexedToForEachIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStatement";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSConvertIndexedToForEachIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSConvertIndexedToForEachIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findForStatement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithForEach";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

