/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.destructuring;

import com.intellij.javascript.typeEngine.TSTypeUtilsKt;
import com.intellij.javascript.types.TSElementFlags;
import com.intellij.javascript.types.TSObjectType;
import com.intellij.javascript.types.TSTupleTypeView;
import com.intellij.javascript.types.TSType;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0005\u001a\f\u0010\t\u001a\u00020\u0005*\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"MAX_PROP_COUNT", "", "MAX_ITEMS_SHOWN", "MAX_TYPE_DEPTH", "isApplicableType", "", "jsType", "Lcom/intellij/lang/javascript/psi/JSType;", "destructureAll", "isGenerateDestructuringPatternApplicable", "Lcom/intellij/javascript/types/TSType;", "intellij.javascript.codeinsight"})
public final class JSGenerateDestructuringPatternIntentionKt {
    private static final int MAX_PROP_COUNT = 20;
    private static final int MAX_ITEMS_SHOWN = 10;
    private static final int MAX_TYPE_DEPTH = 10;

    public static final boolean isApplicableType(@Nullable JSType jsType, boolean destructureAll) {
        if (jsType == null) {
            return false;
        }
        if (jsType instanceof JSTupleType) {
            return ((JSTupleType)jsType).getMaxLength() != Integer.MAX_VALUE && (!destructureAll || !((JSTupleType)jsType).allowWidening());
        }
        if (jsType instanceof JSPrimitiveType || jsType instanceof JSFunctionType) {
            return false;
        }
        if (jsType instanceof JSResolvableType) {
            JSResolvedTypeInfo jSResolvedTypeInfo = ((JSResolvableType)jsType).resolveType();
            Intrinsics.checkNotNullExpressionValue((Object)jSResolvedTypeInfo, (String)"resolveType(...)");
            JSResolvedTypeInfo info = jSResolvedTypeInfo;
            if (info.isEnum() || info.isEnumLiteral()) {
                return false;
            }
        }
        JSRecordType jSRecordType = jsType.asRecordType();
        Intrinsics.checkNotNullExpressionValue((Object)jSRecordType, (String)"asRecordType(...)");
        JSRecordType type = jSRecordType;
        return type.hasProperties() && type.getPropertyNames().size() <= 20;
    }

    private static final boolean isGenerateDestructuringPatternApplicable(TSType $this$isGenerateDestructuringPatternApplicable) {
        if (!($this$isGenerateDestructuringPatternApplicable instanceof TSObjectType)) {
            return false;
        }
        TSTupleTypeView tupleType = TSTypeUtilsKt.asTupleType((TSObjectType)((TSObjectType)$this$isGenerateDestructuringPatternApplicable));
        if (tupleType != null) {
            return !TSElementFlags.has-wPPsbMA((int)tupleType.getCombinedFlags-diOToZQ(), (int)TSElementFlags.Companion.getVariable-diOToZQ());
        }
        List properties = ((TSObjectType)$this$isGenerateDestructuringPatternApplicable).getProperties();
        return !((Collection)properties).isEmpty() && properties.size() <= 20;
    }

    public static final /* synthetic */ boolean access$isGenerateDestructuringPatternApplicable(TSType $receiver) {
        return JSGenerateDestructuringPatternIntentionKt.isGenerateDestructuringPatternApplicable($receiver);
    }
}

